/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.server.web.WebSocketEndpointInfo;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class WebSocketsRegistry {
    private final Map<String, WebSocketEndpointInfo> webSocketEndpoints = new LinkedHashMap<String, WebSocketEndpointInfo>();

    public static synchronized WebSocketsRegistry get() {
        WebSocketsRegistry result;
        if (!Environment.isPublished(WebSocketsRegistry.class)) {
            result = new WebSocketsRegistry();
            Environment.publish((Object)result);
        } else {
            result = (WebSocketsRegistry)Environment.getPublished(WebSocketsRegistry.class);
        }
        return result;
    }

    private WebSocketsRegistry() {
    }

    public Collection<WebSocketEndpointInfo> getWebsocketEndpoints() {
        return this.webSocketEndpoints.values();
    }

    public Collection<WebSocketEndpointInfo> getWebsocketEndpoints(String context) {
        LinkedList<WebSocketEndpointInfo> result = new LinkedList<WebSocketEndpointInfo>();
        for (WebSocketEndpointInfo item : this.webSocketEndpoints.values()) {
            if (!context.equals(item.getWebContextPath())) continue;
            result.add(item);
        }
        return result;
    }

    public void register(WebSocketEndpointInfo info) {
        this.webSocketEndpoints.put(info.getId(), info);
    }
}

