/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.locale;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.server.web.locale.LocaleException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class WebLocaleHelper {
    private final Log log = LogFactory.getLog(this.getClass());

    public static WebLocaleHelper of() {
        return new WebLocaleHelper();
    }

    private WebLocaleHelper() {
    }

    private Locale resolveDefaultLocale() {
        return LocaleManager.get().getDefaultLocale();
    }

    private Locale constructLocale(String value) {
        String[] parts = value.trim().split("_");
        switch (parts.length) {
            case 1: {
                return new Locale(parts[0]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
        }
        return new Locale(parts[0], parts[1], parts[2]);
    }

    private Locale resolveLocale(HttpServletRequest req) {
        try {
            String localeInfo = null;
            if (localeInfo == null) {
                localeInfo = req.getHeader("X-Application-Locale");
            }
            if (!StringUtils.isEmpty(localeInfo)) {
                Locale locale = this.constructLocale(localeInfo);
                return locale;
            }
            return this.resolveDefaultLocale();
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new LocaleException(ex);
        }
    }

    private LocaleManager resolveLocaleManager() {
        return LocaleManager.get();
    }

    private void configureLocaleManager(Locale locale) {
        try {
            LocaleManager localeManager = this.resolveLocaleManager();
            if (localeManager != null) {
                Locale currentLocale = localeManager.getCurrentLocale();
                if (!locale.equals(currentLocale)) {
                    localeManager.setCurrentLocale(locale);
                }
            } else {
                this.log.error((Object)"locale manager isn't published");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new LocaleException(ex);
        }
    }

    public void setupRequestLocaleContext(HttpServletRequest req, HttpServletResponse res) {
        Locale locale = this.resolveLocale(req);
        this.configureLocaleManager(locale);
    }
}

