/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestEnumType;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.meta.rest.RestService;
import com.gridnine.xtrip.common.meta.rest.RestServiceOperation;
import com.gridnine.xtrip.common.model.IntegrationBusException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.XeptionHelper;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.standard.helpers.HttpHelper;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.common.rest.TypeDiscriminator;
import com.gridnine.xtrip.common.rest.TypeHandler;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectTrace;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.IBusWebSocketCallback;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.ibus.rest.RestContextAsync;
import com.gridnine.xtrip.server.web.rest.AuthRestInterceptor;
import com.gridnine.xtrip.server.web.rest.GenericRestInterceptor;
import com.gridnine.xtrip.server.web.rest.JsonMarshaller;
import com.gridnine.xtrip.server.web.rest.NetworkConnectionException;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import com.gridnine.xtrip.server.web.rest.util.collection.FixedCharList;
import com.gridnine.xtrip.server.web.rest.util.collection.FixedCharQueue;
import com.gridnine.xtrip.server.web.rest.util.io.DebugBufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class RestServiceProvider {
    private final Log log = LogFactory.getLog(this.getClass());
    private final RestService service;
    private final JsonMarshaller marshaller;
    private final List<Object> interceptors = new ArrayList<Object>();
    private final Map<OperationKey, Operation> operationsServlet = new HashMap<OperationKey, Operation>();
    private final Map<OperationKey, Operation> operationsWebSocket = new HashMap<OperationKey, Operation>();
    private final Map<String, Set<OperationKey>> servletKeysByPath = new HashMap<String, Set<OperationKey>>();
    private static final Set<String> allowEntity = new HashSet<String>();

    public RestServiceProvider(RestService rs) throws Exception {
        String path;
        this.service = rs;
        this.marshaller = new JsonMarshaller();
        for (Object clazz : this.service.getTypeHandlers()) {
            TypeHandler handler = (TypeHandler)XSHelper.getClassForName((String)clazz).newInstance();
            this.marshaller.addTypeHandler(handler);
        }
        for (Object clazz : this.service.getTypeDiscriminators()) {
            TypeDiscriminator discriminator = (TypeDiscriminator)XSHelper.getClassForName((String)clazz).newInstance();
            this.marshaller.addTypeDiscriminator(discriminator);
        }
        boolean defaultAutorization = false;
        for (Object descriptor : this.service.getInterceptors()) {
            Object interceptor;
            if (TextUtil.isBlank((String)descriptor.getClassName())) {
                throw Xeption.forDeveloper((String)"rest interceptor descriptor class name is empty", (Object[])new Object[0]);
            }
            if (descriptor instanceof RestService.AuthInterceptorDescriptor) {
                RestService.AppliedTo applied = ((RestService.AuthInterceptorDescriptor)descriptor).getAppliedTo();
                if (RestService.AppliedTo.NONE == applied) {
                    defaultAutorization = false;
                } else if (RestService.AppliedTo.ALL == applied) {
                    defaultAutorization = true;
                }
                interceptor = XSHelper.getClass((String)descriptor.getClassName()).newInstance();
                if (interceptor instanceof AuthRestInterceptor) {
                    this.interceptors.add(interceptor);
                    continue;
                }
            } else if (descriptor instanceof RestService.GenericInterceptorDescriptor) {
                interceptor = XSHelper.getClass((String)descriptor.getClassName()).newInstance();
                if (interceptor instanceof GenericRestInterceptor) {
                    this.interceptors.add(interceptor);
                    continue;
                }
            } else {
                throw Xeption.forDeveloper((String)("unsupported rest interceptor descriptor type " + String.valueOf(descriptor.getClass().getName())), (Object[])new Object[0]);
            }
            throw Xeption.forDeveloper((String)("invalid rest interceptor class type " + String.valueOf(interceptor.getClass().getName())), (Object[])new Object[0]);
        }
        String validatingPathSuffix = this.service.getValidatingPathSuffix();
        if (TextUtil.isBlank((String)validatingPathSuffix)) {
            validatingPathSuffix = "/validate";
        }
        if (!validatingPathSuffix.startsWith("/")) {
            validatingPathSuffix = "/" + validatingPathSuffix;
        }
        if (validatingPathSuffix.endsWith("/")) {
            validatingPathSuffix = validatingPathSuffix.substring(0, validatingPathSuffix.length() - 1);
        }
        for (RestServiceOperation restOperation : this.service.getOperations().values()) {
            String path2 = restOperation.getPath();
            if (!path2.startsWith("/")) {
                path2 = "/" + path2;
            }
            if (path2.endsWith("/")) {
                path2 = path2.substring(0, path2.length() - 1);
            }
            try {
                Operation operation;
                String validatingRouteId = restOperation.getValidatingRouteId();
                if (!TextUtil.isBlank((String)restOperation.getRouteId())) {
                    operation = new Operation(restOperation, defaultAutorization, restOperation.getRouteId());
                    this.registerOperation(new OperationKey(path2, restOperation.getMethod()), operation);
                    if (TextUtil.isBlank((String)validatingRouteId)) continue;
                    this.registerOperation(new OperationKey(path2 + validatingPathSuffix, restOperation.getMethod()), new Operation(operation, validatingRouteId));
                    continue;
                }
                if (TextUtil.isBlank((String)validatingRouteId)) {
                    throw Xeption.forDeveloper((String)"operation have got empty route and validating-route", (Object[])new Object[0]);
                }
                operation = new Operation(restOperation, defaultAutorization, null);
                this.registerOperation(new OperationKey(path2 + validatingPathSuffix, restOperation.getMethod()), new Operation(operation, validatingRouteId));
            }
            catch (Throwable t) {
                this.log.error((Object)("unable to configure rest operation " + restOperation.getId() + ", service " + this.service.getId() + ", path " + path2 + ", method " + restOperation.getMethod()), t);
            }
        }
        Set servletPaths = this.operationsServlet.keySet().stream().map(k -> k.getPath().toLowerCase()).collect(Collectors.toSet());
        for (Map.Entry<OperationKey, Operation> e : this.operationsWebSocket.entrySet()) {
            path = e.getKey().getPath();
            if (!"GET".equals(e.getKey().getMethod())) {
                throw new IllegalStateException(String.format("Only GET operation supported for WebSocket services. Found %s for %s.", e.getKey().getMethod(), path));
            }
            if (!servletPaths.contains(path.toLowerCase())) continue;
            throw new IllegalStateException(String.format("Duplicate operation path for servlet and websocket - %s", path));
        }
        for (OperationKey k2 : this.operationsServlet.keySet()) {
            path = k2.getPath();
            Set<OperationKey> keys = this.servletKeysByPath.get(path);
            if (keys == null) {
                keys = new HashSet<OperationKey>();
                this.servletKeysByPath.put(path, keys);
            }
            keys.add(k2);
        }
        this.log.info((Object)("REST service " + this.service.getId() + " started"));
    }

    public Operation getServiceOperation(OperationKey key, OperationType operationType) {
        Map<OperationKey, Operation> operationsMap;
        switch (operationType) {
            case SERVLET: {
                operationsMap = this.operationsServlet;
                break;
            }
            case WEBSOCKET: {
                operationsMap = this.operationsWebSocket;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation type");
            }
        }
        Operation result = operationsMap.get(key);
        if (result == null) {
            return null;
        }
        if (result.getType() != operationType) {
            throw new IllegalArgumentException("Operation type does not match requested one");
        }
        return result;
    }

    public Set<OperationKey> getServletOperationsByPath(String path) {
        Set<OperationKey> result = this.servletKeysByPath.get(path);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    public RestService getService() {
        return this.service;
    }

    public InvocationResult invokeService(final Operation operation, final Map<String, Object> ibusContext, final RestContext restContext) throws Exception {
        Parameters params;
        InvocationResult result;
        block39: {
            boolean useAsyncContext = restContext instanceof RestContextAsync;
            if (operation.getType() == OperationType.WEBSOCKET && !useAsyncContext) {
                throw new IllegalArgumentException("Websocket operation must have async context");
            }
            if (operation.getType() == OperationType.SERVLET && useAsyncContext) {
                throw new IllegalArgumentException("Servlet operation does not support async context");
            }
            result = new InvocationResult();
            result.setOperation(operation);
            result.setIbusContext(ibusContext);
            LogicalStorage.get().setUser("system");
            ibusContext.put(IBusRestContextKeys.REST_CONTEXT.name(), restContext);
            ibusContext.put(IBusRestContextKeys.REST_MESSAGES.name(), result.getMessages());
            ibusContext.put(IBusRestContextKeys.JSON_MARSHALLER.name(), this.marshaller);
            try {
                params = this.getParameters(restContext, operation);
            }
            catch (NetworkConnectionException e) {
                this.log.warn((Object)"Network error", (Throwable)e);
                return result;
            }
            result.setValidatedEntity(params.validatedEntity);
            result.setValidatedParameters(params.validatedParams);
            if (result.hasValidation()) {
                return result;
            }
            if (params.params != null) {
                ibusContext.put(IBusRestContextKeys.REST_PARAMS.name(), params.params);
            }
            if (params.entity != null) {
                ibusContext.put(IBusRestContextKeys.REST_ENTITY.name(), params.entity);
            }
            try {
                IntValue interceptorLevel = new IntValue(-1);
                try {
                    for (Object interceptor : this.interceptors) {
                        if (interceptor instanceof AuthRestInterceptor) {
                            if (operation.hasAutorization()) {
                                ((AuthRestInterceptor)interceptor).authorize(restContext, ibusContext);
                            }
                        } else if (interceptor instanceof GenericRestInterceptor) {
                            ((GenericRestInterceptor)interceptor).before(restContext, ibusContext);
                        }
                        ++interceptorLevel.value;
                    }
                    String routeId = operation.getRouteId();
                    InterceptorRunner interceptorsAfterResponse = level -> {
                        for (int i = level.value; i >= 0; --i) {
                            --level.value;
                            Object interceptor = this.interceptors.get(i);
                            if (!(interceptor instanceof GenericRestInterceptor)) continue;
                            ((GenericRestInterceptor)interceptor).after(restContext, ibusContext);
                        }
                    };
                    try {
                        switch (operation.getType()) {
                            case SERVLET: {
                                if (IntegrationBusFacade.get().isShutdown()) {
                                    throw Xeption.forEndUser((String)"\u0441\u0435\u0440\u0432\u0435\u0440 \u0432\u044b\u043a\u043b\u044e\u0447\u0430\u0435\u0442\u0441\u044f", (Object[])new Object[0]);
                                }
                                IntegrationBusFacade.get().processRouteSync(routeId, ibusContext);
                                break;
                            }
                            case WEBSOCKET: {
                                if (IntegrationBusFacade.get().isShutdown()) {
                                    throw Xeption.forEndUser((String)"\u0441\u0435\u0440\u0432\u0435\u0440 \u0432\u044b\u043a\u043b\u044e\u0447\u0430\u0435\u0442\u0441\u044f", (Object[])new Object[0]);
                                }
                                ibusContext.put(IBusRestContextKeys.REST_WEBSOCKET_CALLBACK.name(), new IBusWebSocketCallback(){

                                    @Override
                                    public void sendResponse(Object response, List<InformationMessage> messages) {
                                        InvocationResult invocationResult = new InvocationResult();
                                        invocationResult.setOperation(operation);
                                        invocationResult.setIbusContext(ibusContext);
                                        invocationResult.setResult(response);
                                        if (messages != null && messages.size() != 0) {
                                            invocationResult.getMessages().addAll(messages);
                                        }
                                        ((RestContextAsync)restContext).sendReponse(invocationResult);
                                    }

                                    @Override
                                    public void sendError(Throwable error) {
                                        ((RestContextAsync)restContext).sendError(error);
                                    }
                                });
                                IntegrationBusFacade.get().processRouteSync(routeId, ibusContext);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unsupported operation type");
                            }
                        }
                    }
                    catch (IntegrationBusException e) {
                        if (e.getMessage() == null && e.getCause() != null) {
                            throw e.getCause();
                        }
                        throw e;
                    }
                    result.setResult(ibusContext.get(IBusRestContextKeys.REST_RESULT.name()));
                    interceptorsAfterResponse.run(interceptorLevel);
                }
                catch (Throwable t) {
                    boolean handled = false;
                    while (interceptorLevel.value >= 0) {
                        Object interceptor = this.interceptors.get(interceptorLevel.value);
                        if (interceptor instanceof GenericRestInterceptor) {
                            GenericRestInterceptor genericRestInterceptor = (GenericRestInterceptor)interceptor;
                            try {
                                if (!handled && genericRestInterceptor.handleException(restContext, ibusContext, t)) {
                                    handled = true;
                                }
                            }
                            catch (Throwable t2) {
                                t = t2;
                            }
                            try {
                                genericRestInterceptor.after(restContext, ibusContext);
                            }
                            catch (Throwable t2) {
                                t = t2;
                            }
                        }
                        --interceptorLevel.value;
                    }
                    if (!handled) {
                        if (t instanceof Exception) {
                            throw (Exception)t;
                        }
                        throw new Exception("Error invoking the service", t);
                    }
                }
            }
            catch (IntegrationBusException e) {
                if (!(e.getCause() instanceof ValidationException)) {
                    throw e;
                }
                if (operation.isValitableParams()) {
                    result.setValidatedParameters(RestServiceProvider.getValidatedObject((Validatable)params.params));
                }
                if (operation.isValitableEntity()) {
                    result.setValidatedEntity(RestServiceProvider.getValidatedObject((Validatable)params.entity));
                }
                if (result.hasValidation()) break block39;
                if (this.isUpdateValidationInfo(ibusContext)) {
                    result.setValidatedParameters(this.getValidationObject(ibusContext, IBusRestContextKeys.REST_PARAMS.name()));
                    result.setValidatedEntity(this.getValidationObject(ibusContext, IBusRestContextKeys.REST_ENTITY.name()));
                }
                if (result.hasValidation()) break block39;
                throw Xeption.forDeveloper((String)"no validation information found", (Throwable)e, (Object[])new Object[0]);
            }
        }
        if (result.getResult() == null && result.getValidatedParameters() == null && operation.isValitableParams()) {
            result.setValidatedParameters(RestServiceProvider.getValidatedObject((Validatable)params.params));
        }
        return result;
    }

    public JSONObject generateResponseJSON(InvocationResult invocationResult) throws Exception {
        if (!invocationResult.hasValidation() && invocationResult.getResult() instanceof Validatable && !ValidationHelper.isValid((Validatable)invocationResult.getResult())) {
            throw Xeption.forDeveloper((String)"not valid result object", (Object[])new Object[0]);
        }
        Map<String, Object> ibusContext = invocationResult.getIbusContext();
        RestContext restContext = (RestContext)ibusContext.get(IBusRestContextKeys.REST_CONTEXT.name());
        JSONObject json = new JSONObject();
        if (invocationResult.getValidatedEntity() != null) {
            json.put("validatedEntity", this.marshaller.marshal(invocationResult.getValidatedEntity(), ibusContext, "validatedEntity"));
        }
        if (invocationResult.getValidatedParameters() != null) {
            json.put("validatedParameters", this.marshaller.marshal(invocationResult.getValidatedParameters(), ibusContext, "validatedParameters"));
        }
        if (!invocationResult.hasValidation()) {
            if (invocationResult.getResult() == null && invocationResult.getOperation().isResultRequired()) {
                this.log.error((Object)("no-mandatory-result-found\n" + this.getInvResultString(invocationResult)));
                throw Xeption.forDeveloper((String)"no mandatory result found", (Object[])new Object[0]);
            }
            if (invocationResult.getResult() != null) {
                if (!this.isSpecialProcessed(invocationResult.getResult(), ibusContext, restContext) && !invocationResult.getOperation().getResultClass().isAssignableFrom(invocationResult.getResult().getClass())) {
                    throw Xeption.forDeveloper((String)("invalid response result class, expected " + invocationResult.getOperation().getResultClass() + ", actual " + invocationResult.getResult().getClass()), (Object[])new Object[0]);
                }
                json.put("result", this.marshaller.marshal(invocationResult.getResult(), ibusContext, "result"));
            }
        }
        if (!invocationResult.getMessages().isEmpty()) {
            json.put("messages", this.marshaller.marshal(invocationResult.getMessages(), ibusContext, true, true, "messages"));
        }
        if (MiscUtil.isTrue((String)System.getProperty("debug.rest"))) {
            ArrayList<String> list = new ArrayList<String>();
            Map contextMessages = (Map)ibusContext.get("messages");
            if (contextMessages != null) {
                for (Message message : contextMessages.values()) {
                    if (message == null || message.getMessage() == null) continue;
                    list.add(message.getMessage().toString());
                }
            }
            if (!list.isEmpty()) {
                json.put("debugMessages", this.marshaller.marshal(list, ibusContext, true, true, "debugMessages"));
            }
        }
        RestServiceProvider.setResponseStatusCode(json, restContext);
        if (json.keySet().isEmpty()) {
            return null;
        }
        return json;
    }

    private String getInvResultString(InvocationResult invocationResult) {
        StringBuilder sb;
        block8: {
            sb = new StringBuilder();
            try {
                sb.append("operation=").append(ObjectTrace.toString((Object)invocationResult.getOperation())).append("\n");
            }
            catch (IOException e) {
                if (invocationResult.operation == null) break block8;
                sb.append("isValitableParams=").append(invocationResult.operation.isValitableParams()).append("\n");
                sb.append("isValitableEntity=").append(invocationResult.operation.isValitableEntity()).append("\n");
                sb.append("isResultRequired=").append(invocationResult.operation.isResultRequired()).append("\n");
            }
        }
        try {
            sb.append("result=").append(ObjectTrace.toString((Object)invocationResult.getResult())).append("\n");
        }
        catch (IOException e) {
            sb.append("hasValidation=").append(invocationResult.hasValidation()).append("\n");
            sb.append("validatedParameters==null:").append(invocationResult.validatedParameters == null).append("\n");
            sb.append("result==null:").append(invocationResult.result == null).append("\n");
        }
        try {
            sb.append("validParams=").append(ObjectTrace.toString((Object)invocationResult.getValidatedParameters())).append("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            sb.append("validEntity=").append(ObjectTrace.toString((Object)invocationResult.getValidatedEntity())).append("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public JSONObject handleInvocationError(Map<String, Object> ibusData, RestContext restContext, Throwable cause) {
        List messages;
        if (restContext.getStatus() == 200) {
            restContext.setStatus(400);
        }
        JSONObject responseJSON = new JSONObject();
        String userMessage = L10nResourcesManager.getStr((String)"AN_ERROR_HAS_OCCURRED_CONTACT_SUPPORT", (Object[])new Object[0]);
        String developerMessage = null;
        Xeption xe = XeptionHelper.findXeption((Throwable)cause);
        if (xe != null) {
            if (xe.getEndUserMessage() != null) {
                userMessage = xe.getEndUserMessage().toString();
            } else if (xe.getAdminMessage() != null) {
                userMessage = xe.getAdminMessage().toString() + " " + L10nResourcesManager.getStr((String)"CONTACT_SUPPORT", (Object[])new Object[0]);
            }
            developerMessage = xe.getMessage();
        }
        responseJSON.put("userErrorMessage", this.marshaller.marshal(userMessage, ibusData, true, true, "userErrorMessage"));
        if (developerMessage != null) {
            responseJSON.put("developerErrorMessage", this.marshaller.marshal(developerMessage, ibusData, true, true, "developerErrorMessage"));
        }
        if (!CollectionUtil.isEmpty((Collection)(messages = (List)ibusData.get(IBusRestContextKeys.REST_MESSAGES.name())))) {
            responseJSON.put("messages", this.marshaller.marshal(messages, ibusData, true, true, "messages"));
        }
        ErrorMessageType errorMessageType = null;
        if (xe != null) {
            if (xe.getMessage() != null) {
                errorMessageType = ErrorMessageType.DEVELOPER;
            } else if (xe.getAdminMessage() != null) {
                errorMessageType = ErrorMessageType.ADMIN;
            } else if (xe.getEndUserMessage() != null) {
                errorMessageType = ErrorMessageType.USER;
            }
        }
        if (errorMessageType != null) {
            responseJSON.put("errorMessageType", (Object)errorMessageType.name());
        }
        if (MiscUtil.isTrue((String)System.getProperty("debug.rest"))) {
            String stackTrace;
            if (cause.getMessage() != null) {
                responseJSON.put("exceptionMessage", this.marshaller.marshal(cause.getMessage(), ibusData, true, true, "exceptionMessage"));
            }
            if ((stackTrace = TextUtil.getExceptionStackTrace((Throwable)cause)) != null) {
                responseJSON.put("exceptionStackTrace", this.marshaller.marshal(stackTrace, ibusData, true, true, "exceptionStackTrace"));
            }
        }
        RestServiceProvider.setResponseStatusCode(responseJSON, restContext);
        return responseJSON;
    }

    private static void setResponseStatusCode(JSONObject responseJSON, RestContext restContext) {
        if (responseJSON != null && responseJSON.length() == 0 && restContext.getStatus() == 200) {
            restContext.setStatus(204);
        }
    }

    private void registerOperation(OperationKey key, Operation operation) {
        Map<OperationKey, Operation> operationsMap;
        switch (operation.getType()) {
            case SERVLET: {
                operationsMap = this.operationsServlet;
                break;
            }
            case WEBSOCKET: {
                operationsMap = this.operationsWebSocket;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported opreration type: " + operation.getType().name());
            }
        }
        operationsMap.put(key, operation);
    }

    private Object getValidationObject(Map<String, Object> data, String id) {
        if (!data.containsKey(id)) {
            return null;
        }
        Object object = data.get(id);
        return object instanceof Validatable ? object : null;
    }

    protected boolean isUpdateValidationInfo(Map<String, Object> data) throws Exception {
        return false;
    }

    protected boolean isSpecialProcessed(Object result, Map<String, Object> data, RestContext restContext) {
        return false;
    }

    private Parameters getParameters(RestContext restContext, Operation operation) throws Exception {
        HttpServletRequest request = restContext.getRequest();
        Collection<?> params = null;
        Object entity = null;
        Object validatedParams = null;
        Object validatedEntity = null;
        String method = request.getMethod();
        if (("GET".equals(method) || "application/x-www-form-urlencoded".equals(restContext.getRequest().getContentType())) && !(restContext instanceof RestContextAsync)) {
            if (operation.getParamsClass() != null) {
                params = this.marshaller.unmarshal(JsonMarshaller.createJSONObject(request.getParameterMap()), operation.getParamsClass(), null, method);
                if (operation.isValitableParams()) {
                    validatedParams = RestServiceProvider.getValidatedObject((Validatable)params);
                }
            }
        } else {
            Object entityObject;
            Object paramObject;
            JSONObject json;
            if (operation.getParamsClass() != null && BinaryData.class.isAssignableFrom(operation.getParamsClass()) || operation.getEntityClass() != null && BinaryData.class.isAssignableFrom(operation.getEntityClass())) {
                BinaryData binaryData = new BinaryData();
                binaryData.setContentType(HttpHelper.getContentType((String)request.getContentType()));
                binaryData.setData(IOUtils.toByteArray((Reader)request.getReader()));
                return new Parameters(binaryData, entity, validatedParams, validatedEntity);
            }
            DebugBufferedReader debugBufferedReader = new DebugBufferedReader(request.getReader(), 10, 10);
            try {
                JSONTokener jsonTokener = new JSONTokener((Reader)debugBufferedReader);
                json = new JSONObject(jsonTokener);
            }
            catch (JSONException e) {
                if (e.getCause() != null && (e.getCause() instanceof EOFException || e.getCause() instanceof MalformedInputException) || e.getMessage() != null && e.getMessage().startsWith("Unterminated string at ")) {
                    throw new NetworkConnectionException(e);
                }
                debugBufferedReader.finish();
                FixedCharList head = debugBufferedReader.getHead();
                FixedCharQueue window = debugBufferedReader.getWindow();
                String methodName = "RestJsonParsing";
                long readBytes = debugBufferedReader.getReadBytes();
                String contentLengthValue = Optional.ofNullable(request.getHeader("Content-Length")).orElse("null");
                ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>();
                stackTraceElements.add(MiscUtil.getContextStackTraceElement((String)methodName, (String)("head=" + head)));
                stackTraceElements.add(MiscUtil.getContextStackTraceElement((String)methodName, (String)("window=" + window)));
                stackTraceElements.add(MiscUtil.getContextStackTraceElement((String)methodName, (String)("readBytes=" + readBytes)));
                stackTraceElements.add(MiscUtil.getContextStackTraceElement((String)methodName, (String)("ContentLengthHeader=" + contentLengthValue)));
                MiscUtil.addStackTraceElement((Throwable)e, (StackTraceElement[])stackTraceElements.toArray(new StackTraceElement[0]));
                throw e;
            }
            if (operation.getParamsClass() != null && null != (paramObject = json.opt("parameters")) && !paramObject.equals(JSONObject.NULL)) {
                if (null == operation.getParamsItemClass()) {
                    params = this.marshaller.unmarshal(json.getJSONObject("parameters"), operation.getParamsClass(), null, method);
                    if (operation.isValitableParams()) {
                        validatedParams = RestServiceProvider.getValidatedObject((Validatable)params);
                    }
                } else {
                    params = this.marshaller.unmarshalCollection(json.getJSONArray("parameters"), operation.getParamsItemClass(), null, method);
                    if (operation.isValitableParams()) {
                        validatedParams = this.getValidatedObject(params);
                    }
                }
            }
            if (operation.getEntityClass() != null && null != (entityObject = json.opt("entity")) && !entityObject.equals(JSONObject.NULL)) {
                entity = this.marshaller.unmarshal(json.getJSONObject("entity"), operation.getEntityClass(), null, method);
                if (operation.isValitableEntity()) {
                    validatedEntity = RestServiceProvider.getValidatedObject((Validatable)entity);
                }
            }
        }
        if (operation.isParamsRequired() && null == params) {
            throw Xeption.forDeveloper((String)"no mandatory parameters object found", (Object[])new Object[0]);
        }
        if (operation.isEntityRequired() && null == entity) {
            throw Xeption.forDeveloper((String)"no mandatory entity object found", (Object[])new Object[0]);
        }
        return new Parameters(params, entity, validatedParams, validatedEntity);
    }

    private static Object getValidatedObject(Validatable params) throws Exception {
        if (!ValidationHelper.noValidationMessages(params)) {
            return ValidationHelper.clearValidValues(params);
        }
        return null;
    }

    private <E> Object getValidatedObject(Collection<E> params) throws Exception {
        ArrayList<Validatable> validatedEntity = null;
        for (E item : params) {
            if (ValidationHelper.noValidationMessages((Validatable)item)) continue;
            if (null == validatedEntity) {
                validatedEntity = new ArrayList<Validatable>();
            }
            validatedEntity.add(ValidationHelper.clearValidValues((Validatable)item));
        }
        return validatedEntity;
    }

    static {
        allowEntity.add(BinaryData.class.getName());
    }

    private static enum ErrorMessageType {
        USER,
        ADMIN,
        DEVELOPER;

    }

    private static class IntValue {
        int value;

        IntValue(int initialValue) {
            this.value = initialValue;
        }
    }

    @FunctionalInterface
    private static interface InterceptorRunner {
        public void run(IntValue var1) throws Exception;
    }

    static final class InvocationResult {
        private Operation operation;
        private Map<String, Object> ibusContext;
        private Object result;
        private Object validatedEntity;
        private Object validatedParameters;
        private final List<InformationMessage> messages = new ArrayList<InformationMessage>();

        InvocationResult() {
        }

        public Operation getOperation() {
            return this.operation;
        }

        public void setOperation(Operation operation) {
            this.operation = operation;
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public Object getValidatedEntity() {
            return this.validatedEntity;
        }

        public void setValidatedEntity(Object validatedEntity) {
            this.validatedEntity = validatedEntity;
        }

        public Object getValidatedParameters() {
            return this.validatedParameters;
        }

        public void setValidatedParameters(Object validatedParameters) {
            this.validatedParameters = validatedParameters;
        }

        public List<InformationMessage> getMessages() {
            return this.messages;
        }

        public boolean hasValidation() {
            return this.validatedEntity != null || this.validatedParameters != null;
        }

        public Map<String, Object> getIbusContext() {
            return this.ibusContext;
        }

        public void setIbusContext(Map<String, Object> ibusContext) {
            this.ibusContext = ibusContext;
        }
    }

    static final class OperationKey {
        private final String path;
        private final String method;

        public OperationKey(String path, String method) {
            this.path = path;
            this.method = method;
        }

        public String getPath() {
            return this.path;
        }

        public String getMethod() {
            return this.method;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OperationKey other = (OperationKey)obj;
            if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }
    }

    static enum OperationType {
        SERVLET,
        WEBSOCKET;

    }

    public static final class Operation {
        private final Class<?> paramsClass;
        private final Class<?> paramsItemClass;
        private final Class<?> entityClass;
        private final Class<?> resultClass;
        private final Class<?> resultItemClass;
        private final boolean paramsRequired;
        private final boolean entityRequired;
        private final boolean resultRequired;
        private final boolean valitableParams;
        private final boolean valitableEntity;
        private final boolean hasAutorization;
        private final OperationType type;
        private final String method;
        private final String routeId;
        private final boolean corsSupported;

        public Operation(RestServiceOperation operation, boolean defaultAutorization, String routeId) throws Exception {
            this.routeId = routeId;
            this.hasAutorization = operation.getAuth() != null ? operation.getAuth() : defaultAutorization;
            this.type = Boolean.TRUE.equals(operation.getWebsocket()) ? OperationType.WEBSOCKET : OperationType.SERVLET;
            this.method = operation.getMethod();
            this.corsSupported = Boolean.TRUE.equals(operation.getCorsSupported());
            RestServiceOperation.ParametersDescriptor paramsInfo = operation.getParametersDescriptor();
            RestServiceOperation.EntityDescriptor entityInfo = operation.getEntityDescriptor();
            RestServiceOperation.ResultDescriptor resultInfo = operation.getResultDescriptor();
            if (paramsInfo != null) {
                boolean bl = this.paramsRequired = !paramsInfo.isOptional();
                if (!paramsInfo.isCollection()) {
                    this.paramsClass = XHelper.getClass((String)paramsInfo.getTypeId());
                    this.paramsItemClass = null;
                } else {
                    if ("GET".equals(operation.getMethod())) {
                        throw Xeption.forDeveloper((String)("method " + operation.getMethod() + " not support list request"), (Object[])new Object[0]);
                    }
                    this.paramsClass = Collection.class;
                    this.paramsItemClass = XHelper.getClass((String)paramsInfo.getTypeId());
                }
                if (this.paramsRequired && null == this.paramsClass) {
                    throw Xeption.forDeveloper((String)"operation have got empty required parameters type-id", (Object[])new Object[0]);
                }
                this.valitableParams = Operation.getEntityValidatable(paramsInfo.getTypeId());
            } else {
                this.paramsRequired = false;
                this.paramsClass = null;
                this.paramsItemClass = null;
                this.valitableParams = false;
            }
            if (entityInfo != null) {
                if ("GET".equals(operation.getMethod())) {
                    throw Xeption.forDeveloper((String)("method " + operation.getMethod() + " not support entity in request"), (Object[])new Object[0]);
                }
                this.entityRequired = !entityInfo.isOptional();
                this.entityClass = XHelper.getClass((String)entityInfo.getTypeId());
                this.valitableEntity = Operation.getEntityValidatable(entityInfo.getTypeId());
                if (this.entityRequired && null == this.entityClass) {
                    throw Xeption.forDeveloper((String)"operation have got empty required entity type-id", (Object[])new Object[0]);
                }
                this.resultRequired = this.entityRequired;
                this.resultClass = this.entityClass;
                this.resultItemClass = null;
            } else {
                this.entityRequired = false;
                this.entityClass = null;
                this.valitableEntity = false;
                if (resultInfo != null) {
                    boolean bl = this.resultRequired = !resultInfo.isOptional();
                    if (!resultInfo.isCollection()) {
                        this.resultClass = XHelper.getClass((String)resultInfo.getTypeId());
                        this.resultItemClass = null;
                    } else {
                        this.resultClass = Collection.class;
                        this.resultItemClass = XHelper.getClass((String)resultInfo.getTypeId());
                    }
                    if (this.resultRequired && null == this.resultClass) {
                        throw Xeption.forDeveloper((String)"operation have got empty required result type-id", (Object[])new Object[0]);
                    }
                } else {
                    this.resultRequired = false;
                    this.resultClass = null;
                    this.resultItemClass = null;
                }
            }
            if (this.type == OperationType.WEBSOCKET && this.paramsClass != null && BinaryData.class.isAssignableFrom(this.paramsClass)) {
                throw new IllegalArgumentException("Requests of type BinaryData not supported for WebSocket requests");
            }
            if (this.entityClass != null && this.resultClass != null && !this.entityClass.equals(this.resultClass)) {
                throw new IllegalArgumentException(String.format("entity %s and result %s must have same classes", this.entityClass, this.resultClass));
            }
        }

        public Operation(Operation operation, String validatingRouteId) {
            this.routeId = validatingRouteId;
            this.paramsClass = operation.paramsClass;
            this.paramsItemClass = operation.paramsItemClass;
            this.entityClass = operation.entityClass;
            this.resultClass = null;
            this.resultItemClass = null;
            this.paramsRequired = operation.paramsRequired;
            this.entityRequired = operation.entityRequired;
            this.resultRequired = false;
            this.valitableParams = operation.valitableParams;
            this.valitableEntity = operation.valitableEntity;
            this.hasAutorization = operation.hasAutorization;
            this.type = OperationType.SERVLET;
            this.method = operation.method;
            this.corsSupported = operation.corsSupported;
        }

        private static boolean getEntityValidatable(String id) {
            RestEntityType entityType = (RestEntityType)RestMetaRegistry.get().getEntities().get(id);
            if (entityType != null) {
                return entityType.isValidatable();
            }
            if (allowEntity.contains(id)) {
                return false;
            }
            RestEnumType enumType = (RestEnumType)RestMetaRegistry.get().getEnums().get(id);
            if (enumType != null) {
                return false;
            }
            throw Xeption.forDeveloper((String)String.format("no rest meta found for id=[%s]", id), (Object[])new Object[0]);
        }

        public String getRouteId() {
            return this.routeId;
        }

        public Class<?> getParamsClass() {
            return this.paramsClass;
        }

        public Class<?> getResultClass() {
            return this.resultClass;
        }

        public boolean isParamsRequired() {
            return this.paramsRequired;
        }

        public boolean isEntityRequired() {
            return this.entityRequired;
        }

        public boolean isResultRequired() {
            return this.resultRequired;
        }

        public Class<?> getParamsItemClass() {
            return this.paramsItemClass;
        }

        public Class<?> getEntityClass() {
            return this.entityClass;
        }

        public Class<?> getResultItemClass() {
            return this.resultItemClass;
        }

        public boolean isValitableParams() {
            return this.valitableParams;
        }

        public boolean isValitableEntity() {
            return this.valitableEntity;
        }

        public boolean hasAutorization() {
            return this.hasAutorization;
        }

        public OperationType getType() {
            return this.type;
        }

        public String getMethod() {
            return this.method;
        }

        public boolean isCorsSupported() {
            return this.corsSupported;
        }
    }

    static final class Parameters {
        final Object params;
        final Object entity;
        final Object validatedParams;
        final Object validatedEntity;

        public Parameters(Object params, Object entity, Object validatedParams, Object validatedEntity) {
            this.params = params;
            this.entity = entity;
            this.validatedParams = validatedParams;
            this.validatedEntity = validatedEntity;
        }
    }
}

