/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest;

import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.meta.rest.RestService;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.web.ServletInfo;
import com.gridnine.xtrip.server.web.ServletsRegistry;
import com.gridnine.xtrip.server.web.WebSocketEndpointInfo;
import com.gridnine.xtrip.server.web.WebSocketsRegistry;
import com.gridnine.xtrip.server.web.rest.RestServiceProvider;
import com.gridnine.xtrip.server.web.rest.RestServlet;
import com.gridnine.xtrip.server.web.rest.RestWebSocketEndpointInfo;
import com.gridnine.xtrip.server.web.rest.WebSocketEndpoint;
import java.lang.reflect.Constructor;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestServicesPublisher
implements Publisher {
    private final transient Log log = LogFactory.getLog(this.getClass());

    public void publish() throws Exception {
        for (RestService restService : RestMetaRegistry.get().getServices().values()) {
            Object serviceProvider = this.getServiceProvider("rest-service-provider.className", restService);
            Object info = new ServletInfo();
            ((ServletInfo)info).setId(restService.getId());
            ((ServletInfo)info).setServletName(restService.getId());
            ((ServletInfo)info).setServletMappingPattern(String.format("/%s/*", restService.getPath()));
            ((ServletInfo)info).setWebContextPath("");
            ((ServletInfo)info).setServlet((Servlet)new RestServlet((RestServiceProvider)serviceProvider));
            ServletsRegistry.get().register((ServletInfo)info);
            this.log.info((Object)("registered servlet for REST service " + restService.getId()));
            if (TextUtil.isBlank((String)restService.getWebSocketPath())) continue;
            info = new RestWebSocketEndpointInfo();
            ((WebSocketEndpointInfo)info).setEndpointClass(WebSocketEndpoint.class);
            ((WebSocketEndpointInfo)info).setId(restService.getId());
            ((WebSocketEndpointInfo)info).setPath(restService.getWebSocketPath());
            ((WebSocketEndpointInfo)info).setWebContextPath("");
            ((RestWebSocketEndpointInfo)info).setServiceProvider((RestServiceProvider)serviceProvider);
            WebSocketsRegistry.get().register((WebSocketEndpointInfo)info);
            this.log.info((Object)("registered WebSocket endpoint for REST service " + restService.getId()));
        }
    }

    private <T extends RestServiceProvider> T getServiceProvider(String key, RestService restService) throws Exception {
        String className = System.getProperty(key);
        if (!TextUtil.isBlank((String)className)) {
            try {
                Class<?> cls = Class.forName(className);
                Constructor<?> constructor = cls.getConstructor(restService.getClass());
                return (T)((RestServiceProvider)constructor.newInstance(restService));
            }
            catch (Exception exception) {
                this.log.error((Object)String.format("unable to load class $1%s", className), (Throwable)exception);
            }
        }
        return (T)new RestServiceProvider(restService);
    }
}

