/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest;

import com.gridnine.xtrip.server.web.WebSocketEndpointInfo;
import com.gridnine.xtrip.server.web.rest.HandshakeRequestAdapter;
import com.gridnine.xtrip.server.web.rest.HandshakeResponseAdapter;
import com.gridnine.xtrip.server.web.rest.RestServiceProvider;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;

public class RestWebSocketEndpointInfo
extends WebSocketEndpointInfo {
    private RestServiceProvider serviceProvider;

    public RestServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(RestServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    @Override
    public ServerEndpointConfig.Configurator getEndpointConfigurator() {
        return new WebSocketEndpointConfigurator();
    }

    class WebSocketEndpointConfigurator
    extends ServerEndpointConfig.Configurator {
        public static final String KEY_SERVICE_PROVIDER = "KEY_SERVICE_PROVIDER";
        public static final String KEY_HTTP_REQUEST = "KEY_HTTP_REQUEST";
        public static final String KEY_HTTP_RESPONSE = "KEY_HTTP_RESPONSE";

        WebSocketEndpointConfigurator() {
        }

        public void modifyHandshake(ServerEndpointConfig config, HandshakeRequest request, HandshakeResponse response) {
            super.modifyHandshake(config, request, response);
            config.getUserProperties().put(KEY_SERVICE_PROVIDER, RestWebSocketEndpointInfo.this.serviceProvider);
            config.getUserProperties().put(KEY_HTTP_REQUEST, new HandshakeRequestAdapter(request, config));
            config.getUserProperties().put(KEY_HTTP_RESPONSE, new HandshakeResponseAdapter(response));
        }
    }
}

