/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest;

import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestMap;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistryHelper;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.rest.InformationMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ValidationHelper {
    public static boolean isValid(Collection<? extends Validatable> objects) {
        for (Validatable validatable : objects) {
            if (ValidationHelper.isValid(validatable)) continue;
            return false;
        }
        return true;
    }

    public static boolean noValidationMessages(Validatable object) {
        return ValidationHelper.noValidationMessages(object, false);
    }

    public static boolean isValid(Validatable object) {
        return ValidationHelper.noValidationMessages(object, true);
    }

    private static boolean noValidationMessages(Validatable object, boolean onlyErrors) {
        Collection value;
        RestEntityType elementEt;
        RestEntityType et = RestMetaRegistryHelper.getEntityType((String)object.getClass().getName());
        for (RestProperty prop : RestMetaRegistryHelper.getAllProperties((RestEntityType)et).values()) {
            Validatable child;
            RestEntityType childEt;
            if (et.isValidatable() && ValidationHelper.hasMessages(object.getValidationContext().getValidationMessages(prop.getId()), onlyErrors)) {
                return false;
            }
            Object propValue = object.getValue(prop.getId());
            if (propValue == null || (childEt = RestMetaRegistryHelper.getEntityType((String)propValue.getClass().getName())) == null || !childEt.isValidatable() || ValidationHelper.noValidationMessages(child = (Validatable)propValue, onlyErrors)) continue;
            return false;
        }
        for (RestCollection coll : RestMetaRegistryHelper.getAllCollections((RestEntityType)et).values()) {
            if (!object.getValidationContext().getValidationMessages(coll.getId()).isEmpty() || !object.getValidationContext().getValidationMessagesForSimpleCollection(coll.getId()).isEmpty()) {
                return false;
            }
            elementEt = RestMetaRegistryHelper.getEntityType((String)coll.getElementType());
            if (elementEt == null || !elementEt.isValidatable()) continue;
            value = (Collection)object.getValue(coll.getId());
            for (Object item : value) {
                if (item == null || ValidationHelper.noValidationMessages((Validatable)item, onlyErrors)) continue;
                return false;
            }
        }
        for (RestMap map : RestMetaRegistryHelper.getAllMaps((RestEntityType)et).values()) {
            if (!object.getValidationContext().getValidationMessages(map.getId()).isEmpty() || !object.getValidationContext().getValidationMessagesForSimpleCollection(map.getId()).isEmpty()) {
                return false;
            }
            elementEt = RestMetaRegistryHelper.getEntityType((String)map.getValueType());
            if (elementEt == null || !elementEt.isValidatable()) continue;
            value = (Collection)object.getValue(map.getId());
            for (Object item : value) {
                if (ValidationHelper.noValidationMessages((Validatable)item, onlyErrors)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean hasMessages(Collection<ValidationMessage> validationMessages, boolean onlyErrors) {
        if (!onlyErrors) {
            return !validationMessages.isEmpty();
        }
        for (ValidationMessage vm : validationMessages) {
            InformationMessage im;
            if (vm instanceof InformationMessage && (im = (InformationMessage)vm).getSeverity() != InformationMessage.Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    public static boolean move(Collection<ValidationMessage> from, Collection<ValidationMessage> to) {
        if (!from.isEmpty()) {
            to.addAll(from);
            from.clear();
            return true;
        }
        return false;
    }

    public static boolean move(Map<Integer, Collection<ValidationMessage>> from, Map<Integer, Collection<ValidationMessage>> to) {
        if (!from.isEmpty()) {
            to.putAll(from);
            from.clear();
            return true;
        }
        return false;
    }

    public static Map<String, Collection<ValidationMessage>> getAllValidationMessages(Validatable object) {
        return ValidationHelper.getAllValidationMessages(object, "");
    }

    public static Map<String, Collection<ValidationMessage>> getAllValidationMessages(Validatable object, String prefix) {
        Map<String, Collection<ValidationMessage>> subresult;
        Object item;
        Object value;
        Collection messages;
        Map messagesMap;
        RestEntityType elementEt;
        HashMap<String, Collection<ValidationMessage>> result = new HashMap<String, Collection<ValidationMessage>>();
        RestEntityType et = RestMetaRegistryHelper.getEntityType((String)object.getClass().getName());
        for (RestProperty prop : RestMetaRegistryHelper.getAllProperties((RestEntityType)et).values()) {
            Map<String, Collection<ValidationMessage>> iterator;
            Object child;
            RestEntityType childEt;
            Collection messages2 = object.getValidationContext().getValidationMessages(prop.getId());
            if (!messages2.isEmpty()) {
                result.put(prefix + prop.getId(), new ArrayList(messages2));
            }
            if ((childEt = RestMetaRegistryHelper.getEntityType((String)prop.getType())) == null || !childEt.isValidatable() || (child = (Validatable)object.getValue(prop.getId())) == null || (iterator = ValidationHelper.getAllValidationMessages((Validatable)child, prefix + prop.getId() + ".")).isEmpty()) continue;
            result.putAll(iterator);
        }
        for (RestCollection coll : RestMetaRegistryHelper.getAllCollections((RestEntityType)et).values()) {
            elementEt = RestMetaRegistryHelper.getEntityType((String)coll.getElementType());
            if (elementEt == null || !elementEt.isValidatable()) {
                messagesMap = object.getValidationContext().getValidationMessagesForSimpleCollection(coll.getId());
                if (messagesMap.isEmpty()) continue;
                for (Map.Entry entry : messagesMap.entrySet()) {
                    result.put(prefix + coll.getId() + "[" + entry.getKey() + "]", new ArrayList((Collection)entry.getValue()));
                }
                continue;
            }
            messages = object.getValidationContext().getValidationMessages(coll.getId());
            if (!messages.isEmpty()) {
                result.put(prefix + coll.getId(), new ArrayList(messages));
            }
            value = (Collection)object.getValue(coll.getId());
            Iterator iterator = value.iterator();
            while (iterator.hasNext()) {
                item = iterator.next();
                subresult = ValidationHelper.getAllValidationMessages((Validatable)item, prefix + coll.getId() + ".");
                if (subresult.isEmpty()) continue;
                result.putAll(subresult);
            }
        }
        for (RestMap map : RestMetaRegistryHelper.getAllMaps((RestEntityType)et).values()) {
            elementEt = RestMetaRegistryHelper.getEntityType((String)map.getValueType());
            if (elementEt == null || !elementEt.isValidatable()) {
                messagesMap = object.getValidationContext().getValidationMessagesForSimpleCollection(map.getId());
                if (messagesMap.isEmpty()) continue;
                for (Map.Entry entry : messagesMap.entrySet()) {
                    result.put(prefix + map.getId() + "[" + entry.getKey() + "]", new ArrayList((Collection)entry.getValue()));
                }
                continue;
            }
            messages = object.getValidationContext().getValidationMessages(map.getId());
            if (!messages.isEmpty()) {
                result.put(prefix + map.getId(), new ArrayList(messages));
            }
            value = (Collection)object.getValue(map.getId());
            Iterator iterator = value.iterator();
            while (iterator.hasNext()) {
                item = iterator.next();
                subresult = ValidationHelper.getAllValidationMessages((Validatable)item, prefix + map.getId() + ".");
                if (subresult.isEmpty()) continue;
                result.putAll(subresult);
            }
        }
        return result;
    }

    public static Validatable clearValidValues(Validatable object) throws Exception {
        Validatable newItem;
        Collection resValue;
        Collection value;
        RestEntityType elementEt;
        Map messagesMap;
        Collection messages;
        Validatable result = (Validatable)object.getClass().newInstance();
        RestEntityType et = RestMetaRegistryHelper.getEntityType((String)object.getClass().getName());
        for (RestProperty prop : RestMetaRegistryHelper.getAllProperties((RestEntityType)et).values()) {
            Validatable child;
            messages = object.getValidationContext().getValidationMessages(prop.getId());
            if (!messages.isEmpty()) {
                result.getValidationContext().getValidationMessages(prop.getId()).addAll(messages);
                continue;
            }
            RestEntityType childEt = RestMetaRegistryHelper.getEntityType((String)prop.getType());
            if (childEt == null || !childEt.isValidatable() || (child = (Validatable)object.getValue(prop.getId())) == null) continue;
            Validatable newChild = ValidationHelper.clearValidValues(child);
            result.setValue(prop.getId(), (Object)newChild);
        }
        for (RestCollection coll : RestMetaRegistryHelper.getAllCollections((RestEntityType)et).values()) {
            messages = object.getValidationContext().getValidationMessages(coll.getId());
            if (!messages.isEmpty()) {
                result.getValidationContext().getValidationMessages(coll.getId()).addAll(messages);
                continue;
            }
            messagesMap = object.getValidationContext().getValidationMessagesForSimpleCollection(coll.getId());
            if (!messagesMap.isEmpty()) {
                result.getValidationContext().getValidationMessagesForSimpleCollection(coll.getId()).putAll(messagesMap);
                continue;
            }
            elementEt = RestMetaRegistryHelper.getEntityType((String)coll.getElementType());
            if (elementEt == null || !elementEt.isValidatable()) continue;
            value = (Collection)object.getValue(coll.getId());
            resValue = (Collection)result.getValue(coll.getId());
            for (Validatable item : value) {
                newItem = ValidationHelper.clearValidValues(item);
                resValue.add(newItem);
            }
        }
        for (RestMap map : RestMetaRegistryHelper.getAllMaps((RestEntityType)et).values()) {
            messages = object.getValidationContext().getValidationMessages(map.getId());
            if (!messages.isEmpty()) {
                result.getValidationContext().getValidationMessages(map.getId()).addAll(messages);
                continue;
            }
            messagesMap = object.getValidationContext().getValidationMessagesForSimpleCollection(map.getId());
            if (!messagesMap.isEmpty()) {
                result.getValidationContext().getValidationMessagesForSimpleCollection(map.getId()).putAll(messagesMap);
                continue;
            }
            elementEt = RestMetaRegistryHelper.getEntityType((String)map.getValueType());
            if (elementEt == null || !elementEt.isValidatable()) continue;
            value = (Collection)object.getValue(map.getId());
            resValue = (Collection)result.getValue(map.getId());
            for (Validatable item : value) {
                newItem = ValidationHelper.clearValidValues(item);
                resValue.add(newItem);
            }
        }
        return result;
    }
}

