/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rest.util.io;

import com.gridnine.xtrip.server.web.rest.util.collection.FixedCharList;
import com.gridnine.xtrip.server.web.rest.util.collection.FixedCharQueue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.lang.CharUtils;

public class DebugBufferedReader
extends BufferedReader {
    private final FixedCharList head;
    private final FixedCharQueue window;
    private long readBytes = 0L;

    public DebugBufferedReader(Reader in, int headSize, int windowSize) {
        super(in);
        this.head = new FixedCharList(headSize);
        this.window = new FixedCharQueue(windowSize);
    }

    @Override
    public int read() throws IOException {
        int readByte = super.read();
        if (readByte == -1) {
            return readByte;
        }
        char readChar = (char)readByte;
        this.head.add(readChar);
        this.window.add(readChar);
        this.readBytes += CharUtils.isAscii((char)readChar) ? 1L : 2L;
        return readByte;
    }

    public void finish() throws IOException {
        while (!this.head.isFull() && this.read() != -1) {
        }
    }

    public FixedCharList getHead() {
        return this.head;
    }

    public FixedCharQueue getWindow() {
        return this.window;
    }

    public long getReadBytes() {
        return this.readBytes;
    }
}

