/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web.rpc;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.ActionSource;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rpc.logging.ServiceInvocationLoggingHelper;
import com.gridnine.xtrip.common.threadactivity.ThreadActivityLog;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.registry.Extension;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.invocation.RemoteInvocation;
import org.jboss.remoting.transport.servlet.ServletServerInvoker;
import org.jboss.remoting.transport.servlet.ServletServerInvokerMBean;
import org.jboss.remoting.transport.servlet.web.ServerInvokerServlet;
import org.jboss.remoting.transporter.TransporterHandler;

public class RPCServlet
extends ServerInvokerServlet {
    private static final String INVOKER_PARAM_PREFIX = "invoker.";
    private static final long serialVersionUID = -7737236363836803649L;
    private final transient Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private transient ServletServerInvoker invoker;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        LogicalStorage.reset();
        try {
            super.processRequest(request, response);
        }
        catch (InvalidClassException ex) {
            throw Xeption.forEndUser((String)Messages.BaseSecureServiceImpl_clientVersionDiffersFromTheServer, (Object[])new Object[0]);
        }
        finally {
            LogicalStorage.reset();
        }
    }

    protected ServletServerInvokerMBean getInvokerFromInvokerUrl(ServletConfig config) throws ServletException {
        return this.getInvoker(config);
    }

    protected ServletServerInvokerMBean getInvokerFromInvokerName(ServletConfig config) throws ServletException {
        return this.getInvoker(config);
    }

    public void destroy() {
        if (this.invoker != null) {
            this.invoker.destroy();
        }
        super.destroy();
    }

    private ServletServerInvokerMBean getInvoker(ServletConfig config) throws ServletException {
        if (this.invoker != null) {
            return this.invoker;
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration enm = config.getInitParameterNames();
            while (enm.hasMoreElements()) {
                String name = (String)enm.nextElement();
                if (!name.startsWith(INVOKER_PARAM_PREFIX)) continue;
                params.put(name.substring(INVOKER_PARAM_PREFIX.length()), config.getInitParameter(name));
            }
            this.invoker = new ServletServerInvoker(new InvokerLocator("servlet://localhost"), params);
            this.publishRemoteServices();
            this.invoker.start();
        }
        catch (Exception e) {
            throw new ServletException("failed creating invoker", (Throwable)e);
        }
        return this.invoker;
    }

    private void publishRemoteServices() {
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"RpcServiceImplementations")) {
            Collection parameters = ext.getParameters("class");
            for (Extension.Parameter param : parameters) {
                try {
                    Object serviceImpl = JpfUtil.getClass((Extension.Parameter)param).newInstance();
                    for (Extension.Parameter service : param.getSubParameters("service")) {
                        this.publishService(serviceImpl, JpfUtil.getClass((Extension.Parameter)service));
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)("failed publishing remote services from " + param), (Throwable)e);
                }
            }
        }
    }

    private void publishService(Object serviceImpl, Class<?> service) {
        final String implName = serviceImpl.getClass().getName();
        this.invoker.addInvocationHandler(service.getName(), (ServerInvocationHandler)new TransporterHandler(serviceImpl){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(InvocationRequest req) throws Throwable {
                ServiceInvocationLoggingHelper.clearThreadLocalClientStacktrace();
                RemoteInvocation invocation = (RemoteInvocation)req.getParameter();
                ThreadActivityLog.beginRequest((String)"rpc", (String)(implName + '.' + invocation.getMethodName()));
                try {
                    boolean contextFound = false;
                    Object[] params = invocation.getParameters();
                    if (params != null) {
                        for (Object param : params) {
                            if (!(param instanceof ServiceInvocationContext)) continue;
                            ServiceInvocationLoggingHelper.setThreadLocalClientStacktrace((String)((ServiceInvocationContext)param).getClientStacktrace());
                            contextFound = true;
                            break;
                        }
                    }
                    if (!contextFound) {
                        switch (implName + '.' + invocation.getMethodName()) {
                            case "com.gridnine.xtrip.server.model.rpc.ModelServiceImpl.getServerTimezone": {
                                break;
                            }
                            case "com.gridnine.xtrip.server.fx.rpc.EntityServiceImpl.toString": {
                                throw Xeption.forDeveloper((String)"com.gridnine.xtrip.server.fx.rpc.EntityServiceImpl.toString", (Object[])new Object[0]);
                            }
                            default: {
                                IncidentsLog.reportStackTrace((String)("missing invocation context\n" + this.getInvocationInfo(invocation)));
                            }
                        }
                    }
                    long timing = System.currentTimeMillis();
                    Object result = super.invoke(req);
                    long elapsed = System.currentTimeMillis() - timing;
                    if (elapsed > 30000L && !Boolean.TRUE.equals(this.isOldClient(invocation)) && !this.isIgnoreLongRequests(invocation)) {
                        IncidentsLog.reportStackTrace((String)(String.format("long request (%d ms)\n", elapsed) + this.getInvocationInfo(invocation)));
                    }
                    ServiceInvocationLoggingHelper.clearThreadLocalClientStacktrace();
                    Object object = result;
                    return object;
                }
                finally {
                    ThreadActivityLog.endRequest((String)"rpc", (String)(implName + '.' + invocation.getMethodName()));
                }
            }

            private boolean isIgnoreLongRequests(RemoteInvocation invocation) {
                if ("com.gridnine.xtrip.server.fx.rpc.EntityServiceImpl".equals(implName)) {
                    return true;
                }
                return "com.gridnine.xtrip.server.rpc.service.AssetServiceImpl".equals(implName);
            }

            private Boolean isOldClient(RemoteInvocation invocation) {
                if (invocation.getParameters() == null) {
                    return null;
                }
                if (invocation.getParameters().length == 0) {
                    return null;
                }
                Object param0 = invocation.getParameters()[0];
                if (param0 == null) {
                    return null;
                }
                if (!(param0 instanceof ServiceInvocationContext)) {
                    return null;
                }
                ServiceInvocationContext ctx = (ServiceInvocationContext)param0;
                return ActionSource.MIDOFFICE_CLIENT == ctx.getActionSource();
            }

            private String getInvocationInfo(RemoteInvocation invocation) {
                StringBuilder result = new StringBuilder();
                result.append(implName).append('.').append(invocation.getMethodName()).append("()");
                Object[] params = invocation.getParameters();
                if (params != null) {
                    result.append(" parameters:");
                    for (Object param : params) {
                        result.append("\n\t").append(param);
                    }
                }
                return result.toString();
            }
        });
        this.log.debug((Object)String.format("published remote service %s from %s", service.getName(), serviceImpl));
    }
}

