<%@page import="java.util.ArrayList"%>
<%@page import="com.gridnine.xtrip.common.meta.rest.RestService"%>
<%@page import="java.util.List"%>
<%@page import="java.util.Collections"%>
<%@page import="com.gridnine.xtrip.common.meta.rest.RestMetaRegistry"%>
<%@page import="com.gridnine.xtrip.common.Environment"%>
<%@ page language="java" session="false"
	contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%><%@ include
	file="common.jspf"%><!DOCTYPE html>
<html>
<head>
<title>REST API - справка</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="lib/bootstrap.css" />
<link rel="stylesheet" href="lib/codemirror/codemirror.css">
<link rel="stylesheet" href="lib/codemirror/fold/foldgutter.css">
<script src="lib/codemirror/codemirror.js"></script>
<script src="lib/codemirror/fold/foldcode.js"></script>
<script src="lib/codemirror/fold/foldgutter.js"></script>
<script src="lib/codemirror/fold/brace-fold.js"></script>
<script src="lib/codemirror/fold/xml-fold.js"></script>
<script src="lib/codemirror/fold/comment-fold.js"></script>
<script src="lib/codemirror/javascript.js"></script>
<script src="lib/textarea-snippet.js"></script>
</head>
<body style="padding-top: 10px">
	<div class="container-fluid">
		<div class="row-fluid">
			<div class="span3">
				<!-- nav pane start -->
				<div class="well well-large">
					<ul class="nav nav-list">
						<li class="nav-header">Список доступных сервисов</li>
						<%
						    List<RestService> services = new ArrayList<RestService>(Environment
						        .getPublished(RestMetaRegistry.class).getServices().values());
						    Collections.sort(services, COMPARATOR);
						    for (RestService service : services) {
						%>
						<li><a
							<%=service.isDeprecated() ? "style=\"text-decoration: line-through;\""
                    : ""%>
							href="service.jsp?s=<%=service.getId()%>"><%=service.getTitle()%>
								<small style="color: black"><%=service.getPath()%>/*</small></a></li>
						<%
						    }
						%>
					</ul>
				</div>
				<!-- nav pane end -->
			</div>
			<div class="span9">
				<!-- content start -->
				<h1>Общие сведения по API</h1>
				<p>API основано на общёпринятой концепции HTTP REST. Весь API
					разделён на сервисы, а сервисы &mdash; на операции. Вызываемая
					операция определяется путём в URL запроса и HTTP методом. Параметры
					операции передаются через HTTP query string или как JSON структура
					в теле запроса. Результат операции возвращается в теле ответа, как
					правило в виде JSON структуры.</p>
				<p>Запросы можно разделить на 2 группы: GET и все остальные. В
					случае GET-запроса все параметры кодируются в URL. В случае POST
					запроса в URL ничего не передается, а в теле запроса будут два
					параметра:</p>
				<table class="table table-striped table-bordered">
					<thead>
						<tr>
							<th>Параметр</th>
							<th>Описание</th>
							<th>Формат, значения</th>
							<th>Обязательность</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td>entity</td>
							<td>Объект. Используется при сохранении, либо удалении
								объекта</td>
							<td>JSON-объект</td>
							<td>0/1</td>
						</tr>
						<tr>
							<td>parameters</td>
							<td>Параметры, которые сопутствуют данной операции.
								Например, при сохранении Билета, данные по билету будут в поле
								entity, а признак того, что нужно применить операцию ко всем
								билетам заказа - в parameters.</td>
							<td>JSON-объект</td>
							<td>0/1</td>
						</tr>
					</tbody>
				</table>
				<p>Ответ на любой запрос может содержать следующие поля:</p>
				<table class="table table-striped table-bordered">
					<thead>
						<tr>
							<th>Параметр</th>
							<th>Описание</th>
							<th>Формат, значения</th>
							<th>Обязательность</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td>result</td>
							<td>Объект - содержащий. В случае, когда в запросе
								присутствует entity (например, это запрос на сохранение
								объекта), то result повторяет по структуре entity.</td>
							<td>(см ниже)</td>
							<td>0/1</td>
						</tr>
						<tr>
							<td>validatedEntity</td>
							<td>В случае валидационной ошибки содержит объект,
								структурно аналогичный entity, заполненный валидационными
								сообщениями.</td>
							<td>(см ниже)</td>
							<td>0/1</td>
						</tr>
						<tr>
							<td>validatedParameters</td>
							<td>В случае валидационной ошибки содержит объект,
								структурно аналогичный parameters, заполненный валидационными
								сообщениями.</td>
							<td>(см ниже)</td>
							<td>0/1</td>
						</tr>
						<tr>
							<td>userErrorMessage</td>
							<td>В случае ошибки содержит текст, который необходимо
								показать пользователю.</td>
							<td>Строка</td>
							<td>0/1</td>
						</tr>
						<tr>
							<td>messages</td>
							<td>Содержит различные информационные сообщения, описывающие
								ход обработки запроса.</td>
							<td>(см ниже)</td>
							<td>0+</td>
						</tr>
						<tr>
							<td>developerErrorMessage <code>*</code></td>
							<td>В случае ошибки содержит текст ошибки для разработчика.</td>
							<td>Строка</td>
							<td>0/1</td>
						</tr>
						<tr>
							<td>exceptionStackTrace <code>*</code></td>
							<td>В случае ошибки содержит стек ошибки.</td>
							<td>Строка</td>
							<td>0/1</td>
						</tr>
						<tr>
							<td>debugMessages <code>*</code></td>
							<td>Содержит различные отладочные сообщения, описывающие ход
								обработки запроса.</td>
							<td>Строка</td>
							<td>0+</td>
						</tr>
					</tbody>
				</table>
				<p>
					Свойства, отмеченные значком
					<code>*</code>
					, будут заполняться только на тестовых инсталяциях с целью более
					быстрого разбора возникающих проблем. На боевых инсталляциях эти
					поля будут отсутствовать.
				</p>
				<p>
					Свойства
					<code>validatedEntity</code>
					и
					<code>validatedParameters</code>
					имеют такую же структуру, как пришедший json-запрос, но вместо
					значений свойств, каждому свойству соответствует коллекция
					валидационных сообщений. При этом, если в изначальном запросе
					свойству соответствовала коллекция объектов, то в провалидированном
					запросе, в случае ошибок, ему может соответствовать также коллекция
					сообщений (если они относятся ко всему свойству, как целому), либо
					структура отображения, где ключом выступает индекс элемента
					оригинального списка (счет от нуля), а значением - коллекция
					валидационных сообщений, предназначенных для этого элемента (см.
					пример ниже). Структура валидационного сообщения проста &mdash; это
					один обязательный элемент
					<code>code</code>
					, в котором содержится код ошибки. Коды ошибок документируются в
					описании соответствующего сервиса.
				</p>
				<p>
					Массив
					<code>messages</code>
					содержит объекты вида:
				</p>
				<p>
					<textarea class="snippet">{
					  "code": "messageCode",
					  "text": "message text to be displayed to user",
					  "severity": "INFO"
					}</textarea>
				</p>
				<p>
					Возможные значения поля
					<code>severity</code>
					: INFO, MESSAGE и ERROR.
				</p>
				<h2>Пример провалидированного запроса</h2>
				<p>Исходный запрос</p>
				<p>
					<textarea class="snippet">Пример запроса</textarea>
				</p>
				<p>Провалидированный запрос:</p>
				<p>
					<textarea class="snippet">Пример ответа</textarea>
				</p>
				<p>Если в процессе обработки запроса возникает необрабатываемая
					ошибка, то в ответе выставляется статус 404.</p>
				<!-- content end -->
			</div>
		</div>
	</div>
</body>
</html>