<%@page import="java.util.Locale"%>
<%@page import="com.gridnine.xtrip.common.l10n.model.LocaleManager"%>
<%@page import="java.util.Map"%>
<%@page import="com.gridnine.xtrip.server.ibus.rest.docs.RestDocObject"%>
<%@page import="com.gridnine.xtrip.common.meta.MetaRegistry"%>
<%@page import="com.gridnine.xtrip.server.ibus.rest.docs.RestDocProperty"%>
<%@page import="com.gridnine.xtrip.common.util.TextUtil"%>
<%@page import="com.gridnine.xtrip.server.ibus.model.RestfulInEndpointDescription"%>
<%@page import="com.gridnine.xtrip.server.ibus.model.BaseEndpointDescription"%>
<%@page import="com.gridnine.xtrip.common.Environment"%>
<%@page import="com.gridnine.xtrip.server.ibus.IntegrationBusRegistry"%>
<%@page import="groovy.lang.Binding"%>
<%@page import="groovy.lang.GroovyShell"%>
<%@page import="java.io.StringWriter"%>
<%@page import="groovy.xml.MarkupBuilder"%>
<%@page import="groovy.lang.Closure"%>
<%@ page language="java" session="false"
	contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
	<%!
public static String getFormat(RestDocProperty prop, Map<String, RestDocObject> referencedObjects) {
	if(prop.getReferencedObjectId() == null){
		return prop.getFormat();
	}
	return String.format("%s <a href=\"#%s\">%s</a>", prop.getFormat(), prop.getReferencedObjectId(), referencedObjects.containsKey(prop.getReferencedObjectId())? getPrettyName(referencedObjects.get(prop.getReferencedObjectId()).getDisplayName()): getPrettyName(prop.getReferencedObjectId()));
}

public static String getPrettyName(String name) {
	if(name == null || name.indexOf(".") == -1){
		return name;
	}
	String res = name.substring(0, name.lastIndexOf("."));
	if(res.indexOf(".") == -1){
		return res;
	}
	return res.substring(res.lastIndexOf(".")+1);
}
%>
<%
    Environment.getPublished(LocaleManager.class).setCurrentLocale(new Locale("ru"));
	String descriptionId = request.getParameter("id");
	String issueId = request.getParameter("issueId");
	String methodId = request.getParameter("methodId");
	String itemId = request.getParameter("itemId");

	RestfulInEndpointDescription description = Environment
			.getPublished(IntegrationBusRegistry.class).getEndpoint(
					descriptionId, RestfulInEndpointDescription.class);
	RestDocItem docItem = null;
	if (!TextUtil.isBlank(itemId)) {
		List<RestDocGroup> groups = RestDocHelper
				.getGroups(description);
		final StringBuffer sb = new StringBuffer(); 
		out: for (RestDocGroup group : groups) {
			for (RestDocItem aMethod : group.getItems()) {
				if (TranslitUtil.cyr2lat(aMethod.getIssueId(),
						TranslitRules.GOST_52535_1_2006).equals(
						itemId)) {
				    if (TextUtil.isBlank(methodId)) {
						docItem = aMethod;
						break out;
				    }
				    sb.setLength(0);
				    for (String docRequestType: aMethod.getMethods().keySet()){
				        if (sb.length() > 0)
				            sb.append("_");
				        sb.append(docRequestType);
				    }
				    if (sb.toString().equals(methodId)) {
						docItem = aMethod;
						break out;
				    }
				}
			}
		}
	}
	
%>
<!DOCTYPE html>
<html>
<head>
<title>Справка по REST API <%=description.getPath()%></title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="lib/bootstrap.css" />
<link rel="stylesheet" type="text/css" href="lib/style.css" />
<link rel="stylesheet" href="lib/codemirror/codemirror.css">
<link rel="stylesheet" href="lib/codemirror/fold/foldgutter.css">
<script src="lib/codemirror/codemirror.js"></script>
<script src="lib/codemirror/fold/foldcode.js"></script>
<script src="lib/codemirror/fold/foldgutter.js"></script>
<script src="lib/codemirror/fold/brace-fold.js"></script>
<script src="lib/codemirror/fold/xml-fold.js"></script>
<script src="lib/codemirror/fold/comment-fold.js"></script>
<script src="lib/codemirror/javascript.js"></script>
<script src="lib/textarea-snippet.js"></script>
</head>
<body style="padding-top: 10px">
	<div class="container-fluid">
		<div class="row-fluid">
			<div class="span3">
				<div class="well well-large">
					<%@ include file="left.jspf"%>
				</div>
			</div>
			<div class="span9">
<%
    if (!TextUtil.isBlank(issueId)) {
		for (String key : description.getIssues().keySet()) {
			if (issueId.equals(TranslitUtil.cyr2lat(key,
					TranslitRules.GOST_52535_1_2006))) {
%>
<%=description.getIssues().get(key)%>
<%
    break;
			}
		}
		
		for (String key : description.getIssueBuilderList().keySet()) {
			if (issueId.equals(TranslitUtil.cyr2lat(key,
					TranslitRules.GOST_52535_1_2006))) {
			    final StringWriter writer = new StringWriter();
			    try {
				    final MarkupBuilder builder = new MarkupBuilder(writer);
				    final Binding binding = new Binding();
		            class Delegate extends Closure {
		                public Delegate() {
		                    super(builder);
		                }

		                protected Object doCall(Object arguments) {
		                    final Closure closure = (Closure)arguments;  
		                    closure.setDelegate(builder);
		                    return closure.call();
		                }
		            }
				    binding.setVariable("html", new Delegate());
					final GroovyShell shell = new GroovyShell(binding);
					shell.evaluate(description.getIssueBuilderList().get(key));
%><%=writer.toString()%><%
    } finally {
					writer.close();
			    }
				break;
			}
		}
	}
%>
<%
    if (docItem != null) {
%>
<h1><%=docItem.getItemName()%></h1>
<div class="subnav">
		<ul class="nav nav-pills">

<%
    for(String docRequestType: docItem.getMethods().keySet()){
%>
<li><a href="#<%=docRequestType%>"><%=docRequestType%></a></li>

<%
    }
%>
	</ul>
				</div>
<dl class="dl-horizontal">
<%
    for(Entry<String, RestDocMethod> docEntry: docItem.getMethods().entrySet()){
%>
<h2 id="<%=docEntry.getKey()%>">Операция <code><%=docEntry.getKey()%> <%=docItem.getIssueId()%></code></h2>
					<dt>Описание</dt>
					<dd><%=docEntry.getValue().getDescription()%></dd>
					<dt>Запрос</dt>
					<dd>
<% 
	if (null != docEntry.getValue().getRequest() && docEntry.getValue().getRequest().getProperties().size() > 0) {
%>
						<table class="table table-striped table-bordered">
							<thead>
								<tr>
									<th>Параметр</th>
									<th>Описание</th>
									<th>Формат, значения</th>
									<th>Обязательность</th>
								</tr>
							</thead>
							<tbody>
<%
		for(RestDocProperty restProperty: docEntry.getValue().getRequest().getProperties()){
			%>
			<tr>
				<td><%= restProperty.getName() %></td>
				<td><%= getPrettyName(restProperty.getDescription()) %></td>
				<td><%= getFormat(restProperty, docItem.getReferencedElements()) %></td>
				<td><%= restProperty.getMultiplicity() %></td>
			</tr>
<%
		}
%>
							</tbody>
						</table>
<%
	} else {
%>
(нет)
<BR><BR>
<%
	}
%>
					</dd>
<%
if(docEntry!= null && docEntry.getValue().getRequest() != null && docEntry.getValue().getRequest().getExample() != null){
%>
<dt>Пример запроса</dt>
<dd><%=docEntry.getValue().getRequest().getExample()%></dd>
<%
}
%>
<%
if(docEntry!= null && docEntry.getValue().getRequest() != null && docEntry.getValue().getRequest().getComment() != null){
%>
<dt>Коментарии</dt>
<dd><%=docEntry.getValue().getRequest().getComment()%></dd>
<%
}
%>
					<dt>Ответ</dt>
					<dd>
<%	if(docEntry.getValue().getResponse() != null){
		if(docEntry.getValue().getResponse().getProperties().size() > 0){%>
						<table class="table table-striped table-bordered">
							<thead>
								<tr>
									<th>Параметр</th>
									<th>Описание</th>
									<th>Формат, значения</th>
									<th>Обязательность</th>
								</tr>
							</thead>
							<tbody>
		<%for(RestDocProperty restProperty: docEntry.getValue().getResponse().getProperties()){
			%>
			<tr>
				<td><%= restProperty.getName() %></td>
				<td><%= getPrettyName(restProperty.getDescription()) %></td>
				<td><%= getFormat(restProperty, docItem.getReferencedElements()) %></td>
				<td><%= restProperty.getMultiplicity() %></td>
			</tr>
<%
		}
%>
</tbody>
						</table>
<%
		} else {
%>
(нет)<BR><BR
<%
		}
	} else {%>
		<em>Бинарные данные</em>
	<%}
%>
						</dd>
<%
if(docEntry.getValue().getResponse() != null && docEntry.getValue().getResponse().getComment() != null){
%>
<dt>Коментарии</dt>
<dd><%=docEntry.getValue().getResponse().getComment()%></dd>
<%
}
%>
<%
if(docEntry.getValue().getResponse() != null && docEntry.getValue().getResponse().getExample() != null){
%>
<dt>Пример ответа</dt>
<dd><%=docEntry.getValue().getResponse().getExample()%></dd>
<%
}
%>
<%
	}
%>
<% if (!docItem.getReferencedElements().isEmpty()) { %>
<h2 id="referencedObjects">Связанные объекты</h2>
<% } %>
<%
		for(Entry<String, RestDocObject> docEntry: docItem.getReferencedElements().entrySet()){
%>
<dt id = "<%=docEntry.getKey()%>"><%= getPrettyName(docEntry.getValue().getDisplayName()) %></dt>
					<dd>
						<table class="table table-striped table-bordered">
							<thead>
								<tr>
									<% if (!docEntry.getValue().isEnumeration()) { %>
									<th>Параметр</th>
									<% } else { %>
									<th>Константа</th>
									<% } %>
									<th>Описание</th>
									<% if (!docEntry.getValue().isEnumeration()) { %>
									<th>Формат, значения</th>
									<th>Обязательность</th>
									<% } %>
								</tr>
							</thead>
							<tbody>
<%
		for(RestDocProperty restProperty: docEntry.getValue().getProperties()){
			%>
			<tr>
				<td><%= restProperty.getName() %></td>
				<td><%= getPrettyName(restProperty.getDescription()) %></td>
				<% if (!docEntry.getValue().isEnumeration()) { %>
				<td><%= getFormat(restProperty, docItem.getReferencedElements()) %></td>
				<td><%= restProperty.getMultiplicity() %></td>
				<% } %>
			</tr>
<%
		}
%>
							</tbody>
						</table>
					</dd>
					<%
if(docEntry.getValue().getComment() != null){
%>
<dt>Коментарии</dt>
<dd><%=docEntry.getValue().getComment()%></dd>
<%
}
%>
<%
		}
	}
%>
</dl>
			</div>
		</div>
	</div>
</body>
</html>