<%@ page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"

	import="com.gridnine.xtrip.server.db.storage.hibernate.StructureAlignment"
	import="java.sql.SQLException"
	import="java.net.URL"
	import="java.io.*"
	import="javax.servlet.jsp.JspWriter"
	import="com.gridnine.xtrip.common.xml.XUtil"
	import="java.util.*"  
%><%!
void println(JspWriter out, String str) throws IOException {
	str = str.replace("<", "&lt;");
	str = str.replace(">", "&gt;");
	str = str.replace("\n", "<BR>");
	str = str.replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
	str = str.replace(" ", "&nbsp;");
	
	out.println(str + "<BR>");
}
%><%

final String server = request.getServerName();
final String location = "http://" + server + ":9090/get-info/db/structure.jsp";
final URL url = new URL(location);
final InputStream in = url.openStream();
final byte[] bytes; 
try {
	final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
	try {
		int b;
		while ((b = in.read()) != -1)
			buffer.write(b);
		bytes = buffer.toByteArray();
	} finally {
		buffer.close();
	}
} finally {
	in.close();
}

final StructureAlignment.StructureInfo currentStructure = new StructureAlignment.StructureInfo();
XUtil.fromBytes(bytes, currentStructure);

out.println("<HTML>");
out.println("<BODY>");

final StructureAlignment.StructureInfo neededStructure = StructureAlignment.collectStructure();

final StructureAlignment.StructureComparison diff = StructureAlignment.compareStructure(currentStructure, neededStructure);

println(out, "");
out.println("<H1>");
println(out, "STRUCTURE MODIFICATION:");
out.println("</H1>");
println(out, "");

if (!diff.getNewTables().isEmpty()
    || !diff.getDropTables().isEmpty()
    || !diff.getModifiedTables().isEmpty()
    || !diff.getDropIndexes().isEmpty()
    || !diff.getNewIndexes().isEmpty()) {
	
	final JspWriter jspout = out;
	
	StructureAlignment.alignStructure(new StructureAlignment.ModificationExecutor() {
        @Override
        public void executeSQL(final String sql)
                throws SQLException, IOException {
        	println(jspout, sql);
        }
    }, diff);
} else {
	println(out, "NO NEEDED MODIFICATION");
}

out.println("</BODY>");
out.println("</HTML>");

%>
