<%@ page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"
	import="java.sql.Connection"
	import="com.gridnine.xtrip.server.db.storage.hibernate.StructureAlignment"
	import="com.gridnine.xtrip.common.Environment"
	import="com.gridnine.xtrip.server.configuration.ServerConfiguration"
	import="com.gridnine.xtrip.common.util.DesUtil"
	import="com.gridnine.xtrip.common.xml.XUtil" 
	import="java.util.Properties"
	import="java.sql.*"
%><%

final Properties configuration = Environment.getPublished(ServerConfiguration.class).getConfiguration();
final String url = configuration.getProperty("db.url");
final String username = configuration.getProperty("db.user");
final String encriptedPassword = configuration.getProperty("db.password");
final String password = DesUtil.decode(encriptedPassword);
    
Class.forName("org.postgresql.Driver");
final Connection connection = DriverManager.getConnection(url, username, password);

StructureAlignment.StructureInfo currentStructure;

try {
    currentStructure = new StructureAlignment().analizeStructure(connection);
} finally {
    if (!connection.isClosed()) {
        connection.close();
    }
}

out.println(XUtil.toString(currentStructure));

%>
