<%@ page
	language="java"
	contentType="text/html; charset=utf-8"
	errorPage="../error.jsp"
	import="java.io.*"
	import="java.util.*"
	import="java.text.*"
	import="javax.xml.transform.dom.*"
	import="javax.xml.transform.stream.*"
	import="org.w3c.dom.*"
	import="org.apache.commons.fileupload.*"
	import="org.apache.commons.fileupload.disk.*"
	import="org.apache.commons.fileupload.servlet.*"
	import="com.gridnine.xtrip.common.*"
	import="com.gridnine.xtrip.common.xml.*"
	import="com.gridnine.xtrip.common.search.*"
	import="com.gridnine.xtrip.common.util.*"
	import="com.gridnine.xtrip.common.meta.*"
	import="com.gridnine.xtrip.common.model.*"
	import="com.gridnine.xtrip.common.model.dict.*"
	import="com.gridnine.xtrip.server.storage.*"
%><%@ include file="../resources/lib.jsp" %><%!static class DictBrowserContext implements Serializable {
    static DictBrowserContext get(HttpSession ss) {
        DictBrowserContext result = null;
        try {
	        result = (DictBrowserContext) ss.getAttribute(
	            DictBrowserContext.class.getName());
        } catch (Exception e) {
            // ignore;
        }
        if (result != null) {
            return result;
        }
        result = new DictBrowserContext();
        ss.setAttribute(DictBrowserContext.class.getName(), result);
        return result;
    }

    private DictionaryType type;

    private String pattern = "";

    private int limit = 100;

    private List<BaseDictionary> searchResult = new LinkedList<BaseDictionary>();

    void populate(HttpServletRequest req) throws Exception {
        type = Environment.getPublished(MetaRegistry.class).getDictionaries().get(
            req.getParameter("dictType"));
        pattern = req.getParameter("pattern");
        limit = Integer.parseInt(req.getParameter("limit"));
    }

    void doSearch() throws Exception {
        List<BaseDictionary> list;
        Class<BaseDictionary> cls =
            (Class<BaseDictionary>) Class.forName(type.getId());
        if (TextUtil.isBlank(pattern)) {
    	    list = new ArrayList<BaseDictionary>(
    	            Environment.getPublished(DictionaryCache.class).getAll(cls)
    	            .values());
        } else {
    	    list = new ArrayList<BaseDictionary>(
    	            Environment.getPublished(DictionaryCache.class).search(
    	                cls, pattern));
        }
        Collections.sort(list, new CollectionUtil.SimpleToStringComparator());
        searchResult.clear();
        for (BaseDictionary item : list) {
            searchResult.add(item);
            if (searchResult.size() >= limit) {
                break;
            }
        }
    }

    void doReset() throws Exception {
		Environment.getPublished(DictionaryCache.class).forceSynchronization();
    }

    DictionaryType getDictionaryType() {
        return type;
    }

    String getPattern() {
        return pattern;
    }

    int getLimit() {
        return limit;
    }

    List<BaseDictionary> getSearchResult() {
        return searchResult;
    }
}

private static void doImport(byte[] data, boolean clean, List<String> messages)
		throws Exception {
    if ((data == null) || (data.length == 0)) {
        messages.add("WARN: no import data provided");
        return;
    }
    Set<String> deleted = new HashSet<String>();
    int count = 0;
    for (Element elm : XmlUtil.getElements(DocumentBuilderHelper.parse(
        	new ByteArrayInputStream(data)).getDocumentElement(), "object")) {
        count++;
        Class<? extends BaseDictionary> cls =
            (Class<? extends BaseDictionary>) Class.forName(elm
                .getAttribute("class")); //$NON-NLS-1$
        BaseDictionary dict = cls.newInstance();
        dict.fromXML(elm);
        BaseDictionary oldDict = null;
        if (clean) {
            if (!deleted.contains(cls.getName())) {
                deleteAll(cls);
                deleted.add(cls.getName());
                messages.add("INFO: deleted all items from dictionary " + cls.getName());
            }
        } else {
            oldDict = Environment.getPublished(
                DictionaryCache.class).findByCode(cls, dict.getCode());
        }
        if (oldDict != null) {
            dict.setUid(oldDict.getUid());
        }
        DictionaryStorage.get().save(dict);

    }
    messages.add("INFO: procesed " + count + " dictionary items");
}

private static void deleteAll(Class<? extends BaseDictionary> cls) throws Exception {
    for (BaseDictionary dict : new ArrayList<BaseDictionary>(
            Environment.getPublished(DictionaryCache.class).getAll(cls).values())) {
    	DictionaryStorage.get().delete(dict);
    }
}%><%DictBrowserContext ctx = DictBrowserContext.get(session);
List<String> messages = new LinkedList<String>();
if (ServletFileUpload.isMultipartContent(request)) {
    ServletFileUpload fu = new ServletFileUpload(new DiskFileItemFactory());
    List<FileItem> items = fu.parseRequest(request);
    String dictType = null;
    FileItem dataItem = null;
    boolean clean = false;
    boolean doExport = false;
    boolean doImport = false;
    for (FileItem item : items) {
        if ("dictType".equals(item.getFieldName())) {
            dictType = item.getString();
        }
        if ("data".equals(item.getFieldName())) {
            dataItem = item;
        }
        if ("clean".equals(item.getFieldName())) {
            clean = true;
        }
        if ("export".equals(item.getFieldName())) {
            doExport = true;
        }
        if ("import".equals(item.getFieldName())) {
            doImport = true;
        }
    }
	if (doExport) {
	    // do export
	    Document result = DocumentBuilderHelper.newDocument();
	    result.appendChild(result.createElement("objects"));
	    for (BaseDictionary obj : Environment.getPublished(DictionaryCache.class)
	            .getAll((Class<BaseDictionary>) Class.forName(dictType)).values()) {
	        Element elm = result.createElement("object");
	        result.getDocumentElement().appendChild(elm);
	        elm.setAttribute("class", obj.getClass().getName());
	        obj.toXML(elm);
	    }
	    response.setContentType("application/force-download");
	    response.setHeader("Content-Disposition",
	        "attachment; filename=" + dictType + ".xml");
	    XUtil.getTransformer().transform(new DOMSource(result),
	        new StreamResult(response.getOutputStream()));
		return;
	} else if (doImport) {
	    doImport(dataItem.get(), clean, messages);
	}
}
if (request.getParameter("search") != null) {
    ctx.populate(request);
    ctx.doSearch();
    response.sendRedirect("dict-browser.jsp");
    return;
}
if (request.getParameter("reset") != null) {
    ctx.doReset();
    response.sendRedirect("dict-browser.jsp");
    return;
}
if (request.getParameter("delete") != null) {
    if (request.getParameterValues("code") != null) {
	    Map<String, BaseDictionary> items =
	        Environment.getPublished(DictionaryCache.class).getAll(
	            (Class<BaseDictionary>) Class.forName(ctx.getDictionaryType().getId()));
	    for (String code : request.getParameterValues("code")) {
	        BaseDictionary item = items.get(code);
	        if (item != null) {
	        	DictionaryStorage.get().delete(item);
	        }
	    }
    }
    ctx.doSearch();
    response.sendRedirect("dict-browser.jsp");
    return;
}
DateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
List<DictionaryType> dictTypes = new ArrayList<DictionaryType>(
        Environment.getPublished(MetaRegistry.class)
        .getDictionaries().values());
Collections.sort(dictTypes, new Comparator<DictionaryType>() {
    public int compare(DictionaryType o1, DictionaryType o2) {
        return TextUtil.compare(o1.getDisplayName(), o2.getDisplayName(), true, true);
    }
});%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
	<title>Dictionary Browser - <%=application.getServletContextName()%></title>
	<link rel="StyleSheet" type="text/css" href="../resources/base.css">
</head>

<body>
<form action="dict-browser.jsp" method="post"><fieldset>
	<legend>Search</legend>
	<label for="dictType">Dictionary:</label>&nbsp;<select id="dictType" name="dictType">
	<% for (DictionaryType type : dictTypes) { %>
		<option value="<%= type.getId() %>" <%= type.equals(ctx.getDictionaryType()) ? "selected" : "" %>><%= type.getDisplayName() %></option>
	<% } %>
	</select>
	<label for="pattern">Free Text Pattern:</label>&nbsp;<input id="pattern" size="10" type="text" name="pattern" value="<%= ctx.getPattern() %>" />
	<label for="limit">Limit:</label>&nbsp;<input id="limit" size="3" type="text" name="limit" value="<%= ctx.getLimit() %>" />
	<input type="submit" name="search" value="Search"/>
	<input type="submit" name="reset" value="Reset"/>
</fieldset></form>
<form action="dict-browser.jsp" method="post" enctype="multipart/form-data"><fieldset>
	<legend>Import/Export</legend>
	<label for="dictType2">Dictionary:</label>&nbsp;<select id="dictType2" name="dictType">
	<% for (DictionaryType type : dictTypes) { %>
		<option value="<%= type.getId() %>" <%= type.equals(ctx.getDictionaryType()) ? "selected" : "" %>><%= type.getDisplayName() %></option>
	<% } %>
	</select>
	<input type="submit" name="export" value="Export"/>
	&nbsp; &nbsp; &nbsp; &nbsp;
	<input id="clean" type="checkbox" name="clean" value="true" />&nbsp;<label for="clean">clean import</label>
	<input type="file" name="data" />
	<input type="submit" name="import" value="Import">
</fieldset></form>

<% if (!messages.isEmpty()) { %>
<ul>
	<% for (String msg : messages) { %>
	<li><%= msg %></li>
	<% } %>
</ul>
<% } %>

<% if (ctx.getDictionaryType() != null) { %>
<form action="dict-browser.jsp" method="post">
<input type="hidden" name="type" value="<%= ctx.getDictionaryType().getId() %>"/>
<p>
	<a href="dict-editor.jsp?type=<%= ctx.getDictionaryType().getId() %>" title="Create new item of type <%= ctx.getDictionaryType().getId() %>">new dictionary item</a>
</p>
<table border="1" cellspacing="0" cellpadding="5" width="99%">
	<tr>
		<th>&nbsp;</th>
		<th>Code</th>
		<th>Name</th>
		<th>Created</th>
		<th>Modified</th>
	</tr>
	<% for (BaseDictionary item : ctx.getSearchResult()) { %>
	<tr>
		<td>
			<nobr>
				<input type="checkbox" name="code" value="<%= item.getCode() %>" />
				<a href="dict-editor.jsp?view&type=<%= item.getClass().getName() %>&code=<%= item.getCode() %>">VIEW</a>
				<a href="dict-editor.jsp?type=<%= item.getClass().getName() %>&code=<%= item.getCode() %>">EDIT</a>
			</nobr>
		</td>
		<td><%= item.getCode() %></td>
		<td><%= item %></td>
		<td><%= (item.getCreated() == null) ? "n/a" : dtf.format(item.getCreated()) %> by <%= item.getCreatedBy() %></td>
		<td><%= (item.getModified() == null) ? "n/a" : dtf.format(item.getModified()) %> by <%= item.getModifiedBy() %></td>
	</tr>
	<% } %>
</table>
	<% if (!ctx.getSearchResult().isEmpty()) { %>
<p>
	<input type="submit" name="delete" value="Delete" onclick="return confirm('Sure to delete seleted entities?')"/>
</p>
	<% } %>
</form>
<% } %>

</body>
</html>