﻿<%@ page
	session="false"
	errorPage="error.jsp"
	pageEncoding="UTF-8"
	contentType="text/html; charset=UTF-8"
	import="com.gridnine.xtrip.common.Environment"
	import="java.util.*"
	import="java.lang.management.*"
%><%!
private static int toKilo(final long i) {
	return (int)Math.floor(i / 1024);
}

private static int toMega(final long i) {
	return (int)Math.floor(i / 1024 / 1024);
}

private static long diffInHours(final java.util.Date date1, final java.util.Date date2) {
	return (date1.getTime() - date2.getTime()) / 1000 / 60 / 60;
}

private static long diffInMinutes(final java.util.Date date1, final java.util.Date date2) {
	return (date1.getTime() - date2.getTime()) / 1000 / 60 - diffInHours(date1, date2) * 60;
}

private static long diffInSeconds(final java.util.Date date1, final java.util.Date date2) {
	return (date1.getTime() - date2.getTime()) / 1000 - diffInHours(date1, date2) * 60 * 60 - diffInMinutes(date1, date2) * 60;
}

private static String dump(final Thread thread) {
    StringBuffer buf = new StringBuffer();
    buf.append("Class: ").append(thread.getClass().getName()).append("\r\n");
    buf.append("Id: ").append(thread.getId()).append("\r\n");
    buf.append("Priority: ").append(thread.getPriority()).append("\r\n");
    buf.append("Group: ").append(thread.getThreadGroup()).append("\r\n");
    buf.append("Class loader: ").append(thread.getContextClassLoader()).append("\r\n");
    buf.append("Daemon: ").append(thread.isDaemon()).append("\r\n");
    buf.append("Alive: ").append(thread.isAlive()).append("\r\n");
    buf.append("Interrupted: ").append(thread.isInterrupted()).append("\r\n");
    buf.append("State: ").append(thread.getState()).append("\r\n");
    buf.append("Stack trace:\r\n");
    for (StackTraceElement elm : thread.getStackTrace()) {
        buf.append("\t").append(elm).append("\r\n");
    }
    return buf.toString();
}
%><%
java.util.Date currDate = new java.util.Date();
%><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
    <title>Debug - Demo Site - <%= application.getServletContextName() %></title>
	<%--meta http-equiv="refresh" content="30;url=debug.jsp"--%>
	<script type="text/javascript">
	function getElement(str) {
	    if (document.layers) {
	        return document.layers[str];
	    } else if (document.getElementById) {
	        return document.getElementById(str);
	    } else if (document.all) {
	        return document.all[str];
	    }
	    return null;
	}

	function toggleVisible(elementId) {
	    var element = getElement(elementId);
	    if (element.style.display == "block") {
	        element.style.display = "none";
	    } else {
	        element.style.display = "block";
	    }
	}
	</script>
</head>
<body>

<h1><%= application.getServletContextName() %> [DEBUG INFO]</h1>
<h3><a href="javascript:toggleVisible('generalInfo')">General Info</a></h3>
<div id="generalInfo" style="display:block;">
<ul>
	<li>Page generation time: <%= new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz").format(currDate) %></li>
	<li>Application ID: <%= Environment.getApplicationId() %></li>
	<li>Instance ID: <%= Environment.getInstanceId() %></li>
</ul>
</div>
<h3><a href="javascript:toggleVisible('jvmInfo')">JVM Info</a></h3>
<div id="jvmInfo" style="display:block;">
	<%
	Runtime rt = Runtime.getRuntime();
	%>
	<ul>
		<li title="an approximation to the total amount of memory currently available for future allocated objects">System.freeMemory() = <%= toMega(rt.freeMemory()) %> mB, <%= toKilo(rt.freeMemory()) %> kB</li>
		<li title="the maximum amount of memory that the virtual machine will attempt to use">System.maxMemory() = <%= toMega(rt.maxMemory()) %> mB, <%= toKilo(rt.maxMemory()) %> kB</li>
		<li title="the total amount of memory currently available for current and future objects">System.totalMemory() = <%= toMega(rt.totalMemory()) %> mB, <%= toKilo(rt.totalMemory()) %> kB</li>
		<li title="the maximum number of processors available to the virtual machine; never smaller than one">System.availableProcessors() = <%= rt.availableProcessors() %></li>
		<li>Active thread count: <strong><%= Thread.activeCount() %></strong></li>
	</ul>

</div>

<h3><a href="javascript:toggleVisible('systemInfo')">System properties</a></h3>
<div id="systemInfo" style="display:none;">
	<table align="center" width="90%" border="1" cellspacing="0" cellpadding="5">
	<tr>
		<th>Property</th>
		<th>Value</th>
	</tr>
	<%
	for (java.util.Iterator it = System.getProperties().entrySet().iterator(); it.hasNext();) {
		java.util.Map.Entry entry = (java.util.Map.Entry) it.next();
	%>
	<tr>
		<td><%= entry.getKey() %></td>
		<td><%= entry.getValue() %>&nbsp;</td>
	</tr>
	<%
	}
	%>
	</table>
</div>
<h3><a href="javascript:toggleVisible('envInfo')">Environment</a></h3>
<div id="envInfo" style="display:none;">
	<table align="center" width="90%" border="1" cellspacing="0" cellpadding="5">
	<tr>
		<th>Property</th>
		<th>Value</th>
	</tr>
	<%
	for (java.util.Iterator it = System.getenv().entrySet().iterator(); it.hasNext();) {
		java.util.Map.Entry entry = (java.util.Map.Entry) it.next();
	%>
	<tr>
		<td><%= entry.getKey() %></td>
		<td><%= entry.getValue() %>&nbsp;</td>
	</tr>
	<%
	}
	%>
	</table>
</div>
<h3><a href="javascript:toggleVisible('servletContextInfo')">Servlet Container/Context Info</a></h3>
<div id="servletContextInfo" style="display:none;">
	<h4>Servlet Context Info</h4>
	<ul>
		<li>Context name: <%= application.getServletContextName() %></li>
		<li>Server info: <%= application.getServerInfo() %></li>
		<li>Major version: <%= application.getMajorVersion() %></li>
		<li>Minor version: <%= application.getMinorVersion() %></li>
		<li>Context path: <%= application.getRealPath("/") %></li>
	</ul>
	<h4>Servlet Context Init Parameters</h4>
	<table align="center" width="90%" border="1" cellspacing="0" cellpadding="5">
	<tr>
		<th>Parameter</th>
		<th>Value</th>
	</tr>
	<%
	for (java.util.Enumeration en = application.getInitParameterNames(); en.hasMoreElements();) {
		String name = (String) en.nextElement();
	%>
	<tr>
		<td><%= name %></td>
		<td><%= application.getInitParameter(name) %>&nbsp;</td>
	</tr>
	<%
	}
	%>
	</table>
	<h4>Servlet Context Attributes</h4>
	<table align="center" width="90%" border="1" cellspacing="0" cellpadding="5">
	<tr>
		<th>Attribute</th>
		<th>Value</th>
	</tr>
	<%
	for (java.util.Enumeration en = application.getAttributeNames(); en.hasMoreElements();) {
		String name = (String) en.nextElement();
	%>
	<tr>
		<td><%= name %></td>
		<td><%= application.getAttribute(name) %>&nbsp;</td>
	</tr>
	<%
	}
	%>
	</table>
	<h4>Servlet Config Info</h4>
	<ul>
		<li>Servlet name: <%= config.getServletName() %></li>
	</ul>
	<h4>Servlet Config Init Parameters</h4>
	<table align="center" width="90%" border="1" cellspacing="0" cellpadding="5">
	<tr>
		<th>Parameter</th>
		<th>Value</th>
	</tr>
	<%
	for (java.util.Enumeration en = config.getInitParameterNames(); en.hasMoreElements();) {
		String name = (String) en.nextElement();
	%>
	<tr>
		<td><%= name %></td>
		<td><%= config.getInitParameter(name) %>&nbsp;</td>
	</tr>
	<%
	}
	%>
	</table>
</div>
<h3><a href="javascript:toggleVisible('requestInfo')">This Request Info</a></h3>
<div id="requestInfo" style="display:none;">
	<ul>
		<li>Character encoding: <%= request.getCharacterEncoding() %></li>
		<li>Content length: <%= request.getContentLength() %></li>
		<li>Content type: <%= request.getContentType() %></li>
		<li>Locale: <%= request.getLocale() %></li>
		<li>Protocol: <%= request.getProtocol() %></li>
		<li>Remote address: <%= request.getRemoteAddr() %></li>
		<li>Remote host: <%= request.getRemoteHost() %></li>
		<li>Scheme: <%= request.getScheme() %></li>
		<li>Server name: <%= request.getServerName() %></li>
		<li>Server port: <%= request.getServerPort() %></li>
		<li>Is secure: <%= request.isSecure() %></li>
		<li>Authentication type: <%= request.getAuthType() %></li>
		<li>Context path: <%= request.getContextPath() %></li>
		<li>Method: <%= request.getMethod() %></li>
		<li>Path info: <%= request.getPathInfo() %></li>
		<li>Path translated: <%= request.getPathTranslated() %></li>
		<li>Query string: <%= request.getQueryString() %></li>
		<li>Remote user: <%= request.getRemoteUser() %></li>
		<li>Requested session ID: <%= request.getRequestedSessionId() %></li>
		<li>Request URI: <%= request.getRequestURI() %></li>
		<li>Request URL: <%= request.getRequestURL() %></li>
		<li>Servlet path: <%= request.getServletPath() %></li>
		<li>User principal: <%= String.valueOf(request.getUserPrincipal()) %></li>
		<li>Is requested session ID valid: <%= request.isRequestedSessionIdValid() %></li>
		<li>Parameters: not implemented</li>
		<li>Headers: not implemented</li>
		<li>Cookies: not implemented</li>
	</ul>
	<h4>Request Attributes</h4>
	<table align="center" width="90%" border="1" cellspacing="0" cellpadding="5">
	<tr>
		<th>Attribute</th>
		<th>Value</th>
	</tr>
	<%
	for (java.util.Enumeration en = request.getAttributeNames(); en.hasMoreElements();) {
		String name = (String) en.nextElement();
	%>
	<tr>
		<td><%= name %></td>
		<td><%= request.getAttribute(name) %>&nbsp;</td>
	</tr>
	<%
	}
	%>
	</table>
</div>
<h3><a href="javascript:toggleVisible('sessionInfo')">Session Info</a></h3>
<div id="sessionInfo" style="display:none;">
	<% if (request.getSession(false) != null) { %>
	<ul>
		<li>ID: <%= request.getSession().getId() %></li>
		<li>Creation time: <%= new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz").format(request.getSession().getCreationTime()) %></li>
		<li>Last accessed time: <%= new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz").format(request.getSession().getLastAccessedTime()) %></li>
		<li>Max inactive interval: <%= request.getSession().getMaxInactiveInterval() %> msec</li>
	</ul>
	<h4>Session Attributes</h4>
	<table align="center" width="90%" border="1" cellspacing="0" cellpadding="5">
	<tr>
		<th>Attribute</th>
		<th>Value</th>
	</tr>
	<%
	for (java.util.Enumeration en = request.getSession().getAttributeNames(); en.hasMoreElements();) {
		String name = (String) en.nextElement();
	%>
	<tr>
		<td><%= name %></td>
		<td><%= request.getSession().getAttribute(name) %>&nbsp;</td>
	</tr>
	<%
	}
	%>
	</table>
	<% } else { %>
	No session defined.
	<% } %>
</div>

<h3><a href="javascript:toggleVisible('jvmMemoryMon')">Memory Monitor</a></h3>
<div id="jvmMemoryMon" style="display:none;">

		<table border="0" width="100%">
			<tr><td colspan="2" align="center"><h3>Memory MXBean</h3></td></tr>
			<tr><td width="200">Heap Memory Usage</td><td>
				<%=ManagementFactory.getMemoryMXBean().getHeapMemoryUsage()%>
			</td></tr>

			<tr>
  				<td>Non-Heap Memory Usage</td>
  				<td><%=ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage()%></td>
			</tr>
			<tr><td colspan="2">&nbsp;</td></tr>
			<tr><td colspan="2" align="center"><h3>Memory Pool MXBeans</h3></td></tr>
				<%
			        Iterator iter = ManagementFactory.getMemoryPoolMXBeans().iterator();
			        while (iter.hasNext()) {
			            MemoryPoolMXBean item = (MemoryPoolMXBean) iter.next();
				%>
			<tr><td colspan="2">
				<table border="0" width="100%" style="border: 1px #98AAB1 solid;">
				<tr><td colspan="2" align="center"><b><%= item.getName() %></b></td></tr>
				<tr><td width="200">Type</td><td><%= item.getType() %></td></tr>
				<tr><td>Usage</td><td><%= item.getUsage() %></td></tr>
				<tr><td>Peak Usage</td><td><%= item.getPeakUsage() %></td></tr>
				<tr><td>Collection Usage</td><td><%= item.getCollectionUsage() %></td></tr>
				</table>
			</td></tr>
			<tr><td colspan="2">&nbsp;</td></tr>
			<%
			        }
			%>

		</table>

</div>

<h3>
	Thread Dumps (<%= Thread.activeCount() %>)
	<% if (!"true".equals(request.getParameter("dump"))) { %>
	<a href="debug.jsp?dump=true">SHOW</a>
	<% } else { %>
	<a href="debug.jsp?dump=false">HIDE</a>
	<% } %>
</h3>
<%
if ("true".equals(request.getParameter("dump"))) {
	Thread[] threads = new Thread[Thread.activeCount()];
	Thread.enumerate(threads);
	for (int i = 0; i < threads.length; i++) {
	    Thread thread = threads[i];
%>
<h4><%= i + 1 %>: <a href="javascript:toggleVisible('dump_<%= i %>')"><%= thread.getName() %></a></h4>
<pre id="dump_<%= i %>" style="display:none;"><%= dump(thread) %></pre>
<%
	}
}
%>

</body>
</html>
