<%@page import="com.gridnine.xtrip.server.db.storage.LogicalStorage"%>
<%@ page errorPage="error.jsp" pageEncoding="UTF-8"
	contentType="text/html; charset=UTF-8" import="java.util.Collection"
	import=" java.util.Collections" import=" java.util.Comparator"
	import=" java.util.Date" import=" java.util.HashSet"
	import=" java.util.ArrayList" import=" java.util.LinkedList"
	import=" java.util.List" import=" java.util.Set"
	import=" org.apache.commons.logging.Log"
	import=" org.apache.commons.logging.LogFactory"
	import=" com.gridnine.xtrip.common.Environment"
	import=" com.gridnine.xtrip.common.meta.EntityType"
	import=" com.gridnine.xtrip.common.meta.MetaRegistry"
	import=" com.gridnine.xtrip.common.model.EntityContainer"
	import=" com.gridnine.xtrip.common.model.helpers.SystemHelper"
	import=" com.gridnine.xtrip.common.model.system.Message"
	import=" com.gridnine.xtrip.common.model.system.MessageType"
	import=" com.gridnine.xtrip.common.util.TextUtil"
	import=" com.gridnine.xtrip.server.storage.EntityStorage"
	import=" com.gridnine.xtrip.server.storage.EntityStorage"
	import=" com.gridnine.xtrip.server.storage.StorageManager"
	import="java.text.SimpleDateFormat"
	import="com.gridnine.xtrip.common.util.MiscUtil"
	import="com.gridnine.xtrip.common.search.SearchQuery"
	import="com.gridnine.xtrip.common.model.entity.EntityStorage"
	import="com.gridnine.xtrip.common.model.booking.BookingFileIndex"
	import="com.gridnine.xtrip.common.search.SearchCriterion"
	import="com.gridnine.xtrip.common.model.booking.BookingFile"
	import="com.gridnine.xtrip.common.model.booking.Payment"
	import="com.gridnine.xtrip.common.model.booking.FinanceDocument"

	%>
	<%!static class ChangeBookingNumbersTask extends Thread {

		private final Log log = LogFactory.getLog(getClass());

		private static int treshlold = 10;

		private static ChangeBookingNumbersTask instance;

		public synchronized static ChangeBookingNumbersTask getInstance() {
			if (instance == null) {
				instance = new ChangeBookingNumbersTask();
			}
			return instance;
		}

		private ChangeBookingNumbersTask() {
			setDaemon(true);
			setPriority(MIN_PRIORITY);
			setName("change number task");
		}

		private boolean taskStarted;

		private boolean taskCompleted;

		private boolean forcedInterupt;

		private Date startDate;

		private Date endDate;

		private int totalCount;

		private int updatedCount;

		private String login;

		private String password;

		@SuppressWarnings("unchecked")
		private final List messages = new LinkedList();

		private String status = "";

		public String getStatus() {
			synchronized (status) {
				return status;
			}
		}

		@SuppressWarnings("unchecked")
		@Override
		public void run() {
			if (taskStarted) {
				log.info("task is already running");
				return;
			}
			try {
				log.info("START export");
				taskStarted = true;
				taskCompleted = false;
				synchronized (messages) {
					messages.clear();
				}
				synchronized (status) {
					status = "starting task";
				}
				synchronized (messages) {
					SystemHelper.addMessage(messages, "task is started", null,
							MessageType.MESSAGE);
				}
				long startTime = System.currentTimeMillis();
				LogicalStorage.get().authorize(login, password.toCharArray());
				EntityStorage es = EntityStorage.get();
				SearchQuery query = new SearchQuery();
				query.getPreferredProperties().add(
						BookingFileIndex.Property.numberPrefix.name());
				if (startDate != null) {
					query.getCriteria().getCriterions().add(
							SearchCriterion
									.ge(BookingFileIndex.Property.createDate
											.name(), startDate));
				}
				if (endDate != null) {
					query.getCriteria().getCriterions().add(
							SearchCriterion
									.le(BookingFileIndex.Property.createDate
											.name(), endDate));
				}
				query.getCriteria().getOrders().put(BookingFileIndex.Property.createDate.name(), SortOrder.DESC);
				List<BookingFileIndex> lst = es.search(BookingFileIndex.class,
						query).getData();
				totalCount = lst.size();
				for (BookingFileIndex index : lst) {
					try {
						synchronized (this) {
							if (forcedInterupt) {
								log.warn("task was interupted");
								SystemHelper.addMessage(messages,
										"task was interupted", null,
										MessageType.WARNING);
								return;
							}
						}
						EntityContainer<BookingFile> ctr = es.resolve(index
								.getSource());
						ctr.getEntity().setNumber(null);
						for (Payment payment : ctr.getEntity().getPayments()) {
							payment.setNumber(null);
							for (FinanceDocument doc : payment
									.getFinanceDocuments()) {
								doc.setNumber(null);
							}
						}
						es.save(ctr, false);
						updatedCount++;
						synchronized (status) {
							status = String
									.format(
											"task is in progress:  updated %s/%s duration %s min",
											Integer.toString(updatedCount),Integer.toString(totalCount),Long
											.toString((System
													.currentTimeMillis() - startTime)
													/ (1000 * 60)));
						}
					} catch (Exception e) {
						LogFactory.getLog(getClass()).error("error", e);
						synchronized (messages) {
							messages.add(SystemHelper.createMessage(
									MessageType.ERROR, e.getMessage(), e));
						}
					}
				}

				synchronized (status) {
					status = String
							.format(
									"task is completed: updated %s objects from %s, duration =  %s min",
									Integer.toString(updatedCount),
									Integer.toString(totalCount),
									Long
											.toString((System
													.currentTimeMillis() - startTime)
													/ (1000 * 60)));
				}
				synchronized (messages) {
					SystemHelper
							.addMessage(
									messages,
									String
											.format(
													"task is completed: updated %s objects from %s, duration =  %s min",
													Integer
															.toString(updatedCount),
													Integer
															.toString(totalCount),
													Long
															.toString((System
																	.currentTimeMillis() - startTime)
																	/ (1000 * 60))),
									null, MessageType.MESSAGE);
				}
				log.info("FINISH export");
			} catch (Throwable e) {
				LogFactory.getLog(getClass()).error(
						"error occured during task", e);
				synchronized (messages) {
					messages.add(SystemHelper.createMessage(MessageType.ERROR,
							e.getMessage(), e));
				}
			} finally {
				forcedInterupt = false;
				taskCompleted = true;
			}

		}

		public void start(final String dateFromStr, final String dateToStr, final String loginName, final String pswd) {
			synchronized (this) {
				if (taskStarted) {
					throw new Error("task is already started, stop task");
				}
				updatedCount = 0;
				totalCount = 0;
				try {
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
					startDate = TextUtil.isBlank(dateFromStr) ? null : MiscUtil
							.clearTime(sdf.parse(dateFromStr));
					endDate = TextUtil.isBlank(dateToStr) ? null : MiscUtil
							.setDayEndTime(sdf.parse(dateToStr));
					login = loginName;
					password = pswd;
				} catch (Exception e) {
					throw new Error(e);
				}
			}
			super.start();
		}

		@SuppressWarnings("unchecked")
		public Collection getMessages() {
			synchronized (messages) {
				ArrayList lst = new ArrayList(messages);
				Collections.sort(lst, new Comparator() {
					public int compare(final Object o1, final Object o2) {
						Message msg1 = (Message) o1;
						Message msg2 = (Message) o2;
						if (msg1.getType() == msg2.getType()) {
							return messages.indexOf(msg1)
									- messages.indexOf(msg2);
						}
						if (msg1.getType() == MessageType.ERROR) {
							return -1;
						}
						if (msg2.getType() == MessageType.ERROR) {
							return 1;
						}
						if (msg1.getType() == MessageType.WARNING) {
							return -1;
						}
						if (msg2.getType() == MessageType.WARNING) {
							return 1;
						}
						return 0;
					}
				});
				return Collections.unmodifiableCollection(lst);
			}
		}

		public boolean interuptTask() {
			synchronized (this) {
				forcedInterupt = true;
				return taskCompleted;
			}
		}

		public boolean isTaskStarted() {
			synchronized (this) {
				return taskStarted;
			}
		}

		public boolean isTaskCompleted() {
			synchronized (this) {
				return taskCompleted;
			}
		}

		public void resetTask() {
			synchronized (this) {
				if (!taskCompleted) {
					return;
				}
				startDate = null;
				endDate = null;
				taskStarted = false;
				taskCompleted = false;
				updatedCount = 0;
				totalCount = 0;
				login = null;
				password = null;
				if (instance != null) {
					instance = new ChangeBookingNumbersTask();
				}
			}
		}
	}

	static final class ExtendedTask extends ChangeBookingNumbersTask {

	}%>
<%
	boolean onlyRefresh = false;
	request.setCharacterEncoding("utf-8");
	if (request.getParameter("stop") != null) {
		while (!ChangeBookingNumbersTask.getInstance().interuptTask()) {
			Thread.sleep(100);
		}
	} else if (request.getParameter("start") != null) {
		ChangeBookingNumbersTask.getInstance().start(
				request.getParameter("startDate"),
				request.getParameter("endDate"),
				request.getParameter("login"),
				request.getParameter("password"));
		onlyRefresh = true;
	} else if (request.getParameter("reset") != null) {
		ChangeBookingNumbersTask.getInstance().resetTask();
	}
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">


<%@page import="com.gridnine.xtrip.server.ServerApplication"%>
<%@page import="com.gridnine.xtrip.common.search.SortOrder"%><head>
<title>Edit bookings page</title>
<%--meta http-equiv="refresh" content="30;url=debug.jsp"--%>
</head>
<body>
<h1>Edit bookings page</h1>
<div id="controls">
<%
	if (!onlyRefresh
			&& !ChangeBookingNumbersTask.getInstance().isTaskStarted()) {
%>
<fieldset><legend><strong>Task parameters</strong></legend>
<p>
<form method="post">
<p><input type="text" name="startDate" value="Input start date" /></p>
<p><input type="text" name="endDate" value="Input end date" />
<p><input type="text" name="login" value="login" /></p>
<p><input type="text" name="password" value="password" />
</p>
<p><input type="submit" name="start" value="Start" /></p>
</form>
</p>
</fieldset>
<%
	} else if (onlyRefresh
			|| (ChangeBookingNumbersTask.getInstance().isTaskStarted() && !ChangeBookingNumbersTask
					.getInstance().isTaskCompleted())) {
%>
<fieldset><legend><strong><%=ChangeBookingNumbersTask.getInstance().getStatus()%></strong></legend>
<p>
<form method="post"><input type="submit" name="refresh"
	value="Refresh" /> <input type="submit" name="stop" value="Stop" /></form>
</p>
</fieldset>
<%
	} else {
%>
<fieldset><legend><strong><%=ChangeBookingNumbersTask.getInstance().getStatus()%></strong></legend>
<p>
<form method="post"><input type="submit" name="reset"
	value="Reset" /></form>
</p>
</fieldset>
<%
	}
%>
</div>
<h3>Messages</h3>
<div id="messages">
<table align="center" width="90%" border="1" cellspacing="0"
	cellpadding="5">
	<tr>
		<th>Status</th>
		<th>Message</th>
		<th>Details</th>
	</tr>
	<%
		for (java.util.Iterator it = ChangeBookingNumbersTask.getInstance()
				.getMessages().iterator(); it.hasNext();) {
			Message message = (Message) it.next();
	%>
	<tr>
		<td><%=message.getType().toString()%></td>
		<td><%=message.getMessage().getKey()%>&nbsp;</td>
		<td><%=message.getDetails()%></td>
	</tr>
	<%
		}
	%>
</table>
</div>
</body>

