<%@page import="com.gridnine.xtrip.common.xml.DocumentBuilderHelper"%>
<%@ page errorPage="error.jsp" pageEncoding="UTF-8"
	contentType="text/html; charset=UTF-8"
	import="java.io.BufferedOutputStream" import=" java.io.File"
	import=" java.io.FileOutputStream" import=" java.util.ArrayList"
	import=" java.util.Collection" import=" java.util.Collections"
	import=" java.util.Comparator" import=" java.util.Date"
	import=" java.util.HashSet" import=" java.util.LinkedList"
	import=" java.util.List" import=" java.util.Set"
	import=" java.util.zip.ZipEntry"
	import=" java.util.zip.ZipOutputStream"
	import=" javax.xml.transform.dom.DOMSource"
	import=" javax.xml.transform.stream.StreamResult"
	import=" org.apache.commons.logging.Log"
	import=" org.apache.commons.logging.LogFactory"
	import=" org.hibernate.criterion.Order"
	import=" org.hibernate.criterion.Projections"
	import=" org.hibernate.criterion.Restrictions"
	import=" org.w3c.dom.Document" import=" org.w3c.dom.Element"
	import=" com.gridnine.xtrip.common.Environment"
	import=" com.gridnine.xtrip.common.meta.EntityType"
	import=" com.gridnine.xtrip.common.meta.MetaRegistry"
	import=" com.gridnine.xtrip.common.model.EntityContainer"
	import=" com.gridnine.xtrip.common.model.entity.EntityStorage"
	import=" com.gridnine.xtrip.common.model.helpers.SystemHelper"
	import=" com.gridnine.xtrip.common.model.system.Message"
	import=" com.gridnine.xtrip.common.model.system.MessageType"
	import=" com.gridnine.xtrip.common.util.TextUtil"
	import=" com.gridnine.xtrip.common.xml.XUtil"
	import=" com.gridnine.xtrip.server.db.ManagedSession"
	import=" com.gridnine.xtrip.server.db.SessionManager"
	import=" com.gridnine.xtrip.server.storage.EntityStorage"
	import=" com.gridnine.xtrip.server.storage.StorageManager"
	import=" com.gridnine.xtrip.server.storage.DatabaseEntityStorage"


	%>


<%!static class ExportTask extends Thread {

		private final Log log = LogFactory.getLog(getClass());

		private static int treshlold = 10;

		private static ExportTask instance;

		public synchronized static ExportTask getInstance() {
			if (instance == null) {
				instance = new ExportTask();
			}
			return instance;
		}

		private ExportTask() {
			setDaemon(true);
			setPriority(MIN_PRIORITY);
			setName("export task");
		}

		private boolean taskStarted;

		private boolean taskCompleted;

		private boolean forcedInterupt;

		private String classesStr;

		private String outputDir;

		@SuppressWarnings("unchecked")
		private final List messages = new LinkedList();

		private String status = "";

		private int exportedCount = 0;

		private int totalCount = 0;

		public String getStatus() {
			synchronized (status) {
				return status;
			}
		}

		@SuppressWarnings("unchecked")
		@Override
		public void run() {
			if (taskStarted) {
				log.info("task is already running");
				return;
			}
			try {
				log.info("START export");
				taskStarted = true;
				taskCompleted = false;
				totalCount = 0;
				exportedCount = 0;
				synchronized (messages) {
					messages.clear();
				}
				synchronized (status) {
					status = "starting export";
				}
				synchronized (messages) {
					SystemHelper.addMessage(messages, "task is started", null,
							MessageType.MESSAGE);
				}
				File dir = new File(outputDir);
				if (!dir.exists() && !dir.mkdirs()) {
					synchronized (messages) {
						SystemHelper.addMessage(messages,
								"unable to create dir " + outputDir, null,
								MessageType.ERROR);
					}
					synchronized (status) {
						status = "export is not started";
					}
					return;
				}

				Set entityClassNames = new HashSet();
				if (!TextUtil.isBlank(classesStr)) {
					for (String entity : classesStr.split(",")) {
						if (!TextUtil.isBlank(entity)) {
							entityClassNames.add(entity.trim());
						}
					}
				}
				long startTime = System.currentTimeMillis();
				SessionManager sm = LogicalStorage.get().getSessionManager();
				EntityStorage es = EntityStorage.get();
				ManagedSession ss = sm.beginUnitOfWork();
				try {
					for (EntityType ett : Environment.getPublished(
							MetaRegistry.class).getEntities().values()) {
						if (ett.isAbstract() || !ett.isRoot()) {
							continue;
						}
						if (!entityClassNames.isEmpty()
								&& !entityClassNames.contains(ett.getId())) {
							continue;
						}
						log.debug("BEGIN exporting of " + ett.getDisplayName());
						synchronized (messages) {
							SystemHelper.addMessage(messages,
									"BEGIN exporting of "
											+ ett.getDisplayName(), null,
									MessageType.MESSAGE);
						}
						synchronized (status) {
							status = "BEGIN exporting of "
									+ ett.getDisplayName();
						}
						List uids = ss
								.getSession()
								.createCriteria(
										"com.gridnine.xtrip.server.storage.EntityData")
								.add(Restrictions.eq("entityType", ett.getId()))
								.setProjection(Projections.property("uid"))
								.addOrder(Order.desc("created")).list();
						sm.endUnitOfWork(ss, false);
						ss.getSession().clear();
						int count = uids.size();
						totalCount += count;
						log.debug(String.format(
								"collected %s entities of type %s", Integer
										.valueOf(count), ett.getDisplayName()));
						if (uids.isEmpty()) {
							synchronized (messages) {
								SystemHelper
										.addMessage(
												messages,
												String
														.format(
																"no entities of type %s was collected",
																ett
																		.getDisplayName()),
												null, MessageType.WARNING);
							}
							continue;
						}
						synchronized (messages) {
							SystemHelper.addMessage(messages, String.format(
									"collected %s entities of type %s", Integer
											.valueOf(count), ett
											.getDisplayName()), null,
									MessageType.MESSAGE);
						}
						Class entityType = Class.forName(ett.getId());
						File zipFile = new File(dir, ett.getId() + ".zip");
						ZipOutputStream strm = new ZipOutputStream(
								new BufferedOutputStream(new FileOutputStream(
										zipFile)));
						int ecount = 0;
						try {
							strm.setComment("xTrip data archive");
							for (int n = 0; n <= count / treshlold; n++) {
								if (n * treshlold >= count) {
									break;
								}
								Document result = DocumentBuilderHelper
										.newDocument();
								result.appendChild(result
										.createElement("objects"));
								result.getDocumentElement().setAttribute(
										"totalCount", Integer.toString(count));
								synchronized (this) {
									if (forcedInterupt) {
										log.warn("export task was interupted");
										SystemHelper.addMessage(messages,
												"task was interupted", null,
												MessageType.WARNING);
										return;
									}
								}
								int ecount2 = 0;
								for (int m = 0; m < treshlold; m++) {
									if (n * treshlold + m >= count) {
										break;
									}
									String uid = (String) uids.get(n
											* treshlold + m);
									Date createDate = null;
									try {
										EntityContainer ctr = es.load(
												entityType, uid);
										if (ctr == null) {
											synchronized (messages) {
												SystemHelper
														.addMessage(
																messages,
																String
																		.format(
																				"unable to load entity %s with UID %s",
																				ett
																						.getDisplayName(),
																				uid),
																null,
																MessageType.ERROR);
											}
											continue;
										}
										createDate = ctr.getCreated();
										Element elm = result
												.createElement("object");
										result.getDocumentElement()
												.appendChild(elm);
										elm
												.setAttribute("class",
														EntityContainer.class
																.getName());
										ctr.toXML(elm);
										sm.endUnitOfWork(ss, false);
										ecount2++;
										ss.getSession().clear();
									} catch (Exception e) {
										log
												.error(
														String
																.format(
																		"failed exporting entity %s with UID %s",
																		ett
																				.getDisplayName(),
																		uid), e);
										synchronized (messages) {
											SystemHelper
													.addExceptionMessage(
															messages,
															String
																	.format(
																			"failed exporting entity %s with UID %s created at %s",
																			ett
																					.getDisplayName(),
																			uid,
																			createDate),
															e,
															MessageType.ERROR);
										}
									}
								}
								String fileName = String.format("%s%08d.xml",
										ett.getId(), Integer.valueOf(n + 1));
								strm.putNextEntry(new ZipEntry(fileName));
								try {
									XUtil.getTransformer().transform(
											new DOMSource(result),
											new StreamResult(strm));
									ecount += ecount2;
								} finally {
									strm.closeEntry();
								}
								log.debug(String.format("exported %s (%s/%s)",
										ett.getDisplayName(), Integer
												.toString((n + 1) * treshlold),
										Integer.toString(count)));
								synchronized (status) {
									status = String
											.format(
													"exported %s (%s/%s = %s%%)",
													ett.getDisplayName(),
													Integer.toString((n + 1)
															* treshlold),
													Integer.toString(count),
													Integer
															.toString((int) (100.0
																	* (n + 1)
																	* treshlold / count)));
								}
							}
						} finally {
							strm.close();
						}
						synchronized (messages) {
							SystemHelper.addMessage(messages, "END exporting "
									+ ett.getDisplayName(), null,
									MessageType.MESSAGE);
						}
						log.debug("END exporting " + ett.getDisplayName());
						exportedCount += ecount;
					}
				} finally {
					sm.cancelUnitOfWork(ss);
				}

				synchronized (status) {
					status = String
							.format(
									"task is completed: exported %s objects from %s, duration =  %s min",
									Integer.toString(exportedCount),
									Integer.toString(totalCount),
									Long
											.toString((System
													.currentTimeMillis() - startTime)
													/ (1000 * 60)));
				}
				synchronized (messages) {
					SystemHelper
							.addMessage(
									messages,
									String
											.format(
													"task is completed: exported %s objects from %s, duration =  %s min",
													Integer
															.toString(exportedCount),
													Integer
															.toString(totalCount),
													Long
															.toString((System
																	.currentTimeMillis() - startTime)
																	/ (1000 * 60))),
									null, MessageType.MESSAGE);
				}
				log.info("FINISH export");
			} catch (Throwable e) {
				LogFactory.getLog(getClass()).error(
						"error occured during export", e);
				synchronized (messages) {
					messages.add(SystemHelper.createMessage(MessageType.ERROR,
							e.getMessage(), e));
				}
			} finally {
				forcedInterupt = false;
				taskCompleted = true;
			}

		}

		public void start(final String classes, final String dir) {
			synchronized (this) {
				if (taskStarted) {
					throw new Error("task is already started, stop task");
				}
				classesStr = classes;
				outputDir = dir;
			}
			super.start();
		}

		@SuppressWarnings("unchecked")
		public Collection getMessages() {
			synchronized (messages) {
				ArrayList lst = new ArrayList(messages);
				Collections.sort(lst, new Comparator() {
					public int compare(final Object o1, final Object o2) {
						Message msg1 = (Message) o1;
						Message msg2 = (Message) o2;
						if (msg1.getType() == msg2.getType()) {
							return messages.indexOf(msg1)
									- messages.indexOf(msg2);
						}
						if (msg1.getType() == MessageType.ERROR) {
							return -1;
						}
						if (msg2.getType() == MessageType.ERROR) {
							return 1;
						}
						if (msg1.getType() == MessageType.WARNING) {
							return -1;
						}
						if (msg2.getType() == MessageType.WARNING) {
							return 1;
						}
						return 0;
					}
				});
				return Collections.unmodifiableCollection(lst);
			}
		}

		public boolean interuptTask() {
			synchronized (this) {
				forcedInterupt = true;
				return taskCompleted;
			}
		}

		public boolean isTaskStarted() {
			synchronized (this) {
				return taskStarted;
			}
		}

		public boolean isTaskCompleted() {
			synchronized (this) {
				return taskCompleted;
			}
		}

		public void resetTask() {
			synchronized (this) {
				if (!taskCompleted) {
					return;
				}
				classesStr = null;
				taskStarted = false;
				taskCompleted = false;
				if (instance != null) {
					instance = new ExportTask();
				}
			}
		}
	}%>
<%
	boolean onlyRefresh = false;
	request.setCharacterEncoding("utf-8");
	if (request.getParameter("stop") != null) {
		while (!ExportTask.getInstance().interuptTask()) {
			Thread.sleep(100);
		}
	} else if (request.getParameter("start") != null) {
		ExportTask.getInstance().start(request.getParameter("classes"),
				request.getParameter("outDir"));
		onlyRefresh = true;
	} else if (request.getParameter("reset") != null) {
		ExportTask.getInstance().resetTask();
	}
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<head>
<title>Export entities page</title>
<%--meta http-equiv="refresh" content="30;url=debug.jsp"--%>
</head>
<body>
<h1>Export entities page</h1>
<div id="controls">
<%
	if (!onlyRefresh && !ExportTask.getInstance().isTaskStarted()) {
%>
<fieldset><legend><strong>Task parameters</strong></legend>
<p>
<form method="post">
<p><input type="text" name="classes" value="Input class name" /></p>
<p><input type="text" name="outDir" value="Output directory name" />
</p>
<p><input type="submit" name="start" value="Start" /></p>
</form>
</p>
</fieldset>
<%
	} else if (onlyRefresh
			|| (ExportTask.getInstance().isTaskStarted() && !ExportTask
					.getInstance().isTaskCompleted())) {
%>
<fieldset><legend><strong><%=ExportTask.getInstance().getStatus()%></strong></legend>
<p>
<form method="post"><input type="submit" name="refresh"
	value="Refresh" /> <input type="submit" name="stop" value="Stop" /></form>
</p>
</fieldset>
<%
	} else {
%>
<fieldset><legend><strong><%=ExportTask.getInstance().getStatus()%></strong></legend>
<p>
<form method="post"><input type="submit" name="reset"
	value="Reset" /></form>
</p>
</fieldset>
<%
	}
%>
</div>
<h3>Messages</h3>
<div id="messages">
<table align="center" width="90%" border="1" cellspacing="0"
	cellpadding="5">
	<tr>
		<th>Status</th>
		<th>Message</th>
		<th>Details</th>
	</tr>
	<%
		for (java.util.Iterator it = ExportTask.getInstance().getMessages()
				.iterator(); it.hasNext();) {
			Message message = (Message) it.next();
	%>
	<tr>
		<td><%=message.getType().toString()%></td>
		<td><%=message.getMessage().getKey()%>&nbsp;</td>
		<td><%=message.getDetails()%></td>
	</tr>
	<%
		}
	%>
</table>
</div>
</body>
</html>
