/*
 * Decompiled with CFR 0.152.
 */
package tools.javazic;

import tools.javazic.DayOfWeek;

class RuleDay {
    private String dayName = null;
    private DayOfWeek dow;
    private boolean lastOne = false;
    private int soonerOrLater = 0;
    private int thanDayOfMonth;

    RuleDay() {
    }

    RuleDay(int n) {
        this.thanDayOfMonth = n;
    }

    int getDay() {
        return this.thanDayOfMonth;
    }

    int getDayOfWeekNum() {
        return this.dow.value();
    }

    boolean isLast() {
        return this.lastOne;
    }

    boolean isLater() {
        return this.soonerOrLater > 0;
    }

    boolean isEarlier() {
        return this.soonerOrLater < 0;
    }

    boolean isExact() {
        return this.soonerOrLater == 0;
    }

    static RuleDay parse(String string) {
        RuleDay ruleDay = new RuleDay();
        if (string.startsWith("last")) {
            ruleDay.lastOne = true;
            ruleDay.dayName = string.substring(4);
            ruleDay.dow = RuleDay.getDOW(ruleDay.dayName);
        } else {
            int n = string.indexOf(">=");
            if (n != -1) {
                ruleDay.dayName = string.substring(0, n);
                ruleDay.dow = RuleDay.getDOW(ruleDay.dayName);
                ruleDay.soonerOrLater = 1;
                ruleDay.thanDayOfMonth = Integer.parseInt(string.substring(n + 2));
            } else {
                n = string.indexOf("<=");
                if (n != -1) {
                    ruleDay.dayName = string.substring(0, n);
                    ruleDay.dow = RuleDay.getDOW(ruleDay.dayName);
                    ruleDay.soonerOrLater = -1;
                    ruleDay.thanDayOfMonth = Integer.parseInt(string.substring(n + 2));
                } else {
                    ruleDay.thanDayOfMonth = Integer.parseInt(string);
                }
            }
        }
        return ruleDay;
    }

    int getDayForSimpleTimeZone() {
        if (this.isLast()) {
            return -1;
        }
        return this.isEarlier() ? -this.getDay() : this.getDay();
    }

    int getDayOfWeekForSimpleTimeZoneInt() {
        if (this.isEarlier() || this.isLater()) {
            return -this.getDayOfWeekNum();
        }
        return this.isLast() ? this.getDayOfWeekNum() : 0;
    }

    String getDayOfWeekForSimpleTimeZone() {
        int n = this.getDayOfWeekForSimpleTimeZoneInt();
        if (n == 0) {
            return "0";
        }
        String string = "";
        if (n < 0) {
            string = "-";
            n = -n;
        }
        return string + RuleDay.toString(n);
    }

    private static DayOfWeek getDOW(String string) {
        int n = string.length();
        if (string.regionMatches(true, 0, "Monday", 0, n)) {
            return DayOfWeek.MONDAY;
        }
        if (string.regionMatches(true, 0, "Tuesday", 0, n)) {
            return DayOfWeek.TUESDAY;
        }
        if (string.regionMatches(true, 0, "Wednesday", 0, n)) {
            return DayOfWeek.WEDNESDAY;
        }
        if (string.regionMatches(true, 0, "Thursday", 0, n)) {
            return DayOfWeek.THURSDAY;
        }
        if (string.regionMatches(true, 0, "Friday", 0, n)) {
            return DayOfWeek.FRIDAY;
        }
        if (string.regionMatches(true, 0, "Saturday", 0, n)) {
            return DayOfWeek.SATURDAY;
        }
        if (string.regionMatches(true, 0, "Sunday", 0, n)) {
            return DayOfWeek.SUNDAY;
        }
        throw new IllegalArgumentException("Unknown day-of-week: " + string);
    }

    static String toString(int n) {
        if (n >= DayOfWeek.SUNDAY.value() && n <= DayOfWeek.SATURDAY.value()) {
            return "Calendar." + (Object)((Object)DayOfWeek.values()[n - 1]);
        }
        throw new IllegalArgumentException("wrong Day_of_Week number: " + n);
    }
}

