/*
 * Decompiled with CFR 0.152.
 */
package tools.tzdb;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import tools.tzdb.Ser;
import tools.tzdb.TzdbZoneRulesProvider;
import tools.tzdb.ZoneRules;

public final class TzdbZoneRulesCompiler {
    private boolean verbose;

    public static void main(String[] stringArray) {
        new TzdbZoneRulesCompiler().compile(stringArray);
    }

    private void compile(String[] stringArray) {
        Object object;
        Object object2;
        int n;
        if (stringArray.length < 2) {
            TzdbZoneRulesCompiler.outputHelp();
            return;
        }
        Path path = null;
        Path path2 = null;
        String string = null;
        for (n = 0; n < stringArray.length && ((String)(object2 = stringArray[n])).startsWith("-"); ++n) {
            if ("-srcdir".equals(object2)) {
                if (path == null && ++n < stringArray.length) {
                    path = Paths.get(stringArray[n], new String[0]);
                    continue;
                }
            } else if ("-dstfile".equals(object2)) {
                if (path2 == null && ++n < stringArray.length) {
                    path2 = Paths.get(stringArray[n], new String[0]);
                    continue;
                }
            } else if ("-verbose".equals(object2)) {
                if (!this.verbose) {
                    this.verbose = true;
                    continue;
                }
            } else if (!"-help".equals(object2)) {
                System.out.println("Unrecognised option: " + (String)object2);
            }
            TzdbZoneRulesCompiler.outputHelp();
            return;
        }
        if (path == null) {
            System.err.println("Source directory must be specified using -srcdir");
            System.exit(1);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            System.err.println("Source does not exist or is not a directory: " + path);
            System.exit(1);
        }
        if (n == stringArray.length) {
            n = 0;
            stringArray = new String[]{"africa", "antarctica", "asia", "australasia", "europe", "northamerica", "pacificnew", "southamerica", "backward", "etcetera", "gmt", "jdk11_backward_jsr310"};
        }
        object2 = new ArrayList();
        while (n < stringArray.length) {
            object = path.resolve(stringArray[n]);
            if (Files.exists((Path)object, new LinkOption[0])) {
                object2.add(object);
            } else {
                this.printVerbose("Warning: Source directory does not contain source file: " + stringArray[n]);
            }
            ++n;
        }
        if (path2 == null) {
            path2 = path.resolve("tzdb.dat");
        } else {
            object = path2.getParent();
            if (object != null && !Files.exists((Path)object, new LinkOption[0])) {
                System.err.println("Destination directory does not exist: " + object);
                System.exit(1);
            }
        }
        try {
            object = Pattern.compile("tzdata(?<ver>[0-9]{4}[A-z])").matcher(new String(Files.readAllBytes(path.resolve("VERSION")), "ISO-8859-1"));
            if (((Matcher)object).find()) {
                string = ((Matcher)object).group("ver");
            } else {
                System.exit(1);
                System.err.println("Source directory does not contain file: VERSION");
            }
            this.printVerbose("Compiling TZDB version " + string);
            TzdbZoneRulesProvider tzdbZoneRulesProvider = new TzdbZoneRulesProvider((List<Path>)object2);
            this.printVerbose("Building rules");
            TreeMap<String, ZoneRules> treeMap = new TreeMap<String, ZoneRules>();
            for (String object3 : tzdbZoneRulesProvider.getZoneIds()) {
                this.printVerbose("Building zone " + object3);
                treeMap.put(object3, tzdbZoneRulesProvider.getZoneRules(object3));
            }
            Map<String, String> map = tzdbZoneRulesProvider.getAliasMap();
            for (String string2 : map.keySet()) {
                String string3 = (String)map.get(string2);
                this.printVerbose("Linking alias " + string2 + " to " + string3);
                ZoneRules zoneRules = (ZoneRules)treeMap.get(string3);
                if (zoneRules == null) {
                    string3 = (String)map.get(string3);
                    this.printVerbose("Relinking alias " + string2 + " to " + string3);
                    zoneRules = (ZoneRules)treeMap.get(string3);
                    if (zoneRules == null) {
                        throw new IllegalArgumentException("Alias '" + string2 + "' links to invalid zone '" + string3);
                    }
                    map.put(string2, string3);
                }
                treeMap.put(string2, zoneRules);
            }
            this.printVerbose("Outputting tzdb file: " + path2);
            this.outputFile(path2, string, treeMap, map);
        }
        catch (Exception exception) {
            System.out.println("Failed: " + exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static void outputHelp() {
        System.out.println("Usage: TzdbZoneRulesCompiler <options> <tzdb source filenames>");
        System.out.println("where options include:");
        System.out.println("   -srcdir  <directory>  Where to find tzdb source directory (required)");
        System.out.println("   -dstfile <file>       Where to output generated file (default srcdir/tzdb.dat)");
        System.out.println("   -help                 Print this usage message");
        System.out.println("   -verbose              Output verbose information during compilation");
        System.out.println(" The source directory must contain the unpacked tzdb files, such as asia or europe");
    }

    private void outputFile(Path path, String string, SortedMap<String, ZoneRules> sortedMap, Map<String, String> map) {
        try (DataOutputStream dataOutputStream = new DataOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF("TZDB");
            dataOutputStream.writeShort(1);
            dataOutputStream.writeUTF(string);
            Object[] objectArray = sortedMap.keySet().toArray(new String[sortedMap.size()]);
            dataOutputStream.writeShort(objectArray.length);
            for (String object : objectArray) {
                dataOutputStream.writeUTF(object);
            }
            List list = sortedMap.values().stream().distinct().collect(Collectors.toList());
            dataOutputStream.writeShort(list.size());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                ZoneRules zoneRules = (ZoneRules)iterator.next();
                byteArrayOutputStream.reset();
                DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
                Ser.write(zoneRules, dataOutputStream2);
                dataOutputStream2.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.writeShort(byArray.length);
                dataOutputStream.write(byArray);
            }
            dataOutputStream.writeShort(sortedMap.size());
            for (Map.Entry entry : sortedMap.entrySet()) {
                int n = Arrays.binarySearch(objectArray, entry.getKey());
                int n2 = list.indexOf(entry.getValue());
                dataOutputStream.writeShort(n);
                dataOutputStream.writeShort(n2);
            }
            dataOutputStream.writeShort(map.size());
            for (Map.Entry entry : map.entrySet()) {
                int n = Arrays.binarySearch(objectArray, entry.getKey());
                int n3 = Arrays.binarySearch(objectArray, entry.getValue());
                dataOutputStream.writeShort(n);
                dataOutputStream.writeShort(n3);
            }
            dataOutputStream.flush();
        }
        catch (Exception exception) {
            System.out.println("Failed: " + exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private TzdbZoneRulesCompiler() {
    }

    private void printVerbose(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }
}

