/*
 * Decompiled with CFR 0.152.
 */
package tools.tzdb;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.zone.ZoneRulesException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import tools.tzdb.ZoneOffsetTransition;
import tools.tzdb.ZoneOffsetTransitionRule;
import tools.tzdb.ZoneRules;

class TzdbZoneRulesProvider {
    private List<String> regionIds = new ArrayList<String>(600);
    private final Map<String, Object> zones = new ConcurrentSkipListMap<String, Object>();
    private static Set<String> excludedZones = new TreeSet<String>();
    private Map<String, String> links = new TreeMap<String, String>();
    private Map<String, List<RuleLine>> rules = new TreeMap<String, List<RuleLine>>();

    public TzdbZoneRulesProvider(List<Path> list) {
        try {
            this.load(list);
        }
        catch (Exception exception) {
            throw new ZoneRulesException("Unable to load TZDB time-zone rules", exception);
        }
    }

    public Set<String> getZoneIds() {
        return new TreeSet<String>(this.regionIds);
    }

    public Map<String, String> getAliasMap() {
        return this.links;
    }

    public ZoneRules getZoneRules(String string) {
        Object object;
        Object object2 = this.zones.get(string);
        if (object2 == null) {
            object = string;
            if (this.links.containsKey(string)) {
                string = this.links.get(string);
                object2 = this.zones.get(string);
            }
            if (object2 == null) {
                String string2 = string;
                if (this.links.containsKey(string)) {
                    string = this.links.get(string);
                    object2 = this.zones.get(string);
                }
                if (object2 == null) {
                    throw new ZoneRulesException("Unknown time-zone ID: " + string2);
                }
            }
        }
        if (object2 instanceof ZoneRules) {
            return (ZoneRules)object2;
        }
        try {
            object = this.buildRules(string, (List)object2);
            this.zones.put(string, object);
            return object;
        }
        catch (Exception exception) {
            throw new ZoneRulesException("Invalid binary time-zone data: TZDB:" + string, exception);
        }
    }

    private void load(List<Path> list) throws IOException {
        for (Path path : list) {
            ArrayList<ZoneLine> arrayList = null;
            try {
                for (String string : Files.readAllLines(path, StandardCharsets.ISO_8859_1)) {
                    Object object;
                    String string2;
                    int n;
                    if (string.length() == 0 || string.charAt(0) == '#') continue;
                    String[] stringArray = this.split(string);
                    if (arrayList != null && Character.isWhitespace(string.charAt(0)) && stringArray.length > 0) {
                        ZoneLine zoneLine = new ZoneLine();
                        arrayList.add(zoneLine);
                        if (!zoneLine.parse(stringArray, 0)) continue;
                        arrayList = null;
                        continue;
                    }
                    int n2 = n = stringArray.length > 0 ? stringArray[0].length() : string.length();
                    if (string.regionMatches(true, 0, "Zone", 0, n)) {
                        string2 = stringArray[1];
                        if (excludedZones.contains(string2)) continue;
                        if (this.zones.containsKey(string2)) {
                            throw new IllegalArgumentException("Duplicated zone name in file: " + string2 + ", line: [" + string + "]");
                        }
                        arrayList = new ArrayList<ZoneLine>(10);
                        this.zones.put(string2, arrayList);
                        this.regionIds.add(string2);
                        object = new ZoneLine();
                        arrayList.add((ZoneLine)object);
                        if (!((ZoneLine)object).parse(stringArray, 2)) continue;
                        arrayList = null;
                        continue;
                    }
                    if (string.regionMatches(true, 0, "Rule", 0, n)) {
                        string2 = stringArray[1];
                        if (!this.rules.containsKey(string2)) {
                            this.rules.put(string2, new ArrayList(10));
                        }
                        this.rules.get(string2).add(new RuleLine().parse(stringArray));
                        continue;
                    }
                    if (!string.regionMatches(true, 0, "Link", 0, n)) continue;
                    if (stringArray.length >= 3) {
                        string2 = stringArray[1];
                        object = stringArray[2];
                        if (excludedZones.contains(object)) continue;
                        this.links.put((String)object, string2);
                        this.regionIds.add((String)object);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid Link line in file" + path + ", line: [" + string + "]");
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed while processing file [" + path + "]", exception);
            }
        }
    }

    private String[] split(String string) {
        int n = 0;
        int n2 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '\t' || c == ' ') {
                ++n;
                continue;
            }
            if (c == '#') break;
            int n3 = n;
            while (n < n2 && (c = string.charAt(n)) != ' ' && c != '\t') {
                ++n;
            }
            if (n3 == n) continue;
            arrayList.add(string.substring(n3, n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private ZoneRules buildRules(String string, List<ZoneLine> list) {
        if (list.isEmpty()) {
            throw new IllegalStateException("No available zone window");
        }
        ArrayList<ZoneOffsetTransition> arrayList = new ArrayList<ZoneOffsetTransition>(4);
        ArrayList<ZoneOffsetTransition> arrayList2 = new ArrayList<ZoneOffsetTransition>(256);
        ArrayList<ZoneOffsetTransitionRule> arrayList3 = new ArrayList<ZoneOffsetTransitionRule>(2);
        ZoneLine zoneLine = list.get(0);
        TemporalAccessor temporalAccessor = ZoneOffset.ofTotalSeconds(zoneLine.stdOffsetSecs);
        int n = zoneLine.fixedSavingsSecs;
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(((ZoneOffset)temporalAccessor).getTotalSeconds() + n);
        LocalDateTime localDateTime = LocalDateTime.MIN;
        ZoneOffset zoneOffset2 = temporalAccessor;
        ZoneOffset zoneOffset3 = zoneOffset;
        for (ZoneLine zoneLine2 : list) {
            List<RuleLine> list2;
            TemporalAccessor temporalAccessor2;
            int n2 = Math.min(zoneLine2.fixedSavingsSecs, this.findNegativeSavings(localDateTime, zoneLine2));
            if (n2 < 0) {
                zoneLine2.stdOffsetSecs += n2;
                if (zoneLine2.fixedSavingsSecs < 0) {
                    zoneLine2.fixedSavingsSecs = 0;
                }
            }
            ZoneOffset zoneOffset4 = temporalAccessor;
            if (zoneLine2.stdOffsetSecs != ((ZoneOffset)temporalAccessor).getTotalSeconds()) {
                temporalAccessor2 = ZoneOffset.ofTotalSeconds(zoneLine2.stdOffsetSecs);
                arrayList.add(ZoneOffsetTransition.of(LocalDateTime.ofEpochSecond(localDateTime.toEpochSecond(zoneOffset), 0, (ZoneOffset)temporalAccessor), (ZoneOffset)temporalAccessor, (ZoneOffset)temporalAccessor2));
                temporalAccessor = temporalAccessor2;
            }
            if (((LocalDateTime)(temporalAccessor2 = zoneLine2.year == 999999999 ? LocalDateTime.MAX : zoneLine2.toDateTime())).compareTo(localDateTime) < 0) {
                throw new IllegalStateException("Windows must be in date-time order: " + temporalAccessor2 + " < " + localDateTime);
            }
            ArrayList<TransRule> arrayList4 = null;
            ArrayList<TransRule> arrayList5 = null;
            int n3 = zoneLine2.fixedSavingsSecs;
            if (zoneLine2.savingsRule != null) {
                TransRule transRule;
                int n4;
                list2 = this.rules.get(zoneLine2.savingsRule);
                if (list2 == null) {
                    throw new IllegalArgumentException("<Rule> not found: " + zoneLine2.savingsRule);
                }
                arrayList4 = new ArrayList<TransRule>(256);
                arrayList5 = new ArrayList<TransRule>(2);
                int n5 = -999999999;
                for (RuleLine ruleLine : list2) {
                    if (ruleLine.startYear > ((LocalDateTime)temporalAccessor2).getYear()) continue;
                    ruleLine.adjustToForwards(2004);
                    n4 = ruleLine.startYear;
                    int n6 = ruleLine.endYear;
                    if (((LocalDateTime)temporalAccessor2).equals(LocalDateTime.MAX)) {
                        if (n6 == 999999999) {
                            n6 = n4;
                            arrayList5.add(new TransRule(n6, ruleLine));
                        }
                        n5 = Math.max(n4, n5);
                    } else if (n6 == 999999999) {
                        n6 = zoneLine2.year;
                    }
                    for (int i = n4; i <= n6; ++i) {
                        arrayList4.add(new TransRule(i, ruleLine));
                    }
                }
                if (((LocalDateTime)temporalAccessor2).equals(LocalDateTime.MAX)) {
                    n5 = Math.max(n5, localDateTime.getYear()) + 1;
                    for (TransRule transRule2 : arrayList5) {
                        if (transRule2.year > n5) continue;
                        for (n4 = transRule2.year; n4 <= n5; ++n4) {
                            arrayList4.add(new TransRule(n4, transRule2.rule));
                        }
                        transRule2.year = n5;
                        transRule2.ldt = transRule2.rule.toDateTime(n4);
                        transRule2.ldtSecs = transRule2.ldt.toEpochSecond(ZoneOffset.UTC);
                    }
                    Collections.sort(arrayList5);
                }
                Collections.sort(arrayList4);
                n3 = -n2;
                Iterator iterator = arrayList4.iterator();
                while (iterator.hasNext() && (transRule = (TransRule)iterator.next()).toEpochSecond(zoneOffset4, n) <= localDateTime.toEpochSecond(zoneOffset)) {
                    n3 = ((TransRule)transRule).rule.savingsAmount - n2;
                }
            }
            if (!zoneOffset.equals(list2 = ZoneOffset.ofTotalSeconds(((ZoneOffset)temporalAccessor).getTotalSeconds() + n3))) {
                arrayList2.add(ZoneOffsetTransition.of(localDateTime, zoneOffset, (ZoneOffset)((Object)list2)));
            }
            n = n3;
            if (arrayList4 != null) {
                long l = localDateTime.toEpochSecond(zoneOffset);
                for (TransRule transRule : arrayList4) {
                    long l2;
                    if (!transRule.isTransition(n, n2) || (l2 = transRule.toEpochSecond((ZoneOffset)temporalAccessor, n)) < l || l2 >= zoneLine2.toDateTimeEpochSecond(n)) continue;
                    arrayList2.add(transRule.toTransition((ZoneOffset)temporalAccessor, n, n2));
                    n = ((TransRule)transRule).rule.savingsAmount - n2;
                }
            }
            if (arrayList5 != null) {
                for (TransRule transRule : arrayList5) {
                    arrayList3.add(transRule.rule.toTransitionRule((ZoneOffset)temporalAccessor, n, n2));
                    n = ((TransRule)transRule).rule.savingsAmount - n2;
                }
            }
            zoneOffset = ZoneOffset.ofTotalSeconds(((ZoneOffset)temporalAccessor).getTotalSeconds() + n);
            localDateTime = LocalDateTime.ofEpochSecond(zoneLine2.toDateTimeEpochSecond(n), 0, zoneOffset);
        }
        return new ZoneRules(zoneOffset2, zoneOffset3, arrayList, arrayList2, arrayList3);
    }

    private int findNegativeSavings(LocalDateTime localDateTime, ZoneLine zoneLine) {
        int n = 0;
        LocalDateTime localDateTime2 = zoneLine.toDateTime();
        if (zoneLine.savingsRule != null) {
            List<RuleLine> list = this.rules.get(zoneLine.savingsRule);
            if (list == null) {
                throw new IllegalArgumentException("<Rule> not found: " + zoneLine.savingsRule);
            }
            n = Math.min(0, list.stream().filter(ruleLine -> this.windowOverlap((RuleLine)ruleLine, localDateTime.getYear(), localDateTime2.getYear())).map(ruleLine -> ruleLine.savingsAmount).min(Comparator.naturalOrder()).orElse(0));
        }
        return n;
    }

    private boolean windowOverlap(RuleLine ruleLine, int n, int n2) {
        boolean bl = n <= ruleLine.startYear && n2 >= ruleLine.startYear || n <= ruleLine.endYear && n2 >= ruleLine.endYear;
        return bl;
    }

    static {
        excludedZones.add("EST");
        excludedZones.add("HST");
        excludedZones.add("MST");
        excludedZones.add("GMT+0");
        excludedZones.add("GMT-0");
        excludedZones.add("ROC");
    }

    private static class TransRule
    implements Comparable<TransRule> {
        private int year;
        private RuleLine rule;
        private LocalDateTime ldt;
        long ldtSecs;

        TransRule(int n, RuleLine ruleLine) {
            this.year = n;
            this.rule = ruleLine;
            this.ldt = ruleLine.toDateTime(n);
            this.ldtSecs = this.ldt.toEpochSecond(ZoneOffset.UTC);
        }

        ZoneOffsetTransition toTransition(ZoneOffset zoneOffset, int n, int n2) {
            ZoneOffset zoneOffset2 = ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + n);
            ZoneOffset zoneOffset3 = ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + this.rule.savingsAmount - n2);
            LocalDateTime localDateTime = this.rule.timeDefinition.createDateTime(this.ldt, zoneOffset, zoneOffset2);
            return ZoneOffsetTransition.of(localDateTime, zoneOffset2, zoneOffset3);
        }

        long toEpochSecond(ZoneOffset zoneOffset, int n) {
            switch (this.rule.timeDefinition) {
                case UTC: {
                    return this.ldtSecs;
                }
                case STANDARD: {
                    return this.ldtSecs - (long)zoneOffset.getTotalSeconds();
                }
            }
            return this.ldtSecs - (long)(zoneOffset.getTotalSeconds() + n);
        }

        boolean isTransition(int n, int n2) {
            return this.rule.savingsAmount - n2 != n;
        }

        @Override
        public int compareTo(TransRule transRule) {
            return this.ldtSecs < transRule.ldtSecs ? -1 : (this.ldtSecs == transRule.ldtSecs ? 0 : 1);
        }
    }

    private static class ZoneLine
    extends MonthDayTime {
        int stdOffsetSecs;
        int fixedSavingsSecs = 0;
        String savingsRule;
        String text;
        int year = 999999999;
        LocalDateTime ldt;
        long ldtSecs = Long.MIN_VALUE;

        private ZoneLine() {
        }

        LocalDateTime toDateTime() {
            if (this.ldt == null) {
                this.ldt = this.toDateTime(this.year);
            }
            return this.ldt;
        }

        long toDateTimeEpochSecond(int n) {
            if (this.ldtSecs == Long.MIN_VALUE) {
                this.ldtSecs = this.toDateTime().toEpochSecond(ZoneOffset.UTC);
            }
            switch (this.timeDefinition) {
                case UTC: {
                    return this.ldtSecs;
                }
                case STANDARD: {
                    return this.ldtSecs - (long)this.stdOffsetSecs;
                }
            }
            return this.ldtSecs - (long)(this.stdOffsetSecs + n);
        }

        boolean parse(String[] stringArray, int n) {
            this.stdOffsetSecs = this.parseOffset(stringArray[n++]);
            this.savingsRule = this.parseOptional(stringArray[n++]);
            if (this.savingsRule != null && this.savingsRule.length() > 0 && (this.savingsRule.charAt(0) == '-' || ZoneLine.isDigit(this.savingsRule.charAt(0)))) {
                try {
                    this.fixedSavingsSecs = this.parsePeriod(this.savingsRule);
                    this.savingsRule = null;
                }
                catch (Exception exception) {
                    this.fixedSavingsSecs = 0;
                }
            }
            this.text = stringArray[n++];
            if (n < stringArray.length) {
                this.year = Integer.parseInt(stringArray[n++]);
                if (n < stringArray.length) {
                    ((MonthDayTime)this).parse(stringArray, n);
                }
                return false;
            }
            return true;
        }
    }

    private static class RuleLine
    extends MonthDayTime {
        int startYear;
        int endYear;
        int savingsAmount;
        String text;

        private RuleLine() {
        }

        ZoneOffsetTransitionRule toTransitionRule(ZoneOffset zoneOffset, int n, int n2) {
            Month month = this.month;
            int n3 = this.dayOfMonth;
            DayOfWeek dayOfWeek = this.dayOfWeek;
            boolean bl = this.endOfDay;
            if (n3 < 0 && month != Month.FEBRUARY) {
                n3 = month.maxLength() - 6;
            }
            if (bl && n3 > 0 && !(n3 == 28 && month == Month.FEBRUARY)) {
                LocalDate localDate = LocalDate.of(2004, month, n3).plusDays(1L);
                month = localDate.getMonth();
                n3 = localDate.getDayOfMonth();
                if (dayOfWeek != null) {
                    dayOfWeek = dayOfWeek.plus(1L);
                }
                bl = false;
            }
            return ZoneOffsetTransitionRule.of(month, n3, dayOfWeek, LocalTime.ofSecondOfDay(this.secsOfDay), bl, this.timeDefinition, zoneOffset, ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + n), ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + this.savingsAmount - n2));
        }

        RuleLine parse(String[] stringArray) {
            this.startYear = this.parseYear(stringArray[2], 0);
            this.endYear = this.parseYear(stringArray[3], this.startYear);
            if (this.startYear > this.endYear) {
                throw new IllegalArgumentException("Invalid <Rule> line/Year order invalid:" + this.startYear + " > " + this.endYear);
            }
            ((MonthDayTime)this).parse(stringArray, 5);
            this.savingsAmount = this.parsePeriod(stringArray[8]);
            return this;
        }
    }

    private static abstract class MonthDayTime {
        Month month = Month.JANUARY;
        int dayOfMonth = 1;
        boolean adjustForwards = true;
        DayOfWeek dayOfWeek;
        int secsOfDay = 0;
        boolean endOfDay;
        ZoneOffsetTransitionRule.TimeDefinition timeDefinition = ZoneOffsetTransitionRule.TimeDefinition.WALL;

        private MonthDayTime() {
        }

        void adjustToForwards(int n) {
            if (!this.adjustForwards && this.dayOfMonth > 0) {
                LocalDate localDate = LocalDate.of(n, this.month, this.dayOfMonth).minusDays(6L);
                this.dayOfMonth = localDate.getDayOfMonth();
                this.month = localDate.getMonth();
                this.adjustForwards = true;
            }
        }

        LocalDateTime toDateTime(int n) {
            LocalDate localDate;
            if (this.dayOfMonth < 0) {
                int n2 = this.month.length(IsoChronology.INSTANCE.isLeapYear(n));
                localDate = LocalDate.of(n, this.month, n2 + 1 + this.dayOfMonth);
                if (this.dayOfWeek != null) {
                    localDate = localDate.with(TemporalAdjusters.previousOrSame(this.dayOfWeek));
                }
            } else {
                localDate = LocalDate.of(n, this.month, this.dayOfMonth);
                if (this.dayOfWeek != null) {
                    localDate = localDate.with(TemporalAdjusters.nextOrSame(this.dayOfWeek));
                }
            }
            if (this.endOfDay) {
                localDate = localDate.plusDays(1L);
            }
            return LocalDateTime.of(localDate, LocalTime.ofSecondOfDay(this.secsOfDay));
        }

        private void parse(String[] stringArray, int n) {
            this.month = this.parseMonth(stringArray[n++]);
            if (n < stringArray.length) {
                String string;
                if ((string = stringArray[n++]).regionMatches(true, 0, "last", 0, 4)) {
                    this.dayOfMonth = -1;
                    this.dayOfWeek = this.parseDayOfWeek(string.substring(4));
                    this.adjustForwards = false;
                } else {
                    int n2 = string.indexOf(">=");
                    if (n2 > 0) {
                        this.dayOfWeek = this.parseDayOfWeek(string.substring(0, n2));
                        string = string.substring(n2 + 2);
                    } else {
                        n2 = string.indexOf("<=");
                        if (n2 > 0) {
                            this.dayOfWeek = this.parseDayOfWeek(string.substring(0, n2));
                            this.adjustForwards = false;
                            string = string.substring(n2 + 2);
                        }
                    }
                    this.dayOfMonth = Integer.parseInt(string);
                    if (this.dayOfMonth < -28 || this.dayOfMonth > 31 || this.dayOfMonth == 0) {
                        throw new IllegalArgumentException("Day of month indicator must be between -28 and 31 inclusive excluding zero");
                    }
                }
                if (n < stringArray.length) {
                    String string2 = stringArray[n++];
                    this.secsOfDay = this.parseSecs(string2);
                    if (this.secsOfDay == 86400) {
                        this.endOfDay = true;
                        this.secsOfDay = 0;
                    } else if (this.secsOfDay < 0 || this.secsOfDay > 86400) {
                        int n3 = this.secsOfDay / 86400;
                        this.secsOfDay %= 86400;
                        if (this.secsOfDay < 0) {
                            this.secsOfDay = 86400 + this.secsOfDay;
                            --n3;
                        }
                        LocalDate localDate = LocalDate.of(2004, this.month, this.dayOfMonth).plusDays(n3);
                        this.month = localDate.getMonth();
                        this.dayOfMonth = localDate.getDayOfMonth();
                        if (this.dayOfWeek != null) {
                            this.dayOfWeek = this.dayOfWeek.plus(n3);
                        }
                    }
                    this.timeDefinition = this.parseTimeDefinition(string2.charAt(string2.length() - 1));
                }
            }
        }

        int parseYear(String string, int n) {
            int n2 = string.length();
            if (string.regionMatches(true, 0, "minimum", 0, n2)) {
                return 1900;
            }
            if (string.regionMatches(true, 0, "maximum", 0, n2)) {
                return 999999999;
            }
            if (string.regionMatches(true, 0, "only", 0, n2)) {
                return n;
            }
            return Integer.parseInt(string);
        }

        Month parseMonth(String string) {
            int n = string.length();
            if (string.regionMatches(true, 0, "January", 0, n)) {
                return Month.JANUARY;
            }
            if (string.regionMatches(true, 0, "February", 0, n)) {
                return Month.FEBRUARY;
            }
            if (string.regionMatches(true, 0, "March", 0, n)) {
                return Month.MARCH;
            }
            if (string.regionMatches(true, 0, "April", 0, n)) {
                return Month.APRIL;
            }
            if (string.regionMatches(true, 0, "May", 0, n)) {
                return Month.MAY;
            }
            if (string.regionMatches(true, 0, "June", 0, n)) {
                return Month.JUNE;
            }
            if (string.regionMatches(true, 0, "July", 0, n)) {
                return Month.JULY;
            }
            if (string.regionMatches(true, 0, "August", 0, n)) {
                return Month.AUGUST;
            }
            if (string.regionMatches(true, 0, "September", 0, n)) {
                return Month.SEPTEMBER;
            }
            if (string.regionMatches(true, 0, "October", 0, n)) {
                return Month.OCTOBER;
            }
            if (string.regionMatches(true, 0, "November", 0, n)) {
                return Month.NOVEMBER;
            }
            if (string.regionMatches(true, 0, "December", 0, n)) {
                return Month.DECEMBER;
            }
            throw new IllegalArgumentException("Unknown month: " + string);
        }

        DayOfWeek parseDayOfWeek(String string) {
            int n = string.length();
            if (string.regionMatches(true, 0, "Monday", 0, n)) {
                return DayOfWeek.MONDAY;
            }
            if (string.regionMatches(true, 0, "Tuesday", 0, n)) {
                return DayOfWeek.TUESDAY;
            }
            if (string.regionMatches(true, 0, "Wednesday", 0, n)) {
                return DayOfWeek.WEDNESDAY;
            }
            if (string.regionMatches(true, 0, "Thursday", 0, n)) {
                return DayOfWeek.THURSDAY;
            }
            if (string.regionMatches(true, 0, "Friday", 0, n)) {
                return DayOfWeek.FRIDAY;
            }
            if (string.regionMatches(true, 0, "Saturday", 0, n)) {
                return DayOfWeek.SATURDAY;
            }
            if (string.regionMatches(true, 0, "Sunday", 0, n)) {
                return DayOfWeek.SUNDAY;
            }
            throw new IllegalArgumentException("Unknown day-of-week: " + string);
        }

        String parseOptional(String string) {
            return string.equals("-") ? null : string;
        }

        static final boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }

        private int parseSecs(String string) {
            char c;
            if (string.equals("-")) {
                return 0;
            }
            int n = 0;
            int n2 = 1;
            int n3 = 0;
            int n4 = string.length();
            if (n3 < n4 && string.charAt(n3) == '-') {
                n2 = -1;
                ++n3;
            }
            if (n3 < n4 && MonthDayTime.isDigit(c = string.charAt(n3++))) {
                char c2;
                int n5 = c - 48;
                if (n3 < n4 && MonthDayTime.isDigit(c2 = string.charAt(n3))) {
                    n5 = n5 * 10 + c2 - 48;
                    ++n3;
                }
                n = n5 * 60 * 60;
                if (n3 < n4 && string.charAt(n3++) == ':' && n3 + 1 < n4 && MonthDayTime.isDigit(c = string.charAt(n3++)) && MonthDayTime.isDigit(c2 = string.charAt(n3++))) {
                    n += ((c - 48) * 10 + c2 - 48) * 60;
                    if (n3 < n4 && string.charAt(n3++) == ':' && n3 + 1 < n4 && MonthDayTime.isDigit(c = string.charAt(n3++)) && MonthDayTime.isDigit(c2 = string.charAt(n3++))) {
                        n += (c - 48) * 10 + c2 - 48;
                    }
                }
                return n * n2;
            }
            throw new IllegalArgumentException("[" + string + "]");
        }

        int parseOffset(String string) {
            int n = this.parseSecs(string);
            if (Math.abs(n) > 64800) {
                throw new IllegalArgumentException("Zone offset not in valid range: -18:00 to +18:00");
            }
            return n;
        }

        int parsePeriod(String string) {
            return this.parseSecs(string);
        }

        ZoneOffsetTransitionRule.TimeDefinition parseTimeDefinition(char c) {
            switch (c) {
                case 'S': 
                case 's': {
                    return ZoneOffsetTransitionRule.TimeDefinition.STANDARD;
                }
                case 'G': 
                case 'U': 
                case 'Z': 
                case 'g': 
                case 'u': 
                case 'z': {
                    return ZoneOffsetTransitionRule.TimeDefinition.UTC;
                }
            }
            return ZoneOffsetTransitionRule.TimeDefinition.WALL;
        }
    }
}

