/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.transport.servlet.ServletServerInvokerMBean;
import org.jboss.remoting.transport.web.WebServerInvoker;
import org.jboss.remoting.transport.web.WebUtil;
import org.jboss.remoting.util.SecurityUtility;

public class ServletServerInvoker
extends WebServerInvoker
implements ServletServerInvokerMBean {
    private static final Logger log = Logger.getLogger(ServletServerInvoker.class);

    public ServletServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public ServletServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    @Override
    protected String getDefaultDataType() {
        return "http";
    }

    @Override
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestContentType;
        HashMap<String, String> metadata = new HashMap<String, String>();
        Enumeration enumer = request.getHeaderNames();
        while (enumer.hasMoreElements()) {
            Object obj = enumer.nextElement();
            String headerKey = (String)obj;
            requestContentType = request.getHeader(headerKey);
            metadata.put(headerKey, requestContentType);
        }
        Map urlParams = request.getParameterMap();
        metadata.putAll(urlParams);
        Object o = this.configuration.get("preserveLines");
        if (o != null) {
            if (o instanceof String[]) {
                metadata.put("preserveLines", ((String[])o)[0]);
            } else {
                metadata.put("preserveLines", (String)o);
            }
        }
        requestContentType = request.getContentType();
        try {
            Object invocationResponse = null;
            ServletInputStream inputStream = request.getInputStream();
            UnMarshaller unmarshaller = MarshalFactory.getUnMarshaller((String)"http", (String)this.getSerializationType());
            Object obj = null;
            obj = unmarshaller instanceof VersionedUnMarshaller ? ((VersionedUnMarshaller)unmarshaller).read((InputStream)inputStream, metadata, this.getVersion()) : unmarshaller.read((InputStream)inputStream, metadata);
            inputStream.close();
            InvocationRequest invocationRequest = null;
            invocationRequest = obj instanceof InvocationRequest ? (InvocationRequest)obj : (WebUtil.isBinary(requestContentType) ? this.getInvocationRequest(metadata, obj) : this.createNewInvocationRequest(metadata, obj));
            String remoteAddressString = request.getRemoteAddr();
            InetAddress remoteAddress = SecurityUtility.getAddressByName((String)remoteAddressString);
            HashMap<String, InetAddress> requestPayload = invocationRequest.getRequestPayload();
            if (requestPayload == null) {
                requestPayload = new HashMap<String, InetAddress>();
                invocationRequest.setRequestPayload(requestPayload);
            }
            requestPayload.put("clientAddress", remoteAddress);
            try {
                invocationResponse = this.invoke(invocationRequest);
            }
            catch (Throwable var19) {
                log.debug((Object)"Error thrown calling invoke on server invoker.", var19);
                invocationResponse = null;
                response.sendError(500, "Error processing invocation request.  " + var19.getMessage());
            }
            if (invocationResponse != null) {
                response.setContentType(requestContentType);
                int iContentLength = this.getContentLength(invocationResponse);
                response.setContentLength(iContentLength);
                ServletOutputStream outputStream = response.getOutputStream();
                Marshaller marshaller = MarshalFactory.getMarshaller((String)"http", (String)this.getSerializationType());
                if (marshaller instanceof VersionedMarshaller) {
                    ((VersionedMarshaller)marshaller).write(invocationResponse, (OutputStream)outputStream, this.getVersion());
                } else {
                    marshaller.write(invocationResponse, (OutputStream)outputStream);
                }
                outputStream.close();
            }
        }
        catch (ClassNotFoundException var20) {
            log.error((Object)"Error processing invocation request due to class not being found.", (Throwable)var20);
            response.sendError(500, "Error processing invocation request due to class not being found.  " + var20.getMessage());
        }
    }

    @Override
    public ByteArrayOutputStream processRequest(HttpServletRequest request, byte[] requestByte, HttpServletResponse response) throws ServletException, IOException {
        String path;
        ByteArrayOutputStream retval = new ByteArrayOutputStream(0);
        boolean isRemotingUserAgent = false;
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            isRemotingUserAgent = userAgent.startsWith("JBossRemoting");
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        Enumeration enumer = request.getHeaderNames();
        while (enumer.hasMoreElements()) {
            Object obj = enumer.nextElement();
            String headerKey = (String)obj;
            path = request.getHeader(headerKey);
            metadata.put(headerKey, path);
        }
        Map urlParams = request.getParameterMap();
        metadata.putAll(urlParams);
        metadata.put("MethodType", request.getMethod());
        Object o = this.configuration.get("preserveLines");
        if (o != null) {
            if (o instanceof String[]) {
                metadata.put("preserveLines", ((String[])o)[0]);
            } else {
                metadata.put("preserveLines", (String)o);
            }
        }
        if ((path = request.getPathTranslated()) != null) {
            metadata.put("Path", path);
        }
        String requestContentType = request.getContentType();
        try {
            Map responseMap;
            Object responseObject = null;
            ServletInputStream inputStream = request.getInputStream();
            UnMarshaller unmarshaller = this.getUnMarshaller();
            Object obj = null;
            obj = unmarshaller instanceof VersionedUnMarshaller ? ((VersionedUnMarshaller)unmarshaller).read((InputStream)new ByteArrayInputStream(requestByte), metadata, this.getVersion()) : unmarshaller.read((InputStream)new ByteArrayInputStream(requestByte), metadata);
            inputStream.close();
            boolean isError = false;
            InvocationRequest invocationRequest = null;
            if (obj instanceof InvocationRequest) {
                invocationRequest = (InvocationRequest)obj;
                Map requestMap = invocationRequest.getRequestPayload();
                if (requestMap == null) {
                    invocationRequest.setRequestPayload(metadata);
                } else {
                    requestMap.putAll(metadata);
                }
            } else {
                invocationRequest = WebUtil.isBinary(requestContentType) ? this.getInvocationRequest(metadata, obj) : this.createNewInvocationRequest(metadata, obj);
            }
            String remoteAddressString = request.getRemoteAddr();
            InetAddress remoteAddress = SecurityUtility.getAddressByName((String)remoteAddressString);
            HashMap<String, InetAddress> requestPayload = invocationRequest.getRequestPayload();
            if (requestPayload == null) {
                requestPayload = new HashMap<String, InetAddress>();
                invocationRequest.setRequestPayload(requestPayload);
            }
            requestPayload.put("clientAddress", remoteAddress);
            try {
                responseObject = this.invoke(invocationRequest);
            }
            catch (Throwable var28) {
                log.debug((Object)"Error thrown calling invoke on server invoker.", var28);
                if (this.checkForNoExceptionReturn(metadata)) {
                    log.trace((Object)"Returning error message instead of Exception");
                    response.sendError(500, "Error occurred processing invocation request. ");
                    return retval;
                }
                responseObject = var28;
                isError = true;
            }
            int status = 200;
            if (responseObject != null) {
                if (isError) {
                    status = 500;
                }
            } else if (!isRemotingUserAgent || "HEAD".equals(request.getMethod())) {
                status = 204;
            }
            if ((responseMap = invocationRequest.getReturnPayload()) != null) {
                Integer handlerStatus = (Integer)responseMap.remove("ResponseCode");
                if (handlerStatus != null) {
                    status = handlerStatus;
                }
                Set entries = responseMap.entrySet();
                for (Map.Entry entry : entries) {
                    response.addHeader(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            response.setStatus(status);
            if (isRemotingUserAgent && !(invocationRequest instanceof WebServerInvoker.CreatedInvocationRequest)) {
                responseObject = new InvocationResponse(invocationRequest.getSessionId(), responseObject, isError, responseMap);
            }
            if (responseObject != null) {
                String responseContentType = null;
                if (responseMap != null) {
                    responseContentType = (String)responseMap.get("Content-Type");
                }
                if (responseContentType == null) {
                    responseContentType = responseObject == null ? requestContentType : WebUtil.getContentType(responseObject);
                }
                response.setContentType(responseContentType);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                Marshaller marshaller = this.getMarshaller();
                if (marshaller instanceof VersionedMarshaller) {
                    ((VersionedMarshaller)marshaller).write(responseObject, (OutputStream)outputStream, this.getVersion());
                } else {
                    marshaller.write(responseObject, (OutputStream)outputStream);
                }
                retval = outputStream;
                response.setContentLength(outputStream.size());
            }
        }
        catch (ClassNotFoundException var29) {
            log.error((Object)"Error processing invocation request due to class not being found.", (Throwable)var29);
            response.sendError(500, "Error processing invocation request due to class not being found.  " + var29.getMessage());
        }
        return retval;
    }

    private boolean checkForNoExceptionReturn(Map headers) {
        Object val;
        boolean flag = false;
        if (headers != null && (val = headers.get("dont-return-exception")) != null) {
            if (val instanceof String) {
                flag = Boolean.valueOf((String)val);
            } else if (val instanceof String[]) {
                String param = ((String[])val)[0];
                flag = Boolean.valueOf(param);
            }
        }
        return flag;
    }
}

