/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.h2.command.Command;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.index.MultiVersionIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.InDoubtTransaction;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueStringIgnoreCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int CONSTRAINTS = 20;
    private static final int FUNCTION_COLUMNS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int META_TABLE_TYPE_COUNT = 28;
    private final int type;
    private final int indexColumn;
    private MetaIndex metaIndex;

    public MetaTable(Schema schema, int n, int n2) {
        super(schema, n, null, true, true);
        Column[] columnArray;
        this.type = n2;
        String string = null;
        switch (n2) {
            case 0: {
                this.setObjectName("TABLES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT", "TYPE_NAME", "TABLE_CLASS");
                string = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setObjectName("COLUMNS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "SEQUENCE_NAME", "REMARKS", "SOURCE_DATA_TYPE SMALLINT");
                string = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setObjectName("INDEXES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT", "CONSTRAINT_NAME", "INDEX_CLASS");
                string = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setObjectName("TABLE_TYPES");
                columnArray = this.createColumns("TYPE");
                break;
            }
            case 4: {
                this.setObjectName("TYPE_INFO");
                columnArray = this.createColumns("TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT");
                break;
            }
            case 5: {
                this.setObjectName("CATALOGS");
                columnArray = this.createColumns("CATALOG_NAME");
                break;
            }
            case 6: {
                this.setObjectName("SETTINGS");
                columnArray = this.createColumns("NAME", "VALUE");
                break;
            }
            case 7: {
                this.setObjectName("HELP");
                columnArray = this.createColumns("ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT");
                break;
            }
            case 8: {
                this.setObjectName("SEQUENCES");
                columnArray = this.createColumns("SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "ID INT");
                break;
            }
            case 9: {
                this.setObjectName("USERS");
                columnArray = this.createColumns("NAME", "ADMIN", "REMARKS", "ID INT");
                break;
            }
            case 10: {
                this.setObjectName("ROLES");
                columnArray = this.createColumns("NAME", "REMARKS", "ID INT");
                break;
            }
            case 11: {
                this.setObjectName("RIGHTS");
                columnArray = this.createColumns("GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setObjectName("FUNCTION_ALIASES");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT", "SOURCE");
                break;
            }
            case 21: {
                this.setObjectName("FUNCTION_COLUMNS");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS", "COLUMN_DEFAULT");
                break;
            }
            case 13: {
                this.setObjectName("SCHEMATA");
                columnArray = this.createColumns("CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT");
                break;
            }
            case 14: {
                this.setObjectName("TABLE_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setObjectName("COLUMN_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setObjectName("COLLATIONS");
                columnArray = this.createColumns("NAME", "KEY");
                break;
            }
            case 17: {
                this.setObjectName("VIEWS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setObjectName("IN_DOUBT");
                columnArray = this.createColumns("TRANSACTION", "STATE");
                break;
            }
            case 19: {
                this.setObjectName("CROSS_REFERENCES");
                columnArray = this.createColumns("PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT");
                string = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setObjectName("CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "UNIQUE_INDEX_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setObjectName("CONSTANTS");
                columnArray = this.createColumns("CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 23: {
                this.setObjectName("DOMAINS");
                columnArray = this.createColumns("DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 24: {
                this.setObjectName("TRIGGERS");
                columnArray = this.createColumns("TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 25: {
                this.setObjectName("SESSIONS");
                columnArray = this.createColumns("ID INT", "USER_NAME", "SESSION_START", "STATEMENT", "STATEMENT_START");
                break;
            }
            case 26: {
                this.setObjectName("LOCKS");
                columnArray = this.createColumns("TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE");
                break;
            }
            case 27: {
                this.setObjectName("SESSION_STATE");
                columnArray = this.createColumns("KEY", "SQL");
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n2);
            }
        }
        this.setColumns(columnArray);
        if (string == null) {
            this.indexColumn = -1;
        } else {
            this.indexColumn = this.getColumn(string).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private Column[] createColumns(String ... stringArray) {
        Column[] columnArray = new Column[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            String string2 = stringArray[i];
            int n2 = string2.indexOf(32);
            if (n2 < 0) {
                n = this.database.getMode().lowerCaseIdentifiers ? 14 : 13;
                string = string2;
            } else {
                n = DataType.getTypeByName((String)string2.substring((int)(n2 + 1))).type;
                string = string2.substring(0, n2);
            }
            columnArray[i] = new Column(string, n);
        }
        return columnArray;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void lock(Session session, boolean bl, boolean bl2) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String string) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            string = string == null ? null : StringUtils.toLowerEnglish(string);
        }
        return string;
    }

    private ArrayList<Table> getAllTables(Session session) {
        ArrayList<Table> arrayList = this.database.getAllTablesAndViews(true);
        ArrayList<Table> arrayList2 = session.getLocalTempTables();
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private boolean checkIndex(Session session, String string, Value value, Value value2) {
        if (string == null || value == null && value2 == null) {
            return true;
        }
        Database database = session.getDatabase();
        if (this.database.getMode().lowerCaseIdentifiers) {
            ValueStringIgnoreCase valueStringIgnoreCase = ValueStringIgnoreCase.get(string);
            if (value.equals(value2) && database.compare(valueStringIgnoreCase, value) != 0) {
                return false;
            }
        } else {
            ValueString valueString = ValueString.get(string);
            if (value != null && database.compare(valueString, value) < 0) {
                return false;
            }
            if (value2 != null && database.compare(valueString, value2) > 0) {
                return false;
            }
        }
        return true;
    }

    private static String replaceNullWithEmpty(String string) {
        return string == null ? "" : string;
    }

    private boolean hideTable(Table table, Session session) {
        return table.isHidden() && session != this.database.getSystemSession();
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<Row> generateRows(Session session, SearchRow searchRow, SearchRow searchRow2) {
        Value value = null;
        Value value2 = null;
        if (this.indexColumn >= 0) {
            if (searchRow != null) {
                value = searchRow.getValue(this.indexColumn);
            }
            if (searchRow2 != null) {
                value2 = searchRow2.getValue(this.indexColumn);
            }
        }
        ArrayList<Row> arrayList = New.arrayList();
        String string = this.identifier(this.database.getShortName());
        boolean bl = session.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                for (Table table : this.getAllTables(session)) {
                    String object3 = this.identifier(table.getName());
                    if (!this.checkIndex(session, object3, value, value2) || this.hideTable(table, session)) continue;
                    String string10 = table.isTemporary() ? (table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistIndexes() ? "CACHED" : "MEMORY");
                    this.add(arrayList, string, this.identifier(table.getSchema().getName()), object3, table.getTableType(), string10, table.getCreateSQL(), MetaTable.replaceNullWithEmpty(table.getComment()), "" + table.getMaxDataModificationId(), "" + table.getId(), null, table.getClass().getName());
                }
                break;
            }
            case 1: {
                for (Table table : this.getAllTables(session)) {
                    String inputStreamReader = this.identifier(table.getName());
                    if (!this.checkIndex(session, inputStreamReader, value, value2) || this.hideTable(table, session)) continue;
                    Column[] string11 = table.getColumns();
                    String string2 = this.database.getCompareMode().getName();
                    for (int i = 0; i < string11.length; ++i) {
                        Column column = string11[i];
                        Sequence sequence = column.getSequence();
                        this.add(arrayList, string, this.identifier(table.getSchema().getName()), inputStreamReader, this.identifier(column.getName()), String.valueOf(i + 1), column.getDefaultSQL(), column.isNullable() ? "YES" : "NO", "" + DataType.convertTypeToSQLType(column.getType()), "" + column.getPrecisionAsInt(), "" + column.getPrecisionAsInt(), "" + column.getPrecisionAsInt(), "10", "" + column.getScale(), CHARACTER_SET_NAME, string2, this.identifier(DataType.getDataType((int)column.getType()).name), "" + (column.isNullable() ? 1 : 0), "" + (column.getComputed() ? "TRUE" : "FALSE"), "" + column.getSelectivity(), column.getCheckConstraintSQL(session, column.getName()), sequence == null ? null : sequence.getName(), MetaTable.replaceNullWithEmpty(column.getComment()), null);
                    }
                }
                break;
            }
            case 2: {
                for (Table table : this.getAllTables(session)) {
                    String sequence = this.identifier(table.getName());
                    if (!this.checkIndex(session, sequence, value, value2) || this.hideTable(table, session)) continue;
                    ArrayList<Index> csv = table.getIndexes();
                    ArrayList<Constraint> arrayList2 = table.getConstraints();
                    for (int n = 0; csv != null && n < csv.size(); ++n) {
                        Object object;
                        Index index = csv.get(n);
                        if (index.getCreateSQL() == null) continue;
                        String string3 = null;
                        for (int i = 0; arrayList2 != null && i < arrayList2.size(); ++i) {
                            object = arrayList2.get(i);
                            if (!((Constraint)object).usesIndex(index)) continue;
                            if (index.getIndexType().isPrimaryKey()) {
                                if (!((Constraint)object).getConstraintType().equals("PRIMARY KEY")) continue;
                                string3 = ((DbObjectBase)object).getName();
                                continue;
                            }
                            string3 = ((DbObjectBase)object).getName();
                        }
                        IndexColumn[] indexColumnArray = index.getIndexColumns();
                        object = index instanceof MultiVersionIndex ? ((MultiVersionIndex)index).getBaseIndex().getClass().getName() : index.getClass().getName();
                        for (int i = 0; i < indexColumnArray.length; ++i) {
                            IndexColumn indexColumn = indexColumnArray[i];
                            Column column = indexColumn.column;
                            this.add(arrayList, new String[]{string, this.identifier(table.getSchema().getName()), sequence, index.getIndexType().isUnique() ? "FALSE" : "TRUE", this.identifier(index.getName()), "" + (i + 1), this.identifier(column.getName()), "0", index.getIndexType().isPrimaryKey() ? "TRUE" : "FALSE", index.getIndexType().getSQL(), index.getIndexType().getBelongsToConstraint() ? "TRUE" : "FALSE", "3", (indexColumn.sortType & 1) != 0 ? "D" : "A", "0", "", MetaTable.replaceNullWithEmpty(index.getComment()), index.getCreateSQL(), "" + index.getId(), "" + indexColumn.sortType, string3, object});
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(arrayList, "TABLE");
                this.add(arrayList, "TABLE LINK");
                this.add(arrayList, "SYSTEM TABLE");
                this.add(arrayList, "VIEW");
                break;
            }
            case 5: {
                this.add(arrayList, string);
                break;
            }
            case 6: {
                Object object2;
                for (Setting object : this.database.getAllSettings()) {
                    String role = object.getStringValue();
                    if (role == null) {
                        role = "" + object.getIntValue();
                    }
                    this.add(arrayList, this.identifier(object.getName()), role);
                }
                this.add(arrayList, "info.BUILD_ID", "166");
                this.add(arrayList, "info.VERSION_MAJOR", "1");
                this.add(arrayList, "info.VERSION_MINOR", "3");
                this.add(arrayList, "info.VERSION", "" + Constants.getFullVersion());
                if (bl) {
                    object2 = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
                    for (String dbObject : object2) {
                        this.add(arrayList, "property." + dbObject, Utils.getProperty(dbObject, ""));
                    }
                }
                this.add(arrayList, "EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE");
                this.add(arrayList, "MODE", this.database.getMode().getName());
                this.add(arrayList, "MULTI_THREADED", this.database.isMultiThreaded() ? "1" : "0");
                this.add(arrayList, "MVCC", this.database.isMultiVersion() ? "TRUE" : "FALSE");
                this.add(arrayList, "QUERY_TIMEOUT", "" + session.getQueryTimeout());
                this.add(arrayList, "LOG", "" + this.database.getLogMode());
                object2 = New.arrayList();
                HashMap<String, String> exception = this.database.getSettings().getSettings();
                for (String string4 : exception.keySet()) {
                    ((ArrayList)object2).add(string4);
                }
                Collections.sort(object2);
                Object n = ((ArrayList)object2).iterator();
                while (n.hasNext()) {
                    String string17 = n.next();
                    this.add(arrayList, string17, exception.get(string17));
                }
                if (!this.database.isPersistent()) break;
                n = this.database.getPageStore();
                this.add(arrayList, "info.FILE_WRITE_TOTAL", "" + ((PageStore)n).getWriteCountTotal());
                this.add(arrayList, "info.FILE_WRITE", "" + ((PageStore)n).getWriteCount());
                this.add(arrayList, "info.FILE_READ", "" + ((PageStore)n).getReadCount());
                this.add(arrayList, "info.PAGE_COUNT", "" + ((PageStore)n).getPageCount());
                this.add(arrayList, "info.PAGE_SIZE", "" + ((PageStore)n).getPageSize());
                this.add(arrayList, "info.CACHE_MAX_SIZE", "" + ((PageStore)n).getCache().getMaxMemory());
                this.add(arrayList, "info.CACHE_SIZE", "" + ((PageStore)n).getCache().getMemory());
                break;
            }
            case 4: {
                for (DataType schemaObject : DataType.getTypes()) {
                    if (schemaObject.hidden || schemaObject.sqlType == 0) continue;
                    this.add(arrayList, schemaObject.name, String.valueOf(schemaObject.sqlType), String.valueOf(MathUtils.convertLongToInt(schemaObject.maxPrecision)), schemaObject.prefix, schemaObject.suffix, schemaObject.params, String.valueOf(schemaObject.autoIncrement), String.valueOf(schemaObject.minScale), String.valueOf(schemaObject.maxScale), schemaObject.decimal ? "10" : null, String.valueOf(schemaObject.sqlTypePos), String.valueOf(schemaObject.caseSensitive), "1", "3");
                }
                break;
            }
            case 7: {
                String string12 = "/org/h2/res/help.csv";
                try {
                    byte[] user = Utils.getResource(string12);
                    InputStreamReader functionAlias = new InputStreamReader(new ByteArrayInputStream(user));
                    Csv string18 = new Csv();
                    string18.setLineCommentCharacter('#');
                    ResultSet indexColumnArray = string18.read(functionAlias, null);
                    boolean indexColumnArray2 = false;
                    while (indexColumnArray.next()) {
                        this.add(arrayList, String.valueOf((int)indexColumnArray), indexColumnArray.getString(1).trim(), indexColumnArray.getString(2).trim(), indexColumnArray.getString(3).trim(), indexColumnArray.getString(4).trim());
                        ++indexColumnArray;
                    }
                    break;
                }
                catch (Exception role) {
                    throw DbException.convert(role);
                }
            }
            case 8: {
                for (SchemaObject right : this.database.getAllSchemaObjects(3)) {
                    Sequence schema = (Sequence)right;
                    this.add(arrayList, string, this.identifier(schema.getSchema().getName()), this.identifier(schema.getName()), String.valueOf(schema.getCurrentValue()), String.valueOf(schema.getIncrement()), schema.getBelongsToTable() ? "TRUE" : "FALSE", MetaTable.replaceNullWithEmpty(schema.getComment()), String.valueOf(schema.getCacheSize()), "" + schema.getId());
                }
                break;
            }
            case 9: {
                for (User dbObject : this.database.getAllUsers()) {
                    if (!bl && session.getUser() != dbObject) continue;
                    this.add(arrayList, this.identifier(dbObject.getName()), String.valueOf(dbObject.isAdmin()), MetaTable.replaceNullWithEmpty(dbObject.getComment()), "" + dbObject.getId());
                }
                break;
            }
            case 10: {
                for (Role schemaObject : this.database.getAllRoles()) {
                    if (!bl && !session.getUser().isRoleGranted(schemaObject)) continue;
                    this.add(arrayList, this.identifier(schemaObject.getName()), MetaTable.replaceNullWithEmpty(schemaObject.getComment()), "" + schemaObject.getId());
                }
                break;
            }
            case 11: {
                if (!bl) break;
                for (Right right : this.database.getAllRights()) {
                    String string23;
                    Role table = right.getGrantedRole();
                    DbObject locale = right.getGrantee();
                    String string5 = string23 = locale.getType() == 2 ? "USER" : "ROLE";
                    if (table == null) {
                        Table session2 = right.getGrantedTable();
                        String string6 = this.identifier(session2.getName());
                        if (!this.checkIndex(session, string6, value, value2)) continue;
                        this.add(arrayList, this.identifier(locale.getName()), string23, "", right.getRights(), this.identifier(session2.getSchema().getName()), this.identifier(session2.getName()), "" + right.getId());
                        continue;
                    }
                    this.add(arrayList, this.identifier(locale.getName()), string23, this.identifier(table.getName()), "", "", "", "" + right.getId());
                }
                break;
            }
            case 12: {
                for (SchemaObject right : this.database.getAllSchemaObjects(9)) {
                    FunctionAlias table = (FunctionAlias)right;
                    for (FunctionAlias.JavaMethod javaMethod : table.getJavaMethods()) {
                        int n = javaMethod.getDataType() == 0 ? 1 : 2;
                        this.add(arrayList, string, table.getSchema().getName(), this.identifier(table.getName()), table.getJavaClassName(), table.getJavaMethodName(), "" + DataType.convertTypeToSQLType(javaMethod.getDataType()), "" + javaMethod.getParameterCount(), "" + n, MetaTable.replaceNullWithEmpty(table.getComment()), "" + table.getId(), table.getSource());
                    }
                }
                for (UserAggregate userAggregate : this.database.getAllAggregates()) {
                    int n = 2;
                    this.add(arrayList, string, "PUBLIC", this.identifier(userAggregate.getName()), userAggregate.getJavaClassName(), "", "" + DataType.convertTypeToSQLType(0), "1", "" + n, MetaTable.replaceNullWithEmpty(userAggregate.getComment()), "" + userAggregate.getId(), "");
                }
                break;
            }
            case 21: {
                for (SchemaObject table : this.database.getAllSchemaObjects(9)) {
                    FunctionAlias string19 = (FunctionAlias)table;
                    for (FunctionAlias.JavaMethod javaMethod : string19.getJavaMethods()) {
                        Class<?>[] classArray = javaMethod.getColumnClasses();
                        for (int i = 0; i < classArray.length; ++i) {
                            if (javaMethod.hasConnectionParam() && i == 0) continue;
                            Class<?> clazz = classArray[i];
                            int n = DataType.getTypeFromClass(clazz);
                            DataType dataType = DataType.getDataType(n);
                            int n2 = clazz.isPrimitive() ? 0 : 1;
                            this.add(arrayList, string, string19.getSchema().getName(), this.identifier(string19.getName()), string19.getJavaClassName(), string19.getJavaMethodName(), "" + javaMethod.getParameterCount(), "" + (i + (javaMethod.hasConnectionParam() ? 0 : 1)), "P" + (i + 1), "" + DataType.convertTypeToSQLType(dataType.type), dataType.name, "" + MathUtils.convertLongToInt(dataType.defaultPrecision), "" + dataType.defaultScale, "10", "" + n2, "1", "", null);
                        }
                    }
                }
                break;
            }
            case 13: {
                String string16 = this.database.getCompareMode().getName();
                for (Schema inDoubtTransaction : this.database.getAllSchemas()) {
                    this.add(arrayList, string, this.identifier(inDoubtTransaction.getName()), this.identifier(inDoubtTransaction.getOwner().getName()), CHARACTER_SET_NAME, string16, "PUBLIC".equals(inDoubtTransaction.getName()) ? "TRUE" : "FALSE", MetaTable.replaceNullWithEmpty(inDoubtTransaction.getComment()), "" + inDoubtTransaction.getId());
                }
                break;
            }
            case 14: {
                for (Right schemaObject : this.database.getAllRights()) {
                    String string22;
                    Table constraint = schemaObject.getGrantedTable();
                    if (constraint == null || this.hideTable(constraint, session) || !this.checkIndex(session, string22 = this.identifier(constraint.getName()), value, value2)) continue;
                    this.addPrivileges(arrayList, schemaObject.getGrantee(), string, constraint, null, schemaObject.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right schemaObject : this.database.getAllRights()) {
                    String valueExpression;
                    Table constraint = schemaObject.getGrantedTable();
                    if (constraint == null || this.hideTable(constraint, session) || !this.checkIndex(session, valueExpression = this.identifier(constraint.getName()), value, value2)) continue;
                    DbObject value3 = schemaObject.getGrantee();
                    int n = schemaObject.getRightMask();
                    for (Column column : constraint.getColumns()) {
                        this.addPrivileges(arrayList, value3, string, constraint, column.getName(), n);
                    }
                }
                break;
            }
            case 16: {
                for (Locale table : Collator.getAvailableLocales()) {
                    this.add(arrayList, CompareMode.getName(table), table.toString());
                }
                break;
            }
            case 17: {
                for (Table userDataType : this.getAllTables(session)) {
                    String column;
                    if (!userDataType.getTableType().equals("VIEW") || !this.checkIndex(session, column = this.identifier(userDataType.getName()), value, value2)) continue;
                    TableView tableView = (TableView)userDataType;
                    this.add(arrayList, string, this.identifier(userDataType.getSchema().getName()), column, userDataType.getCreateSQL(), "NONE", "NO", tableView.isInvalid() ? "INVALID" : "VALID", MetaTable.replaceNullWithEmpty(tableView.getComment()), "" + tableView.getId());
                }
                break;
            }
            case 18: {
                ArrayList<InDoubtTransaction> arrayList4 = this.database.getInDoubtTransactions();
                if (arrayList4 == null || !bl) break;
                for (InDoubtTransaction triggerObject : arrayList4) {
                    this.add(arrayList, triggerObject.getTransaction(), triggerObject.getState());
                }
                break;
            }
            case 19: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    Constraint constraint = (Constraint)schemaObject;
                    if (!constraint.getConstraintType().equals("REFERENTIAL")) continue;
                    ConstraintReferential session3 = (ConstraintReferential)constraint;
                    IndexColumn[] indexColumnArray = session3.getColumns();
                    IndexColumn[] indexColumnArray2 = session3.getRefColumns();
                    Table table = session3.getTable();
                    Table table2 = session3.getRefTable();
                    String string7 = this.identifier(table2.getName());
                    if (!this.checkIndex(session, string7, value, value2)) continue;
                    int n = MetaTable.getRefAction(session3.getUpdateAction());
                    int n3 = MetaTable.getRefAction(session3.getDeleteAction());
                    for (int i = 0; i < indexColumnArray.length; ++i) {
                        this.add(arrayList, string, this.identifier(table2.getSchema().getName()), this.identifier(table2.getName()), this.identifier(indexColumnArray2[i].column.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(indexColumnArray[i].column.getName()), String.valueOf(i + 1), String.valueOf(n), String.valueOf(n3), this.identifier(session3.getName()), this.identifier(session3.getUniqueIndex().getName()), "7");
                    }
                }
                break;
            }
            case 20: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(5)) {
                    void var14_142;
                    String string8;
                    Constraint constraint = (Constraint)schemaObject;
                    String string27 = constraint.getConstraintType();
                    String string9 = null;
                    Object var14_143 = null;
                    Table table = constraint.getTable();
                    if (this.hideTable(table, session)) continue;
                    Index index = constraint.getUniqueIndex();
                    String string10 = null;
                    if (index != null) {
                        string10 = index.getName();
                    }
                    if (!this.checkIndex(session, string8 = this.identifier(table.getName()), value, value2)) continue;
                    if (string27.equals("CHECK")) {
                        string9 = ((ConstraintCheck)constraint).getExpression().getSQL();
                    } else if (string27.equals("UNIQUE") || string27.equals("PRIMARY KEY")) {
                        IndexColumn[] indexColumnArray = ((ConstraintUnique)constraint).getColumns();
                    } else if (string27.equals("REFERENTIAL")) {
                        IndexColumn[] indexColumnArray = ((ConstraintReferential)constraint).getColumns();
                    }
                    String string11 = null;
                    if (var14_142 != null) {
                        StatementBuilder statementBuilder = new StatementBuilder();
                        for (void var24_192 : var14_142) {
                            statementBuilder.appendExceptFirst(",");
                            statementBuilder.append(var24_192.column.getName());
                        }
                        string11 = statementBuilder.toString();
                    }
                    this.add(arrayList, string, this.identifier(constraint.getSchema().getName()), this.identifier(constraint.getName()), string27, string, this.identifier(table.getSchema().getName()), string8, string10, string9, string11, MetaTable.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), "" + constraint.getId());
                }
                break;
            }
            case 22: {
                for (SchemaObject table : this.database.getAllSchemaObjects(11)) {
                    Constant constant = (Constant)table;
                    ValueExpression valueExpression = constant.getValue();
                    this.add(arrayList, string, this.identifier(constant.getSchema().getName()), this.identifier(constant.getName()), "" + DataType.convertTypeToSQLType(valueExpression.getType()), MetaTable.replaceNullWithEmpty(constant.getComment()), valueExpression.getSQL(), "" + constant.getId());
                }
                break;
            }
            case 23: {
                for (UserDataType statementBuilder : this.database.getAllUserDataTypes()) {
                    Column column = statementBuilder.getColumn();
                    this.add(arrayList, string, "PUBLIC", this.identifier(statementBuilder.getName()), column.getDefaultSQL(), column.isNullable() ? "YES" : "NO", "" + column.getDataType().sqlType, "" + column.getPrecisionAsInt(), "" + column.getScale(), column.getDataType().name, "" + column.getSelectivity(), "" + column.getCheckConstraintSQL(session, "VALUE"), MetaTable.replaceNullWithEmpty(statementBuilder.getComment()), "" + statementBuilder.getCreateSQL(), "" + statementBuilder.getId());
                }
                break;
            }
            case 24: {
                for (SchemaObject string26 : this.database.getAllSchemaObjects(4)) {
                    TriggerObject triggerObject = (TriggerObject)string26;
                    Table table = triggerObject.getTable();
                    this.add(arrayList, string, this.identifier(triggerObject.getSchema().getName()), this.identifier(triggerObject.getName()), triggerObject.getTypeNameList(), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), "" + triggerObject.isBefore(), triggerObject.getTriggerClassName(), "" + triggerObject.getQueueSize(), "" + triggerObject.isNoWait(), MetaTable.replaceNullWithEmpty(triggerObject.getComment()), triggerObject.getCreateSQL(), "" + triggerObject.getId());
                }
                break;
            }
            case 25: {
                long l = System.currentTimeMillis();
                for (Session session2 : this.database.getSessions(false)) {
                    if (!bl && session2 != session) continue;
                    Command command = session2.getCurrentCommand();
                    long l2 = session2.getCurrentCommandStart();
                    if (l2 == 0L) {
                        l2 = l;
                    }
                    this.add(arrayList, "" + session2.getId(), session2.getUser().getName(), new Timestamp(session2.getSessionStart()).toString(), command == null ? null : command.toString(), new Timestamp(l2).toString());
                }
                break;
            }
            case 26: {
                for (Session session3 : this.database.getSessions(false)) {
                    if (!bl && session3 != session) continue;
                    for (Table table : session3.getLocks()) {
                        this.add(arrayList, table.getSchema().getName(), table.getName(), "" + session3.getId(), table.isLockedExclusivelyBy(session3) ? "WRITE" : "READ");
                    }
                }
                break;
            }
            case 27: {
                String string12;
                for (String string13 : session.getVariableNames()) {
                    Value value3 = session.getVariable(string13);
                    this.add(arrayList, "@" + string13, "SET @" + string13 + " " + value3.getSQL());
                }
                for (Table table : session.getLocalTempTables()) {
                    this.add(arrayList, "TABLE " + table.getName(), table.getCreateSQL());
                }
                String[] stringArray = session.getSchemaSearchPath();
                if (stringArray != null && stringArray.length > 0) {
                    StatementBuilder statementBuilder = new StatementBuilder("SET SCHEMA_SEARCH_PATH ");
                    for (Object object : stringArray) {
                        statementBuilder.appendExceptFirst(", ");
                        statementBuilder.append(StringUtils.quoteIdentifier((String)object));
                    }
                    this.add(arrayList, "SCHEMA_SEARCH_PATH", statementBuilder.toString());
                }
                if ((string12 = session.getCurrentSchemaName()) == null) break;
                this.add(arrayList, "SCHEMA", "SET SCHEMA " + StringUtils.quoteIdentifier(string12));
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return arrayList;
    }

    private static int getRefAction(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        throw DbException.throwInternalError("action=" + n);
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    private void addPrivileges(ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, int n) {
        if ((n & 1) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "SELECT");
        }
        if ((n & 4) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "INSERT");
        }
        if ((n & 8) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "UPDATE");
        }
        if ((n & 2) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "DELETE");
        }
    }

    private void addPrivilege(ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, String string3) {
        User user;
        String string4 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).isAdmin()) {
            string4 = "YES";
        }
        if (string2 == null) {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), string3, string4);
        } else {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(string2), string3, string4);
        }
    }

    private void add(ArrayList<Row> arrayList, String ... stringArray) {
        Value[] valueArray = new Value[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            Column column = this.columns[i];
            value = column.convert(value);
            valueArray[i] = value;
        }
        Row row = new Row(valueArray, 1);
        row.setKey(arrayList.size());
        arrayList.add(row);
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError();
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public String getTableType() {
        return "SYSTEM TABLE";
    }

    @Override
    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    @Override
    public ArrayList<Index> getIndexes() {
        ArrayList<Index> arrayList = New.arrayList();
        if (this.metaIndex == null) {
            return arrayList;
        }
        arrayList.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        arrayList.add(this.metaIndex);
        return arrayList;
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 6: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 28;
    }

    @Override
    public long getRowCountApproximation() {
        return 1000L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

