/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.server.RMIServerSocketFactory;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.util.SecurityUtility;

public class RemotingRMIServerSocketFactory
implements RMIServerSocketFactory,
Serializable {
    protected static final Logger log = Logger.getLogger((Class)RemotingRMIServerSocketFactory.class);
    private ServerSocketFactory serverSocketFactory;
    private int backlog;
    private InetAddress bindAddress;
    private int timeout;
    private static final long serialVersionUID = -5851426317709480542L;

    public RemotingRMIServerSocketFactory(String bindHost) throws UnknownHostException {
        this(null, -1, bindHost);
    }

    public RemotingRMIServerSocketFactory(int backlog, String bindHost) throws UnknownHostException {
        this(null, backlog, bindHost);
    }

    public RemotingRMIServerSocketFactory(ServerSocketFactory serverSocketFactory, int backlog, String bindHost) throws UnknownHostException {
        this(serverSocketFactory, backlog, bindHost, 60000);
    }

    public RemotingRMIServerSocketFactory(ServerSocketFactory serverSocketFactory, int backlog, String bindHost, int timeout) throws UnknownHostException {
        this.serverSocketFactory = serverSocketFactory;
        this.backlog = backlog;
        this.timeout = timeout;
        this.bindAddress = SecurityUtility.getAddressByName((String)bindHost);
    }

    public RemotingRMIServerSocketFactory(String bindHost, int timeout) throws UnknownHostException {
        this(null, -1, bindHost, timeout);
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket svrSocket = null;
        svrSocket = this.serverSocketFactory != null ? SecurityUtility.createServerSocket((ServerSocketFactory)this.serverSocketFactory, (int)port, (int)this.backlog, (InetAddress)this.bindAddress) : SecurityUtility.createServerSocket((int)port, (int)this.backlog, (InetAddress)this.bindAddress);
        svrSocket.setSoTimeout(this.timeout);
        return svrSocket;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemotingRMIServerSocketFactory)) {
            return false;
        }
        RemotingRMIServerSocketFactory ssf = (RemotingRMIServerSocketFactory)o;
        if (this.serverSocketFactory != null) {
            return ssf.serverSocketFactory != null && this.serverSocketFactory.equals(ssf.serverSocketFactory) && this.backlog == ssf.backlog && this.bindAddress.equals(ssf.bindAddress);
        }
        return ssf.serverSocketFactory == null && this.backlog == ssf.backlog && this.bindAddress.equals(ssf.bindAddress);
    }

    public int hashCode() {
        if (this.serverSocketFactory != null) {
            return this.serverSocketFactory.hashCode() * this.backlog * this.bindAddress.hashCode();
        }
        return this.backlog * this.bindAddress.hashCode();
    }
}

