/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.capability;

import [Ljava.lang.Object;;
import [Ljava.lang.String;;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.Type;
import org.jboss.mx.capability.DispatchClassLoader;
import org.jboss.mx.capability.ReflectedMBeanDispatcher;
import org.jboss.mx.metadata.AttributeOperationResolver;
import org.jboss.mx.server.ServerConstants;

public class OptimizedMBeanDispatcher
implements ServerConstants {
    static final Class SUPER_CLASS = ReflectedMBeanDispatcher.class;

    public static ReflectedMBeanDispatcher create(MBeanInfo info, Object resource) {
        try {
            String className = resource.getClass().getName().replace('.', '_') + "_Dispatcher";
            String superClass = SUPER_CLASS.getName();
            String fileName = className + ".class";
            int modifiers = 1;
            String[] interfaces = new String[]{};
            ClassGen clazz = new ClassGen(className, superClass, fileName, modifiers, interfaces);
            ConstantPoolGen cp = clazz.getConstantPool();
            clazz.addMethod(OptimizedMBeanDispatcher.createConstructor(cp, className).getMethod());
            clazz.addMethod(OptimizedMBeanDispatcher.createInvoke(cp, info, className, resource.getClass().getName()).getMethod());
            clazz.update();
            JavaClass c = clazz.getJavaClass();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2000);
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            c.dump((OutputStream)bos);
            DispatchClassLoader ocl = new DispatchClassLoader(resource.getClass().getClassLoader(), className, baos.toByteArray());
            Class<?> dispatcherClass = ocl.loadClass(className);
            Constructor<?> constr = dispatcherClass.getConstructor(MBeanInfo.class, AttributeOperationResolver.class, Object.class);
            Object o = constr.newInstance(info, new AttributeOperationResolver(info), resource);
            return (ReflectedMBeanDispatcher)o;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error();
        }
    }

    public static String getMethodDescriptor(MBeanParameterInfo[] signature, String returnType) {
        StringBuffer sign = new StringBuffer(256);
        sign.append("(");
        for (int i = 0; i < signature.length; ++i) {
            sign.append(OptimizedMBeanDispatcher.getDescriptorForType(signature[i].getName()));
        }
        sign.append(")" + OptimizedMBeanDispatcher.getDescriptorForType(returnType));
        return sign.toString();
    }

    public static String getDescriptorForType(String name) {
        if (name.equals(Byte.TYPE.getName())) {
            return "B";
        }
        if (name.equals(Character.TYPE.getName())) {
            return "C";
        }
        if (name.equals(Double.TYPE.getName())) {
            return "D";
        }
        if (name.equals(Float.TYPE.getName())) {
            return "F";
        }
        if (name.equals(Integer.TYPE.getName())) {
            return "I";
        }
        if (name.equals(Long.TYPE.getName())) {
            return "J";
        }
        if (name.equals(Short.TYPE.getName())) {
            return "S";
        }
        if (name.equals(Boolean.TYPE.getName())) {
            return "Z";
        }
        if (name.equals(Void.TYPE.getName())) {
            return "V";
        }
        if (name.startsWith("[")) {
            return name.replace('.', '/');
        }
        return "L" + name.replace('.', '/') + ";";
    }

    public static boolean isPrimitive(String name) {
        return name.equals(Byte.TYPE.getName()) || name.equals(Character.TYPE.getName()) || name.equals(Double.TYPE.getName()) || name.equals(Float.TYPE.getName()) || name.equals(Integer.TYPE.getName()) || name.equals(Long.TYPE.getName()) || name.equals(Short.TYPE.getName()) || name.equals(Boolean.TYPE.getName());
    }

    protected static MethodGen createConstructor(ConstantPoolGen cp, String className) {
        InstructionList constrInstructions = new InstructionList();
        int constrRefIndex = cp.addMethodref(SUPER_CLASS.getName(), "<init>", "(" + OptimizedMBeanDispatcher.getDescriptorForType(MBeanInfo.class.getName()) + OptimizedMBeanDispatcher.getDescriptorForType(AttributeOperationResolver.class.getName()) + OptimizedMBeanDispatcher.getDescriptorForType(Object.class.getName()) + ")V");
        constrInstructions.append((Instruction)new ALOAD(0));
        constrInstructions.append((Instruction)new ALOAD(1));
        constrInstructions.append((Instruction)new ALOAD(2));
        constrInstructions.append((Instruction)new ALOAD(3));
        constrInstructions.append((Instruction)new INVOKESPECIAL(constrRefIndex));
        constrInstructions.append((Instruction)new RETURN());
        MethodGen constrMethod = new MethodGen(1, (Type)Type.VOID, new Type[]{new ObjectType(MBeanInfo.class.getName()), new ObjectType(AttributeOperationResolver.class.getName()), new ObjectType(Object.class.getName())}, new String[]{"info", "resolver", "resource"}, "<init>", className, constrInstructions, cp);
        constrMethod.setMaxStack(4);
        return constrMethod;
    }

    protected static MethodGen createInvoke(ConstantPoolGen cp, MBeanInfo info, String className, String resourceClassName) {
        InstructionList invokeInstructions = new InstructionList();
        MethodEntry[] operations = OptimizedMBeanDispatcher.getOperations(info);
        for (int i = 0; i < operations.length; ++i) {
            operations[i].nameIndexInCP = cp.addString(operations[i].getName());
            operations[i].methodIndexInCP = cp.addMethodref(resourceClassName, operations[i].getName(), operations[i].methodDescriptor);
        }
        int invokeIndex = cp.addMethodref(SUPER_CLASS.getName(), "invoke", "(" + OptimizedMBeanDispatcher.getDescriptorForType(String.class.getName()) + OptimizedMBeanDispatcher.getDescriptorForType(Object;.class.getName()) + OptimizedMBeanDispatcher.getDescriptorForType(String;.class.getName()) + ")" + OptimizedMBeanDispatcher.getDescriptorForType(Object.class.getName()));
        int getResourceObjectIndex = cp.addMethodref(SUPER_CLASS.getName(), "getResourceObject", "()Ljava/lang/Object;");
        int strEqualsIndex = cp.addMethodref(String.class.getName(), "equals", "(Ljava/lang/Object;)Z");
        BranchHandle beginTryBlock = null;
        InstructionHandle endTryBlock = null;
        IFNULL ifOperationEqualsNull = new IFNULL(null);
        IFEQ operationElseIfBranch = null;
        if (operations.length > 0) {
            invokeInstructions.append((Instruction)new ALOAD(1));
            beginTryBlock = invokeInstructions.append((BranchInstruction)ifOperationEqualsNull);
            for (int i = 0; i < operations.length; ++i) {
                InstructionHandle jumpToNextElse = invokeInstructions.append((Instruction)new ALOAD(1));
                invokeInstructions.append((Instruction)new LDC(operations[i].nameIndexInCP));
                invokeInstructions.append((Instruction)new INVOKEVIRTUAL(strEqualsIndex));
                if (operationElseIfBranch != null) {
                    operationElseIfBranch.setTarget(jumpToNextElse);
                }
                operationElseIfBranch = new IFEQ(null);
                invokeInstructions.append((BranchInstruction)operationElseIfBranch);
                invokeInstructions.append((Instruction)new ALOAD(0));
                invokeInstructions.append((Instruction)new INVOKEVIRTUAL(getResourceObjectIndex));
                int x = cp.addClass(resourceClassName);
                invokeInstructions.append((Instruction)new CHECKCAST(x));
                if (operations[i].getSignature().length > 0) {
                    for (int arrayIndex = 0; arrayIndex < operations[i].getSignature().length; ++arrayIndex) {
                        invokeInstructions.append((Instruction)new ALOAD(2));
                        invokeInstructions.append((CompoundInstruction)new PUSH(cp, arrayIndex));
                        invokeInstructions.append((Instruction)new AALOAD());
                        String type = operations[i].getSignature()[arrayIndex].getName();
                        if (OptimizedMBeanDispatcher.isPrimitive(type)) {
                            invokeInstructions.append(OptimizedMBeanDispatcher.convertObjectToPrimitive(cp, type));
                            continue;
                        }
                        x = cp.addClass(type);
                        invokeInstructions.append((Instruction)new CHECKCAST(x));
                    }
                }
                x = operations[i].methodIndexInCP;
                invokeInstructions.append((Instruction)new INVOKEVIRTUAL(x));
                String type = operations[i].getReturnType();
                if (OptimizedMBeanDispatcher.isPrimitive(type)) {
                    invokeInstructions.append(OptimizedMBeanDispatcher.convertPrimitiveToObject(cp, type));
                    invokeInstructions.append((Instruction)new ARETURN());
                    continue;
                }
                if (type.equals(Void.TYPE.getName())) {
                    invokeInstructions.append((Instruction)new ACONST_NULL());
                    invokeInstructions.append((Instruction)new ARETURN());
                    continue;
                }
                invokeInstructions.append((Instruction)new ARETURN());
            }
        }
        InstructionHandle jumpToSuperInvoke = invokeInstructions.append((Instruction)new ALOAD(0));
        invokeInstructions.append((Instruction)new ALOAD(1));
        invokeInstructions.append((Instruction)new ALOAD(2));
        invokeInstructions.append((Instruction)new ALOAD(3));
        invokeInstructions.append((Instruction)new INVOKESPECIAL(invokeIndex));
        invokeInstructions.append((Instruction)new ARETURN());
        ifOperationEqualsNull.setTarget(jumpToSuperInvoke);
        if (operations.length > 0) {
            if (operationElseIfBranch != null) {
                operationElseIfBranch.setTarget(jumpToSuperInvoke);
            }
            beginTryBlock = beginTryBlock.getNext();
            endTryBlock = jumpToSuperInvoke.getPrev();
        }
        InstructionHandle exceptionHandlerCode = invokeInstructions.append((Instruction)new ALOAD(0));
        invokeInstructions.append((Instruction)new ALOAD(1));
        invokeInstructions.append((Instruction)new ALOAD(2));
        invokeInstructions.append((Instruction)new ALOAD(3));
        invokeInstructions.append((Instruction)new INVOKESPECIAL(invokeIndex));
        invokeInstructions.append((Instruction)new ARETURN());
        MethodGen invokeMethod = new MethodGen(1, (Type)Type.OBJECT, new Type[]{Type.STRING, new ArrayType(Object.class.getName(), 1), new ArrayType(String.class.getName(), 1)}, new String[]{"operationName", "args", "signature"}, "invoke", className, invokeInstructions, cp);
        invokeMethod.setMaxLocals(7);
        invokeMethod.setMaxStack(OptimizedMBeanDispatcher.calculateMaxStackSize(info));
        invokeMethod.addException(ReflectionException.class.getName());
        invokeMethod.addException(MBeanException.class.getName());
        if (operations.length > 0) {
            invokeMethod.addExceptionHandler((InstructionHandle)beginTryBlock, endTryBlock, exceptionHandlerCode, new ObjectType("java.lang.Throwable"));
        }
        return invokeMethod;
    }

    private static int calculateMaxStackSize(MBeanInfo info) {
        MBeanOperationInfo[] operations = info.getOperations();
        int maxSize = 7;
        for (int i = 0; i < operations.length; ++i) {
            if (operations[i].getSignature().length <= maxSize + 2) continue;
            maxSize = operations[i].getSignature().length + 2;
        }
        return maxSize;
    }

    protected static InstructionList convertObjectToPrimitive(ConstantPoolGen cp, String type) {
        InstructionList il = new InstructionList();
        int intValueIndex = cp.addMethodref(Integer.class.getName(), "intValue", "()I");
        int byteValueIndex = cp.addMethodref(Byte.class.getName(), "byteValue", "()B");
        int charValueIndex = cp.addMethodref(Character.class.getName(), "charValue", "()C");
        int doubleValueIndex = cp.addMethodref(Double.class.getName(), "doubleValue", "()D");
        int floatValueIndex = cp.addMethodref(Float.class.getName(), "floatValue", "()F");
        int longValueIndex = cp.addMethodref(Long.class.getName(), "longValue", "()J");
        int shortValueIndex = cp.addMethodref(Short.class.getName(), "shortValue", "()S");
        int booleanValueIndex = cp.addMethodref(Boolean.class.getName(), "booleanValue", "()Z");
        if (type.equals(Integer.TYPE.getName())) {
            int x = cp.addClass("java.lang.Integer");
            il.append((Instruction)new CHECKCAST(x));
            il.append((Instruction)new INVOKEVIRTUAL(intValueIndex));
        } else if (type.equals(Byte.TYPE.getName())) {
            int x = cp.addClass("java.lang.Byte");
            il.append((Instruction)new CHECKCAST(x));
            il.append((Instruction)new INVOKEVIRTUAL(byteValueIndex));
        } else if (type.equals(Character.TYPE.getName())) {
            int x = cp.addClass("java.lang.Character");
            il.append((Instruction)new CHECKCAST(x));
            il.append((Instruction)new INVOKEVIRTUAL(charValueIndex));
        } else if (type.equals(Double.TYPE.getName())) {
            int x = cp.addClass("java.lang.Double");
            il.append((Instruction)new CHECKCAST(x));
            il.append((Instruction)new INVOKEVIRTUAL(doubleValueIndex));
        } else if (type.equals(Float.TYPE.getName())) {
            int x = cp.addClass("java.lang.Float");
            il.append((Instruction)new CHECKCAST(x));
            il.append((Instruction)new INVOKEVIRTUAL(floatValueIndex));
        } else if (type.equals(Long.TYPE.getName())) {
            int x = cp.addClass("java.lang.Long");
            il.append((Instruction)new CHECKCAST(x));
            il.append((Instruction)new INVOKEVIRTUAL(longValueIndex));
        } else if (type.equals(Short.TYPE.getName())) {
            int x = cp.addClass("java.lang.Short");
            il.append((Instruction)new CHECKCAST(x));
            il.append((Instruction)new INVOKEVIRTUAL(shortValueIndex));
        } else if (type.equals(Boolean.TYPE.getName())) {
            int x = cp.addClass("java.lang.Boolean");
            il.append((Instruction)new CHECKCAST(x));
            il.append((Instruction)new INVOKEVIRTUAL(booleanValueIndex));
        }
        return il;
    }

    protected static InstructionList convertPrimitiveToObject(ConstantPoolGen cp, String type) {
        InstructionList il = new InstructionList();
        if (type.equals(Boolean.TYPE.getName())) {
            int x = cp.addClass("java.lang.Boolean");
            int constrIndex = cp.addMethodref("java.lang.Boolean", "<init>", "(B)V");
            il.append((Instruction)new ISTORE(4));
            il.append((Instruction)new NEW(x));
            il.append((Instruction)new ASTORE(5));
            il.append((Instruction)new ALOAD(5));
            il.append((Instruction)new ILOAD(4));
            il.append((Instruction)new INVOKESPECIAL(constrIndex));
            il.append((Instruction)new ALOAD(5));
        } else if (type.equals(Short.TYPE.getName())) {
            int x = cp.addClass("java.lang.Short");
            int constrIndex = cp.addMethodref("java.lang.Short", "<init>", "(S)V");
            il.append((Instruction)new ISTORE(4));
            il.append((Instruction)new NEW(x));
            il.append((Instruction)new ASTORE(5));
            il.append((Instruction)new ALOAD(5));
            il.append((Instruction)new ILOAD(4));
            il.append((Instruction)new INVOKESPECIAL(constrIndex));
            il.append((Instruction)new ALOAD(5));
        } else if (type.equals(Long.TYPE.getName())) {
            int x = cp.addClass("java.lang.Long");
            int constrIndex = cp.addMethodref("java.lang.Long", "<init>", "(J)V");
            il.append((Instruction)new LSTORE(4));
            il.append((Instruction)new NEW(x));
            il.append((Instruction)new ASTORE(6));
            il.append((Instruction)new ALOAD(6));
            il.append((Instruction)new LLOAD(4));
            il.append((Instruction)new INVOKESPECIAL(constrIndex));
            il.append((Instruction)new ALOAD(6));
        } else if (type.equals(Integer.TYPE.getName())) {
            int x = cp.addClass("java.lang.Integer");
            int constrIndex = cp.addMethodref("java.lang.Integer", "<init>", "(I)V");
            il.append((Instruction)new ISTORE(4));
            il.append((Instruction)new NEW(x));
            il.append((Instruction)new ASTORE(5));
            il.append((Instruction)new ALOAD(5));
            il.append((Instruction)new ILOAD(4));
            il.append((Instruction)new INVOKESPECIAL(constrIndex));
            il.append((Instruction)new ALOAD(5));
        } else if (type.equals(Float.TYPE.getName())) {
            int x = cp.addClass("java.lang.Float");
            int constrIndex = cp.addMethodref("java.lang.Float", "<init>", "(F)V");
            il.append((Instruction)new FSTORE(4));
            il.append((Instruction)new NEW(x));
            il.append((Instruction)new ASTORE(5));
            il.append((Instruction)new ALOAD(5));
            il.append((Instruction)new FLOAD(4));
            il.append((Instruction)new INVOKESPECIAL(constrIndex));
            il.append((Instruction)new ALOAD(5));
        } else if (type.equals(Double.TYPE.getName())) {
            int x = cp.addClass("java.lang.Double");
            int constrIndex = cp.addMethodref("java.lang.Double", "<init>", "(D)V");
            il.append((Instruction)new DSTORE(4));
            il.append((Instruction)new NEW(x));
            il.append((Instruction)new ASTORE(6));
            il.append((Instruction)new ALOAD(6));
            il.append((Instruction)new DLOAD(4));
            il.append((Instruction)new INVOKESPECIAL(constrIndex));
            il.append((Instruction)new ALOAD(6));
        } else if (type.equals(Character.TYPE.getName())) {
            int x = cp.addClass("java.lang.Character");
            int constrIndex = cp.addMethodref("java.lang.Character", "<init>", "(C)V");
            il.append((Instruction)new ISTORE(4));
            il.append((Instruction)new NEW(x));
            il.append((Instruction)new ASTORE(5));
            il.append((Instruction)new ALOAD(5));
            il.append((Instruction)new ILOAD(4));
            il.append((Instruction)new INVOKESPECIAL(constrIndex));
            il.append((Instruction)new ALOAD(5));
        } else if (type.equals(Byte.TYPE.getName())) {
            int x = cp.addClass("java.lang.Byte");
            int constrIndex = cp.addMethodref("java.lang.Byte", "<init>", "(B)V");
            il.append((Instruction)new ISTORE(4));
            il.append((Instruction)new NEW(x));
            il.append((Instruction)new ASTORE(5));
            il.append((Instruction)new ALOAD(5));
            il.append((Instruction)new ILOAD(4));
            il.append((Instruction)new INVOKESPECIAL(constrIndex));
            il.append((Instruction)new ALOAD(5));
        }
        return il;
    }

    protected static MethodEntry[] getOperations(MBeanInfo info) {
        HashMap<String, MethodEntry> operationMap = new HashMap<String, MethodEntry>();
        ArrayList<String> overloadList = new ArrayList<String>();
        MBeanOperationInfo[] operations = info.getOperations();
        for (int i = 0; i < operations.length; ++i) {
            String methodName = operations[i].getName();
            if (operationMap.containsKey(methodName)) {
                overloadList.add(methodName);
                continue;
            }
            operationMap.put(methodName, new MethodEntry(operations[i]));
        }
        Iterator it = overloadList.iterator();
        while (it.hasNext()) {
            operationMap.remove(it.next());
        }
        return operationMap.values().toArray(new MethodEntry[0]);
    }

    private static class MethodEntry
    extends MBeanOperationInfo {
        private static final long serialVersionUID = 1792631947840418314L;
        String methodDescriptor = null;
        int nameIndexInCP = -1;
        int methodIndexInCP = -1;

        public MethodEntry(MBeanOperationInfo info) {
            super(info.getName(), info.getDescription(), info.getSignature(), info.getReturnType(), info.getImpact());
            this.methodDescriptor = OptimizedMBeanDispatcher.getMethodDescriptor(info.getSignature(), info.getReturnType());
        }
    }
}

