/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import javax.management.Attribute;
import javax.management.Descriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.modelmbean.ModelMBeanInvoker;
import org.jboss.mx.server.Invocation;
import org.jboss.util.UnreachableStatementException;

public class ModelMBeanAttributeInterceptor
extends AbstractInterceptor
implements ModelMBeanConstants {
    private static final Logger log = Logger.getLogger((Class)ModelMBeanAttributeInterceptor.class);
    private boolean trace = log.isTraceEnabled();

    public ModelMBeanAttributeInterceptor() {
        super("ModelMBean Attribute Interceptor");
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Descriptor d = invocation.getDescriptor();
        Class clazz = invocation.getAttributeTypeClass();
        String name = null;
        ObjectName objectName = null;
        if (this.trace) {
            name = (String)d.getFieldValue("name");
            objectName = invocation.getInvoker().getObjectName();
        }
        if (invocation.getType().equals("setAttribute")) {
            String timeLimit;
            Object value = invocation.getArgs()[0];
            if (this.trace) {
                log.trace((Object)("Setting objectName=" + objectName + " attr=" + name + " value=" + value));
            }
            this.checkAssignable("Set attribute ", clazz, value);
            Object oldValue = d.getFieldValue("attributeValue");
            if (this.trace) {
                log.trace((Object)("Setting objectName=" + objectName + " attr=" + name + " oldValue=" + value));
            }
            String setMethod = (String)d.getFieldValue("setMethod");
            if (this.trace) {
                log.trace((Object)("Setting objectName=" + objectName + " attr=" + name + " setMethod=" + setMethod));
            }
            if (setMethod != null) {
                invocation.invoke();
            }
            long limit = (timeLimit = (String)d.getFieldValue("currencyTimeLimit")) == null ? -1L : Long.parseLong(timeLimit);
            String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
            if (limit != -1L) {
                if (this.trace) {
                    log.trace((Object)("Setting objectName=" + objectName + " attr=" + name + " value=" + value + " timestamp=" + timestamp));
                }
                d.setField("value", value);
                d.setField("lastUpdatedTimeStamp", timestamp);
            }
            d.setField("attributeValue", value);
            d.setField("lastUpdatedTimeStamp2", timestamp);
            ModelMBeanInvoker invoker = (ModelMBeanInvoker)invocation.getInvoker();
            invoker.sendAttributeChangeNotification(new Attribute(invocation.getName(), oldValue), new Attribute(invocation.getName(), value));
            return null;
        }
        if (invocation.getType().equals("getAttribute")) {
            String timeStamp;
            String timeLimit;
            long limit;
            if (this.trace) {
                log.trace((Object)("Getting objectName=" + objectName + " attr=" + name));
            }
            long l = limit = (timeLimit = (String)d.getFieldValue("currencyTimeLimit")) == null ? -1L : Long.parseLong(timeLimit);
            if (limit == 0L && (timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp")) != null) {
                Object value = d.getFieldValue("value");
                if (this.trace) {
                    log.trace((Object)("Always cache objectName=" + objectName + " attr=" + name + " value=" + value));
                }
                this.checkAssignable("Cached value in descriptor ", clazz, value);
                return value;
            }
            if (limit != -1L) {
                long expires;
                timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp");
                long lastUpdate = timeStamp == null ? 0L : Long.parseLong(timeStamp);
                long now = System.currentTimeMillis();
                if (now < (expires = lastUpdate * 1000L + limit * 1000L)) {
                    Object value = d.getFieldValue("value");
                    if (this.trace) {
                        log.trace((Object)("Using cache objectName=" + objectName + " attr=" + name + " value=" + value + " now=" + now + " expires=" + expires));
                    }
                    this.checkAssignable("Cached value in descriptor ", clazz, value);
                    return value;
                }
                if (this.trace) {
                    log.trace((Object)("Cache expired objectName=" + objectName + " attr=" + name + " now=" + now + " expires=" + expires));
                }
                d.removeField("value");
            } else {
                if (this.trace) {
                    log.trace((Object)("Removing any cached value objectName=" + objectName + " attr=" + name + " descriptor=" + d));
                }
                d.removeField("value");
            }
            String getMethod = (String)d.getFieldValue("getMethod");
            if (this.trace) {
                log.trace((Object)("Get attribute objectName=" + objectName + " attr=" + name + " getMethod=" + getMethod));
            }
            if (getMethod != null) {
                Object value = invocation.invoke();
                if (this.trace) {
                    log.trace((Object)("Got attribute objectName=" + objectName + " attr=" + name + " value=" + value));
                }
                if (limit != -1L) {
                    String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
                    if (this.trace) {
                        log.trace((Object)("Cache attribute objectName=" + objectName + " attr=" + name + " value=" + value + " timestamp=" + timestamp));
                    }
                    d.setField("value", value);
                    d.setField("lastUpdatedTimeStamp", timestamp);
                }
                return value;
            }
            Object value = d.getFieldValue("default");
            if (this.trace) {
                log.trace((Object)("Get attribute use default objectName=" + objectName + " attr=" + name + " default=" + value));
            }
            this.checkAssignable("Default value ", clazz, value);
            return value;
        }
        throw new UnreachableStatementException(invocation.getType());
    }

    protected void checkAssignable(String context, Class clazz, Object value) throws InvalidAttributeValueException, ClassNotFoundException {
        if (value != null && !clazz.isAssignableFrom(value.getClass())) {
            throw new InvalidAttributeValueException(context + " has class " + value.getClass() + " loaded from " + value.getClass().getClassLoader() + " that is not assignable to attribute class " + clazz + " loaded from " + clazz.getClassLoader());
        }
    }
}

