/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.loading.UnifiedClassLoaderMBean;
import org.jboss.util.loading.Translatable;

public class UnifiedClassLoader
extends RepositoryClassLoader
implements UnifiedClassLoaderMBean,
Translatable {
    private static final Logger log = Logger.getLogger((Class)UnifiedClassLoader.class);
    protected URL url;
    protected URL origURL;

    public UnifiedClassLoader(URL url) {
        this(url, (URL)null);
    }

    public UnifiedClassLoader(URL url, URL origURL) {
        this(url, origURL, UnifiedClassLoader.class.getClassLoader());
    }

    public UnifiedClassLoader(URL url, URL origURL, ClassLoader parent) {
        URL[] uRLArray;
        if (url == null) {
            uRLArray = new URL[]{};
        } else {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = url;
        }
        super(uRLArray, parent);
        this.url = null;
        this.origURL = null;
        log.debug((Object)("New jmx UCL with url " + url));
        this.url = url;
        this.origURL = origURL;
    }

    public UnifiedClassLoader(URL url, LoaderRepository repository) {
        this(url, null, repository);
    }

    public UnifiedClassLoader(URL url, URL origURL, LoaderRepository repository) {
        this(url, origURL);
        this.setRepository(repository);
        repository.addClassLoader(this);
    }

    public UnifiedClassLoader(URL url, MBeanServer server, ObjectName repositoryName) throws Exception {
        this(url, null, server, repositoryName);
    }

    public UnifiedClassLoader(URL url, URL origURL, MBeanServer server, ObjectName repositoryName) throws Exception {
        this(url, origURL);
        LoaderRepository rep = (LoaderRepository)server.invoke(repositoryName, "registerClassLoader", new Object[]{this}, new String[]{this.getClass().getName()});
        this.setRepository(rep);
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        String name = "jmx.loading:UCL=" + Integer.toHexString(super.hashCode());
        return new ObjectName(name);
    }

    public void unregister() {
        super.unregister();
        this.origURL = null;
        this.url = null;
    }

    public URL getURL() {
        return this.url;
    }

    public URL getOrigURL() {
        return this.origURL;
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        CodeSource permCS = cs;
        if (this.origURL != null) {
            permCS = new CodeSource(this.origURL, cs.getCertificates());
        }
        Policy policy = Policy.getPolicy();
        PermissionCollection perms = super.getPermissions(permCS);
        PermissionCollection perms2 = super.getPermissions(cs);
        PermissionCollection perms3 = policy.getPermissions(permCS);
        Enumeration<Permission> iter = perms2.elements();
        while (iter.hasMoreElements()) {
            perms.add(iter.nextElement());
        }
        iter = perms3.elements();
        while (iter.hasMoreElements()) {
            perms.add(iter.nextElement());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("getPermissions, url=" + this.url + ", origURL=" + this.origURL + " -> " + perms));
        }
        return perms;
    }

    protected ProtectionDomain getProtectionDomain() {
        return this.getProtectionDomain(this.origURL != null ? this.origURL : this.url);
    }
}

