/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.core.util.PropertiesReader;
import org.unitils.util.PropertyUtils;

public class ConfigurationLoader {
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "unitils-default.properties";
    public static final String PROPKEY_CUSTOM_CONFIGURATION = "unitils.configuration.customFileName";
    public static final String PROPKEY_LOCAL_CONFIGURATION = "unitils.configuration.localFileName";
    private static Log logger = LogFactory.getLog(ConfigurationLoader.class);
    private PropertiesReader propertiesReader = new PropertiesReader();

    public Properties loadConfiguration() {
        Properties properties = new Properties();
        this.loadDefaultConfiguration(properties);
        this.loadCustomConfiguration(properties);
        this.loadLocalConfiguration(properties);
        this.loadSystemProperties(properties);
        this.expandPropertyValues(properties);
        return properties;
    }

    protected void loadDefaultConfiguration(Properties properties) {
        Properties defaultProperties = this.propertiesReader.loadPropertiesFileFromClasspath(DEFAULT_PROPERTIES_FILE_NAME);
        if (defaultProperties == null) {
            throw new UnitilsException("Configuration file: unitils-default.properties not found in classpath.");
        }
        properties.putAll((Map<?, ?>)defaultProperties);
    }

    protected void loadCustomConfiguration(Properties properties) {
        String customConfigurationFileName = this.getConfigurationFileName(PROPKEY_CUSTOM_CONFIGURATION, properties);
        Properties customProperties = this.propertiesReader.loadPropertiesFileFromClasspath(customConfigurationFileName);
        if (customProperties == null) {
            logger.warn((Object)("No custom configuration file " + customConfigurationFileName + " found."));
        } else {
            properties.putAll((Map<?, ?>)customProperties);
        }
    }

    protected void loadLocalConfiguration(Properties properties) {
        String localConfigurationFileName = this.getConfigurationFileName(PROPKEY_LOCAL_CONFIGURATION, properties);
        Properties localProperties = this.propertiesReader.loadPropertiesFileFromUserHome(localConfigurationFileName);
        if (localProperties == null) {
            localProperties = this.propertiesReader.loadPropertiesFileFromClasspath(localConfigurationFileName);
        }
        if (localProperties == null) {
            logger.info((Object)("No local configuration file " + localConfigurationFileName + " found."));
        } else {
            properties.putAll((Map<?, ?>)localProperties);
        }
    }

    protected void loadSystemProperties(Properties properties) {
        properties.putAll((Map<?, ?>)System.getProperties());
    }

    protected void expandPropertyValues(Properties properties) {
        for (Object key : properties.keySet()) {
            Object value = properties.get(key);
            try {
                String expandedValue = StrSubstitutor.replace((Object)value, (Map)properties);
                properties.put(key, expandedValue);
            }
            catch (Exception e) {
                throw new UnitilsException("Unable to load unitils configuration. Could not expand property value for key: " + key + ", value " + value, e);
            }
        }
    }

    protected String getConfigurationFileName(String propertyName, Properties properties) {
        String configurationFileName = System.getProperty(propertyName);
        if (configurationFileName != null) {
            return configurationFileName;
        }
        return PropertyUtils.getString(propertyName, properties);
    }
}

