/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.dbsupport;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.thirdparty.org.apache.commons.dbutils.DbUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDbSupport
extends DbSupport {
    private Integer oracleMajorVersionNumber;

    public OracleDbSupport() {
        super("oracle");
    }

    @Override
    public Set<String> getTableNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TABLE_NAME from ALL_TABLES where OWNER = '" + this.getSchemaName() + "' and TABLE_NAME not like 'BIN$%' minus select MVIEW_NAME from ALL_MVIEWS where OWNER = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLUMN_NAME from ALL_TAB_COLUMNS where TABLE_NAME = '" + tableName + "' and OWNER = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getViewNames() {
        return this.getSQLHandler().getItemsAsStringSet("select VIEW_NAME from ALL_VIEWS where OWNER = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getMaterializedViewNames() {
        return this.getSQLHandler().getItemsAsStringSet("select MVIEW_NAME from ALL_MVIEWS where OWNER = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getSynonymNames() {
        return this.getSQLHandler().getItemsAsStringSet("select SYNONYM_NAME from ALL_SYNONYMS where OWNER = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getSequenceNames() {
        return this.getSQLHandler().getItemsAsStringSet("select SEQUENCE_NAME from ALL_SEQUENCES where SEQUENCE_OWNER = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getTriggerNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TRIGGER_NAME from ALL_TRIGGERS where OWNER = '" + this.getSchemaName() + "' and TRIGGER_NAME not like 'BIN$%'");
    }

    @Override
    public Set<String> getTypeNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TYPE_NAME from ALL_TYPES where OWNER = '" + this.getSchemaName() + "'");
    }

    @Override
    public void dropTable(String tableName) {
        this.getSQLHandler().executeUpdate("drop table " + this.qualified(tableName) + " cascade constraints" + (this.supportsPurge() ? " purge" : ""));
    }

    @Override
    public void dropView(String viewName) {
        this.getSQLHandler().executeUpdate("drop view " + this.qualified(viewName) + " cascade constraints");
    }

    @Override
    public void dropMaterializedView(String materializedViewName) {
        this.getSQLHandler().executeUpdate("drop materialized view " + this.qualified(materializedViewName));
    }

    @Override
    public void dropType(String typeName) {
        this.getSQLHandler().executeUpdate("drop type " + this.qualified(typeName) + " force");
    }

    @Override
    public void disableReferentialConstraints() {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select TABLE_NAME, CONSTRAINT_NAME from ALL_CONSTRAINTS where CONSTRAINT_TYPE = 'R' and OWNER = '" + this.getSchemaName() + "' and CONSTRAINT_NAME not like 'BIN$%' and STATUS <> 'DISABLED'");
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                String constraintName = resultSet.getString("CONSTRAINT_NAME");
                alterStatement.executeUpdate("alter table " + this.qualified(tableName) + " disable constraint " + this.quoted(constraintName));
            }
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error while disabling referential constraints on schema " + this.getSchemaName(), e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    @Override
    public void disableValueConstraints() {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select TABLE_NAME, CONSTRAINT_NAME from ALL_CONSTRAINTS where CONSTRAINT_TYPE in ('U', 'C', 'V') and OWNER = '" + this.getSchemaName() + "' and CONSTRAINT_NAME not like 'BIN$%' and STATUS <> 'DISABLED'");
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                String constraintName = resultSet.getString("CONSTRAINT_NAME");
                alterStatement.executeUpdate("alter table " + this.qualified(tableName) + " disable constraint " + this.quoted(constraintName));
            }
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error while disabling value constraints on schema " + this.getSchemaName(), e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    @Override
    public long getSequenceValue(String sequenceName) {
        return this.getSQLHandler().getItemAsLong("select LAST_NUMBER from ALL_SEQUENCES where SEQUENCE_NAME = '" + sequenceName + "' and SEQUENCE_OWNER = '" + this.getSchemaName() + "'");
    }

    @Override
    public void incrementSequenceToValue(String sequenceName, long newSequenceValue) {
        Connection connection = null;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select LAST_NUMBER, INCREMENT_BY from ALL_SEQUENCES where SEQUENCE_NAME = '" + sequenceName + "' and SEQUENCE_OWNER = '" + this.getSchemaName() + "'");
            while (resultSet.next()) {
                long lastNumber = resultSet.getLong("LAST_NUMBER");
                long incrementBy = resultSet.getLong("INCREMENT_BY");
                this.getSQLHandler().executeUpdate("alter sequence " + this.qualified(sequenceName) + " increment by " + (newSequenceValue - lastNumber));
                this.getSQLHandler().executeQuery("select " + this.qualified(sequenceName) + ".NEXTVAL from DUAL");
                this.getSQLHandler().executeUpdate("alter sequence " + this.qualified(sequenceName) + " increment by " + incrementBy);
            }
        }
        catch (SQLException e) {
            try {
                throw new UnitilsException("Error while incrementing sequence to value", e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
    }

    @Override
    public String getLongDataType() {
        return "INTEGER";
    }

    @Override
    public String getTextDataType(int length) {
        return "VARCHAR2(" + length + ")";
    }

    @Override
    public boolean supportsSynonyms() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsTypes() {
        return true;
    }

    @Override
    public boolean supportsMaterializedViews() {
        return true;
    }

    @Override
    public boolean supportsCascade() {
        return true;
    }

    protected boolean supportsPurge() {
        return this.getOracleMajorVersionNumber() >= 10;
    }

    protected Integer getOracleMajorVersionNumber() {
        if (this.oracleMajorVersionNumber == null) {
            Connection connection = null;
            try {
                connection = this.getSQLHandler().getDataSource().getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                this.oracleMajorVersionNumber = metaData.getDatabaseMajorVersion();
            }
            catch (SQLException e) {
                try {
                    throw new UnitilsException("Unable to determine database major version", e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(connection);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly(connection);
        }
        return this.oracleMajorVersionNumber;
    }
}

