/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image;

import java.io.IOException;
import java.io.OutputStream;

public class BitWriter {
    private int bitCount;
    private int pointer;
    private final OutputStream stream;

    public BitWriter(OutputStream outputStream) {
        this.stream = outputStream;
    }

    public void end() {
        while (this.bitCount > 0) {
            this.writeBit(0);
        }
    }

    public void writeBit(int n) {
        this.pointer = this.pointer << 1 | n;
        ++this.bitCount;
        if (this.bitCount == 8) {
            try {
                this.stream.write(this.pointer);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.pointer = 0;
            this.bitCount = 0;
        }
    }

    public void writeBits(int n, int n2) {
        if (n2 < 0 || n2 > 32) {
            throw new IllegalArgumentException("Number of bits is out of range");
        }
        while (n2 > 0) {
            int n3 = Math.min(n2, 8 - this.bitCount);
            this.pointer = this.pointer << n3 | n >>> n2 - n3 & (1 << n3) - 1;
            this.bitCount += n3;
            n2 -= n3;
            if (this.bitCount != 8) continue;
            try {
                this.stream.write(this.pointer);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.pointer = 0;
            this.bitCount = 0;
        }
    }

    public void writeByte(byte by) {
        if (this.bitCount == 0) {
            try {
                this.stream.write(by);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            this.writeBits(by, 8);
        }
    }

    public void writeBytes(byte[] byArray) {
        if (this.bitCount == 0) {
            try {
                this.stream.write(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            for (byte by : byArray) {
                this.writeByte(by);
            }
        }
    }
}

