/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.LUT;

public class EntropyDecoder {
    private final byte[] stream;
    private final int maxLen;
    private final int dataEnd;
    private int bp;
    private int ch;
    private int cl;
    private int ct;
    private int a;

    public EntropyDecoder(byte[] byArray, int n, int n2) {
        this.stream = byArray;
        this.maxLen = byArray.length;
        this.bp = n;
        this.dataEnd = n2;
        this.ch = byArray[n] & 0xFF;
        this.cl = 0;
        this.byteIn();
        this.ch = this.ch << 7 & 0xFFFF | this.cl >> 9 & 0x7F;
        this.cl = this.cl << 7 & 0xFFFF;
        this.ct -= 7;
        this.a = 32768;
    }

    private void byteIn() {
        if (this.bp < this.maxLen && (this.stream[this.bp] & 0xFF) == 255) {
            int n = this.stream[this.bp + 1] & 0xFF;
            if (n > 143) {
                this.cl += 65280;
                this.ct = 8;
            } else {
                ++this.bp;
                this.cl += (this.stream[this.bp] & 0xFF) << 9;
                this.ct = 7;
            }
        } else {
            ++this.bp;
            this.cl += this.bp < this.dataEnd ? (this.stream[this.bp] & 0xFF) << 8 : 65280;
            this.ct = 8;
        }
        if (this.cl > 65535) {
            this.ch += this.cl >> 16;
            this.cl &= 0xFFFF;
        }
    }

    public int decodeBit(byte[] byArray, int n) {
        int n2;
        int n3 = byArray[n] >> 1;
        int n4 = byArray[n] & 1;
        int n5 = LUT.QE[n3];
        this.a -= n5;
        if (this.ch < n5) {
            if (this.a < n5) {
                this.a = n5;
                n2 = n4;
                n3 = LUT.NMPS[n3];
            } else {
                this.a = n5;
                n2 = 1 ^ n4;
                if (LUT.SWITCHML[n3] == 1) {
                    n4 = n2;
                }
                n3 = LUT.NLPS[n3];
            }
        } else {
            this.ch -= n5;
            if ((this.a & 0x8000) != 0) {
                return n4;
            }
            if (this.a < n5) {
                n2 = 1 ^ n4;
                if (LUT.SWITCHML[n3] == 1) {
                    n4 = n2;
                }
                n3 = LUT.NLPS[n3];
            } else {
                n2 = n4;
                n3 = LUT.NMPS[n3];
            }
        }
        do {
            if (this.ct == 0) {
                this.byteIn();
            }
            this.a <<= 1;
            this.ch = this.ch << 1 & 0xFFFF | this.cl >> 15 & 1;
            this.cl = this.cl << 1 & 0xFFFF;
            --this.ct;
        } while ((this.a & 0x8000) == 0);
        byArray[n] = (byte)(n3 << 1 | n4);
        return n2;
    }
}

