/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.TreeNode;

public class IncQuadTree {
    private final TreeNode[] nodeList;
    private int currentLevel;

    public IncQuadTree(int n, int n2, int n3) {
        int n4 = Math.max(n, n2);
        int n5 = 1;
        int n6 = 0;
        while (n4 > n5) {
            n5 <<= 1;
            ++n6;
        }
        int n7 = n6 + 1;
        this.nodeList = new TreeNode[n7];
        for (int i = 0; i < n7; ++i) {
            TreeNode treeNode = new TreeNode(n, n2);
            int n8 = n * n2;
            for (int j = 0; j < n8; ++j) {
                treeNode.items[j] = n3;
            }
            this.nodeList[i] = treeNode;
            n = n + 1 >> 1;
            n2 = n2 + 1 >> 1;
        }
    }

    public boolean reset(int n, int n2, int n3) {
        int n4;
        int n5 = this.nodeList.length;
        for (n4 = 0; n4 < n5; ++n4) {
            int n6;
            TreeNode treeNode = this.nodeList[n4];
            treeNode.index = n6 = n + n2 * treeNode.width;
            int n7 = treeNode.items[n6];
            if (n7 == 255) break;
            if (n7 > n3) {
                this.currentLevel = n4;
                this.updateValues();
                return false;
            }
            n >>= 1;
            n2 >>= 1;
        }
        this.currentLevel = n4 - 1;
        return true;
    }

    public void incrementValue(int n) {
        TreeNode treeNode = this.nodeList[this.currentLevel];
        treeNode.items[treeNode.index] = n + 1;
        this.updateValues();
    }

    private void updateValues() {
        int n = this.currentLevel;
        TreeNode treeNode = this.nodeList[n];
        int n2 = treeNode.items[treeNode.index];
        while (--n >= 0) {
            treeNode = this.nodeList[n];
            treeNode.items[treeNode.index] = n2;
        }
    }

    public boolean nextNode() {
        int n = this.currentLevel;
        TreeNode treeNode = this.nodeList[n];
        int n2 = treeNode.items[treeNode.index];
        treeNode.items[treeNode.index] = 255;
        if (--n < 0) {
            return false;
        }
        this.currentLevel = n;
        treeNode = this.nodeList[n];
        treeNode.items[treeNode.index] = n2;
        return true;
    }
}

