/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JPXBitWriter {
    private byte buffer;
    private int bitCount;
    private final OutputStream stream;

    public JPXBitWriter(OutputStream outputStream) {
        this.stream = outputStream;
    }

    public void writeUShort(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 8), (byte)n};
        for (int i = 0; i < byArray.length; ++i) {
            this.writeByte(byArray[i]);
        }
    }

    public void writeUInt(long l) {
        byte[] byArray = new byte[]{(byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        for (int i = 0; i < byArray.length; ++i) {
            this.writeByte(byArray[i]);
        }
    }

    public void writeBit(int n) {
        this.buffer = (byte)(this.buffer << 1);
        this.buffer = (byte)(this.buffer | n & 1);
        ++this.bitCount;
        if (this.bitCount == 8) {
            this.bitCount = 0;
            try {
                this.stream.write(this.buffer);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void writeByte(byte by) {
        if (this.bitCount == 0) {
            try {
                this.stream.write(by);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            for (int i = 7; i >= 0; --i) {
                this.writeBit(by >> i & 1);
            }
        }
    }

    public void end() {
        if (this.bitCount > 0) {
            byte by = this.buffer = (byte)(this.buffer << 8 - this.bitCount);
            try {
                this.stream.write(by);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.bitCount = 0;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JPXBitWriter jPXBitWriter = new JPXBitWriter(byteArrayOutputStream);
        jPXBitWriter.writeUInt(Integer.MAX_VALUE);
        jPXBitWriter.end();
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        System.out.println("done");
    }
}

