/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.BlockData;
import com.idrsolutions.image.jpeg2000.COD;
import com.idrsolutions.image.jpeg2000.Cmap;
import com.idrsolutions.image.jpeg2000.CodeBlock;
import com.idrsolutions.image.jpeg2000.CodeBlockInfo;
import com.idrsolutions.image.jpeg2000.EntropyDecoder;
import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import com.idrsolutions.image.jpeg2000.Info;
import com.idrsolutions.image.jpeg2000.JPXBitReader;
import com.idrsolutions.image.jpeg2000.JPXReader;
import com.idrsolutions.image.jpeg2000.LRCP;
import com.idrsolutions.image.jpeg2000.Palette;
import com.idrsolutions.image.jpeg2000.Precinct;
import com.idrsolutions.image.jpeg2000.PrecinctInfo;
import com.idrsolutions.image.jpeg2000.QCD;
import com.idrsolutions.image.jpeg2000.RLCP;
import com.idrsolutions.image.jpeg2000.SIZ;
import com.idrsolutions.image.jpeg2000.SubbandCoefficient;
import com.idrsolutions.image.jpeg2000.Tier1Decoder;
import com.idrsolutions.image.jpeg2000.Tile;
import com.idrsolutions.image.jpeg2000.TileBand;
import com.idrsolutions.image.jpeg2000.TileComponent;
import com.idrsolutions.image.jpeg2000.TileParser;
import com.idrsolutions.image.jpeg2000.TileResolution;
import com.idrsolutions.image.jpeg2000.Trns;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;

public class Jpeg2000Decoder {
    private static final boolean debug = false;

    public BufferedImage read(byte[] byArray) throws Exception {
        Info info = new Info();
        JPXReader jPXReader = new JPXReader(byArray);
        if (65359 == ((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF)) {
            Jpeg2000Decoder.readCodeStream(info, jPXReader, byArray.length);
        } else {
            Jpeg2000Decoder.decodeMain(info, jPXReader);
            Jpeg2000Decoder.decodeContiguousCodeStreamBoxes(info, jPXReader);
        }
        Jpeg2000Decoder.generateTileMap(info);
        Jpeg2000Decoder.decodeTileOffsets(info, jPXReader);
        if (info.palette != null && info.siz.nComp == 1) {
            return Jpeg2000Decoder.convertPalette(info);
        }
        if (info.enumerateCS == 12) {
            return Jpeg2000Decoder.convertCMYKTileToRGB(info, true);
        }
        return Jpeg2000Decoder.convertTileComponentsToBuffered(info);
    }

    private static void decodeMain(Info info, JPXReader jPXReader) {
        long l;
        int n = jPXReader.readInt();
        int n2 = jPXReader.readInt();
        if (n != 12 && n2 != 1783636000) {
            throw new RuntimeException("Jpeg2000 Error: Not a valid jp2 file ");
        }
        jPXReader.readInt();
        long l2 = jPXReader.readInt();
        int n3 = jPXReader.readInt();
        if (n3 != 1718909296) {
            throw new RuntimeException("Jpeg2000 Error: Not a valid filetype declared in file ");
        }
        boolean bl = false;
        if (l2 == 1L) {
            l2 = jPXReader.readLong();
            l = l2 - 16L;
        } else {
            l = l2 - 8L;
        }
        long l3 = l / 4L;
        int n4 = 0;
        while ((long)n4 < l3) {
            if (jPXReader.readInt() == 1785737760) {
                bl = true;
            }
            ++n4;
        }
        if (!bl) {
            throw new RuntimeException("Jpeg2000 Error: Not a valid JP2 Branded File");
        }
        n4 = 1;
        block17: while (jPXReader.getRemaining() > 0 && n4 != 0) {
            int n5 = jPXReader.getPosition();
            long l4 = jPXReader.readInt();
            int n6 = jPXReader.readInt();
            if (l4 == 1L) {
                l4 = jPXReader.readLong();
            } else if (l4 == 0L) {
                n4 = 0;
            }
            switch (n6) {
                case 1785737832: {
                    long l5 = jPXReader.readInt();
                    int n7 = jPXReader.readInt();
                    if (l5 == 1L) {
                        l5 = jPXReader.readLong();
                    }
                    info.imageHeight = jPXReader.readInt();
                    info.imageWidth = jPXReader.readInt();
                    info.nComp = jPXReader.readUShort();
                    info.bitDepth = jPXReader.readUByte();
                    info.compressionType = jPXReader.readUByte();
                    info.unknownColorSpace = jPXReader.readUByte();
                    info.ip = jPXReader.readUByte();
                    long l6 = (long)n5 + l4;
                    block18: while ((long)jPXReader.getPosition() < l6) {
                        int n8 = jPXReader.getPosition();
                        l5 = jPXReader.readInt();
                        n7 = jPXReader.readInt();
                        if (l5 == 1L) {
                            jPXReader.readLong();
                        }
                        switch (n7) {
                            case 1651532643: {
                                int n9;
                                info.bitDepths = new byte[info.nComp];
                                for (n9 = 0; n9 < info.bitDepths.length; ++n9) {
                                    info.bitDepths[n9] = jPXReader.readByte();
                                }
                                continue block18;
                            }
                            case 1668246642: {
                                int n9 = jPXReader.readUByte();
                                jPXReader.readByte();
                                jPXReader.readUByte();
                                if (n9 == 1) {
                                    info.enumerateCS = jPXReader.readInt();
                                } else if (n9 == 2) {
                                    jPXReader.readInt();
                                }
                                jPXReader.setPosition((int)((long)n8 + l5));
                                break;
                            }
                            case 1885564018: {
                                int n10;
                                Palette palette = new Palette();
                                palette.nEntries = jPXReader.readUShort();
                                palette.nColumns = jPXReader.readUByte();
                                palette.bitDepts = new int[palette.nColumns];
                                for (n10 = 0; n10 < palette.nColumns; ++n10) {
                                    palette.bitDepts[n10] = jPXReader.readUByte();
                                }
                                palette.cValues = new int[palette.nEntries][palette.nColumns];
                                for (n10 = 0; n10 < palette.nEntries; ++n10) {
                                    for (int i = 0; i < palette.nColumns; ++i) {
                                        palette.cValues[n10][i] = jPXReader.readUByte();
                                    }
                                }
                                info.palette = palette;
                                jPXReader.setPosition((int)((long)n8 + l5));
                                break;
                            }
                            case 1668112752: {
                                int n11;
                                int n10 = (int)(l5 - (long)(jPXReader.getPosition() - n8));
                                Cmap cmap = new Cmap();
                                cmap.cmp = new int[n10 /= 4];
                                cmap.mtyp = new int[n10];
                                cmap.pcol = new int[n10];
                                for (n11 = 0; n11 < n10; ++n11) {
                                    cmap.cmp[n11] = jPXReader.readUShort();
                                    cmap.mtyp[n11] = jPXReader.readUByte();
                                    cmap.pcol[n11] = jPXReader.readUByte();
                                }
                                info.cmap = cmap;
                                jPXReader.setPosition((int)((long)n8 + l5));
                                break;
                            }
                            case 1667523942: {
                                int n11 = jPXReader.readShort();
                                for (int i = 0; i < n11; ++i) {
                                    short s = jPXReader.readShort();
                                    short s2 = jPXReader.readShort();
                                    short s3 = jPXReader.readShort();
                                    if (s2 != 0) continue;
                                    info.cDef.put(Integer.valueOf(s), Integer.valueOf(s3));
                                }
                                jPXReader.setPosition((int)((long)n8 + l5));
                                break;
                            }
                            case 1919251232: {
                                jPXReader.setPosition((int)((long)n8 + l5));
                                break;
                            }
                            default: {
                                jPXReader.setPosition((int)((long)n8 + l5));
                            }
                        }
                    }
                    jPXReader.setPosition((int)l6);
                    continue block17;
                }
                case 1785737827: {
                    info.contiguousCodeStreamBoxes.add(n5);
                    jPXReader.setPosition((int)((long)n5 + l4));
                    continue block17;
                }
                case 1685074537: {
                    jPXReader.setPosition((int)((long)n5 + l4));
                    continue block17;
                }
                case 2020437024: {
                    jPXReader.setPosition((int)((long)n5 + l4));
                    continue block17;
                }
                case 1970628964: {
                    jPXReader.setPosition((int)((long)n5 + l4));
                    continue block17;
                }
                case 1969843814: {
                    jPXReader.setPosition((int)((long)n5 + l4));
                    continue block17;
                }
            }
            jPXReader.setPosition((int)((long)n5 + l4));
        }
    }

    private static void generateTileMap(Info info) {
        SIZ sIZ = info.siz;
        int n = (int)Math.ceil(1.0 * (double)(sIZ.Xsiz - sIZ.XTOsiz) / (double)sIZ.XTsiz);
        int n2 = (int)Math.ceil(1.0 * (double)(sIZ.Ysiz - sIZ.YTOsiz) / (double)sIZ.YTsiz);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Tile tile = new Tile();
                tile.tx0 = Math.max(sIZ.XTOsiz + j * sIZ.XTsiz, sIZ.XOsiz);
                tile.ty0 = Math.max(sIZ.YTOsiz + i * sIZ.YTsiz, sIZ.YOsiz);
                tile.tx1 = Math.min(sIZ.XTOsiz + (j + 1) * sIZ.XTsiz, sIZ.Xsiz);
                tile.ty1 = Math.min(sIZ.YTOsiz + (i + 1) * sIZ.YTsiz, sIZ.Ysiz);
                for (int k = 0; k < sIZ.nComp; ++k) {
                    int n4 = sIZ.precisionInfo[k][1];
                    int n5 = sIZ.precisionInfo[k][2];
                    TileComponent tileComponent = new TileComponent();
                    tileComponent.x0 = (int)Math.ceil(1.0 * (double)tile.tx0 / (double)n4);
                    tileComponent.x1 = (int)Math.ceil(1.0 * (double)tile.tx1 / (double)n4);
                    tileComponent.y0 = (int)Math.ceil(1.0 * (double)tile.ty0 / (double)n5);
                    tileComponent.y1 = (int)Math.ceil(1.0 * (double)tile.ty1 / (double)n5);
                    tile.components.add(tileComponent);
                }
                info.tilesMap.put(n3, tile);
                ++n3;
            }
        }
    }

    private static void decodeContiguousCodeStreamBoxes(Info info, JPXReader jPXReader) {
        for (int n : info.contiguousCodeStreamBoxes) {
            jPXReader.setPosition(n);
            long l = jPXReader.readInt();
            jPXReader.readInt();
            if (l == 1L) {
                l = jPXReader.readLong();
            } else if (l == 0L) {
                l = jPXReader.getLimit() - n;
            }
            long l2 = (long)n + l;
            Jpeg2000Decoder.readCodeStream(info, jPXReader, l2);
        }
    }

    private static void readCodeStream(Info info, JPXReader jPXReader, long l) {
        block27: while ((long)jPXReader.getPosition() < l) {
            int n = jPXReader.readUShort();
            switch (n) {
                case 65359: {
                    continue block27;
                }
                case 65361: {
                    jPXReader.readUShort();
                    SIZ sIZ = new SIZ();
                    sIZ.capabilities = jPXReader.readUShort();
                    sIZ.Xsiz = jPXReader.readInt();
                    sIZ.Ysiz = jPXReader.readInt();
                    sIZ.XOsiz = jPXReader.readInt();
                    sIZ.YOsiz = jPXReader.readInt();
                    sIZ.XTsiz = jPXReader.readInt();
                    sIZ.YTsiz = jPXReader.readInt();
                    sIZ.XTOsiz = jPXReader.readInt();
                    sIZ.YTOsiz = jPXReader.readInt();
                    sIZ.nComp = jPXReader.readUShort();
                    sIZ.precisionInfo = new int[sIZ.nComp][3];
                    for (int i = 0; i < sIZ.nComp; ++i) {
                        sIZ.precisionInfo[i][0] = jPXReader.readUByte();
                        sIZ.precisionInfo[i][1] = jPXReader.readUByte();
                        sIZ.precisionInfo[i][2] = jPXReader.readUByte();
                    }
                    info.siz = sIZ;
                    info.qcc = new QCD[info.siz.nComp];
                    continue block27;
                }
                case 65362: {
                    int n2;
                    jPXReader.readUShort();
                    COD cOD = new COD();
                    boolean[] blArray = Jpeg2000Decoder.toBoolean8(jPXReader.readByte());
                    cOD.hasPrecint = blArray[7];
                    cOD.hasSOP = blArray[6];
                    cOD.hasEPH = blArray[5];
                    cOD.progressionOrder = jPXReader.readUByte();
                    cOD.nLayers = jPXReader.readUShort();
                    cOD.multiCompTransform = jPXReader.readByte();
                    cOD.nDecompLevel = jPXReader.readUByte();
                    cOD.xcb = jPXReader.readUByte() + 2;
                    cOD.ycb = jPXReader.readUByte() + 2;
                    cOD.codeBlockStyle = jPXReader.readByte();
                    cOD.transformation = jPXReader.readUByte();
                    if (cOD.hasPrecint) {
                        cOD.precintSizes = new int[cOD.nDecompLevel + 1];
                        for (n2 = 0; n2 < cOD.precintSizes.length; ++n2) {
                            cOD.precintSizes[n2] = jPXReader.readByte();
                        }
                    }
                    info.cod = cOD;
                    continue block27;
                }
                case 65363: {
                    int n2 = jPXReader.readUShort();
                    jPXReader.setPosition(jPXReader.getPosition() + n2 - 2);
                    continue block27;
                }
                case 65372: {
                    Object object;
                    int n3;
                    int n4;
                    int n5 = jPXReader.readUShort();
                    QCD qCD = new QCD();
                    Byte by = jPXReader.readByte();
                    JPXBitReader jPXBitReader = new JPXBitReader(by);
                    qCD.guardBits = jPXBitReader.readBits(3);
                    qCD.quantBits = jPXBitReader.readBits(5);
                    qCD.hasScalar = false;
                    int n6 = n5 - 3;
                    int n7 = 0;
                    switch (qCD.quantBits) {
                        case 0: {
                            qCD.hasScalar = true;
                            n7 = n6;
                            qCD.exponentB = new int[n7];
                            qCD.mantissaB = new int[n7];
                            for (n4 = 0; n4 < n7; ++n4) {
                                jPXBitReader = new JPXBitReader(jPXReader.readByte());
                                qCD.exponentB[n4] = jPXBitReader.readBits(5);
                                qCD.mantissaB[n4] = 0;
                            }
                            break;
                        }
                        case 1: {
                            qCD.hasScalar = false;
                            byte[] byArray = new byte[]{jPXReader.readByte(), jPXReader.readByte()};
                            jPXBitReader = new JPXBitReader(byArray);
                            n3 = jPXBitReader.readBits(5);
                            int n8 = jPXBitReader.readBits(11);
                            qCD.exponentB = new int[]{n3};
                            qCD.mantissaB = new int[]{n8};
                            break;
                        }
                        case 2: {
                            n7 = n6 / 2;
                            qCD.hasScalar = true;
                            qCD.exponentB = new int[n7];
                            qCD.mantissaB = new int[n7];
                            for (int i = 0; i < n7; ++i) {
                                object = new byte[]{jPXReader.readByte(), jPXReader.readByte()};
                                jPXBitReader = new JPXBitReader((byte[])object);
                                qCD.exponentB[i] = jPXBitReader.readBits(5);
                                qCD.mantissaB[i] = jPXBitReader.readBits(11);
                            }
                            break;
                        }
                    }
                    info.qcd = qCD;
                    continue block27;
                }
                case 65373: {
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n4 = jPXReader.readUShort();
                    int n3 = jPXReader.readUByte();
                    QCD qCD = new QCD();
                    Byte by = jPXReader.readByte();
                    Object object = new JPXBitReader(by);
                    qCD.guardBits = ((JPXBitReader)object).readBits(3);
                    qCD.quantBits = ((JPXBitReader)object).readBits(5);
                    qCD.hasScalar = false;
                    int n13 = n4 - 4;
                    switch (qCD.quantBits) {
                        case 0: {
                            qCD.hasScalar = true;
                            int n14 = n13;
                            qCD.exponentB = new int[n14];
                            qCD.mantissaB = new int[n14];
                            for (n12 = 0; n12 < n14; ++n12) {
                                object = new JPXBitReader(jPXReader.readByte());
                                qCD.exponentB[n12] = ((JPXBitReader)object).readBits(5);
                                qCD.mantissaB[n12] = 0;
                            }
                            break;
                        }
                        case 1: {
                            qCD.hasScalar = false;
                            byte[] byArray = new byte[]{jPXReader.readByte(), jPXReader.readByte()};
                            object = new JPXBitReader(byArray);
                            n11 = ((JPXBitReader)object).readBits(5);
                            n10 = ((JPXBitReader)object).readBits(11);
                            qCD.exponentB = new int[]{n11};
                            qCD.mantissaB = new int[]{n10};
                            break;
                        }
                        case 2: {
                            int n14 = n13 / 2;
                            qCD.hasScalar = true;
                            qCD.exponentB = new int[n14];
                            qCD.mantissaB = new int[n14];
                            for (n9 = 0; n9 < n14; ++n9) {
                                byte[] byArray = new byte[]{jPXReader.readByte(), jPXReader.readByte()};
                                object = new JPXBitReader(byArray);
                                qCD.exponentB[n9] = ((JPXBitReader)object).readBits(5);
                                qCD.mantissaB[n9] = ((JPXBitReader)object).readBits(11);
                            }
                            break;
                        }
                    }
                    info.qcc[n3] = qCD;
                    continue block27;
                }
                case 65374: {
                    int n12 = jPXReader.readUShort();
                    jPXReader.setPosition(jPXReader.getPosition() + n12 - 2);
                    continue block27;
                }
                case 65375: {
                    int n11 = jPXReader.readUShort();
                    jPXReader.setPosition(jPXReader.getPosition() + n11 - 2);
                    continue block27;
                }
                case 65376: {
                    int n10 = jPXReader.readUShort();
                    jPXReader.setPosition(jPXReader.getPosition() + n10 - 2);
                    continue block27;
                }
                case 65367: {
                    int n9 = jPXReader.readUShort();
                    jPXReader.setPosition(jPXReader.getPosition() + n9 - 2);
                    continue block27;
                }
                case 65365: {
                    int n15 = jPXReader.readUShort();
                    jPXReader.setPosition(jPXReader.getPosition() + n15 - 2);
                    continue block27;
                }
                case 65379: {
                    int n16 = jPXReader.readUShort();
                    jPXReader.setPosition(jPXReader.getPosition() + n16 - 2);
                    continue block27;
                }
                case 65380: {
                    int n17 = jPXReader.readUShort();
                    jPXReader.setPosition(jPXReader.getPosition() + n17 - 2);
                    continue block27;
                }
                case 65424: {
                    int n18 = jPXReader.getPosition() - 2;
                    jPXReader.readInt();
                    int n19 = jPXReader.readInt();
                    jPXReader.readShort();
                    jPXReader.setPosition(n18 + n19);
                    info.tileOffsets.add(n18);
                    continue block27;
                }
                case 65497: {
                    return;
                }
            }
            System.err.println("undefined header in jpeg2000file" + n);
        }
    }

    private static void decodeTileOffsets(Info info, JPXReader jPXReader) {
        boolean bl = false;
        for (int n : info.tileOffsets) {
            jPXReader.setPosition(n);
            int n2 = jPXReader.readUShort();
            int n3 = jPXReader.readUShort();
            int n4 = jPXReader.readUShort();
            int n5 = jPXReader.readInt();
            int n6 = jPXReader.readUByte();
            int n7 = jPXReader.readUByte();
            int n8 = n5 - 12;
            int n9 = n + n5;
            Tile tile = new Tile();
            tile.cod = info.cod;
            tile.qcd = info.qcd;
            tile.qcc = info.qcc;
            tile.index = n4;
            tile.partIndex = n6;
            tile.partCount = n7;
            int n10 = 0;
            while (jPXReader.getPosition() < n9) {
                int n11 = jPXReader.readUShort();
                switch (n11) {
                    case 65362: {
                        int n12;
                        int n13 = jPXReader.readUShort();
                        n10 = n10 + 2 + n13;
                        COD cOD = new COD();
                        boolean[] blArray = Jpeg2000Decoder.toBoolean8(jPXReader.readByte());
                        cOD.hasPrecint = blArray[7];
                        cOD.hasSOP = blArray[6];
                        cOD.hasEPH = blArray[5];
                        cOD.progressionOrder = jPXReader.readUByte();
                        cOD.nLayers = jPXReader.readUShort();
                        cOD.multiCompTransform = jPXReader.readByte();
                        cOD.nDecompLevel = jPXReader.readUByte();
                        cOD.xcb = jPXReader.readUByte() + 2;
                        cOD.ycb = jPXReader.readUByte() + 2;
                        cOD.codeBlockStyle = jPXReader.readByte();
                        cOD.transformation = jPXReader.readUByte();
                        if (cOD.hasPrecint) {
                            cOD.precintSizes = new int[cOD.nDecompLevel + 1];
                            for (n12 = 0; n12 < cOD.precintSizes.length; ++n12) {
                                cOD.precintSizes[n12] = jPXReader.readByte();
                            }
                        }
                        tile.cod = cOD;
                        break;
                    }
                    case 65372: {
                        Object object;
                        int n14;
                        int n15;
                        int n12 = jPXReader.readUShort();
                        n10 = n10 + 2 + n12;
                        QCD qCD = new QCD();
                        Byte by = jPXReader.readByte();
                        JPXBitReader jPXBitReader = new JPXBitReader(by);
                        qCD.guardBits = jPXBitReader.readBits(3);
                        qCD.quantBits = jPXBitReader.readBits(5);
                        qCD.hasScalar = false;
                        int n16 = n12 - 3;
                        int n17 = 0;
                        switch (qCD.quantBits) {
                            case 0: {
                                qCD.hasScalar = true;
                                n17 = n16;
                                qCD.exponentB = new int[n17];
                                for (n15 = 0; n15 < n17; ++n15) {
                                    jPXBitReader = new JPXBitReader(jPXReader.readByte());
                                    qCD.exponentB[n15] = jPXBitReader.readBits(5);
                                }
                                break;
                            }
                            case 1: {
                                qCD.hasScalar = false;
                                byte[] byArray = new byte[]{jPXReader.readByte(), jPXReader.readByte()};
                                jPXBitReader = new JPXBitReader(byArray);
                                n14 = jPXBitReader.readBits(5);
                                int n18 = jPXBitReader.readBits(11);
                                qCD.exponentB = new int[]{n14};
                                qCD.mantissaB = new int[]{n18};
                                break;
                            }
                            case 2: {
                                n17 = n16 / 2;
                                qCD.hasScalar = true;
                                qCD.exponentB = new int[n17];
                                qCD.mantissaB = new int[n17];
                                for (int i = 0; i < n17; ++i) {
                                    object = new byte[]{jPXReader.readByte(), jPXReader.readByte()};
                                    jPXBitReader = new JPXBitReader((byte[])object);
                                    qCD.exponentB[i] = jPXBitReader.readBits(5);
                                    qCD.mantissaB[i] = jPXBitReader.readBits(11);
                                }
                                break;
                            }
                        }
                        tile.qcd = qCD;
                        break;
                    }
                    case 65373: {
                        int n19;
                        int n20;
                        int n15 = jPXReader.readUShort();
                        int n14 = jPXReader.readUByte();
                        QCD qCD = new QCD();
                        Byte by = jPXReader.readByte();
                        Object object = new JPXBitReader(by);
                        qCD.guardBits = ((JPXBitReader)object).readBits(3);
                        qCD.quantBits = ((JPXBitReader)object).readBits(5);
                        qCD.hasScalar = false;
                        int n21 = n15 - 4;
                        switch (qCD.quantBits) {
                            case 0: {
                                qCD.hasScalar = true;
                                int n22 = n21;
                                qCD.exponentB = new int[n22];
                                qCD.mantissaB = new int[n22];
                                for (n20 = 0; n20 < n22; ++n20) {
                                    object = new JPXBitReader(jPXReader.readByte());
                                    qCD.exponentB[n20] = ((JPXBitReader)object).readBits(5);
                                    qCD.mantissaB[n20] = 0;
                                }
                                break;
                            }
                            case 1: {
                                qCD.hasScalar = false;
                                byte[] byArray = new byte[]{jPXReader.readByte(), jPXReader.readByte()};
                                object = new JPXBitReader(byArray);
                                int n23 = ((JPXBitReader)object).readBits(5);
                                n19 = ((JPXBitReader)object).readBits(11);
                                qCD.exponentB = new int[]{n23};
                                qCD.mantissaB = new int[]{n19};
                                break;
                            }
                            case 2: {
                                int n22 = n21 / 2;
                                qCD.hasScalar = true;
                                qCD.exponentB = new int[n22];
                                qCD.mantissaB = new int[n22];
                                for (int i = 0; i < n22; ++i) {
                                    byte[] byArray = new byte[]{jPXReader.readByte(), jPXReader.readByte()};
                                    object = new JPXBitReader(byArray);
                                    qCD.exponentB[i] = ((JPXBitReader)object).readBits(5);
                                    qCD.mantissaB[i] = ((JPXBitReader)object).readBits(11);
                                }
                                break;
                            }
                        }
                        tile.qcc[n14] = qCD;
                        break;
                    }
                    case 65363: 
                    case 65368: 
                    case 65374: 
                    case 65375: 
                    case 65377: 
                    case 65380: {
                        int n20 = jPXReader.readUShort();
                        n10 = n10 + 2 + n20;
                        jPXReader.setPosition(jPXReader.getPosition() + n20 - 2);
                        break;
                    }
                    case 65427: {
                        int n19;
                        byte[] byArray = new byte[n8 - (n10 += 2)];
                        for (n19 = 0; n19 < byArray.length; ++n19) {
                            byArray[n19] = jPXReader.readByte();
                        }
                        tile.data = byArray;
                        if (tile.partIndex == 0) {
                            Jpeg2000Decoder.initializeDimensions(info, tile, tile.index);
                        }
                        TileParser tileParser = new TileParser(tile.data, info.tilesMap.get(tile.index));
                        tileParser.parseTile();
                        break;
                    }
                }
            }
        }
    }

    private static void initializeDimensions(Info info, Tile tile, int n) {
        Tile tile2 = info.tilesMap.get(n);
        tile2.cod = tile2.cod != null ? tile2.cod : tile.cod;
        tile2.qcd = tile2.qcd != null ? tile2.qcd : tile.qcd;
        tile2.qcc = tile2.qcc != null ? tile2.qcc : tile.qcc;
        switch (tile2.cod.progressionOrder) {
            case 0: {
                tile2.progress = new LRCP(info, n);
                break;
            }
            case 1: {
                tile2.progress = new RLCP(info, n);
                break;
            }
            case 2: {
                System.err.print("This progression order not supported");
                break;
            }
            case 3: {
                System.err.print("This progression order not supported");
                break;
            }
            case 4: {
                System.err.print("This progression order not supported");
                break;
            }
            default: {
                System.err.println("Unknown progression order found");
            }
        }
        int n2 = tile2.cod.nDecompLevel;
        int n3 = tile2.cod.xcb;
        int n4 = tile2.cod.xcb;
        for (TileComponent tileComponent : tile2.components) {
            for (int i = 0; i <= n2; ++i) {
                int n5;
                int n6 = i == 0 ? Math.min(n3, 15) : Math.min(n3, 14);
                int n7 = i == 0 ? Math.min(n4, 15) : Math.min(n4, 14);
                TileResolution tileResolution = new TileResolution();
                int n8 = 1 << n2 - i;
                tileResolution.x0 = (int)Math.ceil(1.0 * (double)tileComponent.x0 / (double)n8);
                tileResolution.x1 = (int)Math.ceil(1.0 * (double)tileComponent.x1 / (double)n8);
                tileResolution.y0 = (int)Math.ceil(1.0 * (double)tileComponent.y0 / (double)n8);
                tileResolution.y1 = (int)Math.ceil(1.0 * (double)tileComponent.y1 / (double)n8);
                Jpeg2000Decoder.updatePrecinctInfo(tileResolution, i, 15, 15);
                if (i == 0) {
                    n5 = 1 << n2;
                    TileBand tileBand = new TileBand(0);
                    tileBand.x0 = (int)Math.abs(Math.ceil(1.0 * (double)tileComponent.x0 / (double)n5));
                    tileBand.y0 = (int)Math.abs(Math.ceil(1.0 * (double)tileComponent.y0 / (double)n5));
                    tileBand.x1 = (int)Math.abs(Math.ceil(1.0 * (double)tileComponent.x1 / (double)n5));
                    tileBand.y1 = (int)Math.abs(Math.ceil(1.0 * (double)tileComponent.y1 / (double)n5));
                    tileResolution.tileBands.add(tileBand);
                    Jpeg2000Decoder.updateCodeBlocks(tileResolution, tileBand, n6, n7);
                } else {
                    n5 = n2 + 1 - i;
                    int n9 = 1 << n5;
                    int n10 = 1 << n5 - 1;
                    TileBand tileBand = new TileBand(2);
                    tileBand.x0 = (int)Math.abs(Math.ceil((1.0 * (double)tileComponent.x0 - (double)(n10 * 1)) / (double)n9));
                    tileBand.y0 = (int)Math.abs(Math.ceil((1.0 * (double)tileComponent.y0 - (double)(n10 * 0)) / (double)n9));
                    tileBand.x1 = (int)Math.abs(Math.ceil((1.0 * (double)tileComponent.x1 - (double)(n10 * 1)) / (double)n9));
                    tileBand.y1 = (int)Math.abs(Math.ceil((1.0 * (double)tileComponent.y1 - (double)(n10 * 0)) / (double)n9));
                    tileResolution.tileBands.add(tileBand);
                    Jpeg2000Decoder.updateCodeBlocks(tileResolution, tileBand, n6, n7);
                    tileBand = new TileBand(1);
                    tileBand.x0 = (int)Math.abs(Math.ceil((1.0 * (double)tileComponent.x0 - (double)(n10 * 0)) / (double)n9));
                    tileBand.y0 = (int)Math.abs(Math.ceil((1.0 * (double)tileComponent.y0 - (double)(n10 * 1)) / (double)n9));
                    tileBand.x1 = (int)Math.abs(Math.ceil((1.0 * (double)tileComponent.x1 - (double)(n10 * 0)) / (double)n9));
                    tileBand.y1 = (int)Math.abs(Math.ceil((1.0 * (double)tileComponent.y1 - (double)(n10 * 1)) / (double)n9));
                    tileResolution.tileBands.add(tileBand);
                    Jpeg2000Decoder.updateCodeBlocks(tileResolution, tileBand, n6, n7);
                    tileBand = new TileBand(3);
                    tileBand.x0 = (int)Math.abs(Math.ceil((1.0 * (double)tileComponent.x0 - (double)(n10 * 1)) / (double)n9));
                    tileBand.y0 = (int)Math.abs(Math.ceil((1.0 * (double)tileComponent.y0 - (double)(n10 * 1)) / (double)n9));
                    tileBand.x1 = (int)Math.abs(Math.ceil((1.0 * (double)tileComponent.x1 - (double)(n10 * 1)) / (double)n9));
                    tileBand.y1 = (int)Math.abs(Math.ceil((1.0 * (double)tileComponent.y1 - (double)(n10 * 1)) / (double)n9));
                    tileResolution.tileBands.add(tileBand);
                    Jpeg2000Decoder.updateCodeBlocks(tileResolution, tileBand, n6, n7);
                }
                tileComponent.resolutions.add(tileResolution);
            }
        }
    }

    private static void updatePrecinctInfo(TileResolution tileResolution, int n, int n2, int n3) {
        PrecinctInfo precinctInfo = new PrecinctInfo();
        precinctInfo.precinctWidth = 1 << n2;
        precinctInfo.precinctHeight = 1 << n3;
        precinctInfo.precinctWidthInSubband = 1 << n2 + (n == 0 ? 0 : -1);
        precinctInfo.precinctHeightInSubband = 1 << n3 + (n == 0 ? 0 : -1);
        precinctInfo.numPrecinctsWide = (int)(tileResolution.x1 > tileResolution.x0 ? Math.ceil(1.0 * (double)tileResolution.x1 / (double)precinctInfo.precinctWidth) - Math.floor(1.0 * (double)tileResolution.x0 / (double)precinctInfo.precinctWidth) : 0.0);
        precinctInfo.numPrecinctsHigh = (int)(tileResolution.y1 > tileResolution.y0 ? Math.ceil(1.0 * (double)tileResolution.y1 / (double)precinctInfo.precinctHeight) - Math.floor(1.0 * (double)tileResolution.y0 / (double)precinctInfo.precinctHeight) : 0.0);
        precinctInfo.numPrecincts = precinctInfo.numPrecinctsWide * precinctInfo.numPrecinctsHigh;
        tileResolution.precinctInfo = precinctInfo;
    }

    private static void updateCodeBlocks(TileResolution tileResolution, TileBand tileBand, int n, int n2) {
        int n3 = 1 << n;
        int n4 = 1 << n2;
        int n5 = tileBand.x0 >> n;
        int n6 = tileBand.y0 >> n2;
        int n7 = tileBand.x1 + n3 - 1 >> n;
        int n8 = tileBand.y1 + n4 - 1 >> n2;
        PrecinctInfo precinctInfo = tileResolution.precinctInfo;
        List<CodeBlock> list = tileBand.codeBlocks;
        List<Precinct> list2 = tileBand.precincts;
        for (int i = n6; i < n8; ++i) {
            for (int j = n5; j < n7; ++j) {
                Precinct precinct;
                int n9;
                CodeBlock codeBlock = new CodeBlock();
                codeBlock.x = j;
                codeBlock.y = i;
                codeBlock.tbx0 = n3 * j;
                codeBlock.tby0 = n4 * i;
                codeBlock.tbx1 = n3 * (j + 1);
                codeBlock.tby1 = n4 * (i + 1);
                codeBlock.tbx0_ = Math.max(tileBand.x0, codeBlock.tbx0);
                codeBlock.tby0_ = Math.max(tileBand.y0, codeBlock.tby0);
                codeBlock.tbx1_ = Math.min(tileBand.x1, codeBlock.tbx1);
                codeBlock.tby1_ = Math.min(tileBand.y1, codeBlock.tby1);
                int n10 = (int)Math.floor((double)(codeBlock.tbx0_ - tileBand.x0) / ((double)precinctInfo.precinctWidthInSubband * 1.0));
                int n11 = (int)Math.floor((double)(codeBlock.tby0_ - tileBand.y0) / ((double)precinctInfo.precinctHeightInSubband * 1.0));
                codeBlock.precinctNumber = n9 = n10 + n11 * precinctInfo.numPrecinctsWide;
                codeBlock.subbandType = tileBand.type;
                codeBlock.Lblock = 3;
                if (codeBlock.tbx1_ <= codeBlock.tbx0_ || codeBlock.tby1_ <= codeBlock.tby0_) continue;
                list.add(codeBlock);
                if (list2.size() > n9) {
                    precinct = list2.get(n9);
                    if (j < precinct.cbx0) {
                        precinct.cbx0 = j;
                    } else if (j > precinct.cbx1) {
                        precinct.cbx1 = j;
                    }
                    if (i < precinct.cby0) {
                        precinct.cbx0 = i;
                    } else if (i > precinct.cby1) {
                        precinct.cby1 = i;
                    }
                } else {
                    precinct = new Precinct();
                    precinct.cby0 = i;
                    precinct.cby1 = i;
                    precinct.cbx0 = j;
                    precinct.cbx1 = j;
                    list2.add(precinct);
                }
                codeBlock.precinct = precinct;
            }
        }
        tileBand.codeBlockInfo = new CodeBlockInfo();
        tileBand.codeBlockInfo.codeBlockWidth = n;
        tileBand.codeBlockInfo.codeBlockHeight = n2;
        tileBand.codeBlockInfo.numCodeBlockWide = n7 - n5 + 1;
        tileBand.codeBlockInfo.numCodeBlockHigh = n8 - n6 + 1;
    }

    private static BufferedImage convertPalette(Info info) {
        BufferedImage bufferedImage;
        byte[] byArray;
        int n;
        int n2;
        int n3;
        int n4;
        Object[] objectArray;
        SIZ sIZ = info.siz;
        int n5 = sIZ.nComp;
        ArrayList<SubbandCoefficient> arrayList = new ArrayList<SubbandCoefficient>();
        for (int i = 0; i < info.tilesMap.size(); ++i) {
            Tile tile = info.tilesMap.get(i);
            SubbandCoefficient[] subbandCoefficientArray = new SubbandCoefficient[n5];
            for (int j = 0; j < n5; ++j) {
                subbandCoefficientArray[j] = Jpeg2000Decoder.transformTile(info, tile, j);
                tile.components.get((int)j).resolutions.clear();
            }
            SubbandCoefficient subbandCoefficient = subbandCoefficientArray[0];
            SubbandCoefficient subbandCoefficient2 = new SubbandCoefficient();
            subbandCoefficient2.x = subbandCoefficient.x;
            subbandCoefficient2.y = subbandCoefficient.y;
            subbandCoefficient2.width = subbandCoefficient.width;
            subbandCoefficient2.height = subbandCoefficient.height;
            subbandCoefficient2.byteItems = objectArray = new byte[subbandCoefficient2.width * subbandCoefficient2.height * n5];
            n4 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                float f;
                float[] fArray = subbandCoefficientArray[n3].floatItems;
                n2 = info.siz.precisionInfo[n3][0] + 1 - 8;
                if (n2 == 0) {
                    f = 128.5f;
                    float f2 = 127.5f;
                    float f3 = -f2;
                    n4 = n3;
                    for (n = 0; n < fArray.length; ++n) {
                        float f4 = fArray[n];
                        objectArray[n4] = (byte)(f4 <= f3 ? 0.0f : (f4 >= f2 ? 255.0f : f4 + f));
                        n4 += n5;
                    }
                    continue;
                }
                if (n2 >= 0) continue;
                n4 = n3;
                f = 1 << info.siz.precisionInfo[n3][0];
                int n6 = (1 << info.siz.precisionInfo[n3][0] + 1) - 1;
                for (int j = 0; j < fArray.length; ++j) {
                    float f5 = fArray[j] + f;
                    objectArray[n4] = (byte)Math.max(0.0f, Math.min(f5, (float)n6));
                    n4 += n5;
                }
            }
            arrayList.add(subbandCoefficient2);
        }
        info.tilesMap.clear();
        if (arrayList.size() == 1) {
            byArray = ((SubbandCoefficient)arrayList.get((int)0)).byteItems;
        } else {
            byArray = new byte[sIZ.nComp * sIZ.Xsiz * sIZ.Ysiz];
            int n7 = sIZ.nComp;
            int n8 = sIZ.Xsiz * n7;
            for (SubbandCoefficient subbandCoefficient2 : arrayList) {
                objectArray = subbandCoefficient2.byteItems;
                n2 = subbandCoefficient2.x;
                int n9 = subbandCoefficient2.y;
                int n10 = subbandCoefficient2.width;
                int n11 = subbandCoefficient2.height;
                n4 = n10 * n7;
                n3 = n2 * n7;
                for (int i = 0; i < n11; ++i) {
                    n = i * n4;
                    int n12 = (i + n9) * n8 + n3;
                    System.arraycopy(objectArray, n, byArray, n12, n4);
                }
                subbandCoefficient2.byteItems = null;
            }
        }
        if (info.enumerateCS == 12) {
            byte[] byArray2 = new byte[4 * sIZ.Xsiz * sIZ.Ysiz];
            int n13 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                objectArray = info.palette.cValues[byArray[i] & 0xFF];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    byArray2[n13] = objectArray[n2];
                    ++n13;
                }
            }
            bufferedImage = new BufferedImage(sIZ.Xsiz, sIZ.Ysiz, 1);
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            n13 = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            for (int i = 0; i < nArray.length; ++i) {
                double d8 = (double)(byArray2[n13++] & 0xFF) / 255.0;
                double d9 = (double)(byArray2[n13++] & 0xFF) / 255.0;
                double d10 = (double)(byArray2[n13++] & 0xFF) / 255.0;
                double d11 = (double)(byArray2[n13++] & 0xFF) / 255.0;
                if (d8 == d4 && d9 == d5 && d10 == d6 && d11 == d7 && i > 0) {
                    nArray[i] = nArray[i - 1];
                    continue;
                }
                double d12 = 1.0 - d11;
                d = 255.0 * (1.0 - d8) * d12;
                d2 = 255.0 * (1.0 - d9) * d12;
                d3 = 255.0 * (1.0 - d10) * d12;
                d4 = d8;
                d5 = d9;
                d6 = d10;
                d7 = d11;
                nArray[i] = (int)d << 16 | (int)d2 << 8 | (int)d3;
            }
        } else {
            bufferedImage = Jpeg2000Decoder.generateBufferedImage(info.palette.nColumns, sIZ.Xsiz, sIZ.Ysiz);
            byte[] byArray3 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            int n14 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                objectArray = info.palette.cValues[byArray[i] & 0xFF];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    byArray3[n14] = objectArray[n2];
                    ++n14;
                }
            }
        }
        return bufferedImage;
    }

    private static BufferedImage convertCMYKTileToRGB(Info info, boolean bl) {
        BufferedImage bufferedImage;
        int n;
        int n2;
        byte[] byArray;
        SIZ sIZ = info.siz;
        int n3 = sIZ.nComp;
        ArrayList<SubbandCoefficient> arrayList = new ArrayList<SubbandCoefficient>();
        for (int i = 0; i < info.tilesMap.size(); ++i) {
            float f;
            float f2;
            float f3;
            float[] fArray;
            Tile tile = info.tilesMap.get(i);
            SubbandCoefficient[] subbandCoefficientArray = new SubbandCoefficient[n3];
            for (int j = 0; j < n3; ++j) {
                subbandCoefficientArray[j] = Jpeg2000Decoder.transformTile(info, tile, j);
                tile.components.get((int)j).resolutions.clear();
            }
            SubbandCoefficient subbandCoefficient = subbandCoefficientArray[0];
            SubbandCoefficient subbandCoefficient2 = new SubbandCoefficient();
            subbandCoefficient2.x = subbandCoefficient.x;
            subbandCoefficient2.y = subbandCoefficient.y;
            subbandCoefficient2.width = subbandCoefficient.width;
            subbandCoefficient2.height = subbandCoefficient.height;
            subbandCoefficient2.byteItems = byArray = new byte[subbandCoefficient2.width * subbandCoefficient2.height * n3];
            n2 = 0;
            if (tile.cod.multiCompTransform == 1) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                int n4;
                float[] fArray2 = subbandCoefficientArray[0].floatItems;
                fArray = subbandCoefficientArray[1].floatItems;
                float[] fArray3 = subbandCoefficientArray[2].floatItems;
                float[] fArray4 = subbandCoefficientArray[3].floatItems;
                n = info.siz.precisionInfo[0][0] + 1 - 8;
                f3 = (float)(128 << n) + 0.5f;
                f2 = 255 * (1 << n);
                float f4 = f2 * 0.5f;
                f = -f4;
                if (tile.cod.transformation == 0) {
                    n2 = 0;
                    for (n4 = 0; n4 < fArray2.length; ++n4) {
                        d7 = fArray2[n4] + f3;
                        d6 = fArray[n4];
                        d5 = fArray3[n4];
                        d4 = fArray4[n4];
                        d3 = d7 + 1.402 * d5;
                        d2 = d7 - 0.34413 * d6 - 0.71414 * d5;
                        d = d7 + 1.772 * d6;
                        byArray[n2++] = (byte)(d3 <= 0.0 ? 0 : (d3 >= (double)f2 ? 255 : (int)d3 >> n));
                        byArray[n2++] = (byte)(d2 <= 0.0 ? 0 : (d2 >= (double)f2 ? 255 : (int)d2 >> n));
                        byArray[n2++] = (byte)(d <= 0.0 ? 0 : (d >= (double)f2 ? 255 : (int)d >> n));
                        byArray[n2++] = (byte)(d4 <= (double)f ? 0 : (d4 >= (double)f4 ? 255 : (int)(d4 + (double)f3) >> n));
                    }
                } else {
                    for (n4 = 0; n4 < fArray2.length; ++n4) {
                        d7 = fArray2[n4] + f3;
                        d6 = fArray[n4];
                        d5 = fArray3[n4];
                        d4 = fArray4[n4];
                        d2 = d7 - (double)((int)(d5 + d6) >> 2);
                        d3 = d2 + d5;
                        d = d2 + d6;
                        byArray[n2++] = (byte)(d3 <= 0.0 ? 0 : (d3 >= (double)f2 ? 255 : (int)d3 >> n));
                        byArray[n2++] = (byte)(d2 <= 0.0 ? 0 : (d2 >= (double)f2 ? 255 : (int)d2 >> n));
                        byArray[n2++] = (byte)(d <= 0.0 ? 0 : (d >= (double)f2 ? 255 : (int)d >> n));
                        byArray[n2++] = (byte)(d4 <= (double)f ? 0 : (d4 >= (double)f4 ? 255 : (int)(d4 + (double)f3) >> n));
                    }
                }
            } else {
                for (int j = 0; j < n3; ++j) {
                    fArray = subbandCoefficientArray[j].floatItems;
                    n = info.siz.precisionInfo[j][0] + 1 - 8;
                    f3 = (float)(128 << n) + 0.5f;
                    f2 = (int)(127.5f * (float)(1 << n));
                    f = -f2;
                    n2 = j;
                    for (int k = 0; k < fArray.length; ++k) {
                        float f5 = fArray[k];
                        byArray[n2] = (byte)(f5 <= f ? 0 : (f5 >= f2 ? 255 : (int)(f5 + f3) >> n));
                        n2 += n3;
                    }
                }
            }
            arrayList.add(subbandCoefficient2);
        }
        info.tilesMap.clear();
        byte[] byArray2 = null;
        if (arrayList.size() == 1) {
            byArray2 = ((SubbandCoefficient)arrayList.get((int)0)).byteItems;
        } else {
            byArray2 = new byte[sIZ.nComp * sIZ.Xsiz * sIZ.Ysiz];
            int n5 = sIZ.nComp;
            int n6 = sIZ.Xsiz * n5;
            for (SubbandCoefficient subbandCoefficient2 : arrayList) {
                byArray = subbandCoefficient2.byteItems;
                n = subbandCoefficient2.x;
                int n7 = subbandCoefficient2.y;
                int n8 = subbandCoefficient2.width;
                int n9 = subbandCoefficient2.height;
                int n10 = n8 * n5;
                n2 = n * n5;
                for (int i = 0; i < n9; ++i) {
                    int n11 = i * n10;
                    int n12 = (i + n7) * n6 + n2;
                    System.arraycopy(byArray, n11, byArray2, n12, n10);
                }
                subbandCoefficient2.byteItems = null;
            }
        }
        if (bl) {
            bufferedImage = new BufferedImage(sIZ.Xsiz, sIZ.Ysiz, 1);
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            n = 0;
            EnumeratedSpace enumeratedSpace = new EnumeratedSpace();
            for (int i = 0; i < nArray.length; ++i) {
                byte by = byArray2[n13++];
                byte by2 = byArray2[n13++];
                byte by3 = byArray2[n13++];
                byte by4 = byArray2[n13++];
                byte[] byArray3 = enumeratedSpace.getRGB(by, by2, by3, by4);
                n14 = byArray3[0] & 0xFF;
                n15 = byArray3[1] & 0xFF;
                n = byArray3[2] & 0xFF;
                nArray[i] = n14 << 16 | n15 << 8 | n;
            }
        } else {
            bufferedImage = Jpeg2000Decoder.generateBufferedImage(4, sIZ.Xsiz, sIZ.Ysiz);
            byte[] byArray4 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        }
        return bufferedImage;
    }

    private static BufferedImage convertTileComponentsToBuffered(Info info) {
        int n;
        int n2;
        int n3;
        Object object;
        SIZ sIZ = info.siz;
        int n4 = sIZ.nComp;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < info.tilesMap.size(); ++i) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            int n5;
            int n6;
            double d7;
            int n7;
            float[] fArray;
            float[] fArray2;
            Object object2;
            object = info.tilesMap.get(i);
            SubbandCoefficient[] subbandCoefficientArray = new SubbandCoefficient[n4];
            for (int j = 0; j < n4; ++j) {
                subbandCoefficientArray[j] = Jpeg2000Decoder.transformTile(info, (Tile)object, j);
                ((Tile)object).components.get((int)j).resolutions.clear();
            }
            SubbandCoefficient subbandCoefficient = subbandCoefficientArray[0];
            SubbandCoefficient subbandCoefficient2 = new SubbandCoefficient();
            subbandCoefficient2.x = subbandCoefficient.x;
            subbandCoefficient2.y = subbandCoefficient.y;
            subbandCoefficient2.width = subbandCoefficient.width;
            subbandCoefficient2.height = subbandCoefficient.height;
            if (info.tilesMap.size() == 1) {
                subbandCoefficient2.bufferedImage = Jpeg2000Decoder.generateBufferedImage(n4, subbandCoefficient2.width, subbandCoefficient2.height);
                object2 = ((DataBufferByte)subbandCoefficient2.bufferedImage.getRaster().getDataBuffer()).getData();
            } else {
                object2 = new byte[subbandCoefficient2.width * subbandCoefficient2.height * n4];
                subbandCoefficient2.byteItems = (byte[])object2;
            }
            n3 = 0;
            if (((Tile)object).cod.multiCompTransform != 0) {
                float[] fArray3 = Jpeg2000Decoder.getMappedComponent(subbandCoefficientArray, 0, info);
                fArray2 = Jpeg2000Decoder.getMappedComponent(subbandCoefficientArray, 1, info);
                fArray = Jpeg2000Decoder.getMappedComponent(subbandCoefficientArray, 2, info);
                n7 = info.siz.precisionInfo[0][0] + 1 - 8;
                d7 = (float)(128 << n7) + 0.5f;
                n2 = 255 * (1 << n7);
                n6 = n4 - 3;
                if (((Tile)object).cod.transformation == 0) {
                    n5 = 0;
                    while (n5 < fArray3.length) {
                        d6 = (double)fArray3[n5] + d7;
                        d5 = fArray2[n5];
                        d4 = fArray[n5];
                        d3 = d6 + 1.402 * d4;
                        d2 = d6 - 0.34413 * d5 - 0.71414 * d4;
                        d = d6 + 1.772 * d5;
                        object2[n3++] = (byte)(d3 < 0.0 ? 0 : (d3 > (double)n2 ? 255 : (int)d3 >> n7));
                        object2[n3++] = (byte)(d2 < 0.0 ? 0 : (d2 > (double)n2 ? 255 : (int)d2 >> n7));
                        object2[n3++] = (byte)(d < 0.0 ? 0 : (d > (double)n2 ? 255 : (int)d >> n7));
                        ++n5;
                        n3 += n6;
                    }
                } else {
                    n5 = fArray3.length;
                    int n8 = 0;
                    while (n8 < n5) {
                        d6 = (double)fArray3[n8] + d7;
                        d5 = fArray2[n8];
                        d4 = fArray[n8];
                        d2 = d6 - (double)((int)(d4 + d5) >> 2);
                        d3 = d2 + d4;
                        d = d2 + d5;
                        object2[n3++] = (byte)(d3 < 0.0 ? 0 : (d3 > (double)n2 ? 255 : (int)d3 >> n7));
                        object2[n3++] = (byte)(d2 < 0.0 ? 0 : (d2 > (double)n2 ? 255 : (int)d2 >> n7));
                        object2[n3++] = (byte)(d < 0.0 ? 0 : (d > (double)n2 ? 255 : (int)d >> n7));
                        ++n8;
                        n3 += n6;
                    }
                }
            } else if (info.enumerateCS == 18 && n4 == 3) {
                float[] fArray4 = Jpeg2000Decoder.getMappedComponent(subbandCoefficientArray, 0, info);
                fArray2 = Jpeg2000Decoder.getMappedComponent(subbandCoefficientArray, 1, info);
                fArray = Jpeg2000Decoder.getMappedComponent(subbandCoefficientArray, 2, info);
                n7 = info.siz.precisionInfo[0][0] + 1 - 8;
                d7 = (float)(128 << n7) + 0.5f;
                n2 = 255 * (1 << n7);
                n6 = fArray4.length;
                for (n5 = 0; n5 < n6; ++n5) {
                    d6 = (double)fArray4[n5] + d7;
                    d5 = fArray2[n5];
                    d4 = fArray[n5];
                    d3 = d6 + 1.402 * d4;
                    d2 = d6 - 0.34413 * d5 - 0.71414 * d4;
                    d = d6 + 1.772 * d5;
                    object2[n3++] = (byte)(d3 < 0.0 ? 0 : (d3 > (double)n2 ? 255 : (int)d3 >> n7));
                    object2[n3++] = (byte)(d2 < 0.0 ? 0 : (d2 > (double)n2 ? 255 : (int)d2 >> n7));
                    object2[n3++] = (byte)(d < 0.0 ? 0 : (d > (double)n2 ? 255 : (int)d >> n7));
                }
            } else {
                for (int j = 0; j < n4; ++j) {
                    fArray2 = subbandCoefficientArray[j].floatItems;
                    n7 = info.siz.precisionInfo[j][0] + 1 - 8;
                    d7 = (float)(128 << n7) + 0.5f;
                    n2 = (int)(127.5f * (float)(1 << n7));
                    n = -n2;
                    n3 = j;
                    for (int k = 0; k < fArray2.length; ++k) {
                        float f = fArray2[k];
                        object2[n3] = (byte)(f <= (float)n ? 0 : (f >= (float)n2 ? 255 : (int)((double)f + d7) >> n7));
                        n3 += n4;
                    }
                }
            }
            subbandCoefficient.floatItems = null;
            arrayList.add(subbandCoefficient2);
        }
        info.tilesMap.clear();
        if (arrayList.size() == 1) {
            return ((SubbandCoefficient)arrayList.get((int)0)).bufferedImage;
        }
        BufferedImage bufferedImage = Jpeg2000Decoder.generateBufferedImage(sIZ.nComp, sIZ.Xsiz, sIZ.Ysiz);
        object = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        int n9 = sIZ.nComp;
        int n10 = sIZ.Xsiz * n9;
        for (Object object2 : arrayList) {
            byte[] byArray = ((SubbandCoefficient)object2).byteItems;
            int n11 = ((SubbandCoefficient)object2).x;
            int n12 = ((SubbandCoefficient)object2).y;
            n = ((SubbandCoefficient)object2).width;
            n2 = ((SubbandCoefficient)object2).height;
            n3 = n * n9;
            int n13 = n11 * n9;
            for (int i = 0; i < n2; ++i) {
                int n14 = i * n3;
                int n15 = (i + n12) * n10 + n13;
                System.arraycopy(byArray, n14, object, n15, n3);
            }
            ((SubbandCoefficient)object2).byteItems = null;
        }
        return bufferedImage;
    }

    private static float[] getMappedComponent(SubbandCoefficient[] subbandCoefficientArray, int n, Info info) {
        if (info.cDef.isEmpty()) {
            return subbandCoefficientArray[n].floatItems;
        }
        if (info.cDef.containsKey(n)) {
            return subbandCoefficientArray[info.cDef.get((Object)Integer.valueOf((int)n)).intValue() - 1].floatItems;
        }
        return subbandCoefficientArray[n].floatItems;
    }

    private static SubbandCoefficient transformTile(Info info, Tile tile, int n) {
        int n2;
        int n3;
        SIZ sIZ = info.siz;
        TileComponent tileComponent = tile.components.get(n);
        QCD qCD = tile.qcc[n] != null ? tile.qcc[n] : tile.qcd;
        COD cOD = tile.cod;
        int n4 = cOD.nDecompLevel;
        int n5 = qCD.guardBits;
        int n6 = sIZ.precisionInfo[n][0] + 1;
        boolean bl = cOD.transformation == 1;
        Trns trns = new Trns(bl);
        ArrayList<SubbandCoefficient> arrayList = new ArrayList<SubbandCoefficient>();
        int n7 = 0;
        for (int i = 0; i <= n4; ++i) {
            TileResolution tileResolution = tileComponent.resolutions.get(i);
            n3 = tileResolution.getWidth();
            n2 = tileResolution.getHeight();
            float[] fArray = new float[n3 * n2];
            for (TileBand tileBand : tileResolution.tileBands) {
                int n8 = 0;
                int n9 = 0;
                if (!qCD.hasScalar) {
                    n9 = qCD.exponentB[0] + (i > 0 ? 1 - i : 0);
                    n8 = qCD.mantissaB[0];
                } else {
                    n9 = qCD.exponentB[n7];
                    n8 = qCD.mantissaB[n7];
                    ++n7;
                }
                int n10 = tileBand.getMultiplier();
                double d = n6 + n10 - n9;
                float f = (float)(cOD.transformation == 1 ? 1.0 : Math.pow(2.0, d) * (double)(1.0f + (float)n8 / 2048.0f));
                int n11 = n5 + n9 - 1;
                Jpeg2000Decoder.sendForPassing(fArray, n3, tileBand, f, n11, bl);
            }
            SubbandCoefficient subbandCoefficient = new SubbandCoefficient();
            subbandCoefficient.width = n3;
            subbandCoefficient.height = n2;
            subbandCoefficient.floatItems = fArray;
            arrayList.add(subbandCoefficient);
        }
        SubbandCoefficient subbandCoefficient = trns.getInversed(arrayList, tileComponent.x0, tileComponent.y0);
        subbandCoefficient.x = tileComponent.x0;
        subbandCoefficient.y = tileComponent.y0;
        int n12 = subbandCoefficient.width;
        n3 = subbandCoefficient.height;
        n2 = subbandCoefficient.width * sIZ.precisionInfo[n][1];
        int n13 = subbandCoefficient.height * sIZ.precisionInfo[n][1];
        if (n12 != n2 || n3 != n13) {
            subbandCoefficient.floatItems = Jpeg2000Decoder.applyBilinearScaling(subbandCoefficient.floatItems, n12, n3, n2, n13);
        }
        return subbandCoefficient;
    }

    private static float[] applyBilinearScaling(float[] fArray, int n, int n2, int n3, int n4) {
        float[] fArray2;
        if (n2 == 1) {
            fArray2 = new float[2 * n];
            System.arraycopy(fArray, 0, fArray2, 0, n);
            System.arraycopy(fArray, 0, fArray2, n, n);
            n2 = 2;
            fArray = fArray2;
        }
        fArray2 = new float[n3 * n4];
        float f = (float)(n - 1) / (float)n3;
        float f2 = (float)(n2 - 1) / (float)n4;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n6 = (int)(f * (float)j);
                int n7 = (int)(f2 * (float)i);
                float f3 = f * (float)j - (float)n6;
                float f4 = f2 * (float)i - (float)n7;
                int n8 = n7 * n + n6;
                float f5 = fArray[n8];
                float f6 = fArray[n8 + 1];
                float f7 = fArray[n8 + n];
                float f8 = fArray[n8 + n + 1];
                fArray2[n5++] = f5 * (1.0f - f3) * (1.0f - f4) + f6 * f3 * (1.0f - f4) + f7 * f4 * (1.0f - f3) + f8 * (f3 * f4);
            }
        }
        return fArray2;
    }

    private static void sendForPassing(float[] fArray, int n, TileBand tileBand, float f, int n2, boolean bl) {
        int n3 = tileBand.x1 - tileBand.x0;
        List<CodeBlock> list = tileBand.codeBlocks;
        int n4 = 0;
        int n5 = 0;
        switch (tileBand.type) {
            case 3: {
                n4 = 1;
                n5 = n;
                break;
            }
            case 1: {
                n5 = n;
                break;
            }
            case 2: {
                n4 = 1;
            }
        }
        for (CodeBlock codeBlock : list) {
            int n6;
            int n7 = codeBlock.tbx1_ - codeBlock.tbx0_;
            int n8 = codeBlock.tby1_ - codeBlock.tby0_;
            if (n7 == 0 || n8 == 0 || codeBlock.dataList.isEmpty()) continue;
            Tier1Decoder tier1Decoder = new Tier1Decoder(n7, n8, tileBand, codeBlock.zeroBitPlanes, n2);
            List<BlockData> list2 = codeBlock.dataList;
            int n9 = 0;
            int n10 = 0;
            for (BlockData blockData : list2) {
                n9 += blockData.end - blockData.start;
                n10 += blockData.nCodingPass & 0xFF;
            }
            Object object = new byte[n9];
            int n11 = 0;
            for (BlockData blockData : list2) {
                byte[] byArray = new byte[blockData.end - blockData.start];
                System.arraycopy(blockData.data, blockData.start, byArray, 0, byArray.length);
                System.arraycopy(byArray, 0, object, n11, byArray.length);
                n11 += byArray.length;
            }
            EntropyDecoder entropyDecoder = new EntropyDecoder((byte[])object, 0, n9);
            tier1Decoder.setDecoder(entropyDecoder);
            int n12 = 2;
            for (n6 = 0; n6 < n10; ++n6) {
                switch (n12) {
                    case 0: {
                        tier1Decoder.runSPP();
                        break;
                    }
                    case 1: {
                        tier1Decoder.runMRP();
                        break;
                    }
                    case 2: {
                        tier1Decoder.runCP();
                    }
                }
                n12 = (n12 + 1) % 3;
            }
            n6 = codeBlock.tbx0_ - tileBand.x0 + (codeBlock.tby0_ - tileBand.y0) * n3;
            byte[] byArray = tier1Decoder.coefficientsSign;
            Object object2 = tier1Decoder.magnitude;
            byte[] byArray2 = tier1Decoder.bitsDecoded;
            float f2 = bl ? 0.0f : 0.5f;
            n11 = 0;
            boolean bl2 = tileBand.type != 0;
            for (int i = 0; i < n8; ++i) {
                int n13 = n6 / n3;
                int n14 = 2 * n13 * (n - n3) + n4 + n5;
                for (int j = 0; j < n7; ++j) {
                    float f3 = 0.0f;
                    switch (tier1Decoder.mbType) {
                        case 0: {
                            f3 = ((byte[])object2)[n11] & 0xFF;
                            break;
                        }
                        case 1: {
                            f3 = ((short[])object2)[n11] & 0xFFFF;
                            break;
                        }
                        case 2: {
                            f3 = ((int[])object2)[n11];
                        }
                    }
                    if (f3 != 0.0f) {
                        f3 = (f3 + f2) * f;
                        if (byArray[n11] != 0) {
                            f3 = -f3;
                        }
                        int n15 = byArray2[n11] & 0xFF;
                        int n16 = bl2 ? n14 + (n6 << 1) : n6;
                        fArray[n16] = bl && n15 >= n2 ? f3 : f3 * (float)(1 << n2 - n15);
                    }
                    ++n6;
                    ++n11;
                }
                n6 += n3 - n7;
            }
            tier1Decoder.neighborSigns = null;
            tier1Decoder.coefficientsSign = null;
            tier1Decoder.magnitude = null;
            tier1Decoder.currentFlag = null;
            tier1Decoder.bitsDecoded = null;
            tier1Decoder.cx = null;
        }
    }

    private static boolean[] toBoolean8(byte by) {
        boolean[] blArray = new boolean[8];
        for (int i = 7; i >= 0; --i) {
            blArray[i] = (by >> i & 1) == 1;
        }
        return blArray;
    }

    private static BufferedImage generateBufferedImage(int n, int n2, int n3) {
        switch (n) {
            case 1: {
                ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(1003));
                ComponentColorModel componentColorModel = new ComponentColorModel(iCC_ColorSpace, false, false, 1, 0);
                WritableRaster writableRaster = componentColorModel.createCompatibleWritableRaster(n2, n3);
                return new BufferedImage(componentColorModel, writableRaster, false, null);
            }
            case 2: {
                ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(1003));
                ComponentColorModel componentColorModel = new ComponentColorModel(iCC_ColorSpace, true, false, 1, 0);
                WritableRaster writableRaster = componentColorModel.createCompatibleWritableRaster(n2, n3);
                return new BufferedImage(componentColorModel, writableRaster, false, null);
            }
            case 3: {
                ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(1000));
                ComponentColorModel componentColorModel = new ComponentColorModel(iCC_ColorSpace, false, false, 1, 0);
                WritableRaster writableRaster = componentColorModel.createCompatibleWritableRaster(n2, n3);
                return new BufferedImage(componentColorModel, writableRaster, false, null);
            }
            case 4: {
                ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(1000));
                ComponentColorModel componentColorModel = new ComponentColorModel(iCC_ColorSpace, true, false, 1, 0);
                WritableRaster writableRaster = componentColorModel.createCompatibleWritableRaster(n2, n3);
                return new BufferedImage(componentColorModel, writableRaster, false, null);
            }
        }
        return null;
    }

    public byte[] readComponentsAsConvertedBytes(byte[] byArray) throws Exception {
        boolean bl;
        byte[] byArray2;
        int n;
        int n2;
        Object[] objectArray;
        Info info = new Info();
        JPXReader jPXReader = new JPXReader(byArray);
        if (65359 == ((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF)) {
            Jpeg2000Decoder.readCodeStream(info, jPXReader, byArray.length);
        } else {
            Jpeg2000Decoder.decodeMain(info, jPXReader);
            Jpeg2000Decoder.decodeContiguousCodeStreamBoxes(info, jPXReader);
        }
        Jpeg2000Decoder.generateTileMap(info);
        Jpeg2000Decoder.decodeTileOffsets(info, jPXReader);
        SIZ sIZ = info.siz;
        int n3 = sIZ.nComp;
        ArrayList<SubbandCoefficient> arrayList = new ArrayList<SubbandCoefficient>();
        for (int i = 0; i < info.tilesMap.size(); ++i) {
            int n4;
            float f;
            float f2;
            float f3;
            Tile tile = info.tilesMap.get(i);
            SubbandCoefficient[] subbandCoefficientArray = new SubbandCoefficient[n3];
            for (int j = 0; j < n3; ++j) {
                subbandCoefficientArray[j] = Jpeg2000Decoder.transformTile(info, tile, j);
                tile.components.get((int)j).resolutions.clear();
            }
            SubbandCoefficient subbandCoefficient = subbandCoefficientArray[0];
            SubbandCoefficient subbandCoefficient2 = new SubbandCoefficient();
            subbandCoefficient2.x = subbandCoefficient.x;
            subbandCoefficient2.y = subbandCoefficient.y;
            subbandCoefficient2.width = subbandCoefficient.width;
            subbandCoefficient2.height = subbandCoefficient.height;
            subbandCoefficient2.byteItems = objectArray = new byte[subbandCoefficient2.width * subbandCoefficient2.height * n3];
            n2 = 0;
            float[] fArray = null;
            if (tile.cod.multiCompTransform == 1) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                float[] fArray2 = subbandCoefficientArray[0].floatItems;
                float[] fArray3 = subbandCoefficientArray[1].floatItems;
                float[] fArray4 = subbandCoefficientArray[2].floatItems;
                if (tile.components.size() == 4) {
                    fArray = subbandCoefficientArray[3].floatItems;
                }
                n = info.siz.precisionInfo[0][0] + 1 - 8;
                f3 = (float)(128 << n) + 0.5f;
                f2 = 255 * (1 << n);
                float f4 = f2 * 0.5f;
                f = -f4;
                if (tile.cod.transformation == 0) {
                    n2 = 0;
                    for (n4 = 0; n4 < fArray2.length; ++n4) {
                        d7 = fArray2[n4] + f3;
                        d6 = fArray3[n4];
                        d5 = fArray4[n4];
                        d4 = d7 + 1.402 * d5;
                        d3 = d7 - 0.34413 * d6 - 0.71414 * d5;
                        d2 = d7 + 1.772 * d6;
                        objectArray[n2++] = (byte)(d4 <= 0.0 ? 0 : (d4 >= (double)f2 ? 255 : (int)d4 >> n));
                        objectArray[n2++] = (byte)(d3 <= 0.0 ? 0 : (d3 >= (double)f2 ? 255 : (int)d3 >> n));
                        objectArray[n2++] = (byte)(d2 <= 0.0 ? 0 : (d2 >= (double)f2 ? 255 : (int)d2 >> n));
                        if (fArray == null) continue;
                        d = fArray[n4];
                        objectArray[n2++] = (byte)(d <= (double)f ? 0 : (d >= (double)f4 ? 255 : (int)(d + (double)f3) >> n));
                    }
                } else {
                    for (n4 = 0; n4 < fArray2.length; ++n4) {
                        d7 = fArray2[n4] + f3;
                        d6 = fArray3[n4];
                        d5 = fArray4[n4];
                        d3 = d7 - (double)((int)(d5 + d6) >> 2);
                        d4 = d3 + d5;
                        d2 = d3 + d6;
                        objectArray[n2++] = (byte)(d4 <= 0.0 ? 0 : (d4 >= (double)f2 ? 255 : (int)d4 >> n));
                        objectArray[n2++] = (byte)(d3 <= 0.0 ? 0 : (d3 >= (double)f2 ? 255 : (int)d3 >> n));
                        objectArray[n2++] = (byte)(d2 <= 0.0 ? 0 : (d2 >= (double)f2 ? 255 : (int)d2 >> n));
                        if (fArray == null) continue;
                        d = fArray[n4];
                        objectArray[n2++] = (byte)(d <= (double)f ? 0 : (d >= (double)f4 ? 255 : (int)(d + (double)f3) >> n));
                    }
                }
            } else {
                for (n4 = 0; n4 < n3; ++n4) {
                    float[] fArray5 = subbandCoefficientArray[n4].floatItems;
                    n = info.siz.precisionInfo[n4][0] + 1 - 8;
                    f3 = (float)(128 << n) + 0.5f;
                    f2 = (int)(127.5f * (float)(1 << n));
                    f = -f2;
                    n2 = n4;
                    for (int j = 0; j < fArray5.length; ++j) {
                        float f5 = fArray5[j];
                        objectArray[n2] = (byte)(f5 <= f ? 0 : (f5 >= f2 ? 255 : (int)(f5 + f3) >> n));
                        n2 += n3;
                    }
                }
            }
            arrayList.add(subbandCoefficient2);
        }
        info.tilesMap.clear();
        if (arrayList.size() == 1) {
            byArray2 = ((SubbandCoefficient)arrayList.get((int)0)).byteItems;
        } else {
            byArray2 = new byte[sIZ.nComp * sIZ.Xsiz * sIZ.Ysiz];
            int n5 = sIZ.nComp;
            int n6 = sIZ.Xsiz * n5;
            for (SubbandCoefficient subbandCoefficient2 : arrayList) {
                objectArray = subbandCoefficient2.byteItems;
                n = subbandCoefficient2.x;
                int n7 = subbandCoefficient2.y;
                int n8 = subbandCoefficient2.width;
                int n9 = subbandCoefficient2.height;
                int n10 = n8 * n5;
                n2 = n * n5;
                for (int i = 0; i < n9; ++i) {
                    int n11 = i * n10;
                    int n12 = (i + n7) * n6 + n2;
                    System.arraycopy(objectArray, n11, byArray2, n12, n10);
                }
                subbandCoefficient2.byteItems = null;
            }
        }
        boolean bl2 = bl = info.palette != null && info.siz.nComp == 1;
        if (bl) {
            byte[] byArray3 = new byte[info.palette.nColumns * sIZ.Xsiz * sIZ.Ysiz];
            int n13 = 0;
            for (int i = 0; i < byArray2.length; ++i) {
                objectArray = info.palette.cValues[byArray2[i] & 0xFF];
                for (n = 0; n < objectArray.length; ++n) {
                    byArray3[n13] = objectArray[n];
                    ++n13;
                }
            }
            byArray2 = byArray3;
        }
        if (info.enumerateCS == 12) {
            EnumeratedSpace enumeratedSpace = new EnumeratedSpace();
            int n14 = 0;
            int n15 = 0;
            byte[] byArray4 = new byte[info.imageHeight * info.imageWidth * 3];
            for (int i = 0; i < byArray2.length; i += 4) {
                byte by = byArray2[n14++];
                byte by2 = byArray2[n14++];
                byte by3 = byArray2[n14++];
                n = byArray2[n14++];
                byte[] byArray5 = enumeratedSpace.getRGB(by, by2, by3, (byte)n);
                byArray4[n15++] = byArray5[0];
                byArray4[n15++] = byArray5[1];
                byArray4[n15++] = byArray5[2];
            }
            byArray2 = byArray4;
        }
        return byArray2;
    }
}

