/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.CodeBlock;
import com.idrsolutions.image.jpeg2000.Info;
import com.idrsolutions.image.jpeg2000.Packet;
import com.idrsolutions.image.jpeg2000.Progression;
import com.idrsolutions.image.jpeg2000.SIZ;
import com.idrsolutions.image.jpeg2000.Tile;
import com.idrsolutions.image.jpeg2000.TileBand;
import com.idrsolutions.image.jpeg2000.TileComponent;
import com.idrsolutions.image.jpeg2000.TileResolution;

public class LRCP
implements Progression {
    private final int layersCount;
    private final int componentsCount;
    private final int maxNL;
    private final Tile tile;
    private int comp;
    private int res;
    private int layer;
    private int prec;

    public LRCP(Info info, int n) {
        SIZ sIZ = info.siz;
        this.tile = info.tilesMap.get(n);
        this.layersCount = this.tile.cod.nLayers;
        this.componentsCount = sIZ.nComp;
        this.maxNL = this.tile.cod.nDecompLevel;
    }

    @Override
    public Packet getNextPacket() {
        while (this.layer < this.layersCount) {
            while (this.res <= this.maxNL) {
                while (this.comp < this.componentsCount) {
                    TileComponent tileComponent = this.tile.components.get(this.comp);
                    if (this.res > this.maxNL) continue;
                    TileResolution tileResolution = tileComponent.resolutions.get(this.res);
                    int n = tileResolution.precinctInfo.numPrecincts;
                    if (this.prec < n) {
                        Packet packet = this.createPacket(tileResolution, this.prec, this.layer);
                        ++this.prec;
                        return packet;
                    }
                    this.prec = 0;
                    ++this.comp;
                }
                this.comp = 0;
                ++this.res;
            }
            this.res = 0;
            ++this.layer;
        }
        return null;
    }

    @Override
    public Packet createPacket(TileResolution tileResolution, int n, int n2) {
        Packet packet = new Packet();
        packet.layerNumber = n2;
        for (TileBand tileBand : tileResolution.tileBands) {
            for (CodeBlock codeBlock : tileBand.codeBlocks) {
                if (codeBlock.precinctNumber != n) continue;
                packet.codeBlocks.add(codeBlock);
            }
        }
        return packet;
    }
}

