/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.TreeNode;

public class QuadTree {
    private final TreeNode[] nodeMap;
    private int value;
    private int currentLevel;

    public QuadTree(int n, int n2) {
        int n3 = Math.max(n, n2);
        int n4 = 1;
        int n5 = 0;
        while (n3 > n4) {
            n4 <<= 1;
            ++n5;
        }
        int n6 = n5 + 1;
        this.nodeMap = new TreeNode[n6];
        for (int i = 0; i < n6; ++i) {
            TreeNode treeNode;
            this.nodeMap[i] = treeNode = new TreeNode(n, n2);
            n = n + 1 >> 1;
            n2 = n2 + 1 >> 1;
        }
    }

    public void reset(int n, int n2) {
        TreeNode treeNode;
        int n3;
        int n4 = 0;
        int n5 = this.nodeMap.length;
        for (n3 = 0; n3 < n5; ++n3) {
            treeNode = this.nodeMap[n3];
            int n6 = n + n2 * treeNode.width;
            int n7 = treeNode.items[n6];
            if (n7 != -1) {
                n4 = n7;
                break;
            }
            treeNode.index = n6;
            n >>= 1;
            n2 >>= 1;
        }
        treeNode = this.nodeMap[--n3];
        treeNode.items[treeNode.index] = n4;
        this.currentLevel = n3;
        this.value = 0;
    }

    public void incrementValue() {
        TreeNode treeNode = this.nodeMap[this.currentLevel];
        int n = treeNode.index;
        treeNode.items[n] = treeNode.items[n] + 1;
    }

    public boolean nextNode() {
        int n = this.currentLevel;
        TreeNode treeNode = this.nodeMap[n];
        int n2 = treeNode.items[treeNode.index];
        if (--n < 0) {
            this.value = n2;
            return false;
        }
        this.currentLevel = n;
        treeNode = this.nodeMap[n];
        treeNode.items[treeNode.index] = n2;
        return true;
    }

    public int getValue() {
        return this.value;
    }
}

