/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

public class D3 {
    public final int r;
    public final int g;
    public final int b;
    public final int rgb;

    public D3(int n, int n2, int n3) {
        this.r = n;
        this.g = n2;
        this.b = n3;
        this.rgb = n << 16 | n2 << 8 | n3;
    }

    private static int diff(int n, int n2, int n3, D3 d3) {
        int n4 = n - d3.r;
        int n5 = n2 - d3.g;
        int n6 = n3 - d3.b;
        return n4 * n4 + n5 * n5 + n6 * n6;
    }

    public static int[] findClosest(int n, D3[] d3Array) {
        D3 d3 = d3Array[0];
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = D3.diff(n2, n3, n4, d3);
        int n6 = 0;
        for (int i = 1; i < 256; ++i) {
            D3 d32 = d3Array[i];
            int n7 = D3.diff(n2, n3, n4, d32);
            if (n7 >= n5) continue;
            d3 = d32;
            n6 = i;
            n5 = n7;
        }
        return new int[]{d3.rgb, n6};
    }

    public static byte[] process(byte[] byArray, int[][] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        D3[] d3Array = new D3[256];
        for (int i = 0; i < 256; ++i) {
            n5 = byArray[n6++] & 0xFF;
            n4 = byArray[n6++] & 0xFF;
            n3 = byArray[n6++] & 0xFF;
            d3Array[i] = new D3(n5, n4, n3);
        }
        byte[] byArray2 = new byte[n * n2];
        n6 = 0;
        for (n5 = 0; n5 < n; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                int n7;
                n3 = nArray[n5][n4];
                int[] nArray2 = D3.findClosest(n3, d3Array);
                int n8 = nArray2[0];
                byArray2[n6++] = (byte)nArray2[1];
                int n9 = n3 >> 16 & 0xFF;
                int n10 = n3 >> 8 & 0xFF;
                int n11 = n3 & 0xFF;
                int n12 = n8 >> 16 & 0xFF;
                int n13 = n8 >> 8 & 0xFF;
                int n14 = n8 & 0xFF;
                int n15 = n9 - n12;
                int n16 = n10 - n13;
                int n17 = n11 - n14;
                if (n4 + 1 < n2) {
                    nArray[n5][n4 + 1] = n7 = D3.applyFloyd(nArray[n5][n4 + 1], n15, n16, n17, 7);
                    if (n5 + 1 < n) {
                        nArray[n5 + 1][n4 + 1] = n7 = D3.applyFloyd(nArray[n5 + 1][n4 + 1], n15, n16, n17, 1);
                    }
                }
                if (n5 + 1 >= n) continue;
                nArray[n5 + 1][n4] = n7 = D3.applyFloyd(nArray[n5 + 1][n4], n15, n16, n17, 5);
                if (n4 - 1 < 0) continue;
                nArray[n5 + 1][n4 - 1] = n7 = D3.applyFloyd(nArray[n5 + 1][n4 - 1], n15, n16, n17, 3);
            }
        }
        return byArray2;
    }

    private static int applyFloyd(int n, int n2, int n3, int n4, int n5) {
        int n6 = n >> 16 & 0xFF;
        int n7 = n >> 8 & 0xFF;
        int n8 = n & 0xFF;
        n7 += n3 * n5 / 16;
        n8 += n4 * n5 / 16;
        if ((n6 += n2 * n5 / 16) < 0) {
            n6 = 0;
        } else if (n6 > 255) {
            n6 = 255;
        }
        if (n7 < 0) {
            n7 = 0;
        } else if (n7 > 255) {
            n7 = 255;
        }
        if (n8 < 0) {
            n8 = 0;
        } else if (n8 > 255) {
            n8 = 255;
        }
        return n6 << 16 | n7 << 8 | n8;
    }
}

