/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

import com.idrsolutions.image.BitWriter;
import com.idrsolutions.image.png.D3;
import com.idrsolutions.image.png.D4;
import com.idrsolutions.image.png.PngBitReader;
import com.idrsolutions.image.png.PngChunk;
import com.idrsolutions.image.png.Quant24;
import com.idrsolutions.image.png.Quant32;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.zip.Deflater;

public class PngEncoder {
    private boolean compress;

    public void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        if (this.compress) {
            this.compress8Bit(bufferedImage, outputStream);
        } else {
            this.compressNormal(bufferedImage, outputStream);
        }
    }

    public boolean isCompressed() {
        return this.compress;
    }

    public void setCompressed(boolean bl) {
        this.compress = bl;
    }

    private void compressNormal(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        int n;
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage.getWidth();
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl = colorModel.hasAlpha();
        int n4 = colorModel.getPixelSize();
        int n5 = colorModel.getNumComponents();
        boolean bl2 = colorModel instanceof IndexColorModel;
        int n6 = PngEncoder.calculateBitDepth(n4, n5);
        if (bl2) {
            n = 3;
            n5 = 1;
        } else {
            n = n5 < 3 ? (bl ? 4 : 0) : (n6 < 8 ? (bl ? 4 : 0) : (bl ? 6 : 2));
        }
        outputStream.write(PngChunk.SIGNATURE);
        PngChunk pngChunk = PngChunk.createHeaderChunk(n3, n2, (byte)n6, (byte)n, (byte)0, (byte)0, (byte)0);
        outputStream.write(pngChunk.getLength());
        outputStream.write(pngChunk.getName());
        outputStream.write(pngChunk.getData());
        outputStream.write(pngChunk.getCRCValue());
        byte[] byArray = bl2 && n6 != 8 ? PngEncoder.getIndexedPaletteData(bufferedImage) : PngEncoder.getPixelData(bufferedImage, n6, n5, n3, n2);
        if (bl2) {
            int n7;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n8 = indexColorModel.getMapSize();
            int[] nArray = new int[n8];
            indexColorModel.getRGBs(nArray);
            if (n6 == 8) {
                n8 = PngEncoder.reduceIndexMap(n8, nArray, byArray);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(n8 * 3);
            for (int i = 0; i < n8; ++i) {
                n7 = nArray[i];
                byteBuffer.put(new byte[]{(byte)(n7 >> 16), (byte)(n7 >> 8), (byte)n7});
            }
            pngChunk = PngChunk.createPaleteChunk(byteBuffer.array());
            outputStream.write(pngChunk.getLength());
            outputStream.write(pngChunk.getName());
            outputStream.write(pngChunk.getData());
            outputStream.write(pngChunk.getCRCValue());
            if (indexColorModel.getNumComponents() == 4) {
                byte[] byArray2 = new byte[n8];
                for (n7 = 0; n7 < n8; ++n7) {
                    byArray2[n7] = (byte)(nArray[n7] >> 24);
                }
                pngChunk = PngChunk.createTrnsChunk(byArray2);
                outputStream.write(pngChunk.getLength());
                outputStream.write(pngChunk.getName());
                outputStream.write(pngChunk.getData());
                outputStream.write(pngChunk.getCRCValue());
            }
        }
        byArray = this.getDeflatedData(byArray);
        pngChunk = PngChunk.createDataChunk(byArray);
        outputStream.write(pngChunk.getLength());
        outputStream.write(pngChunk.getName());
        outputStream.write(pngChunk.getData());
        outputStream.write(pngChunk.getCRCValue());
        pngChunk = PngChunk.createEndChunk();
        outputStream.write(pngChunk.getLength());
        outputStream.write(pngChunk.getName());
        outputStream.write(pngChunk.getData());
        outputStream.write(pngChunk.getCRCValue());
    }

    private static int reduceIndexMap(int n, int[] nArray, byte[] byArray) {
        int n2;
        int n3;
        int n4 = 0;
        byte[] byArray2 = new byte[n];
        LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray[n3];
            if (!linkedHashMap.containsKey(n2)) {
                byArray2[n3] = (byte)n4;
                linkedHashMap.put(n2, n4);
                ++n4;
                continue;
            }
            byArray2[n3] = (byte)((Integer)linkedHashMap.get(n2)).intValue();
        }
        if (n4 < n) {
            for (n3 = 0; n3 < byArray.length; ++n3) {
                byArray[n3] = byArray2[byArray[n3] & 0xFF];
            }
            Set set = linkedHashMap.keySet();
            n2 = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int n5 = (Integer)iterator.next();
                nArray[n2++] = n5;
            }
        }
        return n4;
    }

    private static boolean isAlphaUsed(byte[] byArray) {
        for (byte by : byArray) {
            if (by == -1) continue;
            return true;
        }
        return false;
    }

    private void compress8Bit(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray;
        byte[] byArray2;
        Object[] objectArray;
        int n2 = bufferedImage.getType();
        int n3 = bufferedImage.getHeight();
        int n4 = bufferedImage.getWidth();
        int n5 = n3 * n4;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        int[][] nArray = null;
        int[][] nArray2 = null;
        int n6 = 0;
        switch (n2) {
            case 5: {
                int n7;
                int n8;
                int n9;
                int n10;
                int[] nArray3;
                int n11;
                byArray3 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                nArray2 = new int[n3][n4];
                for (n11 = 0; n11 < n3; ++n11) {
                    nArray3 = nArray2[n11];
                    for (n10 = 0; n10 < n4; ++n10) {
                        n9 = byArray3[n6++] & 0xFF;
                        n8 = byArray3[n6++] & 0xFF;
                        n7 = byArray3[n6++] & 0xFF;
                        nArray3[n10] = n7 << 16 | n8 << 8 | n9;
                    }
                }
                break;
            }
            case 6: {
                int n7;
                int n8;
                int n9;
                int n10;
                int[] nArray3;
                int n11;
                byArray3 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                nArray = new int[n3][n4];
                for (n11 = 0; n11 < n3; ++n11) {
                    nArray3 = nArray[n11];
                    for (n10 = 0; n10 < n4; ++n10) {
                        int n12 = byArray3[n6++] & 0xFF;
                        n9 = byArray3[n6++] & 0xFF;
                        n8 = byArray3[n6++] & 0xFF;
                        n7 = byArray3[n6++] & 0xFF;
                        nArray3[n10] = n12 << 24 | n7 << 16 | n8 << 8 | n9;
                    }
                }
                break;
            }
            case 4: {
                int n7;
                int n8;
                int n9;
                int n10;
                int[] nArray3;
                int n11;
                int[] nArray4 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                nArray2 = new int[n3][n4];
                for (n11 = 0; n11 < n3; ++n11) {
                    nArray3 = nArray2[n11];
                    for (n10 = 0; n10 < n4; ++n10) {
                        int n13 = nArray4[n6++];
                        n9 = n13 >> 16 & 0xFF;
                        n8 = n13 >> 8 & 0xFF;
                        n7 = n13 & 0xFF;
                        nArray3[n10] = n7 << 16 | n8 << 8 | n9;
                    }
                }
                break;
            }
            case 2: {
                int n10;
                int[] nArray3;
                int n11;
                int[] nArray4 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                nArray = new int[n3][n4];
                for (n11 = 0; n11 < n3; ++n11) {
                    nArray3 = nArray[n11];
                    for (n10 = 0; n10 < n4; ++n10) {
                        nArray3[n10] = nArray4[n6++];
                    }
                }
                break;
            }
            case 1: {
                int n10;
                int[] nArray3;
                int n11;
                int[] nArray4 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                nArray2 = new int[n3][n4];
                for (n11 = 0; n11 < n3; ++n11) {
                    nArray3 = nArray2[n11];
                    for (n10 = 0; n10 < n4; ++n10) {
                        nArray3[n10] = nArray4[n6++];
                    }
                }
                break;
            }
            default: {
                this.compressNormal(bufferedImage, outputStream);
                return;
            }
        }
        byte[] byArray5 = new byte[n5 + n3];
        if (nArray != null) {
            objectArray = PngEncoder.getIndexedMap(nArray);
            if (objectArray != null) {
                byArray2 = (byte[])objectArray[0];
                byArray = (byte[])objectArray[1];
                byArray4 = (byte[])objectArray[2];
                if (!PngEncoder.isAlphaUsed(byArray4)) {
                    byArray4 = null;
                }
            } else {
                Quant32 quant32 = new Quant32();
                Object[] objectArray2 = quant32.getPalette(nArray);
                byArray = (byte[])objectArray2[0];
                byArray4 = (byte[])objectArray2[1];
                byArray2 = D4.process(byArray, byArray4, nArray, n3, n4);
                if (!PngEncoder.isAlphaUsed(byArray4)) {
                    byArray4 = null;
                }
            }
            n = 0;
            int n14 = 0;
            for (int i = 0; i < n3; ++i) {
                byArray5[n14++] = 0;
                for (int j = 0; j < n4; ++j) {
                    byArray5[n14++] = byArray2[n++];
                }
            }
        } else {
            objectArray = PngEncoder.getIndexedMap(nArray2);
            if (objectArray != null) {
                byArray2 = (byte[])objectArray[0];
                byArray = (byte[])objectArray[1];
            } else {
                Quant24 quant24 = new Quant24();
                byArray = quant24.getPalette(nArray2);
                byArray2 = D3.process(byArray, nArray2, n3, n4);
            }
            n = 0;
            int n15 = 0;
            for (int i = 0; i < n3; ++i) {
                byArray5[n15++] = 0;
                for (int j = 0; j < n4; ++j) {
                    byArray5[n15++] = byArray2[n++];
                }
            }
        }
        byArray3 = null;
        nArray2 = null;
        nArray = null;
        int n16 = 8;
        int n17 = 3;
        outputStream.write(PngChunk.SIGNATURE);
        PngChunk pngChunk = PngChunk.createHeaderChunk(n4, n3, (byte)n16, (byte)n17, (byte)0, (byte)0, (byte)0);
        outputStream.write(pngChunk.getLength());
        outputStream.write(pngChunk.getName());
        outputStream.write(pngChunk.getData());
        outputStream.write(pngChunk.getCRCValue());
        byArray3 = this.getDeflatedData(byArray5);
        pngChunk = PngChunk.createPaleteChunk(byArray);
        outputStream.write(pngChunk.getLength());
        outputStream.write(pngChunk.getName());
        outputStream.write(pngChunk.getData());
        outputStream.write(pngChunk.getCRCValue());
        if (byArray4 != null) {
            pngChunk = PngChunk.createTrnsChunk(byArray4);
            outputStream.write(pngChunk.getLength());
            outputStream.write(pngChunk.getName());
            outputStream.write(pngChunk.getData());
            outputStream.write(pngChunk.getCRCValue());
        }
        pngChunk = PngChunk.createDataChunk(byArray3);
        outputStream.write(pngChunk.getLength());
        outputStream.write(pngChunk.getName());
        outputStream.write(pngChunk.getData());
        outputStream.write(pngChunk.getCRCValue());
        pngChunk = PngChunk.createEndChunk();
        outputStream.write(pngChunk.getLength());
        outputStream.write(pngChunk.getName());
        outputStream.write(pngChunk.getData());
        outputStream.write(pngChunk.getCRCValue());
    }

    public static Object[] getIndexedMap(int[][] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        int[] nArray2 = new int[256];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray = new byte[n2 * n3];
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < n2; ++i) {
            int[] nArray3 = nArray[i];
            for (int j = 0; j < n3; ++j) {
                n = nArray3[j];
                Integer n7 = (Integer)hashMap.get(n);
                if (n7 == null) {
                    if (n4 > 255) {
                        return null;
                    }
                    hashMap.put(n, n4);
                    nArray2[n4] = n;
                    byArray[n5++] = (byte)n4;
                    ++n4;
                    continue;
                }
                byArray[n5++] = (byte)n7.intValue();
            }
        }
        byte[] byArray2 = new byte[n4 * 3];
        byte[] byArray3 = new byte[n4];
        n5 = 0;
        for (n = 0; n < n4; ++n) {
            int n8 = nArray2[n];
            byArray3[n6++] = (byte)(n8 >> 24 & 0xFF);
            byArray2[n5++] = (byte)(n8 >> 16 & 0xFF);
            byArray2[n5++] = (byte)(n8 >> 8 & 0xFF);
            byArray2[n5++] = (byte)(n8 & 0xFF);
        }
        return new Object[]{byArray, byArray2, byArray3};
    }

    private static byte[] getIndexedPaletteData(BufferedImage bufferedImage) throws IOException {
        byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        int n = bufferedImage.getHeight();
        int n2 = byArray.length / n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            byteArrayOutputStream.write(0);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n3, byArray2, 0, n2);
            byteArrayOutputStream.write(byArray2);
            n3 += n2;
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] getPixelData(BufferedImage bufferedImage, int n, int n2, int n3, int n4) throws IOException {
        ColorModel colorModel = bufferedImage.getColorModel();
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n5 = n == 1 ? 8 : (n == 2 ? 4 : 2);
                PngBitReader pngBitReader = new PngBitReader(byArray, true);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BitWriter bitWriter = new BitWriter(byteArrayOutputStream);
                int n6 = 0;
                int n7 = byArray.length * n5;
                for (int i = 0; i < n7; ++i) {
                    if (n6 == 0) {
                        bitWriter.writeByte((byte)0);
                    }
                    bitWriter.writeBits(pngBitReader.getPositive(n), n);
                    if (++n6 != n3) continue;
                    n6 = 0;
                }
                bitWriter.end();
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
                return byteArrayOutputStream.toByteArray();
            }
            case 8: {
                DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
                switch (dataBuffer.getDataType()) {
                    case 0: {
                        byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                        int n8 = byArray.length;
                        int n9 = 0;
                        ByteBuffer byteBuffer = ByteBuffer.allocate(n3 * n4 * n2 + n4);
                        switch (bufferedImage.getType()) {
                            case 5: {
                                for (int i = 0; i < n8; i += n2) {
                                    if (n9 == 0) {
                                        byteBuffer.put((byte)0);
                                    }
                                    byte[] byArray2 = new byte[]{byArray[i + 2], byArray[i + 1], byArray[i]};
                                    byteBuffer.put(byArray2);
                                    if (++n9 != n3) continue;
                                    n9 = 0;
                                }
                                return byteBuffer.array();
                            }
                            case 6: 
                            case 7: {
                                for (int i = 0; i < n8; i += n2) {
                                    if (n9 == 0) {
                                        byteBuffer.put((byte)0);
                                    }
                                    byte[] byArray3 = new byte[]{byArray[i + 3], byArray[i + 2], byArray[i + 1], byArray[i]};
                                    byteBuffer.put(byArray3);
                                    if (++n9 != n3) continue;
                                    n9 = 0;
                                }
                                return byteBuffer.array();
                            }
                        }
                        for (int i = 0; i < n8; i += n2) {
                            if (n9 == 0) {
                                byteBuffer.put((byte)0);
                            }
                            for (int j = 0; j < n2; ++j) {
                                byteBuffer.put(byArray[i + j]);
                            }
                            if (++n9 != n3) continue;
                            n9 = 0;
                        }
                        return byteBuffer.array();
                    }
                    case 3: {
                        byte[] byArray;
                        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                        int n10 = 0;
                        int n11 = 0;
                        if (bufferedImage.getType() == 2 || bufferedImage.getType() == 3) {
                            byArray = new byte[n3 * n4 * 4 + n4];
                            for (int i = 0; i < n4; ++i) {
                                byArray[n10++] = 0;
                                for (int j = 0; j < n3; ++j) {
                                    int n12 = nArray[n11++];
                                    byArray[n10++] = (byte)(n12 >> 16);
                                    byArray[n10++] = (byte)(n12 >> 8);
                                    byArray[n10++] = (byte)n12;
                                    byArray[n10++] = (byte)(n12 >> 24);
                                }
                            }
                        } else if (bufferedImage.getType() == 1) {
                            byArray = new byte[n3 * n4 * 3 + n4];
                            for (int i = 0; i < n4; ++i) {
                                byArray[n10++] = 0;
                                for (int j = 0; j < n3; ++j) {
                                    int n13 = nArray[n11++];
                                    byArray[n10++] = (byte)(n13 >> 16);
                                    byArray[n10++] = (byte)(n13 >> 8);
                                    byArray[n10++] = (byte)n13;
                                }
                            }
                        } else if (bufferedImage.getType() == 4) {
                            byArray = new byte[n3 * n4 * 3 + n4];
                            for (int i = 0; i < n4; ++i) {
                                byArray[n10++] = 0;
                                for (int j = 0; j < n3; ++j) {
                                    int n14 = nArray[n11++];
                                    byArray[n10++] = (byte)n14;
                                    byArray[n10++] = (byte)(n14 >> 8);
                                    byArray[n10++] = (byte)(n14 >> 16);
                                }
                            }
                        } else if (colorModel instanceof DirectColorModel) {
                            DirectColorModel directColorModel = (DirectColorModel)colorModel;
                            long l = PngEncoder.getMaskValue(directColorModel.getRedMask());
                            long l2 = PngEncoder.getMaskValue(directColorModel.getGreenMask());
                            long l3 = PngEncoder.getMaskValue(directColorModel.getBlueMask());
                            long l4 = PngEncoder.getMaskValue(directColorModel.getAlphaMask());
                            byArray = new byte[n3 * n4 * 4 + n4];
                            for (int i = 0; i < n4; ++i) {
                                byArray[n10++] = 0;
                                for (int j = 0; j < n3; ++j) {
                                    int n15 = nArray[n11++];
                                    byArray[n10++] = (byte)(n15 >> (int)l);
                                    byArray[n10++] = (byte)(n15 >> (int)l2);
                                    byArray[n10++] = (byte)(n15 >> (int)l3);
                                    byArray[n10++] = (byte)(n15 >> (int)l4);
                                }
                            }
                        } else {
                            ByteBuffer byteBuffer = ByteBuffer.allocate(n3 * n4 * n2 + n4);
                            int n16 = 0;
                            for (int n17 : nArray) {
                                if (n16 == 0) {
                                    byteBuffer.put((byte)0);
                                }
                                byte[] byArray4 = PngChunk.intToBytes(n17);
                                switch (n2) {
                                    case 4: {
                                        byteBuffer.put(new byte[]{byArray4[1], byArray4[2], byArray4[3], byArray4[0]});
                                        break;
                                    }
                                    case 3: {
                                        byteBuffer.put(new byte[]{byArray4[1], byArray4[2], byArray4[3]});
                                        break;
                                    }
                                    case 2: {
                                        byteBuffer.put(new byte[]{byArray4[2], byArray4[3]});
                                        break;
                                    }
                                    case 1: {
                                        byteBuffer.put(byArray4[3]);
                                    }
                                }
                                if (++n16 != n3) continue;
                                n16 = 0;
                            }
                            return byteBuffer.array();
                        }
                        return byArray;
                    }
                }
            }
            case 16: {
                short[] sArray = ((DataBufferUShort)bufferedImage.getRaster().getDataBuffer()).getData();
                ByteBuffer byteBuffer = ByteBuffer.allocate(sArray.length * 2 + n4);
                int n18 = 0;
                for (int i = 0; i < sArray.length; i += n2) {
                    if (n18 == 0) {
                        byteBuffer.put((byte)0);
                    }
                    for (int j = 0; j < n2; ++j) {
                        byteBuffer.putShort(sArray[i + j]);
                    }
                    if (++n18 != n3) continue;
                    n18 = 0;
                }
                return byteBuffer.array();
            }
        }
        return null;
    }

    private static int getMaskValue(int n) {
        switch (n) {
            case 255: {
                return 0;
            }
            case 65280: {
                return 8;
            }
            case 0xFF0000: {
                return 16;
            }
        }
        return 24;
    }

    private static int calculateBitDepth(int n, int n2) {
        if (n < 8) {
            return n;
        }
        int n3 = n / n2;
        if (n3 == 8 || n3 == 16) {
            return n3;
        }
        return 8;
    }

    private byte[] getDeflatedData(byte[] byArray) throws IOException {
        Deflater deflater = this.compress ? new Deflater(9) : new Deflater(1);
        deflater.setInput(byArray);
        int n = Math.min(byArray.length / 2, 4096);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        deflater.finish();
        byte[] byArray2 = new byte[n];
        while (!deflater.finished()) {
            int n2 = deflater.deflate(byArray2);
            byteArrayOutputStream.write(byArray2, 0, n2);
        }
        deflater.end();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

