/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PackBits {
    public static byte[] decompress(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2);
        int n3 = 0;
        while (n2 < n) {
            int n4;
            int n5;
            byte by;
            if (n3 >= byArray.length) {
                throw new IOException("Error in packbit decompression ");
            }
            if ((by = byArray[n3++]) >= 0 && by <= 127) {
                n5 = by + 1;
                n2 += n5;
                for (n4 = 0; n4 < n5; ++n4) {
                    byteArrayOutputStream.write(byArray[n3++]);
                }
                continue;
            }
            if (by >= -127 && by <= -1) {
                n5 = byArray[n3++];
                n4 = -by + 1;
                n2 += n4;
                for (int i = 0; i < n4; ++i) {
                    byteArrayOutputStream.write(n5);
                }
                continue;
            }
            if (by != -128) continue;
            throw new IOException("Error in packbit decompression ");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] compress(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4 = n * n3;
        int n5 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n5, byArray2, 0, n4);
            n5 += n4;
            byteArrayOutputStream.write(PackBits.compressRow(byArray2));
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] compressRow(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < byArray.length) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = PackBits.getNextDup(byArray, n);
            if (n6 == n) {
                n5 = PackBits.getNextRun(byArray, n6);
                n4 = Math.min(n5, 128);
                byteArrayOutputStream.write(-(n4 - 1));
                byteArrayOutputStream.write(byArray[n]);
                n += n4;
                continue;
            }
            n5 = n6 - n;
            if (n6 > 0 && (n4 = PackBits.getNextRun(byArray, n6)) < 3 && (n3 = PackBits.getNextDup(byArray, n2 = n + n5 + n4)) != n2) {
                n6 = n3;
                n5 = n6 - n;
            }
            if (n6 < 0) {
                n5 = byArray.length - n;
            }
            n4 = Math.min(n5, 128);
            byteArrayOutputStream.write(n4 - 1);
            for (n2 = 0; n2 < n4; ++n2) {
                byteArrayOutputStream.write(byArray[n]);
                ++n;
            }
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static int getNextDup(byte[] byArray, int n) {
        if (n >= byArray.length) {
            return -1;
        }
        byte by = byArray[n];
        for (int i = n + 1; i < byArray.length; ++i) {
            byte by2 = byArray[i];
            if (by2 == by) {
                return i - 1;
            }
            by = by2;
        }
        return -1;
    }

    private static int getNextRun(byte[] byArray, int n) {
        byte by = byArray[n];
        int n2 = 0;
        int n3 = byArray.length;
        int n4 = n + 1;
        while (n4 < n3 && byArray[n4] == by) {
            n2 = n4++;
        }
        return n2 - n;
    }
}

