/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RandomHandler {
    public static final int BIGENDIAN = 1;
    public static final int LITTLEENDIAN = 2;
    private int byteOrder = 1;
    private ByteBuffer buffer;
    private RandomAccessFile raf;
    private final boolean isBuff;

    public RandomHandler(byte[] byArray) {
        this.buffer = ByteBuffer.wrap(byArray);
        this.isBuff = true;
    }

    public RandomHandler(RandomAccessFile randomAccessFile) {
        this.raf = randomAccessFile;
        this.isBuff = false;
    }

    public int getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(int n) {
        this.byteOrder = n;
        if (this.isBuff) {
            if (n == 2) {
                this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.buffer.order(ByteOrder.BIG_ENDIAN);
            }
        }
    }

    public void get(byte[] byArray) throws IOException {
        if (this.isBuff) {
            this.buffer.get(byArray);
        } else {
            this.raf.read(byArray);
        }
    }

    public int getUint8() throws IOException {
        if (this.isBuff) {
            return this.buffer.get() & 0xFF;
        }
        return this.raf.read();
    }

    public int getUint8(int n) throws IOException {
        if (this.isBuff) {
            return this.buffer.get(n) & 0xFF;
        }
        this.raf.seek(n);
        return this.raf.read();
    }

    public int getUint16() throws IOException {
        if (this.isBuff) {
            return this.buffer.getShort() & 0xFFFF;
        }
        if (this.byteOrder == 1) {
            return this.raf.readUnsignedShort();
        }
        int n = this.raf.read();
        int n2 = this.raf.read();
        return n2 << 8 | n;
    }

    public int getUint16(int n) throws IOException {
        if (this.isBuff) {
            return this.buffer.getShort(n) & 0xFFFF;
        }
        this.raf.seek(n);
        if (this.byteOrder == 1) {
            return this.raf.readUnsignedShort();
        }
        int n2 = this.raf.read();
        int n3 = this.raf.read();
        return n3 << 8 | n2;
    }

    public int getInt() throws IOException {
        if (this.isBuff) {
            return this.buffer.getInt();
        }
        if (this.byteOrder == 1) {
            return this.raf.readInt();
        }
        int n = this.raf.read();
        int n2 = this.raf.read();
        int n3 = this.raf.read();
        int n4 = this.raf.read();
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    public int getInt(int n) throws IOException {
        if (this.isBuff) {
            return this.buffer.getInt(n);
        }
        this.raf.seek(n);
        if (this.byteOrder == 1) {
            return this.raf.readInt();
        }
        int n2 = this.raf.read();
        int n3 = this.raf.read();
        int n4 = this.raf.read();
        int n5 = this.raf.read();
        return n5 << 24 | n4 << 16 | n3 << 8 | n2;
    }

    public long getLong() throws IOException {
        if (this.isBuff) {
            return this.buffer.getLong();
        }
        if (this.byteOrder == 1) {
            return this.raf.readLong();
        }
        long l = this.raf.read();
        long l2 = this.raf.read();
        long l3 = this.raf.read();
        long l4 = this.raf.read();
        long l5 = this.raf.read();
        long l6 = this.raf.read();
        long l7 = this.raf.read();
        long l8 = this.raf.read();
        return l8 << 56 | l7 << 48 | l6 << 40 | l5 << 32 | l4 << 24 | l3 << 16 | l2 << 8 | l;
    }

    public int getPosition() throws IOException {
        if (this.isBuff) {
            return this.buffer.position();
        }
        return (int)this.raf.getFilePointer();
    }

    public void setPosition(int n) throws IOException {
        if (this.isBuff) {
            this.buffer.position(n);
        } else {
            this.raf.seek(n);
        }
    }
}

