/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import com.idrsolutions.image.jpeg2000.JPXBitReader;
import com.idrsolutions.image.tiff.CCITT;
import com.idrsolutions.image.tiff.Deflate;
import com.idrsolutions.image.tiff.IFD;
import com.idrsolutions.image.tiff.LZW;
import com.idrsolutions.image.tiff.PackBits;
import com.idrsolutions.image.tiff.RandomHandler;
import com.idrsolutions.image.tiff.Tile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class TiffDecoder {
    private final RandomHandler reader;
    private int pageCount;
    List<IFD> ifds = new ArrayList<IFD>();

    public TiffDecoder(byte[] byArray) throws Exception {
        this.reader = new RandomHandler(byArray);
        int n = this.reader.getUint8();
        int n2 = this.reader.getUint8();
        if (n == 77 && n2 == 77) {
            this.reader.setByteOrder(1);
        } else if (n == 73 && n2 == 73) {
            this.reader.setByteOrder(2);
        }
        int n3 = this.reader.getUint16();
        if (n3 != 42) {
            if (n3 == 43) {
                throw new Exception("Big Tiff File Support not added");
            }
            throw new Exception("This is not a valid Tiff File");
        }
        int n4 = this.reader.getInt();
        while (n4 != 0) {
            IFD iFD = TiffDecoder.getIFD(this.reader, n4);
            this.ifds.add(iFD);
            n4 = iFD.nextIFD;
            ++this.pageCount;
        }
    }

    public TiffDecoder(RandomAccessFile randomAccessFile) throws Exception {
        this.reader = new RandomHandler(randomAccessFile);
        int n = this.reader.getUint8();
        int n2 = this.reader.getUint8();
        if (n == 77 && n2 == 77) {
            this.reader.setByteOrder(1);
        } else if (n == 73 && n2 == 73) {
            this.reader.setByteOrder(2);
        }
        int n3 = this.reader.getUint16();
        if (n3 != 42) {
            if (n3 == 43) {
                throw new Exception("Big Tiff File Support not added");
            }
            throw new Exception("This is not a valid Tiff File");
        }
        int n4 = this.reader.getInt();
        while (n4 != 0) {
            IFD iFD = TiffDecoder.getIFD(this.reader, n4);
            this.ifds.add(iFD);
            n4 = iFD.nextIFD;
            ++this.pageCount;
        }
    }

    public BufferedImage read() throws Exception {
        return this.read(1);
    }

    public BufferedImage read(int n) throws Exception {
        if (n == 0) {
            throw new Exception("PageNumber should start from 1");
        }
        if (n > this.pageCount) {
            throw new Exception("PageNumber should not be greater than Total page count");
        }
        IFD iFD = this.ifds.get(n - 1);
        return TiffDecoder.generateImageFromIFD(this.reader, iFD);
    }

    private static IFD getIFD(RandomHandler randomHandler, int n) throws IOException {
        randomHandler.setPosition(n);
        int n2 = randomHandler.getUint16();
        IFD iFD = new IFD();
        block98: for (int i = 0; i < n2; ++i) {
            int n3 = randomHandler.getUint16();
            int n4 = randomHandler.getUint16();
            int n5 = randomHandler.getInt();
            int n6 = 0;
            switch (n3) {
                case 254: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 255: {
                    randomHandler.getUint16();
                    randomHandler.getUint16();
                    continue block98;
                }
                case 256: {
                    if (n4 == 3) {
                        iFD.imageWidth = randomHandler.getUint16();
                        randomHandler.getUint16();
                        continue block98;
                    }
                    iFD.imageWidth = randomHandler.getInt();
                    continue block98;
                }
                case 257: {
                    if (n4 == 3) {
                        iFD.imageHeight = randomHandler.getUint16();
                        randomHandler.getUint16();
                        continue block98;
                    }
                    iFD.imageHeight = randomHandler.getInt();
                    continue block98;
                }
                case 258: {
                    iFD.bps = new int[n5];
                    if (n5 == 1) {
                        iFD.bps[0] = randomHandler.getUint16();
                        randomHandler.getUint16();
                        continue block98;
                    }
                    if (n5 == 2) {
                        iFD.bps[0] = randomHandler.getUint16();
                        iFD.bps[1] = randomHandler.getUint16();
                        continue block98;
                    }
                    int n7 = randomHandler.getInt();
                    n6 = randomHandler.getPosition();
                    iFD.bps = TiffDecoder.readBitsPerSamples(randomHandler, n7, n5);
                    randomHandler.setPosition(n6);
                    continue block98;
                }
                case 259: {
                    iFD.compressionType = randomHandler.getUint16();
                    randomHandler.getUint16();
                    continue block98;
                }
                case 262: {
                    iFD.photometric = randomHandler.getUint16();
                    randomHandler.getUint16();
                    continue block98;
                }
                case 278: {
                    if (n4 == 3) {
                        iFD.rowsPerStrip = randomHandler.getUint16();
                        randomHandler.getUint16();
                        continue block98;
                    }
                    iFD.rowsPerStrip = randomHandler.getInt();
                    continue block98;
                }
                case 273: {
                    if (n5 == 1) {
                        iFD.stripOffsets = new int[1];
                        iFD.stripOffsets[0] = randomHandler.getInt();
                        continue block98;
                    }
                    int n7 = randomHandler.getInt();
                    n6 = randomHandler.getPosition();
                    iFD.stripOffsets = TiffDecoder.readOffsets(randomHandler, n7, n5, n4);
                    randomHandler.setPosition(n6);
                    continue block98;
                }
                case 279: {
                    if (n5 == 1) {
                        iFD.stripByteCounts = new int[1];
                        iFD.stripByteCounts[0] = randomHandler.getInt();
                        continue block98;
                    }
                    int n7 = randomHandler.getInt();
                    n6 = randomHandler.getPosition();
                    iFD.stripByteCounts = TiffDecoder.readStripTileByteCounts(randomHandler, n7, n5, n4);
                    randomHandler.setPosition(n6);
                    continue block98;
                }
                case 277: {
                    iFD.samplesPerPixel = randomHandler.getUint16();
                    randomHandler.getUint16();
                    continue block98;
                }
                case 320: {
                    int n7 = randomHandler.getInt();
                    n6 = randomHandler.getPosition();
                    iFD.colorMap = TiffDecoder.readColorMap(randomHandler, n7, n5);
                    randomHandler.setPosition(n6);
                    continue block98;
                }
                case 284: {
                    iFD.planarConfiguration = randomHandler.getUint16();
                    randomHandler.getUint16();
                    continue block98;
                }
                case 322: {
                    if (n4 == 3) {
                        iFD.tileWidth = randomHandler.getUint16();
                        randomHandler.getUint16();
                        continue block98;
                    }
                    iFD.tileWidth = randomHandler.getInt();
                    continue block98;
                }
                case 323: {
                    if (n4 == 3) {
                        iFD.tileLength = randomHandler.getUint16();
                        randomHandler.getUint16();
                        continue block98;
                    }
                    iFD.tileLength = randomHandler.getInt();
                    continue block98;
                }
                case 324: {
                    if (n5 == 1) {
                        iFD.tileOffsets = new int[1];
                        iFD.tileOffsets[0] = randomHandler.getInt();
                        continue block98;
                    }
                    int n8 = randomHandler.getInt();
                    int n9 = randomHandler.getPosition();
                    iFD.tileOffsets = TiffDecoder.readOffsets(randomHandler, n8, n5, n4);
                    randomHandler.setPosition(n9);
                    continue block98;
                }
                case 325: {
                    if (n5 == 1) {
                        iFD.tileByteCounts = new int[1];
                        iFD.tileByteCounts[0] = randomHandler.getInt();
                        continue block98;
                    }
                    int n8 = randomHandler.getInt();
                    int n9 = randomHandler.getPosition();
                    iFD.tileByteCounts = TiffDecoder.readStripTileByteCounts(randomHandler, n8, n5, n4);
                    randomHandler.setPosition(n9);
                    continue block98;
                }
                case 347: {
                    int n8 = randomHandler.getInt();
                    int n9 = randomHandler.getPosition();
                    randomHandler.setPosition(n8);
                    byte[] byArray = new byte[n5];
                    randomHandler.get(byArray);
                    randomHandler.setPosition(n9);
                    iFD.jpegTables = new byte[n5 - 2];
                    System.arraycopy(byArray, 0, iFD.jpegTables, 0, n5 - 2);
                    continue block98;
                }
                case 512: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 513: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 514: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 515: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 517: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 518: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 519: {
                    if (n5 == 1) {
                        iFD.jpegQOffsets = new int[1];
                        iFD.jpegQOffsets[0] = randomHandler.getInt();
                        continue block98;
                    }
                    int n10 = randomHandler.getInt();
                    int n11 = randomHandler.getPosition();
                    iFD.jpegQOffsets = TiffDecoder.readOffsets(randomHandler, n10, n5, n4);
                    randomHandler.setPosition(n11);
                    continue block98;
                }
                case 520: {
                    if (n5 == 1) {
                        iFD.jpegDCOffsets = new int[1];
                        iFD.jpegDCOffsets[0] = randomHandler.getInt();
                        continue block98;
                    }
                    int n10 = randomHandler.getInt();
                    int n11 = randomHandler.getPosition();
                    iFD.jpegDCOffsets = TiffDecoder.readOffsets(randomHandler, n10, n5, n4);
                    randomHandler.setPosition(n11);
                    continue block98;
                }
                case 521: {
                    if (n5 == 1) {
                        iFD.jpegACOffsets = new int[1];
                        iFD.jpegACOffsets[0] = randomHandler.getInt();
                        continue block98;
                    }
                    int n10 = randomHandler.getInt();
                    int n11 = randomHandler.getPosition();
                    iFD.jpegACOffsets = TiffDecoder.readOffsets(randomHandler, n10, n5, n4);
                    randomHandler.setPosition(n11);
                    continue block98;
                }
                case 34675: {
                    int n10 = randomHandler.getInt();
                    n6 = randomHandler.getPosition();
                    randomHandler.setPosition(n10);
                    iFD.iccProfile = new byte[n5];
                    randomHandler.get(iFD.iccProfile);
                    randomHandler.setPosition(n6);
                    continue block98;
                }
                case 529: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 530: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 531: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 263: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 264: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 265: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 266: {
                    iFD.fillOrder = randomHandler.getInt();
                    continue block98;
                }
                case 269: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 270: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 271: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 272: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 274: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 280: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 281: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 282: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 283: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 285: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 286: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 287: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 288: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 289: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 290: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 291: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 292: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 293: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 296: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 297: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 301: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 305: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 306: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 315: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 316: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 317: {
                    iFD.predictor = randomHandler.getUint16();
                    randomHandler.getUint16();
                    continue block98;
                }
                case 318: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 319: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 321: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 330: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 332: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 333: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 334: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 336: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 337: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 338: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 339: {
                    if (n5 == 1) {
                        iFD.sampleFormat = new int[1];
                        iFD.sampleFormat[0] = randomHandler.getInt();
                        continue block98;
                    }
                    int n11 = randomHandler.getInt();
                    n6 = randomHandler.getPosition();
                    iFD.sampleFormat = TiffDecoder.readOffsets(randomHandler, n11, n5, n4);
                    randomHandler.setPosition(n6);
                    continue block98;
                }
                case 340: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 341: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 342: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 343: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 344: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 345: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 346: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 532: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 559: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 700: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 32781: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 33432: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 34665: {
                    int n11 = randomHandler.getInt();
                    continue block98;
                }
                case 36864: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 36867: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 36868: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 37121: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 37122: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 37378: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 37393: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 37395: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 655361: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 40962: {
                    randomHandler.getInt();
                    continue block98;
                }
                case 40963: {
                    randomHandler.getInt();
                    continue block98;
                }
                default: {
                    randomHandler.getInt();
                }
            }
        }
        iFD.nextIFD = randomHandler.getInt();
        if (iFD.rowsPerStrip == 0 || iFD.rowsPerStrip > iFD.imageHeight) {
            iFD.rowsPerStrip = iFD.imageHeight;
        }
        return iFD;
    }

    private static BufferedImage getDataFromStrips(RandomHandler randomHandler, IFD iFD) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = iFD.imageWidth;
        int n13 = iFD.imageHeight;
        int n14 = n12 * n13;
        boolean bl = iFD.planarConfiguration == 2;
        boolean bl2 = iFD.colorMap != null;
        int n15 = iFD.rowsPerStrip;
        int n16 = iFD.bps[0];
        int n17 = 0;
        int n18 = n11 = bl ? 1 : iFD.bps.length;
        if (bl) {
            n17 = iFD.bps[0];
        } else {
            for (int i = 0; i < iFD.bps.length; ++i) {
                n17 += iFD.bps[i];
            }
        }
        ArrayList<Tile> arrayList = new ArrayList<Tile>();
        int n19 = iFD.stripOffsets.length / iFD.samplesPerPixel;
        for (int i = 0; i < iFD.stripOffsets.length; ++i) {
            int n20;
            int n21;
            randomHandler.setPosition(iFD.stripOffsets[i]);
            Object object = new byte[iFD.stripByteCounts[i]];
            randomHandler.get((byte[])object);
            int n22 = bl ? ((n10 = n13 - n15 * (n21 = i % n19)) < n15 ? n10 : n15) : ((n21 = n13 - n15 * i) < n15 ? n21 : n15);
            Object object2 = null;
            n9 = ((n12 * n17 + 7) / 8 * 8 * n22 + 7) / 8;
            switch (iFD.compressionType) {
                case 1: {
                    object2 = object;
                    break;
                }
                case 2: {
                    object2 = new byte[n9];
                    CCITT cCITT = new CCITT(iFD.fillOrder, n12, n22);
                    cCITT.decompress1D((byte[])object2, (byte[])object, 0, n22);
                    break;
                }
                case 3: {
                    object2 = new byte[n9];
                    CCITT cCITT = new CCITT(iFD.fillOrder, n12, n22);
                    cCITT.decompressFax3((byte[])object2, (byte[])object, n22);
                    break;
                }
                case 4: {
                    object2 = new byte[n9];
                    CCITT cCITT = new CCITT(iFD.fillOrder, n12, n22);
                    cCITT.decompressFax4((byte[])object2, (byte[])object, n22);
                    break;
                }
                case 5: {
                    object2 = new byte[n9];
                    LZW lZW = new LZW();
                    lZW.decompress((byte[])object2, (byte[])object, n12, n22);
                    break;
                }
                case 6: {
                    throw new Exception("Old style jpeg compression is not supported");
                }
                case 7: {
                    if (iFD.jpegTables != null) {
                        n20 = iFD.jpegTables.length;
                        byte[] byArray = new byte[n20 + ((Object)object).length - 2];
                        System.arraycopy(iFD.jpegTables, 0, byArray, 0, n20);
                        System.arraycopy(object, 2, byArray, n20, ((Object)object).length - 2);
                        object = byArray;
                    }
                    JpegDecoder jpegDecoder = new JpegDecoder();
                    object2 = jpegDecoder.readComponentsAsRawBytes((byte[])object);
                    break;
                }
                case 32773: {
                    int n23 = (n12 * n22 * n17 + 7) / 8;
                    object2 = PackBits.decompress((byte[])object, n23);
                    break;
                }
                case 8: 
                case 32946: {
                    object2 = Deflate.decompress((byte[])object);
                    break;
                }
                default: {
                    System.err.println("unrecognized compression found");
                }
            }
            if (iFD.predictor == 2) {
                for (n20 = 0; n20 < n22; ++n20) {
                    int n24 = n11 * (n20 * n12 + 1);
                    for (int j = n11; j < n12 * n11; ++j) {
                        Object object3 = object2;
                        int n25 = n24;
                        object3[n25] = (byte)(object3[n25] + object2[n24 - n11]);
                        ++n24;
                    }
                }
            }
            n8 = 0;
            if (iFD.photometric == 0) {
                for (n20 = 0; n20 < ((Object)object2).length; ++n20) {
                    object2[n20] = (byte)(object2[n8++] & 0xFF ^ 0xFF);
                }
            }
            Tile tile = new Tile();
            n7 = 0;
            n6 = n12 * n16 * n11 % 8;
            if (n16 != 8) {
                object = new byte[n22 * n12 * n11];
                JPXBitReader jPXBitReader = new JPXBitReader((byte[])object2);
                if (n16 == 1) {
                    for (n5 = 0; n5 < n22; ++n5) {
                        for (n4 = 0; n4 < n12 - 1; ++n4) {
                            for (n3 = 0; n3 < n11; ++n3) {
                                object[n7++] = bl2 ? (Object)((byte)jPXBitReader.readBits(n16)) : (Object)((byte)(jPXBitReader.readBits(n16) * 255));
                            }
                        }
                        if (n6 == 0) continue;
                        jPXBitReader.readBits(8 - n6);
                    }
                } else if (n16 < 8) {
                    n5 = 8 - n16;
                    for (n4 = 0; n4 < n22; ++n4) {
                        for (n3 = 0; n3 < n12; ++n3) {
                            for (n2 = 0; n2 < n11; ++n2) {
                                object[n7++] = bl2 ? (Object)((byte)jPXBitReader.readBits(n16)) : (Object)((byte)(jPXBitReader.readBits(n16) << n5));
                            }
                        }
                        if (n6 == 0) continue;
                        jPXBitReader.readBits(8 - n6);
                    }
                } else {
                    n5 = n16 - 8;
                    n4 = iFD.sampleFormat[0];
                    if (bl2) {
                        object = new byte[n22 * n12 * 3];
                        for (n3 = 0; n3 < n22; ++n3) {
                            for (n2 = 0; n2 < n12; ++n2) {
                                n = jPXBitReader.readBits(n16) * 3;
                                object[n7++] = iFD.colorMap[n++];
                                object[n7++] = iFD.colorMap[n++];
                                object[n7++] = iFD.colorMap[n++];
                            }
                            if (n6 == 0) continue;
                            jPXBitReader.readBits(8 - n6);
                        }
                    } else {
                        for (n3 = 0; n3 < n22; ++n3) {
                            for (n2 = 0; n2 < n12; ++n2) {
                                for (n = 0; n < n11; ++n) {
                                    object[n7++] = n4 == 3 ? (Object)((byte)(TiffDecoder.toFloat(jPXBitReader.readBits(n16), n16) * 255.0f)) : (Object)((byte)(jPXBitReader.readBits(n16) >> n5));
                                }
                            }
                            if (n6 == 0) continue;
                            jPXBitReader.readBits(8 - n6);
                        }
                    }
                }
            } else {
                object = object2;
            }
            tile.data = (byte[])object;
            arrayList.add(tile);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bl) {
            int n26 = iFD.samplesPerPixel;
            byte[][] byArray = new byte[n26][n14];
            int n27 = 0;
            n10 = arrayList.size() / n26;
            for (n9 = 0; n9 < n26; ++n9) {
                for (n8 = 0; n8 < n10; ++n8) {
                    byteArrayOutputStream.write(((Tile)arrayList.get((int)n27++)).data);
                }
                byArray[n9] = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.reset();
            }
            for (n9 = 0; n9 < n14; ++n9) {
                for (n8 = 0; n8 < n26; ++n8) {
                    byteArrayOutputStream.write(byArray[n8][n9]);
                }
            }
        } else {
            for (Tile tile : arrayList) {
                byteArrayOutputStream.write(tile.data);
            }
        }
        BufferedImage bufferedImage = TiffDecoder.allocateBufferedImage(iFD);
        n5 = 0;
        byte[] byArray = byteArrayOutputStream.toByteArray();
        switch (iFD.photometric) {
            case 6: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n14; ++i) {
                    n7 = byArray[n5++] & 0xFF;
                    n6 = byArray[n5++] & 0xFF;
                    int n28 = byArray[n5++] & 0xFF;
                    int n29 = (n6 -= 128) >> 2;
                    int n30 = ((n28 -= 128) >> 3) + (n28 >> 5);
                    n10 = n7 + n28 + (n28 >> 2) + n30;
                    n9 = n7 - (n29 + (n6 >> 4) + (n6 >> 5)) - ((n28 >> 1) + n30 + (n28 >> 4));
                    n8 = n7 + n6 + (n6 >> 1) + n29 + (n6 >> 6);
                    int n31 = n10 < 0 ? 0 : (n10 = n10 > 255 ? 255 : n10);
                    int n32 = n9 < 0 ? 0 : (n9 = n9 > 255 ? 255 : n9);
                    n8 = n8 < 0 ? 0 : (n8 > 255 ? 255 : n8);
                    nArray[i] = n10 << 16 | n9 << 8 | n8;
                }
                break;
            }
            case 2: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                if (iFD.samplesPerPixel == 3) {
                    for (int i = 0; i < n14; ++i) {
                        n10 = byArray[n5++] & 0xFF;
                        n9 = byArray[n5++] & 0xFF;
                        n8 = byArray[n5++] & 0xFF;
                        nArray[i] = n10 << 16 | n9 << 8 | n8;
                    }
                } else {
                    for (int i = 0; i < n14; ++i) {
                        n10 = byArray[n5++] & 0xFF;
                        n9 = byArray[n5++] & 0xFF;
                        n8 = byArray[n5++] & 0xFF;
                        int n33 = byArray[n5++] & 0xFF;
                        nArray[i] = n33 << 24 | n10 << 16 | n9 << 8 | n8;
                    }
                }
                break;
            }
            case 5: {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                EnumeratedSpace enumeratedSpace = new EnumeratedSpace();
                for (int i = 0; i < n14; ++i) {
                    n4 = byArray[n5++];
                    n3 = byArray[n5++];
                    n2 = byArray[n5++];
                    n = byArray[n5++];
                    byte[] byArray2 = enumeratedSpace.getRGB((byte)n4, (byte)n3, (byte)n2, (byte)n);
                    nArray[i] = (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF;
                }
                break;
            }
            case 3: {
                if (iFD.bps[0] > 8) {
                    int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    for (int i = 0; i < n14; ++i) {
                        n10 = byArray[n5++] & 0xFF;
                        n9 = byArray[n5++] & 0xFF;
                        n8 = byArray[n5++] & 0xFF;
                        nArray[i] = n10 << 16 | n9 << 8 | n8;
                    }
                    break;
                }
                byte[] byArray3 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n34 = Math.min(byArray3.length, byArray.length);
                System.arraycopy(byArray, 0, byArray3, 0, n34);
                break;
            }
            default: {
                byte[] byArray4 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n35 = Math.min(byArray4.length, byArray.length);
                System.arraycopy(byArray, 0, byArray4, 0, n35);
            }
        }
        return bufferedImage;
    }

    private static BufferedImage getImageFromTiles(RandomHandler randomHandler, IFD iFD) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Object object;
        int n10;
        int n11;
        if (iFD.tileOffsets == null) {
            iFD.tileOffsets = iFD.stripOffsets;
        }
        if (iFD.tileByteCounts == null) {
            iFD.tileByteCounts = iFD.stripByteCounts;
        }
        int n12 = iFD.imageWidth;
        int n13 = iFD.imageHeight;
        int n14 = iFD.tileWidth;
        int n15 = iFD.tileLength;
        boolean bl = iFD.planarConfiguration == 2;
        int n16 = bl ? 1 : iFD.samplesPerPixel;
        boolean bl2 = iFD.colorMap != null;
        int n17 = (n12 + (n14 - 1)) / n14;
        int n18 = (n13 + (n15 - 1)) / n15;
        int n19 = iFD.tileOffsets.length;
        int n20 = iFD.bps[0];
        int n21 = 0;
        if (iFD.planarConfiguration == 2) {
            n21 = iFD.bps[0];
        } else {
            for (int i = 0; i < iFD.bps.length; ++i) {
                n21 += iFD.bps[i];
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n11 = 0; n11 < n19; ++n11) {
            Object object2;
            randomHandler.setPosition(iFD.tileOffsets[n11]);
            byte[] byArray = new byte[iFD.tileByteCounts[n11]];
            randomHandler.get(byArray);
            byte[] byArray2 = null;
            int n22 = ((n14 * n21 + 7) / 8 * 8 * n15 + 7) / 8;
            switch (iFD.compressionType) {
                case 1: {
                    byArray2 = byArray;
                    break;
                }
                case 2: {
                    byArray2 = new byte[n22];
                    CCITT cCITT = new CCITT(iFD.fillOrder, n14, n15);
                    cCITT.decompress1D(byArray2, byArray, 0, n15);
                    break;
                }
                case 3: {
                    byArray2 = new byte[n22];
                    CCITT cCITT = new CCITT(iFD.fillOrder, n14, n15);
                    cCITT.decompressFax3(byArray2, byArray, n15);
                    break;
                }
                case 4: {
                    byArray2 = new byte[n22];
                    CCITT cCITT = new CCITT(iFD.fillOrder, n14, n15);
                    cCITT.decompressFax4(byArray2, byArray, n15);
                    break;
                }
                case 5: {
                    byArray2 = new byte[n22];
                    object2 = new LZW();
                    ((LZW)object2).decompress(byArray2, byArray, n14, n15);
                    break;
                }
                case 6: {
                    throw new Exception("Old style jpeg compression is not supported");
                }
                case 7: {
                    if (iFD.jpegTables != null) {
                        n10 = iFD.jpegTables.length;
                        object = new byte[n10 + byArray.length - 2];
                        System.arraycopy(iFD.jpegTables, 0, object, 0, n10);
                        System.arraycopy(byArray, 2, object, n10, byArray.length - 2);
                        byArray = object;
                    }
                    JpegDecoder jpegDecoder = new JpegDecoder();
                    byArray2 = jpegDecoder.readComponentsAsRawBytes(byArray);
                    break;
                }
                case 32773: {
                    n10 = (n14 * n15 * n21 + 7) / 8;
                    byArray2 = PackBits.decompress(byArray, n10);
                    break;
                }
                case 8: 
                case 32946: {
                    byArray2 = Deflate.decompress(byArray);
                    break;
                }
                default: {
                    System.err.println("unrecognized compression found");
                }
            }
            if (iFD.predictor == 2) {
                for (n10 = 0; n10 < n15; ++n10) {
                    int n23 = n16 * (n10 * n14 + 1);
                    for (int i = n16; i < n14 * n16; ++i) {
                        int n24 = n23;
                        byArray2[n24] = (byte)(byArray2[n24] + byArray2[n23 - n16]);
                        ++n23;
                    }
                }
            }
            if (iFD.photometric == 0) {
                int n25 = 0;
                for (n10 = 0; n10 < byArray2.length; ++n10) {
                    byArray2[n10] = (byte)(byArray2[n25++] & 0xFF ^ 0xFF);
                }
            }
            object2 = new Tile();
            n10 = n14 * n20 * n16 % 8;
            if (n20 != 8) {
                byArray = new byte[n15 * n14 * n16];
                object = new JPXBitReader(byArray2);
                n9 = 0;
                if (n20 == 1) {
                    for (n8 = 0; n8 < n15; ++n8) {
                        for (n7 = 0; n7 < n14; ++n7) {
                            for (n6 = 0; n6 < n16; ++n6) {
                                byArray[n9++] = bl2 ? (byte)((JPXBitReader)object).readBits(n20) : (byte)(((JPXBitReader)object).readBits(n20) * 255);
                            }
                        }
                        if (n10 == 0) continue;
                        ((JPXBitReader)object).readBits(8 - n10);
                    }
                } else if (n20 < 8) {
                    n8 = 8 - n20;
                    for (n7 = 0; n7 < n15; ++n7) {
                        for (n6 = 0; n6 < n14; ++n6) {
                            for (n5 = 0; n5 < n16; ++n5) {
                                byArray[n9++] = bl2 ? (byte)((JPXBitReader)object).readBits(n20) : (byte)(((JPXBitReader)object).readBits(n20) << n8);
                            }
                        }
                        if (n10 == 0) continue;
                        ((JPXBitReader)object).readBits(8 - n10);
                    }
                } else {
                    n8 = n20 - 8;
                    n7 = iFD.sampleFormat[0];
                    if (bl2) {
                        byArray = new byte[n15 * n14 * 3];
                        n16 = 3;
                        for (n6 = 0; n6 < n15; ++n6) {
                            for (n5 = 0; n5 < n14; ++n5) {
                                n4 = ((JPXBitReader)object).readBits(n20) * 3;
                                byArray[n9++] = iFD.colorMap[n4++];
                                byArray[n9++] = iFD.colorMap[n4++];
                                byArray[n9++] = iFD.colorMap[n4++];
                            }
                            if (n10 == 0) continue;
                            ((JPXBitReader)object).readBits(8 - n10);
                        }
                    } else {
                        for (n6 = 0; n6 < n15; ++n6) {
                            for (n5 = 0; n5 < n14; ++n5) {
                                for (n4 = 0; n4 < n16; ++n4) {
                                    byArray[n9++] = n7 == 3 ? (byte)(TiffDecoder.toFloat(((JPXBitReader)object).readBits(n20), n20) * 255.0f) : (byte)(((JPXBitReader)object).readBits(n20) >> n8);
                                }
                            }
                            if (n10 == 0) continue;
                            ((JPXBitReader)object).readBits(8 - n10);
                        }
                    }
                }
            } else {
                byArray = byArray2;
            }
            ((Tile)object2).data = byArray;
            arrayList.add(object2);
        }
        int[][] nArray = new int[n15 * n18][n14 * n17];
        if (bl) {
            n3 = 0;
            n10 = arrayList.size() / iFD.samplesPerPixel;
            for (int i = 0; i < iFD.samplesPerPixel; ++i) {
                for (n9 = 0; n9 < n10; ++n9) {
                    Tile tile = (Tile)arrayList.get(n3++);
                    byte[] byArray = tile.data;
                    n11 = n9 % n17;
                    int n26 = n9 / n17;
                    int n27 = n11 * n14;
                    int n28 = n26 * n15;
                    int n29 = 0;
                    for (n6 = 0; n6 < n15; ++n6) {
                        n5 = n28 + n6;
                        for (n4 = 0; n4 < n14; ++n4) {
                            n2 = n27 + n4;
                            n = byArray[n29++] & 0xFF;
                            nArray[n5][n2] = nArray[n5][n2] << 8 | n;
                        }
                    }
                }
            }
        } else {
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                Tile tile = (Tile)arrayList.get(n3);
                object = tile.data;
                n11 = n3 % n17;
                int n30 = n3 / n17;
                int n31 = n11 * n14;
                int n32 = n30 * n15;
                int n33 = 0;
                for (n9 = 0; n9 < n15; ++n9) {
                    n8 = n32 + n9;
                    for (n7 = 0; n7 < n14; ++n7) {
                        n6 = n31 + n7;
                        n5 = 0;
                        for (n4 = n16; n4 > 0; --n4) {
                            n5 |= (object[n33++] & 0xFF) << 8 * (n4 - 1);
                        }
                        nArray[n8][n6] = n5;
                    }
                }
            }
        }
        if (iFD.samplesPerPixel == 4 && iFD.photometric == 2) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                for (int i = 0; i < nArray[0].length; ++i) {
                    int n34 = nArray[n3][i];
                    n9 = n34 >> 24 & 0xFF;
                    int n35 = n34 >> 16 & 0xFF;
                    int n36 = n34 >> 8 & 0xFF;
                    n6 = n34 & 0xFF;
                    nArray[n3][i] = n6 << 24 | n9 << 16 | n35 << 8 | n36;
                }
            }
        }
        BufferedImage bufferedImage = TiffDecoder.allocateBufferedImage(iFD);
        int n37 = 0;
        switch (iFD.photometric) {
            case 6: {
                int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n13; ++i) {
                    for (int j = 0; j < n12; ++j) {
                        int n38 = nArray[i][j];
                        int n39 = n38 >> 16 & 0xFF;
                        n6 = n38 >> 8 & 0xFF;
                        n5 = n38 & 0xFF;
                        int n40 = (n6 -= 128) >> 2;
                        int n41 = ((n5 -= 128) >> 3) + (n5 >> 5);
                        n4 = n39 + n5 + (n5 >> 2) + n41;
                        n2 = n39 - (n40 + (n6 >> 4) + (n6 >> 5)) - ((n5 >> 1) + n41 + (n5 >> 4));
                        n = n39 + n6 + (n6 >> 1) + n40 + (n6 >> 6);
                        int n42 = n4 < 0 ? 0 : (n4 = n4 > 255 ? 255 : n4);
                        int n43 = n2 < 0 ? 0 : (n2 = n2 > 255 ? 255 : n2);
                        n = n < 0 ? 0 : (n > 255 ? 255 : n);
                        nArray2[n37++] = n4 << 16 | n2 << 8 | n;
                    }
                }
                break;
            }
            case 2: {
                int[] nArray3 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n13; ++i) {
                    for (int j = 0; j < n12; ++j) {
                        nArray3[n37++] = nArray[i][j];
                    }
                }
                break;
            }
            case 5: {
                int[] nArray4 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                EnumeratedSpace enumeratedSpace = new EnumeratedSpace();
                for (int i = 0; i < n13; ++i) {
                    for (int j = 0; j < n12; ++j) {
                        int n44 = nArray[i][j];
                        byte by = (byte)(n44 >> 24 & 0xFF);
                        byte by2 = (byte)(n44 >> 16 & 0xFF);
                        n9 = (byte)(n44 >> 8 & 0xFF);
                        byte by3 = (byte)(n44 & 0xFF);
                        byte[] byArray = enumeratedSpace.getRGB(by, by2, (byte)n9, by3);
                        nArray4[n37++] = (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF;
                    }
                }
                break;
            }
            case 3: {
                if (iFD.bps[0] > 8) {
                    int[] nArray5 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    for (int i = 0; i < n13; ++i) {
                        for (int j = 0; j < n12; ++j) {
                            nArray5[n37++] = nArray[i][j];
                        }
                    }
                } else {
                    byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                    for (int i = 0; i < n13; ++i) {
                        for (int j = 0; j < n12; ++j) {
                            byArray[n37++] = (byte)nArray[i][j];
                        }
                    }
                }
                break;
            }
            default: {
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < n13; ++i) {
                    for (int j = 0; j < n12; ++j) {
                        byArray[n37++] = (byte)nArray[i][j];
                    }
                }
            }
        }
        return bufferedImage;
    }

    private static BufferedImage generateImageFromIFD(RandomHandler randomHandler, IFD iFD) throws Exception {
        if (iFD.tileWidth != 0) {
            return TiffDecoder.getImageFromTiles(randomHandler, iFD);
        }
        return TiffDecoder.getDataFromStrips(randomHandler, iFD);
    }

    private static BufferedImage allocateBufferedImage(IFD iFD) {
        int n = iFD.imageWidth;
        int n2 = iFD.imageHeight;
        if (iFD.photometric == 3) {
            if (iFD.bps[0] > 8) {
                return new BufferedImage(n, n2, 1);
            }
            IndexColorModel indexColorModel = new IndexColorModel(8, iFD.colorMap.length / 3, iFD.colorMap, 0, false);
            WritableRaster writableRaster = indexColorModel.createCompatibleWritableRaster(iFD.imageWidth, iFD.imageHeight);
            return new BufferedImage(indexColorModel, writableRaster, false, null);
        }
        switch (iFD.samplesPerPixel) {
            case 0: 
            case 1: 
            case 2: {
                return new BufferedImage(n, n2, 10);
            }
            case 3: {
                return new BufferedImage(n, n2, 1);
            }
            case 4: {
                if (iFD.photometric == 5) {
                    return new BufferedImage(n, n2, 1);
                }
                return new BufferedImage(n, n2, 2);
            }
        }
        return new BufferedImage(n, n2, 2);
    }

    private static int[] readBitsPerSamples(RandomHandler randomHandler, int n, int n2) throws IOException {
        randomHandler.setPosition(n);
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = randomHandler.getUint16();
        }
        return nArray;
    }

    private static int[] readOffsets(RandomHandler randomHandler, int n, int n2, int n3) throws IOException {
        randomHandler.setPosition(n);
        int[] nArray = new int[n2];
        if (n3 == 3) {
            for (int i = 0; i < n2; ++i) {
                nArray[i] = randomHandler.getUint16();
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                nArray[i] = randomHandler.getInt();
            }
        }
        return nArray;
    }

    private static int[] readStripTileByteCounts(RandomHandler randomHandler, int n, int n2, int n3) throws IOException {
        randomHandler.setPosition(n);
        int[] nArray = new int[n2];
        if (n3 == 3) {
            for (int i = 0; i < n2; ++i) {
                nArray[i] = randomHandler.getUint16();
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                nArray[i] = randomHandler.getInt();
            }
        }
        return nArray;
    }

    private static byte[] readColorMap(RandomHandler randomHandler, int n, int n2) throws IOException {
        int n3;
        int n4;
        randomHandler.setPosition(n);
        int n5 = n2 / 3;
        byte[] byArray = new byte[n5];
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = randomHandler.getUint16();
            byArray[n4] = (byte)(n3 >> 8);
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = randomHandler.getUint16();
            byArray2[n4] = (byte)(n3 >> 8);
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = randomHandler.getUint16();
            byArray3[n4] = (byte)(n3 >> 8);
        }
        byte[] byArray4 = new byte[n2];
        n3 = 0;
        for (int i = 0; i < n5; ++i) {
            byArray4[n3++] = byArray[i];
            byArray4[n3++] = byArray2[i];
            byArray4[n3++] = byArray3[i];
        }
        return byArray4;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    private static float toFloat(int n, int n2) {
        if (n2 == 16) {
            int n3 = n & 0x3FF;
            int n4 = n & 0x7C00;
            if (n4 == 31744) {
                n4 = 261120;
            } else if (n4 != 0) {
                if (n3 == 0 && (n4 += 114688) > 115712) {
                    return Float.intBitsToFloat((n & 0x8000) << 16 | n4 << 13 | 0x3FF);
                }
            } else if (n3 != 0) {
                n4 = 115712;
                do {
                    n4 -= 1024;
                } while (((n3 <<= 1) & 0x400) == 0);
                n3 &= 0x3FF;
            }
            return Float.intBitsToFloat((n & 0x8000) << 16 | (n4 | n3) << 13);
        }
        return Float.intBitsToFloat(n);
    }
}

