/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import com.idrsolutions.image.tiff.Deflate;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class TiffEncoder {
    private boolean compress;

    public void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        int n;
        int n2;
        boolean bl;
        byte[] byArray = TiffEncoder.getComponentBytes(bufferedImage);
        boolean bl2 = bl = byArray.length > (n2 = bufferedImage.getHeight()) * (n = bufferedImage.getWidth()) * 3;
        if (this.compress) {
            byArray = Deflate.compress(byArray);
        }
        int n3 = 8;
        TiffEncoder.writeIdentifier(outputStream, n3);
        TiffEncoder.writeContents(outputStream, byArray, n, n2, n3, bl, this.compress);
        TiffEncoder.writePadding(outputStream, byArray.length);
    }

    public void append(BufferedImage bufferedImage, String string) throws IOException {
        File file = new File(string);
        if (file.exists() && file.length() > 0L) {
            boolean bl;
            int n = (int)file.length();
            int n2 = n % 8;
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            randomAccessFile.seek(n);
            for (int i = 0; i < n2; ++i) {
                randomAccessFile.write(0);
            }
            TiffEncoder.alterLastIFDOffset(randomAccessFile, n += n2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = TiffEncoder.getComponentBytes(bufferedImage);
            boolean bl2 = bl = byArray.length > bufferedImage.getWidth() * bufferedImage.getHeight() * 3;
            if (this.compress) {
                byArray = Deflate.compress(byArray);
            }
            TiffEncoder.writeContents(byteArrayOutputStream, byArray, bufferedImage.getWidth(), bufferedImage.getHeight(), n, bl, this.compress);
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            randomAccessFile.seek(n);
            randomAccessFile.write(byArray);
            randomAccessFile.close();
        } else {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            TiffEncoder.createImage(bufferedImage, bufferedOutputStream, this.compress);
            bufferedOutputStream.close();
        }
    }

    public boolean isCompressed() {
        return this.compress;
    }

    public void setCompressed(boolean bl) {
        this.compress = bl;
    }

    private static void alterLastIFDOffset(RandomAccessFile randomAccessFile, int n) throws IOException {
        randomAccessFile.seek(0L);
        randomAccessFile.skipBytes(4);
        int n2 = randomAccessFile.readInt();
        do {
            randomAccessFile.seek(n2);
            short s = randomAccessFile.readShort();
            randomAccessFile.skipBytes(s * 12);
        } while ((n2 = randomAccessFile.readInt()) != 0);
        int n3 = (int)randomAccessFile.getFilePointer();
        randomAccessFile.seek(n3 - 4);
        randomAccessFile.writeInt(n);
    }

    private static void createImage(BufferedImage bufferedImage, OutputStream outputStream, boolean bl) throws IOException {
        int n;
        int n2;
        boolean bl2;
        byte[] byArray = TiffEncoder.getComponentBytes(bufferedImage);
        boolean bl3 = bl2 = byArray.length > (n2 = bufferedImage.getHeight()) * (n = bufferedImage.getWidth()) * 3;
        if (bl) {
            byArray = Deflate.compress(byArray);
        }
        int n3 = 8;
        TiffEncoder.writeIdentifier(outputStream, n3);
        TiffEncoder.writeContents(outputStream, byArray, n, n2, n3, bl2, bl);
        TiffEncoder.writePadding(outputStream, byArray.length);
    }

    private static byte[] getComponentBytes(BufferedImage bufferedImage) {
        byte[] byArray;
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        int n3 = 0;
        switch (bufferedImage.getType()) {
            case 1: {
                byArray = new byte[n * n2 * 3];
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        byte[] byArray2 = TiffEncoder.intToBytes(nArray[n4]);
                        byArray[n3++] = byArray2[1];
                        byArray[n3++] = byArray2[2];
                        byArray[n3++] = byArray2[3];
                        ++n4;
                    }
                }
                break;
            }
            case 2: {
                byArray = new byte[n * n2 * 4];
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n5 = 0;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        byte[] byArray3 = TiffEncoder.intToBytes(nArray[n5]);
                        byArray[n3++] = byArray3[1];
                        byArray[n3++] = byArray3[2];
                        byArray[n3++] = byArray3[3];
                        byArray[n3++] = byArray3[0];
                        ++n5;
                    }
                }
                break;
            }
            case 4: {
                byArray = new byte[n * n2 * 3];
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n6 = 0;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        byte[] byArray4 = TiffEncoder.intToBytes(nArray[n6]);
                        byArray[n3++] = byArray4[3];
                        byArray[n3++] = byArray4[2];
                        byArray[n3++] = byArray4[1];
                        ++n6;
                    }
                }
                break;
            }
            case 5: {
                byArray = new byte[n * n2 * 3];
                byte[] byArray5 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n7 = 0;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        byArray[n3++] = byArray5[n7 + 2];
                        byArray[n3++] = byArray5[n7 + 1];
                        byArray[n3++] = byArray5[n7];
                        n7 += 3;
                    }
                }
                break;
            }
            case 6: {
                byArray = new byte[n * n2 * 4];
                byte[] byArray6 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n8 = 0;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        byArray[n3++] = byArray6[n8 + 3];
                        byArray[n3++] = byArray6[n8 + 2];
                        byArray[n3++] = byArray6[n8 + 1];
                        byArray[n3++] = byArray6[n8];
                        n8 += 4;
                    }
                }
                break;
            }
            default: {
                byArray = new byte[n * n2 * 3];
                BufferedImage bufferedImage2 = new BufferedImage(n2, n, 1);
                bufferedImage2.createGraphics().drawImage((Image)bufferedImage, 0, 0, null);
                int[] nArray = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
                int n9 = 0;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        byte[] byArray7 = TiffEncoder.intToBytes(nArray[n9]);
                        byArray[n3++] = byArray7[1];
                        byArray[n3++] = byArray7[2];
                        byArray[n3++] = byArray7[3];
                        ++n9;
                    }
                }
            }
        }
        return byArray;
    }

    private static void writeIdentifier(OutputStream outputStream, int n) throws IOException {
        outputStream.write(new byte[]{77, 77});
        outputStream.write(new byte[]{0, 42});
        outputStream.write(TiffEncoder.intToBytes(n));
    }

    private static int writePadding(OutputStream outputStream, int n) throws IOException {
        int n2 = n % 8;
        for (int i = 0; i < n2; ++i) {
            outputStream.write(0);
        }
        return n2;
    }

    private static void writeContents(OutputStream outputStream, byte[] byArray, int n, int n2, int n3, boolean bl, boolean bl2) throws IOException {
        int n4 = bl ? 4 : 3;
        byte by = (byte)(bl ? 13 : 12);
        int n5 = byArray.length;
        int n6 = n3 + 2 + by * 12 + 4;
        int n7 = n6 + 2 * n4;
        int n8 = n7 + 8;
        int n9 = n8 + 8;
        outputStream.write(TiffEncoder.shortToBytes(by));
        outputStream.write(TiffEncoder.shortToBytes((short)256));
        outputStream.write(TiffEncoder.shortToBytes((short)3));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.shortToBytes((short)n));
        outputStream.write(TiffEncoder.shortToBytes((short)0));
        outputStream.write(TiffEncoder.shortToBytes((short)257));
        outputStream.write(TiffEncoder.shortToBytes((short)3));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.shortToBytes((short)n2));
        outputStream.write(TiffEncoder.shortToBytes((short)0));
        outputStream.write(TiffEncoder.shortToBytes((short)258));
        outputStream.write(TiffEncoder.shortToBytes((short)3));
        outputStream.write(TiffEncoder.intToBytes(n4));
        outputStream.write(TiffEncoder.intToBytes(n6));
        outputStream.write(TiffEncoder.shortToBytes((short)259));
        outputStream.write(TiffEncoder.shortToBytes((short)3));
        outputStream.write(TiffEncoder.intToBytes(1));
        int n10 = bl2 ? 32946 : 1;
        outputStream.write(TiffEncoder.shortToBytes((short)n10));
        outputStream.write(TiffEncoder.shortToBytes((short)0));
        outputStream.write(TiffEncoder.shortToBytes((short)262));
        outputStream.write(TiffEncoder.shortToBytes((short)3));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.shortToBytes((short)2));
        outputStream.write(TiffEncoder.shortToBytes((short)0));
        outputStream.write(TiffEncoder.shortToBytes((short)273));
        outputStream.write(TiffEncoder.shortToBytes((short)4));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.intToBytes(n9));
        outputStream.write(TiffEncoder.shortToBytes((short)277));
        outputStream.write(TiffEncoder.shortToBytes((short)3));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.shortToBytes((short)n4));
        outputStream.write(TiffEncoder.shortToBytes((short)0));
        outputStream.write(TiffEncoder.shortToBytes((short)278));
        outputStream.write(TiffEncoder.shortToBytes((short)4));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.intToBytes(n2));
        outputStream.write(TiffEncoder.shortToBytes((short)279));
        outputStream.write(TiffEncoder.shortToBytes((short)4));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.intToBytes(n5));
        outputStream.write(TiffEncoder.shortToBytes((short)282));
        outputStream.write(TiffEncoder.shortToBytes((short)5));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.intToBytes(n7));
        outputStream.write(TiffEncoder.shortToBytes((short)283));
        outputStream.write(TiffEncoder.shortToBytes((short)5));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.intToBytes(n8));
        outputStream.write(TiffEncoder.shortToBytes((short)296));
        outputStream.write(TiffEncoder.shortToBytes((short)3));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.shortToBytes((short)1));
        outputStream.write(TiffEncoder.shortToBytes((short)0));
        if (bl) {
            outputStream.write(TiffEncoder.shortToBytes((short)338));
            outputStream.write(TiffEncoder.shortToBytes((short)3));
            outputStream.write(TiffEncoder.intToBytes(1));
            outputStream.write(TiffEncoder.shortToBytes((short)2));
            outputStream.write(TiffEncoder.shortToBytes((short)0));
        }
        outputStream.write(TiffEncoder.intToBytes(0));
        for (int i = 0; i < n4; ++i) {
            outputStream.write(TiffEncoder.shortToBytes((short)8));
        }
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(TiffEncoder.intToBytes(1));
        outputStream.write(byArray);
    }

    private static byte[] shortToBytes(short s) {
        int n = s & 0xFFFF;
        return new byte[]{(byte)(n >> 8), (byte)n};
    }

    private static byte[] intToBytes(int n) {
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }
}

