/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.PixelFactory;
import com.idrsolutions.pdf.color.shading.ShadingFactory;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;

public class AxialContext
implements PaintContext {
    private float maxPDFX = -9999.0f;
    private float maxPDFY = -9999.0f;
    private float minPDFX = 9999.0f;
    private float minPDFY = 9999.0f;
    final GenericColorSpace shadingColorSpace;
    private float scaling = 1.0f;
    private final boolean[] isExtended;
    private final float x0;
    private final float x1;
    private final float y0;
    private final float y1;
    private final float t0;
    private float t1 = 1.0f;
    private final PDFFunction[] function;
    private final boolean isPrinting;
    private final int pageHeight;
    private final boolean colorsReversed;
    private final int minX;
    private final float[] background;
    private final float offX;
    private final float offY;
    int pageRotation;
    private final boolean isInverted;
    private int renderingType = 3;

    AxialContext(AffineTransform affineTransform, int n, boolean bl, int n2, int n3, int n4, int n5, float f, boolean[] blArray, float[] fArray, float[] fArray2, GenericColorSpace genericColorSpace, boolean bl2, float[] fArray3, PDFFunction[] pDFFunctionArray) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        if (dArray[0] == 0.0 && dArray[1] > 0.0 && dArray[2] > 0.0 && dArray[3] == 0.0) {
            this.pageRotation = 90;
        }
        this.isInverted = n == 8;
        this.renderingType = n;
        this.isPrinting = bl;
        this.offX = n2;
        this.offY = n3;
        this.colorsReversed = bl2;
        this.pageHeight = n5;
        this.isExtended = blArray;
        this.t0 = fArray[0];
        this.t1 = fArray[1];
        this.background = fArray3;
        this.x0 = fArray2[0];
        this.x1 = fArray2[2];
        this.y0 = fArray2[1];
        this.y1 = fArray2[3];
        this.shadingColorSpace = genericColorSpace;
        this.function = pDFFunctionArray;
        this.scaling = f;
        this.minX = n4;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        if (this.pageRotation == 90) {
            n7 = n;
            n = n2;
            n2 = n7;
        }
        n7 = this.renderingType == 3 && ((float)n3 / this.scaling <= 1.0f || (float)n4 / this.scaling <= 1.0f) ? 1 : 0;
        int n8 = n3 * n4 * 4;
        int[] nArray = new int[n8];
        float f = -1.0f;
        float f2 = this.x1 - this.x0;
        float f3 = this.y1 - this.y0;
        float f4 = f2 * f2 + f3 * f3;
        Color color = this.colorsReversed ? this.calculateColor(this.t1) : this.calculateColor(this.t0);
        int n9 = color.getRed();
        int n10 = color.getGreen();
        int n11 = color.getBlue();
        if (this.background != null) {
            this.shadingColorSpace.setColor(this.background, 4);
            Color color2 = (Color)((Object)this.shadingColorSpace.getColor());
            for (int i = 0; i < n4; ++i) {
                for (n6 = 0; n6 < n3; ++n6) {
                    n5 = (i * n3 + n6) * 4;
                    nArray[n5] = color2.getRed();
                    nArray[n5 + 1] = color2.getGreen();
                    nArray[n5 + 2] = color2.getBlue();
                    nArray[n5 + 3] = 255;
                }
            }
        }
        for (n6 = 0; n6 < n4; ++n6) {
            for (n5 = 0; n5 < n3; ++n5) {
                Object object = this.pageRotation != 90 ? PixelFactory.convertPhysicalToPDF(this.isPrinting, n5, n6, this.offX, this.offY, this.scaling, n, n2, this.minX, this.pageHeight) : PixelFactory.convertPhysicalToPDF(this.isPrinting, n6, n5, this.offX, this.offY, this.scaling, n, n2, this.minX, this.pageHeight);
                float f5 = object[0];
                float f6 = this.isInverted ? -object[1] : object[1];
                float f7 = n7 != 0 ? 0.5f : (f2 * (f5 - this.x0) + f3 * (f6 - this.y0)) / f4;
                float f8 = this.y0 - this.y1;
                if (this.isPrinting && f8 < 0.0f) {
                    f7 = 1.0f - f7;
                }
                if (f5 > this.maxPDFX) {
                    this.maxPDFX = f5;
                }
                if (f5 < this.minPDFX) {
                    this.minPDFX = f5;
                }
                if (f6 > this.maxPDFY) {
                    this.maxPDFY = f6;
                }
                if (f6 < this.minPDFY) {
                    this.minPDFY = f6;
                }
                float f9 = f7 < 0.0f && this.isExtended[0] ? this.t0 : (f7 > 1.0f && this.isExtended[1] ? this.t1 : this.t0 + (this.t1 - this.t0) * f7);
                if (n7 != 0) {
                    f9 = 0.5f;
                }
                if (!(f9 >= this.t0) || !(f9 <= this.t1)) continue;
                if (this.colorsReversed) {
                    f9 = 1.0f - f9;
                }
                if (f9 != f) {
                    f = f9;
                    object = this.calculateColor(f9);
                    n9 = object.getRed();
                    n10 = object.getGreen();
                    n11 = object.getBlue();
                }
                int n12 = (n6 * n3 + n5) * 4;
                nArray[n12] = n9;
                nArray[n12 + 1] = n10;
                nArray[n12 + 2] = n11;
                nArray[n12 + 3] = 255;
            }
        }
        WritableRaster writableRaster = new BufferedImage(n3, n4, 2).getRaster();
        writableRaster.setPixels(0, 0, n3, n4, nArray);
        return writableRaster;
    }

    private Color calculateColor(float f) {
        float[] fArray = ShadingFactory.applyFunctions(this.function, new float[]{f});
        this.shadingColorSpace.setColor(fArray, fArray.length);
        Color color = (Color)((Object)this.shadingColorSpace.getColor());
        return color;
    }
}

