/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

public class BitReader {
    private int p;
    private int pos;
    private final byte[] data;
    private final boolean hasSmallBits;
    private int bufferSize;
    private int buffer;
    private final int totalBitLen;

    public BitReader(byte[] byArray, boolean bl) {
        this.hasSmallBits = bl;
        this.data = byArray;
        this.totalBitLen = this.data.length * 8;
    }

    private int readBits(int n) {
        if (this.hasSmallBits) {
            while (this.bufferSize < n) {
                int n2 = this.data[this.pos] & 0xFF;
                ++this.pos;
                this.buffer = this.buffer << 8 | n2;
                this.bufferSize += 8;
            }
            this.bufferSize -= n;
            this.p += n;
            return this.buffer >>> this.bufferSize & (1 << n) - 1;
        }
        int n3 = 0;
        int n4 = n / 8;
        for (int i = 0; i < n4; ++i) {
            n3 <<= 8;
            n3 |= this.data[this.p / 8] & 0xFF;
            this.p += 8;
        }
        return n3;
    }

    public int getPositive(int n) {
        return this.readBits(n);
    }

    public float getFloat(int n) {
        int n2 = this.readBits(n);
        byte[] byArray = new byte[]{(byte)(n2 >>> 24), (byte)(n2 >>> 16), (byte)(n2 >>> 8), (byte)n2};
        float f = 0.0f;
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                f = (float)byArray[3] / 15.0f;
                break;
            }
            case 8: {
                f = (float)(byArray[3] & 0xFF) / 256.0f;
                break;
            }
            case 16: {
                f = (float)(byArray[2] & 0xFF) / 256.0f;
                f += (float)(byArray[3] & 0xFF) / 65536.0f;
                break;
            }
            case 24: {
                f = (float)(byArray[1] & 0xFF) / 256.0f;
                f += (float)(byArray[2] & 0xFF) / 65536.0f;
                f += (float)(byArray[3] & 0xFF) / 1.6777216E7f;
                break;
            }
            case 32: {
                f = (float)(byArray[0] & 0xFF) / 256.0f;
                f += (float)(byArray[1] & 0xFF) / 65536.0f;
                f += (float)(byArray[2] & 0xFF) / 1.6777216E7f;
                f += (float)(byArray[3] & 0xFF) / 4.2949673E9f;
            }
        }
        return f;
    }

    public int getPointer() {
        return this.p;
    }

    public int getTotalBitLen() {
        return this.totalBitLen;
    }
}

