/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;

public class RadialContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final float[] background;
    private final PdfObject shadingObj;
    private final PDFFunction[] function;
    private final float[] coords;
    private boolean[] extended = new boolean[]{false, false};
    private float t0;
    private float t1 = 1.0f;
    private final float x0;
    private final float y0;
    private final float r0;
    private final float x1;
    private final float y1;
    private final float r1;
    private final float deltaX;
    private final float deltaY;
    private final float deltaR;
    private final float deltaC;
    private final float powerR0;
    private final Color colorT0;
    private final Color colorT1;

    RadialContext(AffineTransform affineTransform, boolean bl, GenericColorSpace genericColorSpace, float[] fArray, PdfObject pdfObject, float[][] fArray2, PDFFunction[] pDFFunctionArray) {
        float[] fArray3;
        this.shadingColorSpace = genericColorSpace;
        this.background = fArray;
        this.shadingObj = pdfObject;
        this.function = pDFFunctionArray;
        float[] fArray4 = pdfObject.getFloatArray(1061308290);
        boolean[] blArray = this.shadingObj.getBooleanArray(1144345468);
        if (blArray != null) {
            this.extended = blArray;
        }
        if ((fArray3 = this.shadingObj.getFloatArray(1026641277)) != null) {
            this.t0 = fArray3[0];
            this.t1 = fArray3[1];
        }
        this.coords = new float[fArray4.length];
        System.arraycopy(fArray4, 0, this.coords, 0, fArray4.length);
        AffineTransform affineTransform2 = new AffineTransform(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1], fArray2[2][0], fArray2[2][1]);
        double[] dArray = new double[6];
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(this.coords[0], this.coords[1]);
        generalPath.lineTo(this.coords[0] + this.coords[2], this.coords[1]);
        PathIterator pathIterator = generalPath.getPathIterator(affineTransform2);
        pathIterator.currentSegment(dArray);
        Point2D.Double double_ = new Point2D.Double(dArray[0], dArray[1]);
        pathIterator.next();
        pathIterator.currentSegment(dArray);
        Point2D.Double double_2 = new Point2D.Double(dArray[0], dArray[1]);
        generalPath = new GeneralPath();
        generalPath.moveTo(this.coords[3], this.coords[4]);
        generalPath.lineTo(this.coords[3] + this.coords[5], this.coords[4]);
        pathIterator = generalPath.getPathIterator(affineTransform2);
        pathIterator.currentSegment(dArray);
        Point2D.Double double_3 = new Point2D.Double(dArray[0], dArray[1]);
        pathIterator.next();
        pathIterator.currentSegment(dArray);
        Point2D.Double double_4 = new Point2D.Double(dArray[0], dArray[1]);
        Point2D[] point2DArray = new Point2D[]{double_, double_3, double_2, double_4};
        affineTransform.transform(point2DArray, 0, point2DArray, 0, 4);
        this.x0 = (float)point2DArray[0].getX();
        this.y0 = (float)point2DArray[0].getY();
        this.x1 = (float)point2DArray[1].getX();
        this.y1 = (float)point2DArray[1].getY();
        this.r0 = (float)point2DArray[0].distance(point2DArray[2]);
        this.r1 = (float)point2DArray[1].distance(point2DArray[3]);
        this.colorT0 = this.calculateColor(this.t0);
        this.colorT1 = this.calculateColor(this.t1);
        this.deltaX = this.x1 - this.x0;
        this.deltaY = this.y1 - this.y0;
        this.deltaR = this.r1 - this.r0;
        this.deltaC = this.deltaX * this.deltaX + this.deltaY * this.deltaY - this.deltaR * this.deltaR;
        this.powerR0 = this.r0 * this.r0;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    private Color calculateColor(float f) {
        float[] fArray = ShadingFactory.applyFunctions(this.function, new float[]{f});
        this.shadingColorSpace.setColor(fArray, fArray.length);
        return (Color)((Object)this.shadingColorSpace.getColor());
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        Object object;
        int n5;
        int n6;
        int[] nArray = new int[n3 * n4 * 4];
        if (this.background != null) {
            for (n6 = 0; n6 < n4; ++n6) {
                for (n5 = 0; n5 < n3; ++n5) {
                    this.shadingColorSpace.setColor(this.background, this.shadingColorSpace.getColorComponentCount());
                    object = (Color)((Object)this.shadingColorSpace.getColor());
                    int n7 = (n6 * n3 + n5) * 4;
                    nArray[n7] = ((Color)object).getRed();
                    nArray[n7 + 1] = ((Color)object).getGreen();
                    nArray[n7 + 2] = ((Color)object).getBlue();
                    nArray[n7 + 3] = 255;
                }
            }
        }
        for (n6 = 0; n6 < n4; ++n6) {
            for (n5 = 0; n5 < n3; ++n5) {
                object = new float[]{n5 + n, n6 + n2};
                Color color = null;
                float[] fArray = this.quadraticEquate((float)object[0], (float)object[1]);
                if (fArray[1] >= 0.0f && fArray[1] <= 1.0f) {
                    color = this.calculateColor(this.getTfromS(fArray[1]));
                } else if (this.extended[1] && fArray[1] >= 0.0f && this.r1 + fArray[1] * this.deltaR >= 0.0f) {
                    color = this.colorT1;
                } else if (fArray[0] >= 0.0f && fArray[0] <= 1.0f) {
                    color = this.calculateColor(this.getTfromS(fArray[0]));
                } else if (this.extended[0] && fArray[1] <= 0.0f && this.r1 + fArray[1] * this.deltaR >= 0.0f) {
                    color = this.calculateColor(this.getTfromS(fArray[1]));
                } else if (this.extended[0] && fArray[0] <= 1.0f && this.r1 + fArray[0] * this.deltaR >= 0.0f) {
                    color = this.colorT0;
                }
                if (color == null) continue;
                int n8 = (n6 * n3 + n5) * 4;
                nArray[n8] = color.getRed();
                nArray[n8 + 1] = color.getGreen();
                nArray[n8 + 2] = color.getBlue();
                nArray[n8 + 3] = 255;
            }
        }
        WritableRaster writableRaster = new BufferedImage(n3, n4, 2).getRaster();
        writableRaster.setPixels(0, 0, n3, n4, nArray);
        return writableRaster;
    }

    private float getTfromS(float f) {
        return f * (this.t1 - this.t0) + this.t0;
    }

    private float[] quadraticEquate(float f, float f2) {
        float[] fArray;
        float f3 = f - this.x0;
        float f4 = f2 - this.y0;
        float f5 = -f3 * this.deltaX - f4 * this.deltaY - this.r0 * this.deltaR;
        float f6 = f3 * f3 + f4 * f4 - this.powerR0;
        float f7 = (float)Math.sqrt(f5 * f5 - this.deltaC * f6);
        float f8 = (f7 - f5) / this.deltaC;
        float f9 = (-f5 - f7) / this.deltaC;
        if (this.deltaC < 0.0f) {
            float[] fArray2 = new float[2];
            fArray2[0] = f8;
            fArray = fArray2;
            fArray2[1] = f9;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = f9;
            fArray = fArray3;
            fArray3[1] = f8;
        }
        return fArray;
    }
}

