/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ShadingUtils {
    public static Point2D findIntersect(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        double d = point2D2.getX() - point2D.getX();
        double d2 = point2D4.getX() - point2D3.getX();
        double d3 = point2D2.getY() - point2D.getY();
        double d4 = point2D4.getY() - point2D3.getY();
        double d5 = point2D.getX() - point2D3.getX();
        double d6 = point2D.getY() - point2D3.getY();
        double d7 = d4 * d - d2 * d3;
        double d8 = (d2 * d6 - d4 * d5) / d7;
        return new Point2D.Double(point2D.getX() + d8 * d, point2D.getY() + d8 * d3);
    }

    public static Color interpolate2Color(Color color, Color color2, float f) {
        f = Math.min(f, 1.0f);
        f = Math.max(f, 0.0f);
        float f2 = (float)color.getRed() * 0.003921569f;
        float f3 = (float)color.getGreen() * 0.003921569f;
        float f4 = (float)color.getBlue() * 0.003921569f;
        float f5 = (float)color.getAlpha() * 0.003921569f;
        float f6 = (float)color2.getRed() * 0.003921569f;
        float f7 = (float)color2.getGreen() * 0.003921569f;
        float f8 = (float)color2.getBlue() * 0.003921569f;
        float f9 = (float)color2.getAlpha() * 0.003921569f;
        float f10 = f6 - f2;
        float f11 = f7 - f3;
        float f12 = f8 - f4;
        float f13 = f9 - f5;
        float f14 = f2 + f10 * f;
        float f15 = f3 + f11 * f;
        float f16 = f4 + f12 * f;
        float f17 = f5 + f13 * f;
        f14 = Math.max(Math.min(f14, 1.0f), 0.0f);
        f15 = Math.max(Math.min(f15, 1.0f), 0.0f);
        f16 = Math.max(Math.min(f16, 1.0f), 0.0f);
        f17 = Math.max(Math.min(f17, 1.0f), 0.0f);
        return new Color(f14, f15, f16, f17);
    }

    public static Color bilinearInterpolateColor(Color color, Color color2, Color color3, Color color4, float f, float f2) {
        Color color5 = ShadingUtils.interpolate2Color(color, color2, f);
        Color color6 = ShadingUtils.interpolate2Color(color3, color4, f);
        return ShadingUtils.interpolate2Color(color5, color6, f2);
    }

    public static Point2D findDistancedPoint(double d, Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        double d2 = 1.0 - d;
        double d3 = d2 * d2 * d2;
        double d4 = d2 * d2;
        double d5 = d * d * d;
        double d6 = d * d;
        double d7 = d3 * point2D.getX() + 3.0 * d * d4 * point2D2.getX() + 3.0 * d6 * d2 * point2D3.getX() + d5 * point2D4.getX();
        double d8 = d3 * point2D.getY() + 3.0 * d * d4 * point2D2.getY() + 3.0 * d6 * d2 * point2D3.getY() + d5 * point2D4.getY();
        return new Point2D.Double(d7, d8);
    }

    public static int getRotationFromAffine(AffineTransform affineTransform) {
        return (int)Math.toDegrees(Math.atan2(affineTransform.getShearX(), affineTransform.getScaleX()));
    }

    public static final float[] getPixelPDF(boolean bl, int n, float f, float f2, int n2, int n3, float f3, float f4, float f5, float f6, float f7) {
        if (!bl) {
            switch (n) {
                case 0: {
                    float f8 = f7 * ((float)n2 + f + f5 - f3);
                    float f9 = f7 * (f6 - ((float)n3 + f2 - f4));
                    return new float[]{f8, f9};
                }
                case 90: {
                    float f10 = f7 * (f + (float)n2 + f5 - f3);
                    float f11 = f7 * (f2 + (float)n3 - (f6 + f4));
                    return new float[]{f11, f10};
                }
                case 180: {
                    float f12 = f7 * (f3 - (f + (float)n2 + f5));
                    float f13 = f7 * (f2 + (float)n3 - (f6 + f4));
                    return new float[]{f12, f13};
                }
                case -90: {
                    float f14 = f7 * (f6 - (f + (float)n2 + 2.0f));
                    float f15 = f7 * (f2 + (float)n3);
                    return new float[]{f15, f14};
                }
            }
        } else {
            float f16 = (f + (float)n2 - f3) * f7;
            float f17 = (f2 + (float)n3 - f4) * f7;
            return new float[]{f16, f17};
        }
        return new float[]{0.0f, 0.0f};
    }

    public static GeneralPath getPathFromBBox(float[] fArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0], fArray[1]);
        generalPath.lineTo(fArray[2], fArray[1]);
        generalPath.lineTo(fArray[2], fArray[3]);
        generalPath.lineTo(fArray[0], fArray[3]);
        generalPath.lineTo(fArray[0], fArray[1]);
        generalPath.closePath();
        return generalPath;
    }

    public static float[] getPdfCoords(AffineTransform affineTransform, int n, int n2, int n3, int n4) {
        float[] fArray = new float[]{n + n3, n2 + n4};
        affineTransform.transform(fArray, 0, fArray, 0, 1);
        return fArray;
    }
}

