/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class Shape67 {
    private Rectangle boundingBox;
    private final GeneralPath shape;
    private final Color[] colorsArr;
    private final Point2D[] pointsArr;
    private int nSteps = 10;
    private final List<TinyPatch> patches = new ArrayList<TinyPatch>();
    private TinyPatch lastFound;

    public Shape67(Point2D[] point2DArray, Color[] colorArray) {
        this.pointsArr = point2DArray;
        this.colorsArr = colorArray;
        this.shape = new GeneralPath();
        this.shape.moveTo(point2DArray[0].getX(), point2DArray[0].getY());
        this.shape.curveTo(point2DArray[1].getX(), point2DArray[1].getY(), point2DArray[2].getX(), point2DArray[2].getY(), point2DArray[3].getX(), point2DArray[3].getY());
        this.shape.curveTo(point2DArray[4].getX(), point2DArray[4].getY(), point2DArray[5].getX(), point2DArray[5].getY(), point2DArray[6].getX(), point2DArray[6].getY());
        this.shape.curveTo(point2DArray[7].getX(), point2DArray[7].getY(), point2DArray[8].getX(), point2DArray[8].getY(), point2DArray[9].getX(), point2DArray[9].getY());
        this.shape.curveTo(point2DArray[10].getX(), point2DArray[10].getY(), point2DArray[11].getX(), point2DArray[11].getY(), point2DArray[0].getX(), point2DArray[0].getY());
        this.shape.closePath();
        this.boundingBox = this.shape.getBounds();
    }

    public GeneralPath getShape() {
        return this.shape;
    }

    public void applyTransformation(AffineTransform affineTransform) {
        this.shape.transform(affineTransform);
        double[] dArray = new double[6];
        PathIterator pathIterator = this.shape.getPathIterator(null);
        int n = 0;
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    this.pointsArr[0] = new Point2D.Double(dArray[0], dArray[1]);
                    break;
                }
                case 1: {
                    this.pointsArr[1] = new Point2D.Double(dArray[0], dArray[1]);
                    this.pointsArr[2] = new Point2D.Double(dArray[2], dArray[3]);
                    this.pointsArr[3] = new Point2D.Double(dArray[4], dArray[5]);
                    break;
                }
                case 2: {
                    this.pointsArr[4] = new Point2D.Double(dArray[0], dArray[1]);
                    this.pointsArr[5] = new Point2D.Double(dArray[2], dArray[3]);
                    this.pointsArr[6] = new Point2D.Double(dArray[4], dArray[5]);
                    break;
                }
                case 3: {
                    this.pointsArr[7] = new Point2D.Double(dArray[0], dArray[1]);
                    this.pointsArr[8] = new Point2D.Double(dArray[2], dArray[3]);
                    this.pointsArr[9] = new Point2D.Double(dArray[4], dArray[5]);
                    break;
                }
                case 4: {
                    this.pointsArr[10] = new Point2D.Double(dArray[0], dArray[1]);
                    this.pointsArr[11] = new Point2D.Double(dArray[2], dArray[3]);
                }
            }
            ++n;
            pathIterator.next();
        }
        this.determineSteps();
        this.boundingBox = this.shape.getBounds();
    }

    public Point2D[] getPointsArray() {
        return this.pointsArr;
    }

    public Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(Rectangle rectangle) {
        this.boundingBox = rectangle;
    }

    private static Point2D[] curvePoints(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4, int n) {
        Point2D[] point2DArray = new Point2D[n + 1];
        point2DArray[0] = point2D;
        for (int i = 1; i <= n; ++i) {
            Point2D point2D5;
            float f = 1.0f / (float)n * (float)i;
            point2DArray[i] = point2D5 = ShadingUtils.findDistancedPoint(f, point2D, point2D2, point2D3, point2D4);
        }
        return point2DArray;
    }

    private static Point2D[] linePoints(Point2D point2D, Point2D point2D2, int n) {
        double d = point2D.distance(point2D2);
        Point2D[] point2DArray = new Point2D[n + 1];
        double d2 = d / (double)n;
        for (int i = 0; i <= n; ++i) {
            double d3 = d2 * (double)i / d;
            double d4 = d3 * point2D2.getX() + (1.0 - d3) * point2D.getX();
            double d5 = d3 * point2D2.getY() + (1.0 - d3) * point2D.getY();
            point2DArray[i] = new Point2D.Double(d4, d5);
        }
        return point2DArray;
    }

    private Point2D[] getC1Points() {
        return Shape67.curvePoints(this.pointsArr[0], this.pointsArr[11], this.pointsArr[10], this.pointsArr[9], this.nSteps);
    }

    private Point2D[] getC2Points() {
        return Shape67.curvePoints(this.pointsArr[3], this.pointsArr[4], this.pointsArr[5], this.pointsArr[6], this.nSteps);
    }

    private Point2D[] getD1Points() {
        return Shape67.curvePoints(this.pointsArr[0], this.pointsArr[1], this.pointsArr[2], this.pointsArr[3], this.nSteps);
    }

    private Point2D[] getD2Points() {
        return Shape67.curvePoints(this.pointsArr[9], this.pointsArr[8], this.pointsArr[7], this.pointsArr[6], this.nSteps);
    }

    public void generateBilinearMapping() {
        int n;
        Point2D[] point2DArray = this.getC1Points();
        Point2D[] point2DArray2 = this.getC2Points();
        Point2D[] point2DArray3 = this.getD1Points();
        Point2D[] point2DArray4 = this.getD2Points();
        int n2 = point2DArray.length;
        int n3 = point2DArray3.length;
        Point2D[][] point2DArray5 = new Point2D[n3][n2];
        Color[][] colorArray = new Color[n3][n2];
        double d = 1.0 / (double)(n3 - 1);
        double d2 = 1.0 / (double)(n2 - 1);
        double d3 = -d;
        int[][] nArray = new int[4][4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = new int[]{this.colorsArr[i].getRed(), this.colorsArr[i].getGreen(), this.colorsArr[i].getBlue(), this.colorsArr[i].getAlpha()};
        }
        for (n = 0; n < n3; ++n) {
            double d4 = 1.0 - (d3 += d);
            double d5 = -d2;
            for (int i = 0; i < n2; ++i) {
                double d6 = 1.0 - (d5 += d2);
                double d7 = d4 * point2DArray[i].getX() + d3 * point2DArray2[i].getX();
                double d8 = d4 * point2DArray[i].getY() + d3 * point2DArray2[i].getY();
                double d9 = d6 * point2DArray3[n].getX() + d5 * point2DArray4[n].getX();
                double d10 = d6 * point2DArray3[n].getY() + d5 * point2DArray4[n].getY();
                double d11 = d4 * (d6 * point2DArray[0].getX() + d5 * point2DArray[point2DArray.length - 1].getX()) + d3 * (d6 * point2DArray2[0].getX() + d5 * point2DArray2[point2DArray2.length - 1].getX());
                double d12 = d4 * ((1.0 - d5) * point2DArray[0].getY() + d5 * point2DArray[point2DArray.length - 1].getY()) + d3 * (d6 * point2DArray2[0].getY() + d5 * point2DArray2[point2DArray2.length - 1].getY());
                double d13 = d7 + d9 - d11;
                double d14 = d8 + d10 - d12;
                point2DArray5[n][i] = new Point2D.Double(d13, d14);
                int[] nArray2 = new int[4];
                for (int j = 0; j < 4; ++j) {
                    nArray2[j] = (int)(d4 * (d6 * (double)nArray[0][j] + d5 * (double)nArray[3][j]) + d3 * (d6 * (double)nArray[1][j] + d5 * (double)nArray[2][j]));
                }
                colorArray[n][i] = new Color(nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
            }
        }
        n = point2DArray5.length - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                Point2D[] point2DArray6 = new Point2D[]{point2DArray5[i][j], point2DArray5[i][j + 1], point2DArray5[i + 1][j + 1], point2DArray5[i + 1][j]};
                Color[] colorArray2 = new Color[]{colorArray[i][j], colorArray[i][j + 1], colorArray[i + 1][j + 1], colorArray[i + 1][j]};
                this.patches.add(new TinyPatch(point2DArray6, colorArray2));
            }
        }
    }

    public Color findPointColor(Point point, boolean bl) {
        if (this.patches.isEmpty()) {
            this.generateBilinearMapping();
        }
        Color color = null;
        if (this.lastFound != null && this.lastFound.getPath().contains(point)) {
            Color[] colorArray = this.lastFound.getColors();
            Point2D[] point2DArray = this.lastFound.getPoints();
            return this.recurseTrapezoidal(point, point2DArray, colorArray, bl, 0);
        }
        for (TinyPatch tinyPatch : this.patches) {
            if (tinyPatch.getPath().contains(point)) {
                this.lastFound = tinyPatch;
                Color[] colorArray = tinyPatch.getColors();
                Point2D[] point2DArray = tinyPatch.getPoints();
                return this.recurseTrapezoidal(point, point2DArray, colorArray, bl, 0);
            }
            this.lastFound = null;
        }
        return color;
    }

    public Color recurseTrapezoidal(Point2D point2D, Point2D[] point2DArray, Color[] colorArray, boolean bl, int n) {
        int n2;
        if (n > 2 || !bl || point2DArray[0].distance(point2DArray[1]) < 4.0) {
            return colorArray[0];
        }
        Point2D[] point2DArray2 = Shape67.linePoints(point2DArray[0], point2DArray[3], 2);
        Point2D[] point2DArray3 = Shape67.linePoints(point2DArray[1], point2DArray[2], 2);
        Point2D[] point2DArray4 = Shape67.linePoints(point2DArray[0], point2DArray[1], 2);
        Point2D[] point2DArray5 = Shape67.linePoints(point2DArray[3], point2DArray[2], 2);
        int n3 = point2DArray2.length;
        int n4 = point2DArray4.length;
        Point2D[][] point2DArray6 = new Point2D[n4][n3];
        Color[][] colorArray2 = new Color[n4][n3];
        double d = 1.0 / (double)(n4 - 1);
        double d2 = 1.0 / (double)(n3 - 1);
        double d3 = -d;
        int[][] nArray = new int[4][4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = new int[]{colorArray[i].getRed(), colorArray[i].getGreen(), colorArray[i].getBlue(), colorArray[i].getAlpha()};
        }
        for (n2 = 0; n2 < n4; ++n2) {
            double d4 = 1.0 - (d3 += d);
            double d5 = -d2;
            for (int i = 0; i < n3; ++i) {
                double d6 = 1.0 - (d5 += d2);
                double d7 = d4 * point2DArray2[i].getX() + d3 * point2DArray3[i].getX();
                double d8 = d4 * point2DArray2[i].getY() + d3 * point2DArray3[i].getY();
                double d9 = d6 * point2DArray4[n2].getX() + d5 * point2DArray5[n2].getX();
                double d10 = d6 * point2DArray4[n2].getY() + d5 * point2DArray5[n2].getY();
                double d11 = d4 * (d6 * point2DArray2[0].getX() + d5 * point2DArray2[point2DArray2.length - 1].getX()) + d3 * (d6 * point2DArray3[0].getX() + d5 * point2DArray3[point2DArray3.length - 1].getX());
                double d12 = d4 * ((1.0 - d5) * point2DArray2[0].getY() + d5 * point2DArray2[point2DArray2.length - 1].getY()) + d3 * (d6 * point2DArray3[0].getY() + d5 * point2DArray3[point2DArray3.length - 1].getY());
                double d13 = d7 + d9 - d11;
                double d14 = d8 + d10 - d12;
                point2DArray6[n2][i] = new Point2D.Double(d13, d14);
                int[] nArray2 = new int[4];
                for (int j = 0; j < 4; ++j) {
                    nArray2[j] = (int)(d4 * (d6 * (double)nArray[0][j] + d5 * (double)nArray[3][j]) + d3 * (d6 * (double)nArray[1][j] + d5 * (double)nArray[2][j]));
                }
                colorArray2[n2][i] = new Color(nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
            }
        }
        n2 = point2DArray6.length - 1;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                Point2D[] point2DArray7 = new Point2D[]{point2DArray6[i][j], point2DArray6[i][j + 1], point2DArray6[i + 1][j + 1], point2DArray6[i + 1][j]};
                Color[] colorArray3 = new Color[]{colorArray2[i][j], colorArray2[i][j + 1], colorArray2[i + 1][j + 1], colorArray2[i + 1][j]};
                TinyPatch tinyPatch = new TinyPatch(point2DArray7, colorArray3);
                if (!tinyPatch.getPath().contains(point2D)) continue;
                return this.recurseTrapezoidal(point2D, point2DArray7, colorArray3, bl, ++n);
            }
        }
        return colorArray[0];
    }

    private void determineSteps() {
        int n = (int)this.pointsArr[0].distance(this.pointsArr[6]);
        this.nSteps = n < 4 ? 4 : Math.min(10, n);
    }

    protected Shape67 cloneShape() {
        return new Shape67((Point2D[])this.pointsArr.clone(), (Color[])this.colorsArr.clone());
    }

    public class TinyPatch {
        private final GeneralPath path;
        private final Color[] colors;
        private final Point2D[] points;

        public TinyPatch(Point2D[] point2DArray, Color[] colorArray) {
            this.colors = colorArray;
            this.points = point2DArray;
            this.path = new GeneralPath();
            this.path.moveTo(point2DArray[0].getX(), point2DArray[0].getY());
            this.path.lineTo(point2DArray[1].getX(), point2DArray[1].getY());
            this.path.lineTo(point2DArray[2].getX(), point2DArray[2].getY());
            this.path.lineTo(point2DArray[3].getX(), point2DArray[3].getY());
            this.path.closePath();
        }

        public GeneralPath getPath() {
            return this.path;
        }

        public Color[] getColors() {
            return this.colors;
        }

        public Point2D[] getPoints() {
            return this.points;
        }
    }
}

