/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.display.PageOffsets;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.linear.LinearParser;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;

public class FileAccess {
    Certificate certificate;
    private PageOffsets currentOffset;
    private String password;
    private DynamicVectorRenderer currentDisplay;
    private int lastPageDecoded = -1;
    PrivateKey key;
    private PdfPageData pageData = new PdfPageData();
    private ObjectStore objectStoreRef = new ObjectStore();
    public boolean isOpen;
    int minimumCacheSize = -1;
    private static final Calendar cal = Calendar.getInstance();
    static int bb = 5;
    private boolean closeOnExit = true;
    private String filename;
    private PdfObjectReader currentPdfFile;
    private int pageCount;
    private int pageNumber = 1;
    private boolean isDecoding;
    final LinearParser linearParser = new LinearParser();
    final ExternalHandlers externalHandlers;
    private static final String flag = "06309265023764729";
    private final PdfResources res;
    private final DecoderOptions options;
    float[] defaultMediaSize;
    float[] defaultCropSize;

    public FileAccess(ExternalHandlers externalHandlers, PdfResources pdfResources, DecoderOptions decoderOptions) {
        this.externalHandlers = externalHandlers;
        this.res = pdfResources;
        this.options = decoderOptions;
    }

    public boolean isFileViewable(PdfObjectReader pdfObjectReader) {
        if (pdfObjectReader != null) {
            PdfFileReader pdfFileReader = pdfObjectReader.getObjectReader();
            DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
            return decryptionFactory == null || decryptionFactory.getBooleanValue(100) || this.certificate != null;
        }
        return false;
    }

    void openPdfArray(byte[] byArray, String string) throws PdfException {
        this.password = string;
        this.openPdfArray(byArray);
    }

    void openPdfArray(byte[] byArray) throws PdfException {
        if (byArray == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        if (this.isOpen) {
            this.closePdfFile();
        }
        this.isOpen = false;
        this.res.flush();
        this.res.flushObjects();
        try {
            this.currentPdfFile = this.password != null ? new PdfObjectReader(this.password) : new PdfObjectReader();
            this.currentPdfFile.openPdfFile(byArray);
            this.openPdfFile();
            this.objectStoreRef.storeFileName("r" + System.currentTimeMillis());
        }
        catch (PdfException pdfException) {
            throw new PdfException("[PDF] OpenPdfArray generated exception " + pdfException.getMessage());
        }
    }

    DynamicVectorRenderer getDynamicRenderer() {
        return this.currentDisplay;
    }

    public PdfResources getRes() {
        return this.res;
    }

    DynamicVectorRenderer getDynamicRenderer(boolean bl) {
        DynamicVectorRenderer dynamicVectorRenderer = this.currentDisplay;
        if (bl) {
            this.currentDisplay = new SwingDisplay(0, this.objectStoreRef, false);
        }
        return dynamicVectorRenderer;
    }

    public final void openPdfFileFromStream(Object object, String string) throws PdfException {
        ImageInputStream imageInputStream;
        this.closeOnExit = false;
        if (object instanceof ImageInputStream) {
            imageInputStream = (ImageInputStream)object;
            if (this.isOpen) {
                this.closePdfFile();
            }
        } else {
            throw new RuntimeException(object + " not currently an option");
        }
        this.isOpen = false;
        this.filename = "ImageInputStream" + System.currentTimeMillis();
        this.res.flush();
        this.res.flushObjects();
        this.objectStoreRef.storeFileName(this.filename);
        this.currentPdfFile = new PdfObjectReader(string);
        this.currentPdfFile.openPdfFile(imageInputStream);
        this.openPdfFile();
    }

    void openPdfFile(String string, String string2) throws PdfException {
        if (this.isOpen) {
            this.closePdfFile();
        }
        this.isOpen = false;
        this.filename = string;
        this.res.flush();
        this.res.flushObjects();
        this.objectStoreRef.storeFileName(string);
        this.currentPdfFile = new PdfObjectReader(string2);
        this.currentPdfFile.openPdfFile(string);
        this.openPdfFile();
    }

    int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int n) {
        this.pageNumber = n;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    void setPageCount(int n) {
        this.pageCount = n;
    }

    boolean isDecoding() {
        return this.isDecoding;
    }

    void setDecoding(boolean bl) {
        this.isDecoding = bl;
    }

    public boolean isPasswordSupplied(PdfObjectReader pdfObjectReader) {
        if (pdfObjectReader != null) {
            PdfFileReader pdfFileReader = pdfObjectReader.getObjectReader();
            DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
            return decryptionFactory != null && (decryptionFactory.getBooleanValue(104) || this.certificate != null);
        }
        return false;
    }

    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    void setObjectStore(ObjectStore objectStore) {
        this.objectStoreRef = objectStore;
    }

    public void setUserEncryption(Certificate certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.key = privateKey;
    }

    public PdfObjectReader getNewReader() {
        PdfObjectReader pdfObjectReader = this.certificate != null ? new PdfObjectReader(this.certificate, this.key) : new PdfObjectReader();
        return pdfObjectReader;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public PdfObjectReader getIO() {
        return this.currentPdfFile;
    }

    public void setIO(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
    }

    public final boolean isEncrypted() {
        if (this.currentPdfFile != null) {
            PdfFileReader pdfFileReader = this.currentPdfFile.getObjectReader();
            DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
            return decryptionFactory != null && decryptionFactory.getBooleanValue(101);
        }
        return false;
    }

    public void dispose() {
        if (this.currentPdfFile != null) {
            this.currentPdfFile.dispose();
        }
        this.currentPdfFile = null;
        if (this.currentDisplay != null) {
            this.currentDisplay.dispose();
        }
        this.currentDisplay = null;
        ++bb;
        bb = 2;
    }

    public String getFilename() {
        return this.filename;
    }

    public int readAllPageReferences(boolean bl, PdfObject pdfObject, Map map, Map map2, int n, AcroRenderer acroRenderer, PdfResources pdfResources, int n2, int n3) {
        Object object;
        String string = pdfObject.getObjectRefAsString();
        int n4 = 0;
        int n5 = pdfObject.getParameterConstant(608780341);
        if (n5 == -1) {
            n5 = 825701731;
        }
        int n6 = pdfObject.getInt(1144088180);
        String string2 = pdfObject.getStringKey(1110793845);
        if (n6 == -1) {
            while (string2 != null && n6 == -1) {
                if (string2 != null && (object = map.get(string2)) != null) {
                    n6 = (Integer)object;
                }
                if (n6 != -1) continue;
                string2 = (String)map2.get(string2);
            }
            if (n6 != -1) {
                map.put(string, n6);
                map2.put(string, string2);
            }
        } else {
            map.put(string, n6);
            map2.put(string, string2);
        }
        if (n6 != -1) {
            n4 = n6;
        }
        object = this.pageData;
        ((PdfPageData)object).setPageRotation(n4, n);
        float[] fArray = pdfObject.getFloatArray(1313305473);
        float[] fArray2 = pdfObject.getFloatArray(1076199815);
        if (fArray == null) {
            fArray = this.defaultMediaSize;
        }
        if (fArray2 == null) {
            fArray2 = this.defaultCropSize;
        }
        if (fArray != null) {
            ((PdfPageData)object).setMediaBox(fArray);
        }
        if (fArray2 != null) {
            ((PdfPageData)object).setCropBox(fArray2);
        }
        if (n5 == 825701731) {
            if (pdfObject.getDictionary(2004251818) != null) {
                pdfResources.setPdfObject(2, pdfObject.getDictionary(2004251818));
            }
            byte[][] byArray = pdfObject.getKeyArray(456733763);
            int n7 = 0;
            if (byArray != null) {
                n7 = byArray.length;
            }
            if (n7 > 0) {
                for (int i = 0; i < n7; ++i) {
                    PageObject pageObject = new PageObject(new String(byArray[i]));
                    pageObject.ignoreRecursion(bl);
                    pageObject.ignoreStream(true);
                    float[] fArray3 = this.defaultMediaSize;
                    this.defaultMediaSize = fArray;
                    float[] fArray4 = this.defaultCropSize;
                    this.defaultCropSize = fArray2;
                    this.currentPdfFile.readObject(pageObject);
                    n = this.readAllPageReferences(bl, pageObject, map, map2, n, acroRenderer, pdfResources, n2, n3);
                    this.defaultMediaSize = fArray3;
                    this.defaultCropSize = fArray4;
                }
            }
        } else if (n5 == 540096309) {
            this.currentPdfFile.setLookup(string, n);
            ((PdfPageData)object).checkSizeSet(n);
            if (acroRenderer != null) {
                byte[][] byArray = pdfObject.getKeyArray(1044338049);
                if (byArray != null && byArray.length == 1 && byArray[0] == null) {
                    byArray = null;
                }
                if (byArray != null) {
                    acroRenderer.resetAnnotData(n2, n3, this.pageData, n, this.currentPdfFile, byArray);
                }
            }
            ++n;
        }
        return n;
    }

    PdfPageData getPdfPageData() {
        return this.pageData;
    }

    void setPageData(PdfPageData pdfPageData) {
        this.pageData = pdfPageData;
    }

    public void waitForDecodingToFinish() {
        while (this.isDecoding) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + interruptedException.getMessage());
                }
                this.isDecoding = false;
            }
        }
    }

    boolean readFile(boolean bl, InputStream inputStream, String string, String string2) throws PdfException {
        this.objectStoreRef.setFileToDeleteOnFlush(ObjectStore.temp_dir + string);
        this.objectStoreRef.setFileToDeleteOnFlush(string);
        this.res.flush();
        this.res.flushObjects();
        this.currentPdfFile = string2 == null ? new PdfObjectReader() : new PdfObjectReader(string2);
        if (inputStream != null) {
            try {
                File file;
                if (string.startsWith("inputstream")) {
                    file = new File(ObjectStore.temp_dir + string);
                    this.filename = file.getAbsolutePath();
                } else {
                    file = ObjectStore.createTempFile(string);
                }
                this.objectStoreRef.storeFileName(file.getName().substring(0, file.getName().lastIndexOf(46)));
                if (bl) {
                    byte[] byArray = this.linearParser.readLinearData(this.currentPdfFile, file, inputStream, this);
                    if (byArray != null) {
                        this.currentPdfFile.openPdfFile(byArray);
                        this.openPdfFile();
                        if (this.pageCount < 2) {
                            this.options.setDisplayView(1);
                        } else {
                            this.options.setDisplayView(this.options.getPageMode());
                        }
                        this.linearParser.linearizedBackgroundReaderer.start();
                        return true;
                    }
                } else {
                    this.currentPdfFile.openPdfFile(inputStream);
                    this.openPdfFile();
                    if (this.pageCount < 2) {
                        this.options.setDisplayView(1);
                    } else {
                        this.options.setDisplayView(this.options.getPageMode());
                    }
                }
                if (bl) {
                    this.openPdfFile(file.getAbsolutePath());
                    this.objectStoreRef.storeFileName(file.getName().substring(0, file.getName().lastIndexOf(46)));
                }
            }
            catch (IOException iOException) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF] Exception " + iOException + " opening URL ");
                }
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public void closePdfFile() {
        AcroRenderer acroRenderer;
        this.waitForDecodingToFinish();
        if (bb < 1) {
            System.out.println("JPedal Trial has now expired");
            LogWriter.writeLog("JPedal Trial has now expired");
            System.exit(1);
        } else if (bb < 15) {
            System.out.println("Trial expires in " + bb + " days");
            LogWriter.writeLog("Trial expires in " + bb + " days");
        }
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        this.linearParser.closePdfFile();
        Javascript javascript = this.externalHandlers.getJavaScript();
        if (javascript != null) {
            javascript.closeFile();
        }
        if ((acroRenderer = this.externalHandlers.getFormRenderer()) != null) {
            acroRenderer.openFile(this.pageCount, 0, 0, this.pageData, this.currentPdfFile, null);
            acroRenderer.removeDisplayComponentsFromScreen();
        }
        this.objectStoreRef.flush();
        ObjectStore.flushPages();
        this.pageCount = 0;
        if (this.currentPdfFile != null && this.closeOnExit) {
            this.currentPdfFile.closePdfFile();
            this.currentPdfFile = null;
        }
        this.lastPageDecoded = -1;
        this.currentDisplay.flush();
    }

    public void setStreamCacheSize(int n) {
        this.minimumCacheSize = n;
    }

    int getLastPageDecoded() {
        return this.lastPageDecoded;
    }

    void setLastPageDecoded(int n) {
        this.lastPageDecoded = n;
    }

    public void setDVR(DynamicVectorRenderer dynamicVectorRenderer) {
        this.currentDisplay = dynamicVectorRenderer;
    }

    public PageOffsets getOffset() {
        return this.currentOffset;
    }

    public void setOffset(PageOffsets pageOffsets) {
        this.currentOffset = pageOffsets;
    }

    public void openPdfFile() throws PdfException {
        this.currentPdfFile.setJavaScriptObject(this.externalHandlers.getJavaScript());
        if (bb < 1) {
            throw new RuntimeException("JPedal Trial has now expired");
        }
        this.pageNumber = 1;
        this.isDecoding = true;
        AcroRenderer acroRenderer = this.externalHandlers.getFormRenderer();
        try {
            PdfObject pdfObject;
            this.currentPdfFile.getObjectReader().setCacheSize(this.minimumCacheSize);
            PdfPageData pdfPageData = this.pageData = new PdfPageData();
            String string = this.currentPdfFile.getObjectReader().getType();
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Pdf version : " + string);
            }
            if (string == null) {
                this.currentPdfFile = null;
                this.isDecoding = false;
                throw new PdfException("No version on first line ");
            }
            int n = -1;
            if (this.linearParser.hasLinearData()) {
                pdfObject = this.linearParser.readHintTable(this.currentPdfFile);
                n = this.linearParser.getPageCount();
            } else {
                pdfObject = this.currentPdfFile.getObjectReader().readReferenceTable(null);
            }
            if (!this.isEncrypted() || this.isPasswordSupplied(this.currentPdfFile)) {
                PdfObject pdfObject2;
                int n2;
                if (pdfObject != null) {
                    pdfObject.ignoreRecursion(true);
                    this.res.setValues(pdfObject, this.currentPdfFile);
                    PdfObject pdfObject3 = pdfObject.getDictionary(826094945);
                    if (pdfObject3 != null) {
                        this.currentPdfFile.readNames(pdfObject3, this.externalHandlers.getJavaScript(), false);
                    }
                }
                if ((n2 = pdfObject.getParameterConstant(608780341)) != 540096309 && (pdfObject2 = pdfObject.getDictionary(825701731)) != null) {
                    pdfObject = new PageObject(pdfObject2.getObjectRefAsString());
                    this.currentPdfFile.readObject(pdfObject);
                    if (pdfObject.getParameterConstant(608780341) == -1) {
                        pdfObject = pdfObject2;
                    }
                }
                if (pdfObject != null) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Pages being read from " + pdfObject + ' ' + pdfObject.getObjectRefAsString());
                    }
                    this.pageNumber = 1;
                    if (acroRenderer != null) {
                        acroRenderer.resetAnnotData(this.options.getInsetW(), this.options.getInsetW(), pdfPageData, 1, this.currentPdfFile, null);
                    }
                    int n3 = this.readAllPageReferences(true, pdfObject, new HashMap(1000), new HashMap(1000), 1, acroRenderer, this.res, this.options.getInsetW(), this.options.getInsetH());
                    this.pageCount = n > 0 ? n : n3 - 1;
                    if (this.pageCount == 0 && LogWriter.isOutput()) {
                        LogWriter.writeLog("No pages found");
                    }
                }
                if (acroRenderer != null) {
                    this.pageCount = acroRenderer.openFile(this.pageCount, this.options.getInsetW(), this.options.getInsetH(), pdfPageData, this.currentPdfFile, this.res.getPdfObject(1));
                }
                pdfPageData.setPageCount(this.pageCount);
            }
            this.currentOffset = null;
            this.isOpen = true;
        }
        catch (PdfException pdfException) {
            this.isDecoding = false;
            this.isOpen = true;
            this.closePdfFile();
            this.isOpen = false;
            throw new PdfException(pdfException.getMessage() + " opening file");
        }
        finally {
            this.isDecoding = false;
        }
    }

    public void openPdfFile(String string) throws PdfException {
        this.isOpen = false;
        this.filename = string;
        this.res.flush();
        this.res.flushObjects();
        this.objectStoreRef.storeFileName(string);
        this.currentPdfFile = this.getNewReader();
        this.currentPdfFile.openPdfFile(string);
        this.openPdfFile();
        if (this.pageCount < 2) {
            this.options.setDisplayView(1);
        } else {
            this.options.setDisplayView(this.options.getPageMode());
        }
    }

    static {
        bb = 2;
        int n = 1;
        int n2 = Integer.parseInt(flag.substring(3, 5));
        int n3 = Integer.parseInt(flag.substring(0, n + n));
        int n4 = Integer.parseInt(flag.substring(2, 3));
        int n5 = Integer.parseInt(flag.substring(5, 6));
        int n6 = Integer.parseInt(flag.substring(6, 7 * n));
        int n7 = Integer.parseInt(flag.substring(7, 8));
        int n8 = Integer.parseInt(flag.substring(8, 10));
        int n9 = Integer.parseInt(flag.substring(10, 11));
        int n10 = Integer.parseInt(flag.substring(11, 15));
        Calendar calendar = Calendar.getInstance();
        int n11 = n8 - n - n7;
        if (n11 < 0) {
            n11 = 12 + n11;
        }
        calendar.set(2, n11);
        calendar.set(1, 1000 * (n + n) + n2 + n6);
        int n12 = n3 - n4;
        if (n12 < 1) {
            n12 = 31 + n12;
        }
        calendar.set(5, n12);
        long l = 86400000L;
        bb = (int)((Calendar.getInstance().getTime().getTime() - calendar.getTime().getTime()) / l);
        bb = 2;
        bb = 30 - bb;
        bb = 2;
    }
}

