/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.jpedal.FileAccess;
import org.jpedal.display.PageOffsets;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.structuredtext.HTMLMarkedContentGenerator;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.parser.PDFtoImageConvertor;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.ImageDisplay;
import org.jpedal.text.TextLines;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class Parser {
    private String decodeStatus = "";
    private StatusBar statusBar;
    private String fontsInFile = "";
    private String imagesInFile = "";
    private float multiplyer = 1.0f;
    private PdfImageData pdfImages = new PdfImageData();
    private PdfImageData pdfBackgroundImages = new PdfImageData();
    private PdfData pdfData;
    private PdfData pdfBackgroundData;
    private int displayRotation;
    private float scaling = 1.0f;
    private boolean isBackgroundDecoding;
    private final ExternalHandlers externalHandlers;
    private int extractionMode = 7;
    private int renderMode = 7;
    private DecoderOptions options = new DecoderOptions();
    private final FileAccess fileAcces;
    private PdfResources res = new PdfResources();
    private DecoderResults resultsFromDecode = new DecoderResults();
    private final TextLines textLines = new TextLines();
    private boolean generateGlyphOnRender;
    private int indent;
    private int specialMode;
    private final boolean useJavaFX;
    private boolean warnOnceOnForms;
    private PdfObject structTreeRootObj;
    private HTMLMarkedContentGenerator htmlMarkedContent;

    float getHiResUpscaleFactor() {
        return this.multiplyer;
    }

    void setParms(int n, float f, int n2, int n3) {
        this.displayRotation = n;
        this.scaling = f;
        this.indent = n2;
        this.specialMode = n3;
    }

    void resetOnOpen() {
        this.warnOnceOnForms = false;
    }

    TextLines getTextLines() {
        return this.textLines;
    }

    Parser(ExternalHandlers externalHandlers, DecoderOptions decoderOptions, FileAccess fileAccess, PdfResources pdfResources, DecoderResults decoderResults) {
        this.externalHandlers = externalHandlers;
        this.options = decoderOptions;
        this.fileAcces = fileAccess;
        this.res = pdfResources;
        this.resultsFromDecode = decoderResults;
        this.useJavaFX = externalHandlers.isJavaFX();
        externalHandlers.setDVR(fileAccess);
    }

    void setExtractionMode(int n, float f) {
        boolean bl;
        PdfPageData pdfPageData = this.fileAcces.getPdfPageData();
        pdfPageData.setScalingValue(f);
        this.extractionMode = n;
        PdfLayerList pdfLayerList = this.res.getPdfLayerList();
        if (pdfLayerList != null && (bl = pdfLayerList.setZoom(f))) {
            this.decodePage(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decodePageInBackground(int n) throws PdfException {
        if (this.fileAcces.isDecoding()) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[PDF]WARNING - this file is being decoded already in foreground");
                LogWriter.writeLog("[PDF]Multiple access not recommended - use  waitForDecodingToFinish() to check");
            }
        } else if (this.isBackgroundDecoding) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[PDF]WARNING - this file is being decoded already in background");
            }
        } else {
            try {
                this.isBackgroundDecoding = true;
                if (n > this.fileAcces.getPageCount()) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Page out of bounds");
                    }
                } else {
                    String string = this.getIO().getReferenceforPage(n);
                    AcroRenderer acroRenderer = this.externalHandlers.getFormRenderer();
                    if (string != null || acroRenderer.isXFA() && acroRenderer.useXFA()) {
                        if (this.getIO() == null) {
                            throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                        }
                        PageObject pageObject = new PageObject(string);
                        this.getIO().readObject(pageObject);
                        PdfObject pdfObject = ((PdfObject)pageObject).getDictionary(2004251818);
                        pageObject.setPageNumber(n);
                        ObjectStore objectStore = new ObjectStore();
                        PdfStreamDecoder pdfStreamDecoder = acroRenderer.getStreamDecoder(this.getIO(), this.options.useHiResImageForDisplay(), this.res.getPdfLayerList(), false);
                        pdfStreamDecoder.setParameters(true, false, 0, this.extractionMode, false, this.useJavaFX);
                        pdfStreamDecoder.setXMLExtraction(this.options.isXMLExtraction());
                        this.externalHandlers.addHandlers(pdfStreamDecoder);
                        pdfStreamDecoder.setObjectValue(-9, this.fileAcces.getFilename());
                        pdfStreamDecoder.setRenderer(new ImageDisplay(this.fileAcces.getPageNumber(), false, 5000, new ObjectStore()));
                        pdfStreamDecoder.setObjectValue(-8, objectStore);
                        pdfStreamDecoder.setObjectValue(-18, this.fileAcces.getPdfPageData());
                        pdfStreamDecoder.setIntValue(-10, n);
                        this.res.setupResources(pdfStreamDecoder, false, pdfObject, this.fileAcces.getPageNumber(), this.getIO());
                        pdfStreamDecoder.decodePageContent(pageObject);
                        this.pdfBackgroundData = (PdfData)pdfStreamDecoder.getObjectValue(-19);
                        this.pdfBackgroundImages = (PdfImageData)pdfStreamDecoder.getObjectValue(-20);
                    }
                }
            }
            catch (PdfException pdfException) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + pdfException.getMessage());
                }
            }
            finally {
                this.isBackgroundDecoding = false;
            }
        }
    }

    BufferedImage getPageAsImage(int n, boolean bl) throws PdfException {
        BufferedImage bufferedImage = null;
        if (n > this.fileAcces.getPageCount() || n < 1) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Page " + n + " not in range");
            }
        } else {
            if (this.getIO() == null) {
                throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
            }
            String string = this.getIO().getReferenceforPage(n);
            PdfPageData pdfPageData = this.fileAcces.getPdfPageData();
            if (string != null || this.externalHandlers.getFormRenderer().isXFA()) {
                PDFtoImageConvertor pDFtoImageConvertor = this.externalHandlers.getConverter(this.multiplyer, this.options);
                bufferedImage = pDFtoImageConvertor.convert(this.resultsFromDecode, this.displayRotation, this.res, this.externalHandlers, this.renderMode, pdfPageData, this.externalHandlers.getFormRenderer(), this.scaling, this.getIO(), n, bl, string);
                if (TTGlyph.redecodePage) {
                    TTGlyph.redecodePage = false;
                    return this.getPageAsImage(n, bl);
                }
                this.multiplyer = pDFtoImageConvertor.getMultiplyer();
            }
            if (!DecoderOptions.isRunningOnAIX && !bl && bufferedImage != null) {
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
            }
        }
        return bufferedImage;
    }

    void setRenderMode(int n) {
        this.renderMode = n;
        this.extractionMode = n;
    }

    void setExtractionMode(int n) {
        this.extractionMode = n;
    }

    void disposeObjects() {
        FontMappings.fontsInitialised = false;
        this.externalHandlers.dispose();
        if (this.pdfData != null) {
            this.pdfData.dispose();
        }
        this.pdfData = null;
        FontMappings.defaultFont = null;
        this.fileAcces.dispose();
    }

    Object getJPedalObject(int n) {
        switch (n) {
            case 826881374: {
                return this.res.getPdfLayerList();
            }
            case 2004845231: {
                return this.fileAcces.linearParser.getLinearObject(this.fileAcces.isOpen, this.getIO());
            }
            case -1276915978: {
                return this.fileAcces.linearParser.linearizedBackgroundReaderer;
            }
            case 0x6F6A6AAF: {
                return this.fileAcces;
            }
        }
        return null;
    }

    synchronized BufferedImage getPageAsHiRes(int n, boolean bl) throws PdfException {
        this.multiplyer = this.options.getImageDimensions(n, this.fileAcces.getPdfPageData());
        return this.getPageAsImage(n, bl);
    }

    synchronized boolean isPageAvailable(int n) {
        return this.fileAcces.linearParser.isPageAvailable(n, this.getIO());
    }

    PdfData getPdfBackgroundData() {
        return this.pdfBackgroundData;
    }

    PdfData getPdfData() throws PdfException {
        if ((this.extractionMode & 1) == 0) {
            throw new PdfException("[PDF] Page data object requested will be empty as text extraction disabled. Enable with PdfDecoder method setExtractionMode(PdfDecoderInt.TEXT | other values");
        }
        return this.pdfData;
    }

    PdfGroupingAlgorithms getGroupingObject() throws PdfException {
        return this.options.getGroupingObject(this.fileAcces.getLastPageDecoded(), this.getPdfData(), this.fileAcces.getPdfPageData());
    }

    PdfGroupingAlgorithms getBackgroundGroupingObject() {
        return this.options.getBackgroundGroupingObject(this.pdfBackgroundData, this.fileAcces.getPdfPageData());
    }

    PdfImageData getPdfImageData() {
        return this.pdfImages;
    }

    PdfImageData getPdfBackgroundImageData() {
        return this.pdfBackgroundImages;
    }

    void flushObjectValues(boolean bl) {
        if (this.pdfData != null && !bl) {
            this.pdfData.flushTextList();
        }
        if (this.pdfImages != null && bl) {
            this.pdfImages.clearImageData();
        }
    }

    String getPageDecodeReport() {
        return this.decodeStatus;
    }

    String getInfo(int n) {
        String string;
        switch (n) {
            case 373243460: {
                if (this.fontsInFile == null) {
                    string = "No fonts defined";
                    break;
                }
                string = this.fontsInFile;
                break;
            }
            case 1026635598: {
                if (this.imagesInFile == null) {
                    string = "No images defined as XObjects";
                    break;
                }
                string = this.imagesInFile;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decodePage(int n) {
        Object object;
        block33: {
            DynamicVectorRenderer dynamicVectorRenderer;
            object = this.externalHandlers.getExternalHandler(31);
            if (object != null) {
                ((ErrorTracker)object).startedPageDecoding(n);
            }
            DynamicVectorRenderer dynamicVectorRenderer2 = (DynamicVectorRenderer)this.externalHandlers.getExternalHandler(20);
            PdfPageData pdfPageData = this.fileAcces.getPdfPageData();
            if (dynamicVectorRenderer2 != null) {
                dynamicVectorRenderer = dynamicVectorRenderer2;
                if (dynamicVectorRenderer2.isHTMLorSVG()) {
                    this.fileAcces.setDVR(dynamicVectorRenderer);
                    this.structTreeRootObj = this.res.getPdfObject(3);
                    if (this.structTreeRootObj != null) {
                        this.fileAcces.getIO().checkResolved(this.structTreeRootObj);
                    }
                }
            } else {
                dynamicVectorRenderer = this.fileAcces.getDynamicRenderer();
            }
            boolean bl = false;
            if (n == -1) {
                n = this.fileAcces.getLastPageDecoded();
                bl = true;
            }
            int n2 = n;
            if (this.fileAcces.isDecoding()) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF]WARNING - this file is being decoded already - use  waitForDecodingToFinish() to check");
                }
            } else {
                PdfObject pdfObject = this.fileAcces.linearParser.getLinearPageObject();
                AcroRenderer acroRenderer = this.externalHandlers.getFormRenderer();
                this.fileAcces.setDecoding(true);
                try {
                    Object object2;
                    Timer timer;
                    block34: {
                        this.fileAcces.setDecoding(true);
                        PdfLayerList pdfLayerList = this.res.getPdfLayerList();
                        if (pdfLayerList != null && pdfLayerList.getChangesMade()) {
                            this.handleJSInLayer(acroRenderer, pdfLayerList);
                        }
                        this.fileAcces.setLastPageDecoded(n2);
                        this.decodeStatus = "";
                        dynamicVectorRenderer.flush();
                        if (n2 > this.fileAcces.getPageCount() || n2 < 1) {
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("Page out of bounds");
                            }
                            this.fileAcces.setDecoding(false);
                            break block33;
                        }
                        timer = null;
                        if (this.statusBar != null) {
                            object2 = new ProgressListener();
                            timer = new Timer(150, (ActionListener)object2);
                            timer.start();
                        }
                        this.fileAcces.setPageNumber(n2);
                        if (this.getIO() == null) {
                            throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                        }
                        pdfObject = this.getPdfObject(n2, pdfObject);
                        object2 = this.setupObjectsForDecode(dynamicVectorRenderer, pdfPageData, n2, pdfObject, acroRenderer);
                        try {
                            if (this.textLines != null) {
                                this.textLines.setLineAreas(null);
                            }
                            if (this.htmlMarkedContent != null) {
                                ((PdfStreamDecoder)object2).setObjectValue(-5, this.htmlMarkedContent.getLookup());
                                this.htmlMarkedContent.traverseContentTree(this.structTreeRootObj, (PdfStreamDecoder)object2);
                            }
                            ((PdfStreamDecoder)object2).decodePageContent(pdfObject);
                        }
                        catch (Error error) {
                            this.decodeStatus = this.decodeStatus + "Error in decoding page " + error;
                        }
                        catch (PdfException pdfException) {
                            if (pdfException.getMessage() == null || !pdfException.getMessage().contains("JPeg 2000")) break block34;
                            this.decodeStatus = this.decodeStatus + "Error in decoding page " + pdfException;
                        }
                    }
                    this.setResultsFromDecode(n2, (PdfStreamDecoder)object2);
                    if (timer != null) {
                        timer.stop();
                        this.statusBar.setProgress(100);
                    }
                    if (this.options.getRenderPage() && !bl && (this.renderMode & 0x20) != 32 && !acroRenderer.ignoreForms()) {
                        PageOffsets pageOffsets = this.fileAcces.getOffset();
                        if (pageOffsets != null) {
                            acroRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, this.indent, 0, 0, 1, pageOffsets.getWidestPageNR(), pageOffsets.getWidestPageR());
                        }
                        acroRenderer.createDisplayComponentsForPage(n2, (PdfStreamDecoder)object2);
                        acroRenderer.getFormFactory().indexAllKids();
                        if (!(acroRenderer.useXFA() || dynamicVectorRenderer.getType() != 4 && dynamicVectorRenderer.getType() != 5)) {
                            List[] listArray = acroRenderer.getCompData().getFormList(true);
                            for (Object e : listArray[n2]) {
                                if (e == null) continue;
                                acroRenderer.getFormFlattener().drawFlattenedForm((PdfStreamDecoder)object2, (FormObject)e, true, (PdfObject)acroRenderer.getFormResources()[0]);
                            }
                        }
                        if (this.specialMode != -1 && this.specialMode != 1 && n2 != this.fileAcces.getPageCount()) {
                            // empty if block
                        }
                    }
                }
                catch (PdfException pdfException) {
                    Logger.getLogger(Parser.class.getName()).log(Level.SEVERE, null, pdfException);
                }
                finally {
                    this.fileAcces.setDecoding(false);
                    if (this.statusBar != null) {
                        this.statusBar.percentageDone = 100.0f;
                    }
                }
            }
        }
        if (TTGlyph.redecodePage) {
            TTGlyph.redecodePage = false;
            this.decodePage(n);
        }
        if (object != null) {
            ((ErrorTracker)object).finishedPageDecoding(n);
        }
        this.fileAcces.getDynamicRenderer().flagDecodingFinished();
    }

    private PdfObject getPdfObject(int n, PdfObject pdfObject) {
        if (pdfObject == null) {
            pdfObject = new PageObject(this.getIO().getReferenceforPage(n));
            this.getIO().readObject(pdfObject);
            this.getIO().checkParentForResources(pdfObject);
        }
        if (pdfObject.getPageNumber() == -1) {
            pdfObject.setPageNumber(n);
        }
        return pdfObject;
    }

    private void handleJSInLayer(AcroRenderer acroRenderer, PdfLayerList pdfLayerList) {
        Iterator iterator = pdfLayerList.getJSCommands();
        Javascript javascript = this.externalHandlers.getJavaScript();
        if (javascript != null && iterator != null) {
            while (iterator.hasNext()) {
                javascript.executeAction((String)iterator.next());
            }
        }
        this.fileAcces.setLastPageDecoded(-1);
        pdfLayerList.setChangesMade(false);
        acroRenderer.getCompData().setForceRedraw(true);
        acroRenderer.getCompData().setLayerData(pdfLayerList);
        acroRenderer.getCompData().resetScaledLocation(this.scaling, this.displayRotation, this.indent);
    }

    private PdfStreamDecoder setupObjectsForDecode(DynamicVectorRenderer dynamicVectorRenderer, PdfPageData pdfPageData, int n, PdfObject pdfObject, AcroRenderer acroRenderer) throws PdfException {
        PdfStreamDecoder pdfStreamDecoder;
        PdfObject pdfObject2 = pdfObject.getDictionary(2004251818);
        if (acroRenderer.isXFA() && acroRenderer.useXFA()) {
            pdfStreamDecoder = acroRenderer.getStreamDecoder(this.getIO(), this.options.useHiResImageForDisplay(), this.res.getPdfLayerList(), false);
            pdfObject2 = (PdfObject)acroRenderer.getFormResources()[0];
        } else {
            pdfStreamDecoder = acroRenderer.getStreamDecoder(this.getIO(), this.options.useHiResImageForDisplay(), this.res.getPdfLayerList(), false);
            if (!this.warnOnceOnForms) {
                this.warnOnceOnForms = true;
            }
        }
        if (!this.warnOnceOnForms) {
            this.warnOnceOnForms = acroRenderer.showFormWarningMessage(n);
        }
        pdfStreamDecoder.setXMLExtraction(this.options.isXMLExtraction());
        dynamicVectorRenderer.setHiResImageForDisplayMode(this.options.useHiResImageForDisplay());
        dynamicVectorRenderer.setPrintPage(n);
        dynamicVectorRenderer.setCustomColorHandler((ColorHandler)this.externalHandlers.getExternalHandler(19));
        pdfStreamDecoder.setParameters(true, this.options.getRenderPage(), this.renderMode, this.extractionMode, false, this.useJavaFX);
        this.externalHandlers.addHandlers(pdfStreamDecoder);
        pdfStreamDecoder.setObjectValue(-9, this.fileAcces.getFilename());
        pdfStreamDecoder.setIntValue(-10, n);
        pdfStreamDecoder.setRenderer(dynamicVectorRenderer);
        pdfStreamDecoder.setObjectValue(-8, this.fileAcces.getObjectStore());
        pdfStreamDecoder.setObjectValue(-3, this.statusBar);
        pdfStreamDecoder.setObjectValue(-18, pdfPageData);
        this.res.setupResources(pdfStreamDecoder, false, pdfObject2, n, this.getIO());
        dynamicVectorRenderer.init(pdfPageData.getMediaBoxWidth(n), pdfPageData.getMediaBoxHeight(n), pdfPageData.getRotation(n), this.options.getPageColor());
        if (!dynamicVectorRenderer.isHTMLorSVG() && this.options.getTextColor() != null) {
            dynamicVectorRenderer.setValue(2, this.options.getTextColor().getRGB());
            if (this.options.getChangeTextAndLine()) {
                dynamicVectorRenderer.setValue(3, 1);
            } else {
                dynamicVectorRenderer.setValue(3, 0);
            }
            dynamicVectorRenderer.setValue(4, this.options.getReplacementColorThreshold());
        }
        return pdfStreamDecoder;
    }

    private void setResultsFromDecode(int n, PdfStreamDecoder pdfStreamDecoder) {
        if (this.textLines != null && this.extractionMode > 0) {
            Vector_Rectangle_Int vector_Rectangle_Int = (Vector_Rectangle_Int)pdfStreamDecoder.getObjectValue(-21);
            vector_Rectangle_Int.trim();
            int[][] nArray = vector_Rectangle_Int.get();
            Vector_Int vector_Int = (Vector_Int)pdfStreamDecoder.getObjectValue(22);
            vector_Int.trim();
            int[] nArray2 = vector_Int.get();
            for (int i = 0; i != nArray.length; ++i) {
                this.textLines.addToLineAreas(nArray[i], nArray2[i], n);
            }
        }
        this.fontsInFile = (String)pdfStreamDecoder.getObjectValue(373243460);
        this.imagesInFile = (String)pdfStreamDecoder.getObjectValue(1026635598);
        this.pdfData = (PdfData)pdfStreamDecoder.getObjectValue(-19);
        this.pdfImages = (PdfImageData)pdfStreamDecoder.getObjectValue(-20);
        this.resultsFromDecode.update(pdfStreamDecoder, true);
    }

    protected PdfObjectReader getIO() {
        return this.fileAcces.getIO();
    }

    void resetMultiplyer() {
        this.multiplyer = 1.0f;
    }

    void resetFontsInFile() {
        this.fontsInFile = "";
    }

    void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    class ProgressListener
    implements ActionListener {
        ProgressListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Parser.this.statusBar.setProgress((int)((Parser)Parser.this).statusBar.percentageDone);
        }
    }
}

