/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.border.Border;
import org.jpedal.FileAccess;
import org.jpedal.Parser;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.structuredtext.MarkedContentGenerator;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.text.TextLines;
import org.jpedal.utils.DPIFactory;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;

public class PdfDecoderServer
implements PdfDecoderInt {
    private final DecoderOptions options = new DecoderOptions();
    private final ExternalHandlers externalHandlers = new ExternalHandlers();
    private final PdfResources res = new PdfResources();
    final FileAccess fileAccess = new FileAccess(this.externalHandlers, this.res, this.options);
    private final DecoderResults resultsFromDecode = new DecoderResults();
    final Parser parser = new Parser(this.externalHandlers, this.options, this.fileAccess, this.res, this.resultsFromDecode);
    private final DPIFactory scalingdpi = new DPIFactory();
    private ActionHandler formsActionHandler;
    private ActionHandler userActionHandler;
    private boolean isNewRotationSet;
    int displayRotation;
    int x_size = 100;
    int y_size = 100;
    int max_y;
    float scaling = 1.0f;

    @Override
    public boolean isOpen() {
        return this.fileAccess.isOpen();
    }

    @Override
    public Document getMarkedContent() {
        return new MarkedContentGenerator().getMarkedContentTree(this.res, this.fileAccess.getPdfPageData(), this.getIO());
    }

    @Override
    public int getDisplayRotation() {
        return this.displayRotation;
    }

    @Override
    public int getPageNumber() {
        return this.fileAccess.getPageNumber();
    }

    @Override
    public void setDisplayRotation(int n) {
        this.displayRotation = n;
    }

    @Override
    public Display getPages() {
        return null;
    }

    @Override
    public int getlastPageDecoded() {
        return this.fileAccess.getLastPageDecoded();
    }

    @Override
    public Iterator getPageInfo(int n) {
        return this.resultsFromDecode.getPageInfo(n);
    }

    @Override
    public OutlineData getOutlineData() {
        return this.res.getOutlineData();
    }

    @Override
    public boolean isLoadingLinearizedPDF() {
        return this.fileAccess.linearParser.linearizedBackgroundReaderer != null && this.fileAccess.linearParser.linearizedBackgroundReaderer.isAlive();
    }

    public void showExpiry() {
        System.out.println("Trial expires in " + FileAccess.bb + " days");
    }

    @Override
    public void resetViewableArea() {
    }

    @Override
    public int getPageAlignment() {
        return this.options.getPageAlignment();
    }

    public static void init(boolean bl) {
        DecoderOptions.embedWidthData = bl;
    }

    public PdfDecoderServer(boolean bl) {
        this.setup(bl);
    }

    public PdfDecoderServer() {
        this.setup(true);
    }

    public static void disposeAllStatic() {
        StandardFonts.dispose();
        FontMappings.dispose();
    }

    @Override
    public final void dispose() {
        this.parser.disposeObjects();
    }

    @Override
    public final void closePdfFile() {
        this.fileAccess.closePdfFile();
    }

    public final PdfData getPdfBackgroundData() {
        return this.parser.getPdfBackgroundData();
    }

    @Override
    public final PdfData getPdfData() throws PdfException {
        return this.parser.getPdfData();
    }

    @Override
    public final boolean hasOutline() {
        return this.res.hasOutline();
    }

    @Override
    public final Document getOutlineAsXML() {
        return this.res.getOutlineAsXML(this.getIO());
    }

    @Override
    public final PdfPageData getPdfPageData() {
        return this.fileAccess.getPdfPageData();
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int n) throws PdfException {
        return this.getPageAsHiRes(n, false);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int n, Map map) throws PdfException {
        if (map != null) {
            this.modifyNonstaticJPedalParameters(map);
        }
        return this.getPageAsHiRes(n);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int n, Map map, boolean bl) throws PdfException {
        if (map != null) {
            this.options.set(map);
        }
        return this.getPageAsHiRes(n, bl);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int n, boolean bl) throws PdfException {
        boolean bl2 = this.getFormRenderer().getCompData().formsRasterizedForDisplay();
        this.getFormRenderer().getCompData().setRasterizeForms(true);
        this.parser.setParms(this.displayRotation, this.scaling, 0, -1);
        BufferedImage bufferedImage = this.parser.getPageAsHiRes(n, bl);
        this.getFormRenderer().getCompData().setRasterizeForms(bl2);
        return bufferedImage;
    }

    @Override
    public BufferedImage getPageAsImage(int n) throws PdfException {
        return this.getPageAsImage(n, false);
    }

    @Override
    public BufferedImage getPageAsTransparentImage(int n) throws PdfException {
        return this.getPageAsImage(n, true);
    }

    private BufferedImage getPageAsImage(int n, boolean bl) throws PdfException {
        boolean bl2 = this.getFormRenderer().getCompData().formsRasterizedForDisplay();
        this.getFormRenderer().getCompData().setRasterizeForms(true);
        this.parser.setParms(this.displayRotation, this.scaling, 0, -1);
        BufferedImage bufferedImage = this.parser.getPageAsImage(n, bl);
        this.getFormRenderer().getCompData().setRasterizeForms(bl2);
        return bufferedImage;
    }

    @Override
    public float getHiResUpscaleFactor() {
        return this.parser.getHiResUpscaleFactor();
    }

    @Override
    public final void flushObjectValues(boolean bl) {
        this.parser.flushObjectValues(bl);
    }

    @Override
    public final PdfImageData getPdfImageData() {
        return this.parser.getPdfImageData();
    }

    public final PdfImageData getPdfBackgroundImageData() {
        return this.parser.getPdfBackgroundImageData();
    }

    @Override
    public final void setRenderMode(int n) {
        this.parser.setRenderMode(n);
    }

    @Override
    public final void setExtractionMode(int n) {
        this.parser.setExtractionMode(n);
    }

    @Override
    public void modifyNonstaticJPedalParameters(Map map) throws PdfException {
        this.options.set(map);
    }

    public static void modifyJPedalParameters(Map map) throws PdfException {
        if (map != null) {
            DecoderOptions.modifyJPedalParameters(map);
        }
    }

    @Override
    public final PdfFileInformation getFileInformationData() {
        return this.res.getMetaData(this.getIO());
    }

    @Override
    public final void setExtractionMode(int n, float f) {
        this.scaling = f;
        this.parser.setExtractionMode(n, f);
    }

    @Override
    public DPIFactory getDPIFactory() {
        return this.scalingdpi;
    }

    @Override
    public final void setPageParameters(float f, int n) {
        AcroRenderer acroRenderer;
        boolean bl;
        this.fileAccess.setPageNumber(n);
        this.parser.resetMultiplyer();
        if (f > 0.0f) {
            this.scaling = f;
        } else {
            f = this.scaling;
        }
        PdfLayerList pdfLayerList = this.res.getPdfLayerList();
        if (pdfLayerList != null && (bl = pdfLayerList.setZoom(this.scalingdpi.removeScaling(f)))) {
            this.decodePage(-1);
        }
        PdfPageData pdfPageData = this.fileAccess.getPdfPageData();
        pdfPageData.setScalingValue(f);
        int n2 = pdfPageData.getMediaBoxWidth(n);
        this.max_y = pdfPageData.getMediaBoxHeight(n);
        int n3 = pdfPageData.getCropBoxWidth(n);
        int n4 = pdfPageData.getCropBoxHeight(n);
        this.x_size = (int)((float)n3 * f);
        this.y_size = (int)((float)n4 * f);
        if (!this.isNewRotationSet) {
            this.displayRotation = pdfPageData.getRotation(n);
        } else {
            this.isNewRotationSet = false;
        }
        DynamicVectorRenderer dynamicVectorRenderer = this.fileAccess.getDynamicRenderer();
        dynamicVectorRenderer.init(n2, this.max_y, this.displayRotation, this.options.getPageColor());
        if (!dynamicVectorRenderer.isHTMLorSVG()) {
            dynamicVectorRenderer.setValue(1, this.options.getPageColor().getRGB());
            if (this.options.getTextColor() != null) {
                dynamicVectorRenderer.setValue(2, this.options.getTextColor().getRGB());
                if (this.options.getChangeTextAndLine()) {
                    dynamicVectorRenderer.setValue(3, 1);
                } else {
                    dynamicVectorRenderer.setValue(3, 0);
                }
            }
        }
        if ((acroRenderer = this.externalHandlers.getFormRenderer()) != null) {
            acroRenderer.getCompData().setForceRedraw(true);
        }
    }

    @Override
    public final void setPageParameters(float f, int n, int n2) {
        this.isNewRotationSet = true;
        this.displayRotation = n2;
        this.setPageParameters(f, n);
    }

    @Override
    public void waitForDecodingToFinish() {
        this.fileAccess.waitForDecodingToFinish();
    }

    @Override
    public DynamicVectorRenderer getDynamicRenderer() {
        return this.fileAccess.getDynamicRenderer();
    }

    @Override
    public DynamicVectorRenderer getDynamicRenderer(boolean bl) {
        return this.fileAccess.getDynamicRenderer(bl);
    }

    @Override
    public PdfObjectReader getIO() {
        return this.parser.getIO();
    }

    @Override
    public final void decodePage(int n) {
        boolean bl = this.isPageAvailable(n);
        PdfObject pdfObject = this.fileAccess.linearParser.getLinearPageObject();
        if (!bl) {
            return;
        }
        if (bl && pdfObject != null) {
            this.fileAccess.readAllPageReferences(true, pdfObject, new HashMap(1000), new HashMap(1000), n, this.getFormRenderer(), this.res, this.options.getInsetW(), this.options.getInsetH());
        }
        this.parser.setParms(this.displayRotation, this.scaling, 0, -1);
        this.parser.decodePage(n);
    }

    @Override
    public synchronized boolean isPageAvailable(int n) {
        return this.parser.isPageAvailable(n);
    }

    @Override
    public void drawAdditionalObjectsOverPage(int n, int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        DynamicVectorRenderer dynamicVectorRenderer = this.fileAccess.getDynamicRenderer();
        if (n == this.getPageNumber()) {
            dynamicVectorRenderer.drawAdditionalObjectsOverPage(nArray, colorArray, objectArray);
        }
    }

    @Override
    public void flushAdditionalObjectsOnPage(int n) throws PdfException {
        if (n == this.getPageNumber()) {
            DynamicVectorRenderer dynamicVectorRenderer = this.fileAccess.getDynamicRenderer();
            dynamicVectorRenderer.flushAdditionalObjOnPage();
        }
    }

    @Override
    public boolean isHiResScreenDisplay() {
        return this.options.useHiResImageForDisplay();
    }

    @Override
    public void useHiResScreenDisplay(boolean bl) {
        this.options.useHiResImageForDisplay(bl);
    }

    @Override
    public final synchronized void decodePageInBackground(int n) throws PdfException {
        this.parser.decodePageInBackground(n);
    }

    @Override
    public final int getPageCount() {
        return this.fileAccess.getPageCount();
    }

    @Override
    public final boolean isEncrypted() {
        return this.fileAccess.isEncrypted();
    }

    @Override
    public final boolean isPasswordSupplied() {
        return this.fileAccess.isPasswordSupplied(this.getIO());
    }

    @Override
    public boolean isFileViewable() {
        return this.fileAccess.isFileViewable(this.getIO());
    }

    @Override
    public boolean isExtractionAllowed() {
        if (this.getIO() != null) {
            PdfFileReader pdfFileReader = this.getIO().getObjectReader();
            DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
            return decryptionFactory == null || decryptionFactory.getBooleanValue(103);
        }
        return false;
    }

    @Override
    public final void setEncryptionPassword(String string) throws PdfException {
        block4: {
            if (this.getIO() == null) {
                throw new PdfException("Must open PdfDecoder file first");
            }
            this.getIO().getObjectReader().setPassword(string);
            if (this.getIO() != null) {
                try {
                    this.preOpen();
                    this.fileAccess.openPdfFile();
                    this.postOpen();
                }
                catch (PdfException pdfException) {
                    if (!LogWriter.isOutput()) break block4;
                    LogWriter.writeLog("Exception " + pdfException + " opening file");
                }
            }
        }
    }

    @Override
    public final void openPdfArray(byte[] byArray) throws PdfException {
        if (byArray == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        this.preOpen();
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.fileAccess.openPdfArray(byArray);
        this.postOpen();
    }

    @Override
    public final void openPdfArray(byte[] byArray, String string) throws PdfException {
        if (byArray == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        this.preOpen();
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.fileAccess.openPdfArray(byArray, string);
        this.postOpen();
    }

    @Override
    public void openPdfFile(String string, Certificate certificate, PrivateKey privateKey) throws PdfException {
        this.fileAccess.setUserEncryption(certificate, privateKey);
        this.openPdfFile(string);
    }

    @Override
    public final void openPdfFileFromStream(Object object, String string) throws PdfException {
        this.preOpen();
        this.fileAccess.openPdfFileFromStream(object, string);
        this.postOpen();
    }

    @Override
    public final void openPdfFile(String string) throws PdfException {
        if (this.fileAccess.isOpen && this.fileAccess.linearParser.linearizedBackgroundReaderer == null) {
            this.closePdfFile();
        }
        this.preOpen();
        this.fileAccess.openPdfFile(string);
        this.postOpen();
    }

    @Override
    public final void openPdfFile(String string, String string2) throws PdfException {
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.preOpen();
        this.fileAccess.openPdfFile(string, string2);
        this.postOpen();
    }

    @Override
    public final boolean openPdfFileFromURL(String string, boolean bl) throws PdfException {
        String string2;
        InputStream inputStream;
        block2: {
            this.preOpen();
            inputStream = null;
            string2 = null;
            try {
                URL uRL = new URL(string);
                string2 = uRL.getPath().substring(uRL.getPath().lastIndexOf(47) + 1);
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
        boolean bl2 = this.fileAccess.readFile(bl, inputStream, string2, null);
        this.postOpen();
        return bl2;
    }

    @Override
    public final boolean openPdfFileFromURL(String string, boolean bl, String string2) throws PdfException {
        InputStream inputStream;
        String string3;
        try {
            URL uRL = new URL(string);
            string3 = uRL.getPath().substring(uRL.getPath().lastIndexOf(47) + 1);
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
            throw new PdfException("[PDFException] Unable to open URL " + string);
        }
        this.preOpen();
        boolean bl2 = this.fileAccess.readFile(bl, inputStream, string3, string2);
        this.postOpen();
        return bl2;
    }

    @Override
    public final boolean openPdfFileFromInputStream(InputStream inputStream, boolean bl) throws PdfException {
        String string = "inputstream" + System.currentTimeMillis() + '-' + this.fileAccess.getObjectStore().getKey() + ".pdf";
        this.preOpen();
        boolean bl2 = this.fileAccess.readFile(bl, inputStream, string, null);
        this.postOpen();
        return bl2;
    }

    @Override
    public final boolean openPdfFileFromInputStream(InputStream inputStream, boolean bl, String string) throws PdfException {
        String string2 = "inputstream" + System.currentTimeMillis() + '-' + this.fileAccess.getObjectStore().getKey() + ".pdf";
        this.preOpen();
        boolean bl2 = this.fileAccess.readFile(bl, inputStream, string2, string);
        this.postOpen();
        return bl2;
    }

    private void postOpen() {
        if (this.fileAccess.getPageCount() < 2) {
            this.options.setDisplayView(1);
        } else {
            this.options.setDisplayView(this.options.getPageMode());
        }
    }

    private void preOpen() {
        this.fileAccess.setDecoding(true);
        this.options.setDisplayView(2);
        this.fileAccess.setDecoding(false);
        this.parser.resetOnOpen();
        Object object = this.externalHandlers.getExternalHandler(6);
        this.externalHandlers.openPdfFile(object);
        AcroRenderer acroRenderer = this.externalHandlers.getFormRenderer();
        acroRenderer.resetHandler(null, this.scalingdpi.getDpi(), this.externalHandlers.getJavaScript());
    }

    @Override
    public Object getJPedalObject(int n) {
        return this.parser.getJPedalObject(n);
    }

    @Override
    public void setPageMode(int n) {
        this.options.setPageMode(n);
    }

    @Override
    public boolean isXMLExtraction() {
        return this.options.isXMLExtraction();
    }

    @Override
    public void useTextExtraction() {
        this.options.setXMLExtraction(false);
    }

    @Override
    public void useXMLExtraction() {
        this.options.setXMLExtraction(true);
    }

    public void clearScreen() {
        DynamicVectorRenderer dynamicVectorRenderer = this.fileAccess.getDynamicRenderer();
        dynamicVectorRenderer.flush();
    }

    @Override
    public void setStreamCacheSize(int n) {
        this.fileAccess.setStreamCacheSize(n);
    }

    @Override
    public void setUserOffsets(int n, int n2, int n3) {
    }

    @Override
    public boolean hasEmbeddedFonts() {
        return this.resultsFromDecode.hasEmbeddedFonts();
    }

    @Override
    public int getPageFromObjectRef(String string) {
        return this.getIO().convertObjectToPageNumber(string);
    }

    @Override
    public String getInfo(int n) {
        return this.parser.getInfo(n);
    }

    @Override
    public AcroRenderer getFormRenderer() {
        return this.externalHandlers.getFormRenderer();
    }

    @Override
    public Javascript getJavaScript() {
        return this.externalHandlers.getJavaScript();
    }

    @Override
    public String getPageDecodeReport() {
        return this.parser.getPageDecodeReport();
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.fileAccess.getObjectStore();
    }

    @Override
    public void setObjectStore(ObjectStore objectStore) {
        this.fileAccess.setObjectStore(objectStore);
    }

    @Override
    public DecoderOptions getDecoderOptions() {
        return this.options;
    }

    @Override
    public PdfGroupingAlgorithms getGroupingObject() throws PdfException {
        return this.parser.getGroupingObject();
    }

    @Override
    public PdfGroupingAlgorithms getBackgroundGroupingObject() {
        return this.parser.getBackgroundGroupingObject();
    }

    @Override
    public final String getPDFVersion() {
        if (this.getIO() == null) {
            return "";
        }
        return this.getIO().getObjectReader().getType();
    }

    public boolean hasAllImages() {
        return this.resultsFromDecode.getImagesProcessedFully();
    }

    @Override
    public boolean getPageDecodeStatus(int n) {
        return this.resultsFromDecode.getPageDecodeStatus(n);
    }

    @Override
    public String getPageDecodeStatusReport(int n) {
        return this.resultsFromDecode.getPageDecodeStatusReport(n);
    }

    @Override
    public void addExternalHandler(Object object, int n) {
        switch (n) {
            case 5: {
                this.userActionHandler = (ActionHandler)object;
                break;
            }
            default: {
                this.externalHandlers.addExternalHandler(object, n);
            }
        }
    }

    @Override
    public Object getExternalHandler(int n) {
        switch (n) {
            case 17: {
                return this.fileAccess.getOffset();
            }
        }
        return this.externalHandlers.getExternalHandler(n);
    }

    @Override
    public String getFileName() {
        return this.fileAccess.getFilename();
    }

    @Override
    public boolean isForm() {
        return this.res.isForm();
    }

    @Override
    public TextLines getTextLines() {
        return this.parser.getTextLines();
    }

    @Override
    public final int getPDFWidth() {
        int n = this.options.getInsetW();
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.y_size + n + n;
        }
        return this.x_size + n + n;
    }

    @Override
    public final int getPDFHeight() {
        int n = this.options.getInsetH();
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.x_size + n + n;
        }
        return this.y_size + n + n;
    }

    @Override
    public int getDisplayView() {
        return this.options.getDisplayView();
    }

    @Override
    public float getScaling() {
        return this.scaling;
    }

    private void setup(boolean bl) {
        this.options.setRenderPage(bl);
        if (!FontMappings.fontsInitialised) {
            FontMappings.initFonts();
            FontMappings.fontsInitialised = true;
        }
    }

    @Override
    public int getInsetH() {
        return this.options.getInsetH();
    }

    @Override
    public int getInsetW() {
        return this.options.getInsetW();
    }

    @Override
    public BufferedImage getSelectedRectangleOnscreen(float f, float f2, float f3, float f4, float f5) {
        return null;
    }

    @Override
    public int getScrollInterval() {
        return this.options.getScrollInterval();
    }

    @Override
    public void setScrollInterval(int n) {
        this.options.setScrollInterval(n);
    }

    @Override
    public void resetForNonPDFPage(int n) {
    }

    @Override
    public void setPDFBorder(Border border) {
    }

    @Override
    public void updateCursorBoxOnScreen(Rectangle rectangle, Color color) {
    }

    @Override
    public void updateCursorBoxOnScreen(int[] nArray, int n) {
    }

    @Override
    public AffineTransform setViewableArea(Rectangle rectangle) throws PdfException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHardwareAccelerationforScreen(boolean bl) {
    }

    @Override
    public ExternalHandlers getExternalHandler() {
        return null;
    }

    @Override
    public int getSpecialMode() {
        return 0;
    }

    @Override
    public boolean useNewGraphicsMode() {
        return false;
    }

    @Override
    public void useNewGraphicsMode(boolean bl) {
    }

    @Override
    public void setScaling(float f) {
    }

    @Override
    public void setStatusBarObject(StatusBar statusBar) {
    }

    @Override
    public void setInset(int n, int n2) {
    }

    @Override
    public int[] getMaxSizeWH() {
        return null;
    }

    @Override
    public int[] getPaneBounds() {
        return null;
    }

    @Override
    public void repaintPane(int n) {
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void setBorderPresent(boolean bl) {
    }

    @Override
    public boolean isBorderPresent() {
        return false;
    }

    @Override
    public void setPreviewThumbnail(BufferedImage bufferedImage, String string) {
    }

    @Override
    public int getTextPrint() {
        return -1;
    }

    @Override
    public Rectangle getVisibleRect() {
        return null;
    }

    @Override
    public DisplayOffsets getDisplayOffsets() {
        return null;
    }

    static {
        block9: {
            String string = System.getProperty("os.name");
            if (string.equals("Mac OS X")) {
                DecoderOptions.isRunningOnMac = true;
            } else if (string.startsWith("Windows")) {
                DecoderOptions.isRunningOnWindows = true;
            } else if (string.startsWith("AIX")) {
                DecoderOptions.isRunningOnAIX = true;
            } else if (string.equals("Linux")) {
                DecoderOptions.isRunningOnLinux = true;
            }
            try {
                DecoderOptions.javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
            }
            catch (NumberFormatException numberFormatException) {
                if (!LogWriter.isOutput()) break block9;
                LogWriter.writeLog("Exception: " + numberFormatException.getMessage());
            }
        }
    }
}

