/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.color.PdfColor;
import org.jpedal.color.SeparationColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;

public class DeviceNColorSpace
extends SeparationColorSpace {
    private static final long serialVersionUID = -1372268945371555187L;
    private final Map cache = new HashMap();

    public DeviceNColorSpace(PdfObjectReader pdfObjectReader, PdfObject pdfObject) {
        this.setType(960981604);
        this.processColorToken(pdfObjectReader, pdfObject);
    }

    @Override
    public void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        this.setColor(fArray, n);
    }

    @Override
    public void setColor(float[] fArray, int n) {
        Object object;
        int n2;
        int[] nArray = new int[3];
        int n3 = fArray.length;
        if (n3 > 3) {
            n3 = 3;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = (int)(fArray[n2] * 255.0f);
        }
        n2 = 0;
        if (this.cmykMapping == 1009857357 && n == 1) {
            object = new float[]{0.0f, 0.0f, 0.0f, fArray[0]};
            this.altCS.setColor((float[])object, ((float[])object).length);
        } else if (n < 4 && this.cache.get((nArray[0] << 16) + (nArray[1] << 8) + nArray[2]) != null) {
            n2 = 1;
            object = this.cache.get((nArray[0] << 16) + (nArray[1] << 8) + nArray[2]);
            int n4 = (Integer)object;
            int n5 = n4 >> 16 & 0xFF;
            int n6 = n4 >> 8 & 0xFF;
            int n7 = n4 & 0xFF;
            this.altCS.currentColor = new PdfColor(n5, n6, n7);
        } else if (this.cmykMapping == 9 && n == 4) {
            object = new float[]{fArray[0], fArray[1], fArray[2], fArray[3]};
            this.altCS.setColor((float[])object, ((float[])object).length);
        } else if (this.cmykMapping == 1 && n == 3) {
            object = new float[]{0.0f, fArray[0], fArray[1], fArray[2]};
            this.altCS.setColor((float[])object, ((float[])object).length);
        } else if (this.cmykMapping == 2 && n == 3) {
            object = new float[]{fArray[0], fArray[1], fArray[2], 0.0f};
            this.altCS.setColor((float[])object, ((float[])object).length);
        } else if (this.cmykMapping == 4 && n == 3) {
            object = new float[]{fArray[0], fArray[1], 0.0f, fArray[2]};
            this.altCS.setColor((float[])object, ((float[])object).length);
        } else if (this.cmykMapping == 5 && n == 2) {
            object = new float[]{fArray[0], 0.0f, fArray[1], 0.0f};
            this.altCS.setColor((float[])object, ((float[])object).length);
        } else if (this.cmykMapping == 8 && n == 2) {
            object = new float[]{fArray[0], fArray[1], 0.0f, 0.0f};
            this.altCS.setColor((float[])object, ((float[])object).length);
        } else if (this.cmykMapping == 6 && n == 2) {
            object = new float[]{0.0f, fArray[0], fArray[1], 0.0f};
            this.altCS.setColor((float[])object, ((float[])object).length);
        } else {
            object = this.colorMapper.getOperandFloat(fArray);
            this.altCS.setColor((float[])object, ((float[])object).length);
        }
        if (n2 == 0) {
            this.altCS.getColor().getRGB();
            int n8 = this.altCS.getColor().getRGB();
            this.cache.put((nArray[0] << 16) + (nArray[1] << 8) + nArray[2], n8);
        }
    }

    @Override
    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = this.createImage(n, n2, byArray, false);
        return bufferedImage;
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl, PdfObject pdfObject) {
        BufferedImage bufferedImage = null;
        Raster raster = JPEGDecoder.getRasterFromJPEG(byArray, "JPEG");
        if (raster != null) {
            raster = DeviceNColorSpace.cleanupRaster(raster, n3, n4, this.componentCount);
            int n5 = raster.getWidth();
            int n6 = raster.getHeight();
            DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
            bufferedImage = this.createImage(n5, n6, dataBufferByte.getData(), bl);
        }
        return bufferedImage;
    }

    @Override
    BufferedImage createImage(int n, int n2, byte[] byArray, boolean bl) {
        byte[] byArray2 = new byte[n * n2 * 3];
        int n3 = byArray.length;
        int n4 = byArray.length / this.componentCount;
        float[] fArray = new float[this.componentCount];
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n4 && n5 < n3; ++i) {
            int n7;
            for (n7 = 0; n7 < this.componentCount; ++n7) {
                fArray[n7] = (float)(byArray[n5] & 0xFF) / 255.0f;
                ++n5;
            }
            this.setColor(fArray, this.componentCount);
            n7 = this.altCS.currentColor.getRGB();
            byArray2[n6] = (byte)(n7 >> 16 & 0xFF);
            byArray2[n6 + 1] = (byte)(n7 >> 8 & 0xFF);
            byArray2[n6 + 2] = (byte)(n7 & 0xFF);
            n6 += 3;
        }
        int[] nArray = new int[]{0, 1, 2};
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }
}

