/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.idrsolutions.image.jpeg2000.Jpeg2000Decoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javafx.scene.shape.Path;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.CMYKtoRGB;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.NodeList;

public class GenericColorSpace
implements Cloneable,
Serializable {
    boolean isConverted;
    float[] rawValues;
    Map patterns;
    float[][] CTM;
    private int size;
    float c = -1.0f;
    float y = -1.0f;
    float m = -1.0f;
    float k = -1.0f;
    float[] W;
    float[] G;
    float[] Ma;
    float[] R;
    static ColorSpace rgbCS;
    public static final String cb = "<color ";
    public static final String ce = "</color>";
    private int value = 1785221209;
    static ColorConvertOp CSToRGB;
    ColorSpace cs;
    int type;
    PdfPaint currentColor = new PdfColor(0, 0, 0);
    static ColorModel rgbModel;
    private static ICC_Profile ICCProfileForRGB;
    public static boolean fasterPNG;
    boolean failed;
    int alternative = -1;
    private PdfObject decodeParms;
    private boolean hasYCCKimages;
    boolean isPrinting;
    private static final int[] bands4;
    private int rawCSType;
    int r;
    int g;
    int b;
    byte[] IndexedColorMap;
    String pantoneName;
    int componentCount = 3;
    GraphicsState gs;
    int pageWidth;
    int pageHeight;

    public void setPrinting(boolean bl) {
        this.isPrinting = bl;
    }

    protected static void initCMYKColorspace() throws PdfException {
        try {
            Object object;
            if (ICCProfileForRGB == null) {
                rgbModel = new ComponentColorModel(rgbCS, new int[]{8, 8, 8}, false, false, 1, 0);
            } else {
                int n = rgbCS.getNumComponents();
                object = new int[n];
                for (int i = 0; i < n; ++i) {
                    object[i] = 8;
                }
                rgbModel = new ComponentColorModel(rgbCS, (int[])object, false, false, 1, 0);
            }
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(GenericColorSpace.class.getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm"));
            object = new ICC_ColorSpace(iCC_Profile);
            CSToRGB = new ColorConvertOp((ColorSpace)object, rgbCS, ColorSpaces.hints);
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + exception.getMessage() + " initialising color components");
            }
            throw new PdfException("[PDF] Unable to create CMYK colorspace. Check cmyk.icm in jar file");
        }
    }

    public void reset() {
        this.currentColor = new PdfColor(0, 0, 0);
    }

    public boolean isInvalid() {
        return this.failed;
    }

    public int getIndexSize() {
        return this.size;
    }

    public PdfPaint getColor() {
        return this.currentColor;
    }

    public ColorSpace getColorSpace() {
        return this.cs;
    }

    GenericColorSpace() {
        this.cs = rgbCS;
    }

    protected void setAlternateColorSpace(int n) {
        this.alternative = n;
    }

    public int getAlternateColorSpace() {
        return this.alternative;
    }

    public void restoreColorStatus() {
        this.currentColor = new PdfColor(this.r, this.g, this.b);
    }

    public Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to clone object " + exception);
        }
        return object;
    }

    protected final BufferedImage nonRGBJPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4) {
        BufferedImage bufferedImage;
        block40: {
            ImageInputStream imageInputStream;
            ImageReader imageReader;
            ByteArrayInputStream byteArrayInputStream;
            block38: {
                boolean bl = false;
                bufferedImage = null;
                byteArrayInputStream = null;
                imageReader = null;
                imageInputStream = null;
                try {
                    int n5;
                    Object object;
                    block39: {
                        int n6;
                        Object object2;
                        int n7;
                        block37: {
                            if (CSToRGB == null) {
                                GenericColorSpace.initCMYKColorspace();
                            }
                            CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                            n7 = GenericColorSpace.getJPEGTransform(byArray);
                            try {
                                object = ImageIO.getImageReadersByFormatName("JPEG");
                                while (object.hasNext() && !(imageReader = (object2 = object.next())).canReadRaster()) {
                                }
                            }
                            catch (Exception exception) {
                                if (LogWriter.isOutput()) {
                                    LogWriter.writeLog("Unable to find jars on classpath " + exception);
                                }
                                return null;
                            }
                            ImageIO.setUseCache(false);
                            imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                            imageReader.setInput(imageInputStream, true);
                            object = imageReader.readRaster(0, null);
                            if (fArray != null) {
                                if (fArray.length == 6 && fArray[0] == 1.0f && fArray[1] == 0.0f && fArray[2] == 1.0f && fArray[3] == 0.0f && fArray[4] == 1.0f && fArray[5] == 0.0f || fArray.length > 2 && fArray[0] == 1.0f && fArray[1] == 0.0f) {
                                    object2 = ((Raster)object).getDataBuffer();
                                    n5 = ((DataBuffer)object2).getSize();
                                    for (n6 = 0; n6 < n5; ++n6) {
                                        ((DataBuffer)object2).setElem(n6, 255 - ((DataBuffer)object2).getElem(n6));
                                    }
                                } else if (fArray.length == 6 && fArray[0] == 0.0f && fArray[1] == 1.0f && fArray[2] == 0.0f && fArray[3] == 1.0f && fArray[4] == 0.0f && fArray[5] == 1.0f || fArray == null || fArray.length > 0) {
                                    // empty if block
                                }
                            }
                            if (this.cs.getNumComponents() == 1 && n7 == 0) {
                                bufferedImage = JPEGDecoder.grayJPEGToRGBImage(byArray, n3, n4, false);
                                if (bufferedImage != null) {
                                    bl = true;
                                }
                            } else {
                                if (this.cs.getNumComponents() == 4) {
                                    bl = true;
                                    try {
                                        if (n7 == 2) {
                                            this.hasYCCKimages = true;
                                            bufferedImage = ColorSpaceConvertor.iccConvertCMYKImageToRGB(((DataBufferByte)((Raster)object).getDataBuffer()).getData(), n, n2);
                                            break block37;
                                        }
                                        object = GenericColorSpace.cleanupRaster((Raster)object, n3, n4, 4);
                                        n = ((Raster)object).getWidth();
                                        n2 = ((Raster)object).getHeight();
                                        bufferedImage = CMYKtoRGB.convert((Raster)object, n, n2);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        if (LogWriter.isOutput()) {
                                            LogWriter.writeLog("Problem with JPEG conversion");
                                        }
                                        break block37;
                                    }
                                }
                                if (n7 != 0) {
                                    bufferedImage = imageReader.read(0);
                                    bufferedImage = GenericColorSpace.cleanupImage(bufferedImage, n3, n4);
                                    bl = true;
                                }
                            }
                        }
                        if (bl) break block38;
                        if (n7 == 4) {
                            object = GenericColorSpace.cleanupRaster((Raster)object, n3, n4, 4);
                            n5 = ((Raster)object).getWidth();
                            n6 = ((Raster)object).getHeight();
                            object2 = rgbModel.createCompatibleWritableRaster(n5, n6);
                            CSToRGB.filter((Raster)object, (WritableRaster)object2);
                            bufferedImage = new BufferedImage(n5, n6, 1);
                            bufferedImage.setData((Raster)object2);
                            break block38;
                        }
                        n5 = 0;
                        try {
                            IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
                            String string = iIOMetadata.getNativeMetadataFormatName();
                            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree(string);
                            NodeList nodeList = iIOMetadataNode.getElementsByTagName("app14Adobe");
                            if (nodeList.getLength() > 0) {
                                n5 = 1;
                            }
                        }
                        catch (Exception exception) {
                            if (!LogWriter.isOutput()) break block39;
                            LogWriter.writeLog("[PDF] Unable to read metadata on Jpeg " + exception);
                        }
                    }
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("COLOR_ID_YCbCr image");
                    }
                    bufferedImage = n5 != 0 ? DefaultImageHelper.read(byArray) : ColorSpaceConvertor.algorithmicConvertYCbCrToRGB(((DataBufferByte)((Raster)object).getDataBuffer()).getData(), n, n2);
                    bufferedImage = GenericColorSpace.cleanupImage(bufferedImage, n3, n4);
                    bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
                }
                catch (Exception exception) {
                    bufferedImage = null;
                    exception.printStackTrace();
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
                    }
                }
                catch (Error error) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("JPeg error " + error);
                    }
                    if (imageReader != null) {
                        imageReader.dispose();
                    }
                    if (imageInputStream == null) break block38;
                    try {
                        imageInputStream.flush();
                    }
                    catch (IOException iOException) {
                        if (!LogWriter.isOutput()) break block38;
                        LogWriter.writeLog("Exception: " + iOException.getMessage());
                    }
                }
            }
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
                if (imageReader != null) {
                    imageReader.dispose();
                }
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block40;
                LogWriter.writeLog("Problem closing  " + exception);
            }
        }
        return bufferedImage;
    }

    protected static BufferedImage cleanupImage(BufferedImage bufferedImage, int n, int n2) {
        try {
            int n3 = bufferedImage.getType();
            if (GenericColorSpace.getSampling(bufferedImage.getWidth(), bufferedImage.getHeight(), n, n2) <= 1 || n3 == 0) {
                return bufferedImage;
            }
            if (n3 == 5) {
                return GenericColorSpace.cleanupBGRImage(bufferedImage, n, n2);
            }
            if (n3 == 5) {
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
            }
            Raster raster = GenericColorSpace.cleanupRaster(bufferedImage.getData(), n, n2, bufferedImage.getColorModel().getNumColorComponents());
            bufferedImage = new BufferedImage(raster.getWidth(), raster.getHeight(), bufferedImage.getType());
            bufferedImage.setData(raster);
            return bufferedImage;
        }
        catch (Error error) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[PDF] Error in cleanupImage " + error);
            }
            return bufferedImage;
        }
    }

    private static int getSampling(int n, int n2, int n3, int n4) {
        int n5 = 1;
        int n6 = n;
        if (n3 > 0 && n4 > 0) {
            int n7;
            int n8 = n4 << 2;
            int n9 = n3 << 2;
            for (int i = n2; n6 > n9 && i > n8; n6 >>= 1, i >>= 1) {
                n5 <<= 1;
            }
            int n10 = n / n3;
            if (n10 < 1) {
                n10 = 1;
            }
            if ((n7 = n2 / n4) < 1) {
                n7 = 1;
            }
            if ((n5 = n10) > n7) {
                n5 = n7;
            }
        }
        return n5;
    }

    protected static Raster cleanupRaster(Raster raster, int n, int n2, int n3) {
        block25: {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            String string = System.getProperty("org.jpedal.avoidCleanupRaster");
            if (string != null && string.toLowerCase().contains("true")) {
                return raster;
            }
            byte[] byArray = null;
            int[] nArray = null;
            DataBuffer dataBuffer = raster.getDataBuffer();
            boolean bl = dataBuffer instanceof DataBufferInt;
            if (bl) {
                nArray = ((DataBufferInt)dataBuffer).getData();
            } else {
                n11 = raster.getNumBands();
                if (n11 == n3) {
                    byArray = ((DataBufferByte)dataBuffer).getData();
                } else if (n11 == 1) {
                    byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                    n10 = byArray2.length;
                    n9 = n10 * n3;
                    n8 = 0;
                    n7 = 0;
                    byArray = new byte[n9];
                    do {
                        for (n6 = 0; n6 < n3; ++n6) {
                            byArray[n8] = byArray2[n7];
                            ++n8;
                        }
                    } while (++n7 < n10);
                }
            }
            n11 = 1;
            int n12 = raster.getWidth();
            n10 = raster.getHeight();
            n9 = n12;
            if (n > 0 && n2 > 0) {
                n7 = n2 << 2;
                n6 = n << 2;
                for (n8 = n10; n9 > n6 && n8 > n7; n9 >>= 1, n8 >>= 1) {
                    n11 <<= 1;
                }
                n5 = n12 / n;
                if (n5 < 1) {
                    n5 = 1;
                }
                if ((n4 = n10 / n2) < 1) {
                    n4 = 1;
                }
                if ((n11 = n5) > n4) {
                    n11 = n4;
                }
            }
            if (n11 > 1) {
                n9 = n12 / n11;
                n8 = n10 / n11;
                int n13 = n12;
                try {
                    int n14;
                    byte[] byArray3 = new byte[n9 * n8 * n3];
                    if (!bl) {
                        n13 = n12 * n3;
                    }
                    for (n6 = 0; n6 < n8; ++n6) {
                        for (n7 = 0; n7 < n9; ++n7) {
                            int n15 = n11;
                            n14 = n11;
                            int n16 = n12 - n7;
                            int n17 = n10 - n6;
                            if (n15 > n16) {
                                n15 = n16;
                            }
                            if (n14 > n17) {
                                n14 = n17;
                            }
                            for (int i = 0; i < n3; ++i) {
                                int n18 = 0;
                                int n19 = 0;
                                for (n4 = 0; n4 < n14; ++n4) {
                                    for (n5 = 0; n5 < n15; ++n5) {
                                        n18 = !bl ? (n18 += byArray[(n4 + n6 * n11) * n13 + (n7 * n11 * n3 + n5 * n3 + i)] & 0xFF) : (n18 += nArray[(n4 + n6 * n11) * n13 + n7 * n11 + n5] >> 8 * (2 - i) & 0xFF);
                                        ++n19;
                                    }
                                }
                                if (n19 <= 0) continue;
                                byArray3[i + n7 * n3 + n9 * n6 * n3] = (byte)(n18 / n19);
                            }
                        }
                    }
                    int[] nArray2 = new int[n3];
                    for (n14 = 0; n14 < n3; ++n14) {
                        nArray2[n14] = n14;
                    }
                    raster = Raster.createInterleavedRaster(new DataBufferByte(byArray3, byArray3.length), n9, n8, n9 * n3, n3, nArray2, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!LogWriter.isOutput()) break block25;
                    LogWriter.writeLog("Problem with Image");
                }
            }
        }
        return raster;
    }

    private static BufferedImage cleanupBGRImage(BufferedImage bufferedImage, int n, int n2) {
        block27: {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            String string = System.getProperty("org.jpedal.avoidCleanupRaster");
            if (string != null && string.toLowerCase().contains("true")) {
                return bufferedImage;
            }
            if (System.getProperty("java.version").startsWith("1.5")) {
                return bufferedImage;
            }
            Raster raster = bufferedImage.getData();
            int n11 = bufferedImage.getColorModel().getNumColorComponents();
            byte[] byArray = null;
            int[] nArray = null;
            DataBuffer dataBuffer = raster.getDataBuffer();
            boolean bl = dataBuffer instanceof DataBufferInt;
            if (bl) {
                nArray = ((DataBufferInt)dataBuffer).getData();
            } else {
                n10 = raster.getNumBands();
                if (n10 == n11) {
                    byArray = ((DataBufferByte)dataBuffer).getData();
                } else if (n10 == 1) {
                    byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                    n9 = byArray2.length;
                    n8 = n9 * n11;
                    n7 = 0;
                    n6 = 0;
                    byArray = new byte[n8];
                    do {
                        for (n5 = 0; n5 < n11; ++n5) {
                            byArray[n7] = byArray2[n6];
                            ++n7;
                        }
                    } while (++n6 < n9);
                }
            }
            n10 = 1;
            int n12 = raster.getWidth();
            n9 = raster.getHeight();
            n8 = n12;
            if (n > 0 && n2 > 0) {
                n6 = n2 << 2;
                n5 = n << 2;
                for (n7 = n9; n8 > n5 && n7 > n6; n8 >>= 1, n7 >>= 1) {
                    n10 <<= 1;
                }
                n4 = n12 / n;
                if (n4 < 1) {
                    n4 = 1;
                }
                if ((n3 = n9 / n2) < 1) {
                    n3 = 1;
                }
                if ((n10 = n4) > n3) {
                    n10 = n3;
                }
            }
            if (n10 > 1) {
                WritableRaster writableRaster = (WritableRaster)raster;
                n8 = n12 / n10;
                n7 = n9 / n10;
                int n13 = n12;
                try {
                    int[] nArray2 = new int[n11];
                    if (!bl) {
                        n13 = n12 * n11;
                    }
                    for (n4 = 0; n4 < n7; ++n4) {
                        for (n5 = 0; n5 < n8; ++n5) {
                            int n14 = n10;
                            int n15 = n10;
                            int n16 = n12 - n5;
                            int n17 = n9 - n4;
                            if (n14 > n16) {
                                n14 = n16;
                            }
                            if (n15 > n17) {
                                n15 = n17;
                            }
                            for (int i = 0; i < n11; ++i) {
                                int n18 = 0;
                                int n19 = 0;
                                for (int j = 0; j < n15; ++j) {
                                    for (n3 = 0; n3 < n14; ++n3) {
                                        n18 = !bl ? (n18 += byArray[(j + n4 * n10) * n13 + (n5 * n10 * n11 + n3 * n11 + i)] & 0xFF) : (n18 += nArray[(j + n4 * n10) * n13 + n5 * n10 + n3] >> 8 * (2 - i) & 0xFF);
                                        ++n19;
                                    }
                                }
                                if (n19 <= 0) continue;
                                if (i == 0) {
                                    nArray2[2] = n18 / n19;
                                    continue;
                                }
                                if (i == 2) {
                                    nArray2[0] = n18 / n19;
                                    continue;
                                }
                                nArray2[i] = n18 / n19;
                            }
                            writableRaster.setPixels(n5, n4, 1, 1, nArray2);
                        }
                    }
                    bufferedImage = new BufferedImage(n8, n7, bufferedImage.getType());
                    bufferedImage.setData(writableRaster);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!LogWriter.isOutput()) break block27;
                    LogWriter.writeLog("Problem with Image");
                }
            }
        }
        return bufferedImage;
    }

    private static int getJPEGTransform(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = n2 - 2;
        block0: while (n3 < n4) {
            int n5 = byArray[n3 + 1] & 0xFF;
            n3 += 2;
            if (n5 == 1 || 208 <= n5 && n5 <= 218) continue;
            if (n5 == 218) {
                n3 = n3 + ((byArray[n3] & 0xFF) << 8) + (byArray[n3 + 1] & 0xFF);
                while (true) {
                    if (n3 < n4 && ((byArray[n3] & 0xFF) != 255 || byArray[n3 + 1] == 0)) {
                        ++n3;
                        continue;
                    }
                    int n6 = byArray[n3 + 1] & 0xFF;
                    if (208 > n6 || n6 > 215) continue block0;
                    n3 += 2;
                }
            }
            if (n3 + 1 >= n2) continue;
            if (n5 == 238 && byArray[n3 + 2] == 65 && byArray[n3 + 3] == 100 && byArray[n3 + 4] == 111 && byArray[n3 + 5] == 98 && byArray[n3 + 6] == 101) {
                n = byArray[n3 + 13] & 0xFF;
                break;
            }
            n3 = n3 + ((byArray[n3] & 0xFF) << 8) + (byArray[n3 + 1] & 0xFF);
        }
        return n;
    }

    public void setIndex(byte[] byArray, int n) {
        this.IndexedColorMap = byArray;
        this.size = n;
    }

    protected int getIndexedColorComponent(int n) {
        int n2 = 255;
        if (this.IndexedColorMap != null && (n2 = this.IndexedColorMap[n]) < 0) {
            n2 = 256 + n2;
        }
        return n2;
    }

    public byte[] getIndexedMap() {
        if (this.IndexedColorMap == null) {
            return null;
        }
        int n = this.IndexedColorMap.length;
        byte[] byArray = new byte[n];
        System.arraycopy(this.IndexedColorMap, 0, byArray, 0, n);
        return byArray;
    }

    public void setColor(String[] stringArray, int n) {
    }

    public void setColor(float[] fArray, int n) {
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl, PdfObject pdfObject) {
        BufferedImage bufferedImage;
        block9: {
            if (this.decodeParms != null && this.decodeParms.getInt(-1263544861) == 1 && this.value != 1568372915) {
                return JPEGDecoder.JPEGToRGBImageFromLUV(byArray, n3, n4);
            }
            try {
                bufferedImage = DefaultImageHelper.read(byArray);
                if (bufferedImage != null && !fasterPNG) {
                    if (this.value != 1568372915) {
                        bufferedImage = GenericColorSpace.cleanupImage(bufferedImage, n3, n4);
                    }
                    if (this.value != 1568372915) {
                        bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
                    }
                }
            }
            catch (Exception exception) {
                bufferedImage = null;
                if (!LogWriter.isOutput()) break block9;
                LogWriter.writeLog("Problem reading JPEG: " + exception);
            }
        }
        if (bufferedImage == null) {
            bufferedImage = JPEGDecoder.JPEGToRGBImageFromLUV(byArray, n3, n4);
        }
        if (bl && this.value == 1568372915) {
            DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
            byte[] byArray2 = dataBufferByte.getData();
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = (byte)(byArray2[i] ^ 0xFF);
            }
            bufferedImage.setData(Raster.createRaster(bufferedImage.getSampleModel(), new DataBufferByte(byArray2, byArray2.length), null));
        }
        return bufferedImage;
    }

    public BufferedImage JPEG2000ToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, int n5) throws PdfException {
        Object object;
        Object object2;
        block10: {
            object2 = null;
            try {
                object = new Jpeg2000Decoder();
                object2 = ((Jpeg2000Decoder)object).read(byArray);
                this.IndexedColorMap = null;
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block10;
                LogWriter.writeLog("Exception in JPEG2000toImage  " + exception);
            }
        }
        if (object2 != null) {
            Object object3;
            int n6;
            int n7;
            object = this.getIndexedMap();
            if (object != null) {
                if (this.value != 1785221209) {
                    object = this.convertIndexToRGB((byte[])object);
                    int n8 = ((Object)object).length;
                    for (n7 = 0; n7 < n8; n7 = (int)((byte)(n7 + 1))) {
                        object[n7] = (byte)(object[n7] ^ 0xFF);
                    }
                }
                byArray = ((DataBufferByte)((BufferedImage)object2).getRaster().getDataBuffer()).getData();
                object2 = ColorSpaceConvertor.convertIndexedToFlat(n5, n, n2, byArray, (byte[])object, false, false);
            }
            if (((BufferedImage)(object2 = GenericColorSpace.cleanupImage((BufferedImage)object2, n3, n4))).getType() == 13) {
                BufferedImage bufferedImage = object2;
                n7 = ((BufferedImage)object2).getWidth();
                n6 = ((BufferedImage)object2).getHeight();
                object2 = new BufferedImage(n7, n6, 1);
                object3 = (Graphics2D)((BufferedImage)object2).getGraphics();
                ((Graphics2D)object3).setPaint(Color.WHITE);
                ((Graphics)object3).fillRect(0, 0, n7, n6);
                ((Graphics)object3).drawImage(bufferedImage, 0, 0, null);
            }
            ColorSpace colorSpace = ((BufferedImage)object2).getColorModel().getColorSpace();
            n7 = colorSpace.getType();
            n6 = ((BufferedImage)object2).getColorModel().getTransferType();
            if (((BufferedImage)object2).getType() == 0 && (n7 == 1000 || n7 == 5) && n6 == 0) {
                object3 = new BufferedImage(((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight(), 1);
                int[] nArray = ((DataBufferInt)((BufferedImage)object3).getRaster().getDataBuffer()).getData();
                byte[] byArray2 = ((DataBufferByte)((BufferedImage)object2).getRaster().getDataBuffer()).getData();
                int n9 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    int n10;
                    nArray[i] = n10 = (byArray2[n9] & 0xFF) << 16 | (byArray2[n9 + 1] & 0xFF) << 8 | byArray2[n9 + 2] & 0xFF;
                    n9 += 3;
                }
                object2 = object3;
            } else {
                object2 = ColorSpaceConvertor.convertToRGB((BufferedImage)object2);
            }
        }
        return object2;
    }

    public byte[] dataToRGBByteArray(byte[] byArray, int n, int n2, boolean bl) {
        return byArray;
    }

    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray, n, n2);
        bufferedImage.setData(raster);
        return bufferedImage;
    }

    public int getID() {
        return this.value;
    }

    public final void setCIEValues(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        this.cs = ColorSpace.getInstance(1001);
        this.G = fArray4;
        this.Ma = fArray3;
        this.W = fArray;
        this.R = fArray2;
    }

    byte[] convert4Index(byte[] byArray) {
        block7: {
            if (this.value == 1498837125) {
                int n = byArray.length;
                byte[] byArray2 = new byte[n * 3 / 4];
                int n2 = 0;
                for (int i = 0; i < n; i += 4) {
                    int n3;
                    float[] fArray = new float[4];
                    for (n3 = 0; n3 < 4; ++n3) {
                        fArray[n3] = (float)(byArray[i + n3] & 0xFF) / 255.0f;
                    }
                    this.setColor(fArray, 4);
                    n3 = this.currentColor.getRGB();
                    byArray2[n2] = (byte)(n3 >> 16 & 0xFF);
                    byArray2[n2 + 1] = (byte)(n3 >> 8 & 0xFF);
                    byArray2[n2 + 2] = (byte)(n3 & 0xFF);
                    n2 += 3;
                    if (n - 4 - i >= 4) continue;
                    i = n;
                }
                return byArray2;
            }
            try {
                int n = byArray.length / 4;
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, 1, n * 4, 4, bands4, null);
                if (CSToRGB == null) {
                    GenericColorSpace.initCMYKColorspace();
                    CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
                }
                WritableRaster writableRaster2 = rgbModel.createCompatibleWritableRaster(n, 1);
                CSToRGB.filter(writableRaster, writableRaster2);
                DataBuffer dataBuffer = writableRaster2.getDataBuffer();
                int n4 = n * 1 * 3;
                byArray = new byte[n4];
                for (int i = 0; i < n4; ++i) {
                    byArray[i] = (byte)dataBuffer.getElem(i);
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block7;
                LogWriter.writeLog("Exception  " + exception + " converting colorspace");
            }
        }
        return byArray;
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        return byArray;
    }

    public String getXMLColorToken() {
        String string;
        if (this.c == -1.0f) {
            if (this.currentColor instanceof Color) {
                Color color = (Color)((Object)this.currentColor);
                float f = (float)(255 - color.getRed()) / 255.0f;
                float f2 = (float)(255 - color.getGreen()) / 255.0f;
                float f3 = (float)(255 - color.getBlue()) / 255.0f;
                float f4 = f;
                if (f4 < f2) {
                    f4 = f2;
                }
                if (f4 < f3) {
                    f4 = f3;
                }
                string = this.pantoneName == null ? "<color C='" + f + "' M='" + f2 + "' Y='" + f3 + "' K='" + f4 + "' >" : "<color C='" + f + "' M='" + f2 + "' Y='" + f3 + "' K='" + f4 + "' pantoneName='" + this.pantoneName + "' >";
            } else {
                string = "<color type='shading'>";
            }
        } else {
            string = this.pantoneName == null ? "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' >" : "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' pantoneName='" + this.pantoneName + "' >";
        }
        return string;
    }

    public void setPattern(Map map, int n, int n2, float[][] fArray) {
        this.patterns = map;
        this.pageWidth = n;
        this.pageHeight = n2;
        this.CTM = fArray;
    }

    public void setColor(PdfPaint pdfPaint) {
        this.currentColor = pdfPaint;
    }

    public int getColorComponentCount() {
        return this.componentCount;
    }

    public void setGS(GraphicsState graphicsState) {
        this.gs = graphicsState;
    }

    public float[] getRawValues() {
        return this.rawValues;
    }

    public boolean isImageYCCK() {
        return this.hasYCCKimages;
    }

    public void setDecodeParms(PdfObject pdfObject) {
        this.decodeParms = pdfObject;
    }

    public boolean isIndexConverted() {
        return this.isConverted;
    }

    public void clearCache() {
    }

    public static ColorSpace getColorSpaceInstance() {
        ColorSpace colorSpace;
        block3: {
            colorSpace = ColorSpace.getInstance(1000);
            String string = System.getProperty("org.jpedal.RGBprofile");
            if (string != null) {
                try {
                    colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(string)));
                    System.out.println("use " + string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("[PDF] Problem " + exception.getMessage() + " with ICC data ");
                }
            }
        }
        return colorSpace;
    }

    public BufferedImage getImageForPatternedShape(Path path) {
        return null;
    }

    int getType() {
        return this.type;
    }

    void setType(int n) {
        this.value = n;
        this.rawCSType = n;
    }

    void setRawColorSpace(int n) {
        this.rawCSType = n;
    }

    public int getRawColorSpacePDFType() {
        return this.rawCSType;
    }

    public BufferedImage JPEG2000ToImage(byte[] byArray, int n, int n2, float[] fArray) throws PdfException {
        BufferedImage bufferedImage;
        block2: {
            bufferedImage = null;
            try {
                Jpeg2000Decoder jpeg2000Decoder = new Jpeg2000Decoder();
                bufferedImage = jpeg2000Decoder.read(byArray);
                bufferedImage = GenericColorSpace.cleanupImage(bufferedImage, n, n2);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception in JPEG2000toImage  " + exception);
            }
        }
        return bufferedImage;
    }

    static {
        block4: {
            bands4 = new int[]{0, 1, 2, 3};
            String string = System.getProperty("org.jpedal.fasterPNG");
            fasterPNG = string != null && string.equalsIgnoreCase("true");
            String string2 = System.getProperty("org.jpedal.RGBprofile");
            if (string2 != null) {
                try {
                    ICCProfileForRGB = ICC_Profile.getInstance(new FileInputStream(string2));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[PDF] Problem " + exception.getMessage() + " with ICC data ");
                    }
                    if (ICCProfileForRGB != null) break block4;
                    throw new RuntimeException("Problem wth RGB profile " + string2 + ' ' + exception.getMessage());
                }
            }
        }
        rgbCS = ICCProfileForRGB != null ? new ICC_ColorSpace(ICCProfileForRGB) : ColorSpace.getInstance(1000);
    }
}

